/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.metadata.BaseTableReference;
import com.kingdee.eas.base.form.metadata.FormCondition;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormDBUtils {
    public static final Log log = LogFactory.getLog(FormDBUtils.class);
    public static final String FORM_TABLE = "T_BAS_Form";
    public static final String FORMACTIONLIST_TABLE = "T_BAS_FormActionList";
    public static final String FORMACTION_TABLE = "T_BAS_FormAction";
    public static final String FORMEntity_TABLE = "T_BAS_FormEntity";
    public static final String FORMENTITYFIELDS_TABLE = "T_BAS_FormField";
    public static final String LOOKUPCLASS_TABLE = "T_BAS_LookUpClass";
    public static final String FORMLAYOUT_TABLE = "T_BAS_FormLayout";
    public static final String ElementType_TABLE = "T_BAS_ElementType";
    public static final String FORMENTITYLayout_TABLE = "T_BAS_FormLayoutEntity";
    public static final String FormEntityFieldsLayout_Table = "T_BAS_FormLayoutField";
    public static final String BillEntityControlsLayout_Table = "T_BAS_FormLayoutCtrl";
    public static final String LayoutTabPage_Table = "T_BAS_FormLayoutTabPage";
    public static final String ElementProperty_Table = "T_BAS_EelementProperty";
    public static final String FilterCondition_Table = "T_BAS_FilterCondition";
    public static final String SQL_FORMTYPE = " select * from T_BAS_Form WHERE FID=?";
    public static final String SQL_UPDATE_FORMVERSION = "update T_BAS_Form set FVersion = ''{0}'' WHERE FID=''{1}''";
    public static final String SQL_FORMACTIONLIST = " select t1.fid id1, t1.FLayoutID, t1.FObjectKey, t1.FObjectType,  t1.FActionID, t1.FDefineType, t1.FActionType, t1.FParaments, t1.FExpression, t1.FSetting, t1.FSeq,  t2.FRunComponent, t2.FSetComponent, t2.FReverseActionClass, t2.fname, t2.fdesc, t2.FType from T_BAS_FormActionList t1 inner join T_BAS_FormAction t2 on t1.FActionID=t2.FID where t1.FFormID=''{0}'' order by t1.FLayoutID,t1.FObjectKey,t1.FActionType,t1.FSeq";
    private static final String SQL_FORMACTIONLISTENTRY = "select * from T_BAS_FCEntry WHERE fparentid in  ( select fid from T_BAS_FormActionList WHERE FFormID = ?  ) order by fparentid, fseq";
    public static final String SQL_FORMTYPE2 = "select * from T_BAS_Form WHERE FBOSTYPE=''{0}''";
    public static final String EnumItem_Table = "t_BAS_FormEnumItem";
    public static final String FormEnum_Table = "T_BAS_FormEnum";
    public static final String SQL_FormEnum = "SELECT *  FROM T_BAS_FormEnum where FID in(Select FEnumType FROM t_BAS_FormField WHERE FElementTypeID in(9,29,10013,32) and FFormID =''{0}'')";
    public static final String SQL_FormSqlComboList = "SELECT FID,FSqlString FROM t_BAS_FormField WHERE FElementTypeID in(36) and FFormID =''{0}''";
    public static final String SQL_FormEnumItem = "SELECT *  FROM t_BAS_FormEnumItem t1 inner join t_BAS_FormEnum t2 on t2.FID=t1.FEnumID \n where t2.FID in(Select FEnumType FROM t_BAS_FormField WHERE  FElementTypeID in (25,32,9,29,10013) and FFormID =''{0}'') \n ORDER BY FValue;";
    private static final String SQL_FORMOPERATION = " select a.*, b.FOperation, b.FName, b.FIsConfirm, b.FResource, b.FEnabledState,  b.FOperEleIds, b.FTopSysID, b.FSubSysID, b.FRunClassName, b.FType  from T_BAS_FormOperation a,T_BAS_FormOperationType b  WHERE a.FOperationID=b.FID AND a.FFormID=? order by b.fid ";
    private static final String SQL_FORMPLUGIN = "select FClassName,FType from T_BAS_FormPlugin WHERE FFormID=? ORDER BY FType,FSeq";
    private static final String SQL_FORMEVENTPM = "select * from T_BAS_FormEventPm WHERE FFormID=? ORDER BY FIndex";
    private static final String SQL_FORMEVENTPM_MAXIDX = "select MAX(FIndex) from T_BAS_FormEventPm WHERE FFormID=? ";
    private static final String SQL_FORMCONDITION = "select * from T_BAS_FormCondition WHERE FFormID=? order by fseq";
    private static final String SQL_FORMCONDITIONENTRY = "select * from T_BAS_FCEntry WHERE fparentid in  ( select fid from T_BAS_FormCondition WHERE FFormID=?  ) order by fparentid, fseq";
    public static final String SQL_FORMENTITY = " select * from T_BAS_FormEntity WHERE FFormID=''{0}'' order by FSeq ";
    public static final String SQL_FORMENTITY_FIELDS = "select t1.* from T_BAS_FormField t1  WHERE t1.FFormID=? ";
    public static final String SQL_FOMR_LAYOUT = "select t1.*, t2.FControlTypeID from T_BAS_FormLayout  t1   left join T_BAS_ElementType t2 on t1.FElementTypeID=t2.FID WHERE t1.FFormID=''{0}''";
    public static final String SQL_FORM_BASETABLE = "select * from T_BAS_BaseTableInfo WHERE FFormID=''{0}''";
    public static final String SQL_FORM_ENTITY_LAYOUT = "select t1.*, t2.FControlTypeID from T_BAS_FormLayoutEntity t1 inner join T_BAS_FormLayout t3 on t1.FLayoutID = t3.FID  left join T_BAS_ElementType t2 on t1.FElementTypeID=t2.FID WHERE t3.FFormID=''{0}'' ";
    public static final String SQL_FOMR_ENTITY_FIELDS_LAYOUT = "select t1.*, t5.FControlTypeID from T_BAS_FormLayoutField t1  inner join T_BAS_FormLayout t2 on t1.FLayoutID = t2.FID   left join T_BAS_ElementType t5 on t1.FElementTypeID=t5.FID  WHERE t2.FFormID=''{0}'' order by t1.ftabindex";
    public static final String SQL_FORM_ENTITY_CONTROLS_LAYOUT = "select t1.*, t2.FControlTypeID from T_BAS_FormLayoutCtrl t1 inner join T_BAS_FormLayout t3 on t1.FLayoutID = t3.FID  left join T_BAS_ElementType  t2 on t1.FElementTypeID=t2.FID WHERE t3.FFormID=''{0}'' ";
    public static final String SQL_FOMRLAYOUTTabPage = "select t1.*, t5.FControlTypeID from T_BAS_FormLayoutTabPage t1  inner join T_BAS_FormLayout t2 on t1.FLayoutID = t2.FID   left join T_BAS_ElementType t5 on t1.FElementTypeID=t5.FID  WHERE t2.FFormID=''{0}'' order by t1.FLayoutID,t1.FContainer,t1.FPageIndex ";
    public static final String SQL_ELEMENT_TYPE = "select * from T_BAS_ElementType";
    public static final String SQL_ELEMENT_PROPERTY = "select * from T_BAS_EelementProperty WHERE FElementTypeID={0}";
    private static final String SQL_CONDITION = "select * from T_BAS_FilterCondition Order by Findex";
    public static final String TEST_NULL_CONTEXT_USERID = "1";
    public static final String QUERY_FORM_SQL = "select FID,FName_L1,FName_L2,FName_L3,FElementTypeID from T_BAS_Form where FELementTypeID={0}";

    public static void updateFormVersion(Context ctx, String formID) throws BOSException {
        String sql = MessageFormat.format(SQL_UPDATE_FORMVERSION, "" + System.currentTimeMillis(), formID);
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static ResultSet getFormType(String formID, Context ctx) throws BOSException {
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormType Sql is:\n select * from T_BAS_Form WHERE FID=?formID ====" + formID));
        }
        return DbUtil.executeQuery((Context)ctx, (String)SQL_FORMTYPE, (Object[])new String[]{formID});
    }

    public static ResultSet getFormActionList(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FORMACTIONLIST, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormType Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static ResultSet getFormActionListEntry(String formID, Context ctx) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)SQL_FORMACTIONLISTENTRY, (Object[])new String[]{formID});
    }

    public static ResultSet getFormControlExtPropertys(String formID, Context ctx) throws BOSException {
        String sql = "SELECT FLayoutID, FObjectKey, FObjectType, FPropertyName, FValue, FValueType FROM T_BAS_FormExtProperty  WHERE  FFormID=? Order by FLayoutID, FObjectKey, FObjectType ";
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormType Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{formID});
    }

    public static ResultSet getFormConatinerLayout(String formID, Context ctx) throws BOSException {
        String sql = "SELECT FLayoutID,FContainerKey,FLayoutType,FCols,FRows FROM  t_BAS_FormContainerLayout WHERE  FFormID=?";
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormType Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{formID});
    }

    public static ResultSet getFormTableLayoutStyle(String formID, Context ctx) throws BOSException {
        String sql = "SELECT FLayoutID,FContainerKey,FType,FOut FROM  t_BAS_FormTableLayoutStyle WHERE  FFormID=? Order by FLayoutID,FContainerKey,FType,FIndex ";
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormType Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{formID});
    }

    public static ResultSet getFormType(BOSObjectType bosType, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FORMTYPE2, bosType.toString());
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormType Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public ResultSet getFormType(String formID) throws BOSException {
        return FormDBUtils.getFormType(formID, null);
    }

    public static ResultSet getFormEntity(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FORMENTITY, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormEntity Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public ResultSet getFormEntity(String formID) throws BOSException {
        return FormDBUtils.getFormEntity(formID, null);
    }

    public static ResultSet getFormEntityFields(String formID, Context ctx) throws BOSException {
        return DBUtil.executeQuery((Context)ctx, (String)SQL_FORMENTITY_FIELDS, (Object[])new Object[]{formID});
    }

    public ResultSet getFormEntityFields(String formID) throws BOSException {
        return FormDBUtils.getFormEntityFields(formID, null);
    }

    public static ResultSet getFormLayout(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FOMR_LAYOUT, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormLayout Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static IRowSet getBaseTableInfo(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FORM_BASETABLE, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormLayout Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public ResultSet getFormLayout(String formID) throws BOSException {
        return FormDBUtils.getFormLayout(formID, null);
    }

    public static ResultSet getFormEntityLayout(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FORM_ENTITY_LAYOUT, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormEntityLayout Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public ResultSet getFormEntityLayout(String formID) throws BOSException {
        return FormDBUtils.getFormEntityLayout(formID, null);
    }

    public static ResultSet getFormEntityFieldsLayout(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FOMR_ENTITY_FIELDS_LAYOUT, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormEntityFieldsLayout Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public ResultSet getFormEntityFieldsLayout(String formID) throws BOSException {
        return FormDBUtils.getFormEntityFieldsLayout(formID, null);
    }

    public static ResultSet getFormEntityControlsLayout(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FORM_ENTITY_CONTROLS_LAYOUT, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormEntityControlsLayout Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public ResultSet getFormEntityControlsLayout(String formID) throws BOSException {
        return FormDBUtils.getFormEntityControlsLayout(formID, null);
    }

    public static ResultSet getCondition(Context ctx) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)SQL_CONDITION);
    }

    public ResultSet getCondition() throws BOSException {
        return FormDBUtils.getCondition(null);
    }

    public static ResultSet getFormLayoutTabPage(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FOMRLAYOUTTabPage, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("SQL_FOMRLAYOUTTabPage Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static ResultSet getElementType(Context ctx) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)SQL_ELEMENT_TYPE);
    }

    public ResultSet getElementType() throws BOSException {
        return DbUtil.executeQuery(null, (String)SQL_ELEMENT_TYPE);
    }

    public static ResultSet getElementProperty(String elementTypeID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_ELEMENT_PROPERTY, elementTypeID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getElementProperty Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static String getCurrentContextUser(Context ctx) {
        String userID = "";
        userID = ctx == null ? TEST_NULL_CONTEXT_USERID : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        return userID;
    }

    public static HashMap getLookUpObjects(String formID, Context ctx) throws BOSException {
        HashMap<String, LookUpObject> LookUpObjectMaps = new HashMap<String, LookUpObject>();
        try {
            String sql = "select distinct t2.fid,t2.fqueryinfo,t2.f7provider,t2.FControlFieldFilter,t2.FBusinessImplName,t2.FBosType, t2.furl, FTableName,FPkFieldName,FNameFieldName,FNumberFieldName from T_BAS_FormField t1 inner join T_BAS_LookUpClass t2 on t1.FLookUpObjectID = t2.FID  WHERE FFormID='" + formID + "' ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                LookUpObject obj = new LookUpObject();
                obj.setQueryInfo(rs.getString("FQueryInfo"));
                obj.setF7Provider(rs.getString("F7Provider"));
                obj.setCtlFieldFiler(rs.getString("FControlFieldFilter"));
                obj.setBusinessImplName(rs.getString("FBusinessImplName"));
                obj.setBosType(rs.getString("FBosType"));
                obj.setTableName(rs.getString("FTableName"));
                obj.setPkFieldName(rs.getString("FPkFieldName"));
                obj.setNameFieldName(rs.getString("FNameFieldName"));
                obj.setNumberFieldName(rs.getString("FNumberFieldName"));
                obj.setUrl(rs.getString("FURL"));
                LookUpObjectMaps.put(String.valueOf(rs.getInt("FID")), obj);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return LookUpObjectMaps;
    }

    public static ResultSet getFormListByElementTypeID(int elementTypeID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(QUERY_FORM_SQL, "" + elementTypeID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormListByElementTypeID Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static ResultSet getFormEnum(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FormEnum, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormType Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static ResultSet getFormSqlComboList(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FormSqlComboList, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormSqlComboList Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static ResultSet getFormEnumItem(String formID, Context ctx) throws BOSException {
        String sql = MessageFormat.format(SQL_FormEnumItem, formID);
        if (log.isInfoEnabled()) {
            log.info((Object)("getFormType Sql is:\n" + sql));
        }
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static IRowSet getFormOperation(String formID, Context ctx, String name) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)SQL_FORMOPERATION.replaceFirst("FName", name), (Object[])new Object[]{formID});
    }

    public static List[] getFormPlugins(String formID, Context ctx) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SQL_FORMPLUGIN, (Object[])new Object[]{formID});
        List[] plugins = new List[]{new ArrayList(), new ArrayList(), new ArrayList()};
        try {
            rs.beforeFirst();
            while (rs.next()) {
                int type = rs.getInt("FType");
                plugins[type - 1].add(rs.getString("FClassName"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return plugins;
    }

    public static IRowSet getFormByBosType(String bosType, Context ctx) throws BOSException {
        String sql = " select * from T_BAS_Form WHERE fbostype = ? order by FIsMain desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bosType});
        return rs;
    }

    public static String[][] getFormEventParams(String formID, Context ctx) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SQL_FORMEVENTPM, (Object[])new Object[]{formID});
        String[][] params = new String[rs.size()][2];
        try {
            rs.beforeFirst();
            int row = 0;
            while (rs.next()) {
                params[row][0] = rs.getString("FEventKey");
                params[row][1] = rs.getString("FFieldKey");
                ++row;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return params;
    }

    public static void updateFormEventParams(String formID, Context ctx, List deletes, List inserts) throws BOSException {
        try {
            ArrayList<String> updateSqls = new ArrayList<String>();
            Iterator iter = deletes.iterator();
            updateSqls.add("delete from T_BAS_FormEventPm where fformid='" + formID + "'");
            if (inserts.size() > 0) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SQL_FORMEVENTPM_MAXIDX, (Object[])new Object[]{formID});
                int maxIdx = 0;
                if (rs.next()) {
                    maxIdx = rs.getInt(1);
                }
                for (String fieldKey : inserts) {
                    updateSqls.add("insert into T_BAS_FormEventPm (FFormID,FIndex,FEventKey,FFieldKey) values('" + formID + "'," + ++maxIdx + ",'" + fieldKey.replaceAll("\\.", "_") + "','" + fieldKey + "');");
                }
            }
            if (updateSqls.size() == 0) {
                return;
            }
            DBUtil.executeBatch((Context)ctx, (String[])updateSqls.toArray(new String[0]));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static ArrayList getFormConditions(String formID, Context ctx) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)SQL_FORMCONDITION, (Object[])new Object[]{formID});
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)SQL_FORMCONDITIONENTRY, (Object[])new Object[]{formID});
        ArrayList<FormCondition> conditions = new ArrayList<FormCondition>();
        String lang = ResourceUtil.getLanguage(ctx);
        try {
            HashMap<String, String> cacheMap1 = new HashMap<String, String>();
            HashMap<String, String> cacheMap2 = new HashMap<String, String>();
            while (rs1.next()) {
                String parentId = rs1.getString("FParentID");
                String condition = rs1.getString("FCondition");
                String setting = rs1.getString("FSetting");
                if (cacheMap1.containsKey(parentId)) {
                    if (!StringUtils.isEmpty((String)condition)) {
                        cacheMap1.put(parentId, cacheMap1.get(parentId) + condition);
                    }
                    if (StringUtils.isEmpty((String)setting)) continue;
                    cacheMap2.put(parentId, cacheMap2.get(parentId) + setting);
                    continue;
                }
                cacheMap1.put(parentId, condition);
                cacheMap2.put(parentId, setting);
            }
            while (rs.next()) {
                FormCondition fc = new FormCondition(rs.getString("FCondition"), rs.getString("FName_" + lang), rs.getString("FName_L1"), rs.getString("FName_L2"), rs.getString("FName_L3"));
                fc.setId(rs.getString("FID"));
                fc.setSetting(rs.getString("FSetting"));
                fc.setSeq(rs.getInt("FSeq"));
                if (cacheMap1.containsKey(fc.getId())) {
                    fc.setConditon(cacheMap1.get(fc.getId()).toString());
                    fc.setSetting(cacheMap2.get(fc.getId()).toString());
                }
                conditions.add(fc);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
            SQLUtils.cleanup((ResultSet)rs1);
        }
        return conditions;
    }

    public static String[] getOrgsByLongNumber(OrgType ot, String longNumber, Context ctx) throws BOSException, SQLException {
        String tabName = null;
        String[] orgs = null;
        if (longNumber != null) {
            switch (ot.getValue()) {
                case 0: {
                    tabName = "T_ORG_Admin";
                }
                case 10: {
                    tabName = "T_ORG_CtrlUnit";
                }
            }
            String[] numbers = longNumber.split("!");
            orgs = new String[numbers.length];
            for (int i = 0; i < numbers.length; ++i) {
                String sql = " SELECT FID FROM " + tabName + " WHERE FNumber=?;";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{numbers[i]});
                rs.next();
                orgs[i] = rs.getString("FID");
            }
        }
        return orgs;
    }

    public static ResultSet getAssistantData(String dataType, Context ctx) throws BOSException {
        String locale = "_" + ctx.getLocale().toString();
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT defDataEntry.FID,defDataEntry.FDataValue" + locale + " FDesc,defDataEntry.FParentId,defDataEntry.FControlUnitId ");
        sql.append(" FROM T_BAS_UserDefinedDataEntry defDataEntry, T_BAS_UserDefinedData defData");
        sql.append(" WHERE defDataEntry.FHead=defData.FID AND defDataEntry.FHead=? AND defData.FUsedState=0 ORDER BY defDataEntry.FID;");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{dataType});
        return rs;
    }

    public static ResultSet getAssistantData(String dataType, String cu, String longNumber, Context ctx) throws BOSException {
        String locale = "_" + ctx.getLocale().toString();
        IRowSet rs = null;
        try {
            String[] orgs = FormDBUtils.getOrgsByLongNumber(OrgType.ControlUnit, longNumber, ctx);
            Object[] param = new String[orgs.length + 1 + 2];
            System.arraycopy(orgs, 0, param, 1, orgs.length);
            param[0] = dataType;
            param[param.length - 3] = cu;
            param[param.length - 2] = dataType;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < orgs.length - 1; ++i) {
                sb.append(",?");
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT defDataEntry.FID FROM T_BAS_UserDefinedDataEntry defDataEntry, T_BAS_UserDefinedData defData");
            sql.append(" WHERE defDataEntry.FHead=defData.FID AND defData.FUsedState=0 and defDataEntry.FUsedState=0");
            sql.append(" AND defDataEntry.FHead=? AND (");
            if (orgs.length > 1) {
                sql.append("(defDataEntry.FControlUnitId in (" + sb.substring(1) + ") AND defDataEntry.FIsVisibleToSubCU=1) OR");
            }
            sql.append(" defDataEntry.FControlUnitId=? OR ").append(" defDataEntry.FID IN (SELECT FDataBaseDID FROM T_BD_DataBaseDAssign da").append("         INNER JOIN t_bas_UserdefinedDataEntry ue on ue.FID=da.FDataBaseDID").append("\t\t WHERE da.FBOSObjectType='EE025FDF' AND da.FAssignCUID =? and ue.FHead=?))").append(" ORDER BY defDataEntry.FParentId,defDataEntry.FNumber");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rs;
    }

    public static String getAssistantDataVersion(String dataType, String cu, Context ctx) throws BOSException {
        String version = null;
        String sql = " SELECT FVersion FROM T_BAS_UserDefinedData WHERE FID=?;";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{dataType});
        try {
            while (rs.next()) {
                version = rs.getString("FVersion");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return version;
    }

    public static String getAssistantDataDesc(String ids, Context ctx) throws BOSException {
        StringBuffer desc = new StringBuffer();
        if (ids != null && ids.trim().length() > 0) {
            String locale = "_" + ctx.getLocale().toString();
            Object[] idArr = ids.split(",");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < idArr.length; ++i) {
                sb.append(",?");
            }
            String sql = " SELECT FDataValue" + locale + " FDesc FROM T_BAS_UserDefinedDataEntry WHERE FID in (" + sb.substring(1) + ") ORDER BY FNumber";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])idArr);
            try {
                while (rs.next()) {
                    desc.append("," + rs.getString("FDesc"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return desc.length() > 0 ? desc.substring(1) : "";
    }

    public static Map getBaseReferTables(Context ctx, String formId) throws BOSException {
        HashMap<String, BaseTableReference> map = new HashMap<String, BaseTableReference>();
        String sql = " SELECT * FROM T_BAS_BaseTableInfo WHERE FFormID = ?;";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{formId});
        try {
            while (rs.next()) {
                BaseTableReference referTable = new BaseTableReference();
                referTable.setLookupClassId(rs.getInt("FLookupClassId"));
                referTable.setDisplayFieldName(rs.getString("FDspFieldName"));
                referTable.setFieldName(rs.getString("FFieldName"));
                referTable.setSrcFieldName(rs.getString("FSrcFieldName"));
                referTable.setSrcTableName(rs.getString("FSrcTableName"));
                referTable.setTableName(rs.getString("FTableName"));
                referTable.setFieldKey(rs.getString("FFieldKey"));
                map.put(referTable.getFieldKey(), referTable);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public static boolean isDynWebForm(Context ctx, String bosType) {
        boolean sign = false;
        String sql = " select fid from  t_bas_form  where fbostype = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{bosType});
            if (rs.next()) {
                sign = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            log.error((Object)e);
            e.printStackTrace();
        }
        return sign;
    }

    public static boolean templateCanNew(Context ctx, String templateId) throws BOSException, SQLException {
        IRowSet rowSet = FormDBUtils.getTemplateRowseByIsAllCU(ctx, templateId);
        if (rowSet.next()) {
            return true;
        }
        rowSet = FormDBUtils.getTemplateRowseByCurrOrg(ctx, templateId);
        return rowSet.next();
    }

    private static IRowSet getTemplateRowseByIsAllCU(Context ctx, String templateId) throws BOSException {
        IRowSet rowSet = null;
        String isAllCUSql = "select tt.fid from T_WFM_TemplatePermission tp inner join T_bas_Template tt on tp.FTemplateID=tt.FId where tt.FControlUnitID ='eThjryu4wEKoEK1veu3ZzDUlqpQ='and tt.FusedState=2  and tp.fisAllCU=1  and tp.FControlUnitID!= ?  and tt.fid = ?";
        String currCUid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        rowSet = DbUtil.executeQuery((Context)ctx, (String)isAllCUSql, (Object[])new String[]{currCUid, templateId});
        return rowSet;
    }

    private static IRowSet getTemplateRowseByCurrOrg(Context ctx, String templateId) throws BOSException {
        IRowSet rowSet = null;
        String currCUid = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        StringBuffer currOrgSql = new StringBuffer();
        currOrgSql.append("select fid  from T_wfm_TemplatePermission where FControlUnitID = '" + currCUid + "' and FTemplateID = '" + templateId + "'");
        rowSet = DbUtil.executeQuery((Context)ctx, (String)currOrgSql.toString());
        return rowSet;
    }
}

