/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.IPageQueryServer;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PageQueryServer
extends AbstractBOSObject
implements IPageQueryServer {
    private static final String ROW_COUNT_ALIAS = "totalrowcount";
    private static final String SQL_GET_ROW_COUNT = "SELECT count(*) totalrowcount from ";
    private static final String FIELD_SEQ = "KSQL_SEQ";
    private static final String MAIN_PK = "FID";
    private static final String ENTRY_PK = "FEntryID";
    private static final String TEMP_TABLE_NAME = "WEB_LIST_QUERY_TABLE";
    private static final String SQL_CREATE_TEMP_TABLE = "CREATE TABLE WEB_LIST_QUERY_TABLE(KSQL_SEQ INT IDENTITY (1, 1) NOT NULL,FID varchar(44) NOT NULL);";
    private static final String SQL_CREATE_TEMP_TABLE_WITH_ENTRY = "CREATE TABLE WEB_LIST_QUERY_TABLE(KSQL_SEQ INT IDENTITY (1, 1) NOT NULL ,FID varchar(44) NOT NULL,FEntryID varchar(44));";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.core.app.PageQueryServer");

    public PageQueryServer(Context ctx) {
        super(ctx);
    }

    public PageQueryServer() {
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public void clearPageInfo(String tmpTable) {
        TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
        if (tmpTable != null) {
            logger.info((Object)("PageQueryServer.clearPageInfo, drop temp table:" + tmpTable));
            pool.releaseTable(tmpTable);
        }
    }

    @Override
    public IRowSet getData(String tmpTableName, String mainPk, String entryPk, String select, String from, String where, int start, int end) throws BOSException {
        if (StringUtil.isEmpty((String)tmpTableName)) {
            throw new BOSException("The temp table name is not a valid table name");
        }
        boolean includeEntry = !StringUtil.isEmpty((String)entryPk);
        StringBuffer sql = new StringBuffer(400);
        sql.append(" SELECT ").append(tmpTableName).append(".").append(FIELD_SEQ).append(",").append(tmpTableName).append(".").append(MAIN_PK).append(",");
        if (includeEntry) {
            sql.append(tmpTableName).append(".").append(ENTRY_PK).append(",");
        }
        sql.append(select).append("\n").append(" FROM ").append(from);
        sql.append(" INNER JOIN ").append(tmpTableName).append(" ON ").append(tmpTableName).append(".").append(MAIN_PK).append("=").append(mainPk).append("\n");
        if (includeEntry) {
            sql.append(" \tAND (").append(tmpTableName).append(".").append(ENTRY_PK).append("=").append(entryPk).append(" OR (").append(tmpTableName).append(".").append(ENTRY_PK).append(" is null AND ").append(entryPk).append(" is null)) ").append("\n");
        }
        sql.append(" \tAND ").append(tmpTableName).append(".").append(FIELD_SEQ).append("> ? AND ").append(tmpTableName).append(".").append(FIELD_SEQ).append("<= ?").append("\n");
        sql.append(" ORDER BY ").append(tmpTableName).append(".").append(FIELD_SEQ);
        String sSQL = sql.toString();
        logger.info((Object)("PageQueryServer.getData:\n" + sSQL));
        IRowSet rs = DBUtil.executeQuery((Context)this.getContext(), (String)sSQL, (Object[])new Object[]{new Integer(start), new Integer(end)});
        return rs;
    }

    @Override
    public IRowSet getAllData(String mainPk, String entryPk, String select, String from, String where, String order) throws BOSException {
        boolean includeEntry = !StringUtil.isEmpty((String)entryPk);
        StringBuffer sql = new StringBuffer(400);
        sql.append(" SELECT ").append(mainPk).append(",");
        if (includeEntry) {
            sql.append(entryPk).append(",");
        }
        sql.append(select).append("\n").append(" FROM ").append(from);
        if (!StringUtil.isEmpty((String)where)) {
            sql.append(where);
        }
        sql.append(" ORDER BY ").append(order).append(";");
        String sSQL = sql.toString();
        logger.info((Object)("PageQueryServer.getData:\n" + sSQL));
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sSQL);
        return rs;
    }

    private int getRowCount(String tempTableName) throws BOSException {
        int rowCount = -1;
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getContext(), (String)(SQL_GET_ROW_COUNT + tempTableName));
        try {
            rowSet.next();
            rowCount = rowSet.getInt(ROW_COUNT_ALIAS);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return rowCount;
    }

    @Override
    public IPageQueryServer.PageInfo preparePageInfo(String tempTableName, String mainPk, String entryPk, String select, String from, String where, String order, int maxRowCount) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
        if (tempTableName != null) {
            logger.info((Object)("PageQueryServer.clearPageInfo, drop temp table:" + tempTableName));
            pool.releaseTable(tempTableName);
        }
        IPageQueryServer.PageInfo pi = new IPageQueryServer.PageInfo();
        String tmpTableName = null;
        boolean includeEntry = !StringUtil.isEmpty((String)entryPk);
        try {
            tmpTableName = pool.createTempTable(includeEntry ? SQL_CREATE_TEMP_TABLE_WITH_ENTRY : SQL_CREATE_TEMP_TABLE);
            StringBuffer insert = new StringBuffer();
            insert.append("INSERT INTO ").append(tmpTableName).append("(").append(FIELD_SEQ).append(",").append(MAIN_PK).append(includeEntry ? ",FEntryID) \n" : ") \n");
            insert.append(" SELECT ").append(" TOP ").append(maxRowCount).append(" ").append(mainPk).append(" AS FID ").append(includeEntry ? "," + entryPk + " AS FEntryID " : "").append(" FROM ").append(from).append("\n").append(where).append("\n").append(" ORDER BY ").append(order).append("\n");
            String sSQL = insert.toString();
            logger.info((Object)("PageQueryServer.preparePageInfo:\n" + sSQL));
            DbUtil.execute((Context)this.getContext(), (String)sSQL);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        pi.setTempTableName(tmpTableName);
        pi.setRowCount(this.getRowCount(tmpTableName));
        return pi;
    }
}

