/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.expression;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.base.form.expression.ExpressionEvaluator;
import com.kingdee.eas.base.form.expression.FunctionExpressionCalculator;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.SelectField;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.List;

public class DefaultValueCalculator
extends FunctionExpressionCalculator {
    private boolean skipIfNotNull = true;
    private String inOpertion;

    public void setInOpertion(String inOpertion) {
        this.inOpertion = inOpertion;
    }

    public void applyDefaultVallue(String entityKey) throws BOSException, EASBizException {
        for (Entity entity : this.businessInfo.getEntrys()) {
            if (!entity.getKey().equals(entityKey)) continue;
            for (Field field : entity.getFields()) {
                boolean inCopy;
                boolean hasValue = this.application.getValue(field.getKey(), this.row) != null;
                boolean bl = inCopy = this.inOpertion != null && this.inOpertion.equalsIgnoreCase("Copy");
                if (this.skipIfNotNull && hasValue && (!inCopy || field.isCopyControl())) continue;
                String defValue = field.getDefValue();
                if (hasValue && inCopy && !field.isCopyControl() && StringUtils.isEmpty((String)defValue)) {
                    this.application.setValue(field.getKey(), null, this.row);
                    continue;
                }
                this.applyFieldValue(field, defValue, true);
            }
        }
    }

    public void setSkipIfNotNull(boolean skipIfNotNull) {
        this.skipIfNotNull = skipIfNotNull;
    }

    public void applyDefaultVallue(List fields) throws BOSException, EASBizException {
        this.applyDefaultValue(fields, true);
    }

    public void applyDefaultValue(List fields, boolean checkNull) throws BOSException, EASBizException {
        for (SelectField selectfield : fields) {
            Field field = selectfield.getField();
            String defValue = field.getDefValue();
            this.applyFieldValue(field, defValue, checkNull);
        }
    }

    private void applyFieldValue(Field field, String funcValue, boolean checkNull) throws EASBizException, BOSException {
        if (checkNull && StringUtils.isEmpty((String)funcValue)) {
            return;
        }
        Object value = null;
        if (funcValue != null) {
            DataType dataType = DataMappingUtil.getDataTypeForElementType(field.getElementType());
            ExpressionEvaluator evaluator = new ExpressionEvaluator(this.application, this.businessInfo, this.objValue, funcValue, dataType);
            value = evaluator.evaluate();
        }
        if (value instanceof UserInfo) {
            this.application.getDynamicFormModel().getItemByKey(field.getKey(), "id", ((UserInfo)value).getId().toString(), this.row);
        } else if (value instanceof PersonInfo) {
            this.application.getDynamicFormModel().getItemByKey(field.getKey(), "id", ((PersonInfo)value).getId().toString(), this.row);
        } else {
            this.application.setValue(field.getKey(), value, this.row);
        }
    }

    public DefaultValueCalculator(DynamicFormApplication application, BusinessInfo businessInfo, IObjectValue objValue, int row) {
        this(application, businessInfo, objValue);
        this.row = row;
    }

    public DefaultValueCalculator(DynamicFormApplication application, BusinessInfo businessInfo, IObjectValue objValue) {
        super(application, businessInfo, objValue);
    }

    @Override
    protected Object evaluateExpression(String expr) throws EASBizException, BOSException {
        return null;
    }
}

