/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.expression;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.base.form.expression.FormFunctionLoader;
import com.kingdee.eas.base.form.expression.FunctionExpressionCalculator;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.base.form.util.ExpressionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.condition.ObjectValueSearcher;
import com.kingdee.eas.dynbusiness.function.IFuncParamValueProvider;
import com.kingdee.eas.dynbusiness.function.IFunction;
import com.kingdee.eas.dynbusiness.util.DataConverter;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.dynbusiness.util.ValidationUtils;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class ExpressionEvaluator
extends FunctionExpressionCalculator {
    private String expression;
    private DataType dataType;
    private boolean isSingleFuncOrField = true;

    @Override
    public Object evaluateFunction(String funcValue) throws EASBizException, BOSException {
        if (funcValue == null || funcValue.length() == 0) {
            return null;
        }
        IFunction function = new FormFunctionLoader(this.application, this.row).parseFunction(funcValue);
        if (function != null) {
            function.addParamValueProvider((IFuncParamValueProvider)this);
            return function.eval();
        }
        return super.evaluateFunction(funcValue);
    }

    public ExpressionEvaluator(DynamicFormApplication application, BusinessInfo businessInfo, IObjectValue objValue, String expression, int row) {
        super(application, businessInfo, objValue);
        this.expression = expression;
        this.row = row;
    }

    public ExpressionEvaluator(DynamicFormApplication application, BusinessInfo businessInfo, IObjectValue objValue, String expression) {
        super(application, businessInfo, objValue);
        this.expression = expression;
    }

    public ExpressionEvaluator(DynamicFormApplication application, BusinessInfo businessInfo, IObjectValue objValue, String expression, DataType dataType) {
        super(application, businessInfo, objValue);
        this.expression = expression;
        this.dataType = dataType;
    }

    public ExpressionEvaluator(DynamicFormApplication application, BusinessInfo businessInfo, IObjectValue objValue) {
        super(application, businessInfo, objValue);
    }

    private Object evalExtOperExpressioni(String expression) throws EASBizException, BOSException {
        ExpressionParser expParser = ExpressionParser.getInstance();
        String[] opers = expParser.splitOperatorAndVar(expression);
        String operator = opers[1];
        Object optValue = null;
        optValue = this.evalCommon(opers[0], null);
        if (optValue == null) {
            return Boolean.FALSE;
        }
        boolean result = false;
        Object setValue = this.evalCommon(opers[2], null);
        if (setValue instanceof String) {
            setValue = this.processStringConstant((String)setValue);
        }
        result = ValidationUtils.doRealCompare((Object)optValue, (Object)setValue, (String)operator, (DataType)DataType.STRING, null);
        return result;
    }

    private String processStringConstant(String str) {
        if (ExpressionUtil.isStringConstant(str)) {
            return ExpressionUtil.removeFormatSymbol(str);
        }
        return str;
    }

    private Entity getLoopEntry() {
        ExpressionParser expParser = ExpressionParser.getInstance();
        if (this.row == -1) {
            String[] vars = expParser.splitBracesVariables(this.expression);
            for (int i = 0; i < vars.length; ++i) {
                Entity entity;
                String var;
                Field field;
                if (!ExpressionUtil.isFieldName(vars[i]) && !ExpressionUtil.isPropertyName(vars[i]) || (field = this.businessInfo.getField(var = ExpressionUtil.removeFormatSymbol(vars[i]))) == null || (entity = this.businessInfo.getEntity(field.getEntityKey())).getEntityType() != 1) continue;
                return entity;
            }
        }
        return null;
    }

    public Object evaluate() throws EASBizException, BOSException {
        Entity entity = this.getLoopEntry();
        if (entity != null && !StringUtils.isEmpty((String)entity.getEntryName())) {
            IObjectCollection collection = (IObjectCollection)ObjectValueSearcher.searchValue((Object)this.objValue, (String)entity.getEntryName(), (int)0, null, null, (int)0);
            if (collection == null || collection.size() == 0) {
                return null;
            }
            int size = collection.size();
            Object[] values = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.row = i;
                values[i] = this.evaluateExpression();
            }
            return values;
        }
        Object value = this.evaluateExpression();
        return value;
    }

    private Object evaluateExpression() throws EASBizException, BOSException {
        Object value;
        ExpressionParser expParser = ExpressionParser.getInstance();
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        String thisExpr = this.expression;
        String[] extOperatorExpr = expParser.splitExtCompareOperator(this.expression);
        if (extOperatorExpr.length > 0) {
            this.isSingleFuncOrField = false;
            for (int i = 0; i < extOperatorExpr.length; ++i) {
                Boolean result = (Boolean)this.evalExtOperExpressioni(extOperatorExpr[i]);
                String var = "__inExpr_" + i;
                thisExpr = thisExpr.replaceAll(expParser.castRegular(extOperatorExpr[i]), var);
                context.put(var, result);
            }
        }
        if (!((value = this.evalCommon(thisExpr, context)) == null || this.dataType == null || this.dataType.equals((Object)DataType.ENUM) || this.dataType.equals((Object)DataType.OBJECTVALUE) || value.getClass().getName().equals(DataMappingUtil.getJavaTypeClassName(this.dataType)))) {
            try {
                value = DataConverter.stringConvert((String)value.toString(), (DataType)this.dataType, null);
            }
            catch (DataConverter.DataConvertException e) {
                return value;
            }
        }
        return value;
    }

    private Object evalCommon(String expression, Map context) throws EASBizException, BOSException {
        if (ExpressionUtil.isSqlText(expression)) {
            return expression;
        }
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        ExpressionParser expParser = ExpressionParser.getInstance();
        boolean isOperationExpr = expParser.isExpression(expression);
        String[] funcList = expParser.parseFunctions(expression);
        Object singleValue = null;
        for (int i = 0; i < funcList.length; ++i) {
            String funcExpr = funcList[i];
            for (int j = 0; j < i; ++j) {
                if (!funcExpr.equals(funcList[j])) continue;
            }
            Object value = this.evaluateFunction(funcExpr);
            String prop = expParser.parsePropertyAfterFunction(funcExpr);
            if (prop != null) {
                value = ObjectValueSearcher.searchValue((Object)value, (String)prop, (int)0, null, null, (int)this.row);
            }
            singleValue = value;
            value = this.evalForObjectValue(value);
            String var = "__function_" + i;
            expression = expression.replaceAll(expParser.castRegular(funcExpr), var);
            context.put(var, value);
        }
        if (expression.equals("__function_0")) {
            if (this.isSingleFuncOrField) {
                return singleValue;
            }
            return context.get("__function_0");
        }
        String[] vars = expParser.splitBracesVariables(expression);
        for (int i = 0; i < vars.length; ++i) {
            String var = null;
            Object value = null;
            if (!ExpressionUtil.isFieldName(vars[i]) && !ExpressionUtil.isPropertyName(vars[i])) continue;
            var = ExpressionUtil.removeFormatSymbol(vars[i]);
            singleValue = value = ExpressionUtil.searchVariableValue(this.application, vars[i], this.objValue, this.row, isOperationExpr);
            value = this.evalForObjectValue(value);
            var = var.replaceAll("\\.", "_");
            context.put(var, value);
            expression = expression.replaceAll(expParser.castRegular(vars[i]), var);
        }
        if (vars.length == 1 && expression.equals(vars[0])) {
            if (this.isSingleFuncOrField) {
                return singleValue;
            }
            return context.get(vars[0]);
        }
        String[] dates = expParser.parseDateTimes(expression);
        try {
            for (int i = 0; i < dates.length; ++i) {
                String var = ExpressionUtil.removeFormatSymbol(dates[i]);
                Object date = DataConverter.stringConvert((String)var, (DataType)DataType.DATE, null);
                var = "__datetime_" + i;
                context.put(var, date);
                expression = expression.replaceAll(expParser.castRegular(dates[i]), var);
            }
        }
        catch (DataConverter.DataConvertException e) {
            throw new BOSException((Throwable)e);
        }
        Interpreter interpreter = new Interpreter();
        return interpreter.eval(expression, context);
    }

    private Object evalForObjectValue(Object value) {
        if (!(value instanceof IObjectValue)) {
            return value;
        }
        if (this.dataType != null && this.dataType.equals((Object)DataType.OBJECTVALUE)) {
            return value;
        }
        IObjectValue ov = (IObjectValue)value;
        return ov.get(ov.getPKField()).toString();
    }

    @Override
    protected Object evaluateExpression(String expr) throws EASBizException, BOSException {
        return this.evalCommon(expr, null);
    }
}

