/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.expression;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.util.ExpressionUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.function.FunctionLoader;
import com.kingdee.eas.dynbusiness.function.IFuncParamValueProvider;
import com.kingdee.eas.dynbusiness.function.IFunction;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;

public abstract class FunctionExpressionCalculator
implements IFuncParamValueProvider {
    protected DynamicFormApplication application;
    protected BusinessInfo businessInfo;
    protected IObjectValue objValue;
    protected int row = 0;
    protected int nodeType = 2;

    public Object provideValue(String key) throws EASBizException, BOSException {
        if (key == null) {
            return null;
        }
        if (key.equalsIgnoreCase("@CONTEXT")) {
            return this.application.getContext();
        }
        if (key.equalsIgnoreCase("@MAINORG")) {
            return this.application.getMainOrgUnit();
        }
        if (key.equalsIgnoreCase("@THIS")) {
            return this.objValue;
        }
        if (key.equalsIgnoreCase("@MAINORGTYPE")) {
            Field field = this.businessInfo.getMainOrgField();
            if (field == null) {
                return BusinessProcessUtil.getOrgTypeFromEntity((Context)this.application.getContext(), (BOSObjectType)BOSObjectType.create((String)this.businessInfo.getForm().getBosType()));
            }
            int orgType = field.getOrgType();
            return OrgType.getEnum((int)orgType);
        }
        if (ExpressionParser.isTemporaryVariable((String)key)) {
            return this.application.getValue(ExpressionUtil.removeFormatSymbol(key), this.row);
        }
        String[] funcs = ExpressionParser.getInstance().parseFunction(key);
        if (funcs.length > 1 && "getFullPropetyName".equalsIgnoreCase(funcs[0]) && ExpressionParser.isTemporaryVariable((String)funcs[1])) {
            return this.businessInfo.getFullPropertyName(ExpressionUtil.removeFormatSymbol(funcs[1]));
        }
        return this.evaluateExpression(key);
    }

    protected abstract Object evaluateExpression(String var1) throws EASBizException, BOSException;

    public FunctionExpressionCalculator(DynamicFormApplication application, BusinessInfo businessInfo, IObjectValue objValue) {
        this.application = application;
        this.businessInfo = businessInfo;
        this.objValue = objValue;
    }

    public FunctionExpressionCalculator(DynamicFormApplication application, BusinessInfo businessInfo, IObjectValue objValue, int row) {
        this.application = application;
        this.businessInfo = businessInfo;
        this.objValue = objValue;
        this.row = row;
    }

    public Object evaluateFunction(String funcValue) throws EASBizException, BOSException {
        if (funcValue == null || funcValue.length() == 0) {
            return funcValue;
        }
        IFunction function = FunctionLoader.getInstance().parseFunction(funcValue);
        if (function == null) {
            return funcValue;
        }
        function.addParamValueProvider((IFuncParamValueProvider)this);
        return function.eval();
    }

    public boolean isApplicationServer() {
        return this.nodeType == 3;
    }

    public boolean isGUIClient() {
        return this.nodeType == 1;
    }

    public boolean isWebServer() {
        return this.nodeType == 2;
    }
}

