/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import com.kingdee.eas.base.form.core.PropertyUtil;
import com.kingdee.eas.base.form.metadata.ExtProperty;
import com.kingdee.eas.base.form.metadata.KeyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractElement
implements Serializable,
Cloneable {
    protected String key;
    protected String originKey;
    protected String id;
    protected int elementType;
    protected int custom;
    protected static final Log log = LogFactory.getLog(AbstractElement.class);
    private EventListenerList listenerList = new EventListenerList();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AbstractElement(String key) {
        this.key = key;
        this.originKey = key;
    }

    public AbstractElement() {
    }

    public String getOriginKey() {
        return this.originKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        if (this.key != null && key != null && !this.key.equals(key)) {
            this.fireKeyChanged(this, key, this.key);
        }
        this.key = key;
    }

    public void setKeyWithoutChangeEvent(String key) {
        this.key = key;
    }

    public void setElementType(int elementType) {
        this.elementType = elementType = elementType < 0 ? -elementType : elementType;
    }

    public int getElementType() {
        return this.elementType;
    }

    public void addKeyChangeListener() {
    }

    public void addKeyChangeListener(KeyChangeListener pl) {
        this.listenerList.add(KeyChangeListener.class, pl);
    }

    public void removeKeyChangeListener(KeyChangeListener pl) {
        this.listenerList.remove(KeyChangeListener.class, pl);
    }

    private void fireKeyChanged(AbstractElement element, String newKey, String oldKey) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KeyChangeListener.class) continue;
            ((KeyChangeListener)listeners[i + 1]).keyChanged(element, newKey, oldKey);
        }
    }

    public ArrayList getExtPropertys() {
        return new ArrayList();
    }

    public void setExtPropertys(ArrayList extProps) {
        for (ExtProperty prop : extProps) {
            Object value = prop.getValue();
            if (prop.getValueType() == 1) {
                value = Integer.valueOf(value.toString());
            }
            PropertyUtil.setPropertyValue(this, prop.getPropertyName(), value);
        }
    }

    public int getCustom() {
        return this.custom;
    }

    public boolean isCustom() {
        return this.custom == 1;
    }

    public void setCustom(int custom) {
        this.custom = custom;
    }
}

