/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class EntityObjectInfoConvert
implements Serializable {
    private BusinessInfo businessInfo;
    private LayoutInfo layoutInfo;
    private final String BILLIMPLNAME = "com.kingdee.eas.base.form.extend.bill.Bill";
    private final String BILLENTRYIMPLNAME = "com.kingdee.eas.base.form.extend.bill.BillEntry";
    private final String BILLENTRYCOLLECTIONIMPLNAME = "com.kingdee.eas.base.form.extend.bill.BillEntryCollection";

    public EntityObjectInfoConvert(BusinessInfo businessInfo, LayoutInfo layoutInfo) {
        this.businessInfo = businessInfo;
        this.layoutInfo = layoutInfo;
    }

    public EntityObjectInfo toEntityObjectInfo(Context ctx) {
        HashMap<String, EntityObjectInfo> entityMap = new HashMap<String, EntityObjectInfo>();
        EntityObjectInfo mainBO = new EntityObjectInfo();
        mainBO.setName("Bill");
        mainBO.setBusinessImplName("com.kingdee.eas.base.form.extend.bill.Bill");
        List entrys = this.businessInfo.getEntrys();
        Entity entity = (Entity)entrys.get(0);
        mainBO.setType(BOSObjectType.create((String)entity.getBosType()));
        mainBO.setPKField(entity.getPkFieldName());
        this.createDynamicTable(ctx, entity, mainBO);
        for (int i = 1; i < entrys.size(); ++i) {
            entity = (Entity)entrys.get(i);
            LinkPropertyInfo property = new LinkPropertyInfo();
            RelationshipInfo relation = new RelationshipInfo();
            relation.setType(RelationshipType.COMPOSITION);
            relation.setPackage(mainBO.getPackage());
            relation.setName("R_" + mainBO.getName() + "_BillEntry_" + entity.getKey());
            relation.setClientObject(mainBO);
            EntityObjectInfo bo = new EntityObjectInfo();
            bo.setName("BillEntry" + i);
            bo.setBusinessImplName("com.kingdee.eas.base.form.extend.bill.BillEntry");
            bo.setPKField(entity.getEntryPkFieldName());
            bo.setType(BOSObjectType.create((String)entity.getBosType()));
            entityMap.put(entity.getKey(), bo);
            relation.setSupplierObject(bo);
            if (entity.getEntityType() == 1) {
                relation.setClientCardinality(CardinalityType.ZERO_TO_UNBOUNDED);
            } else {
                relation.setSupplierCardinality(CardinalityType.ONE);
            }
            property.setRelationship(relation);
            property.setConfigured(true);
            property.setName(entity.getEntryName());
            property.setAlias(this.layoutInfo.getEntityAppearance(entity.getKey()).getCaption());
            mainBO.getProperties().add((PropertyInfo)property);
        }
        return mainBO;
    }

    private void createDynamicTable(Context ctx, Entity entity, EntityObjectInfo mainEO) {
        DataTableInfo table = new DataTableInfo();
        mainEO.setTable(table);
        table.setName(entity.getTableName());
        ColumnCollection cols = table.getColumns();
        PrimaryKeyInfo primaryKey = new PrimaryKeyInfo();
        primaryKey.setPKField(entity.getPkFieldName());
        table.setPrimaryKey(primaryKey);
        ColumnInfo col = new ColumnInfo();
        col.setName(entity.getPkFieldName());
        col.setTypeName(SQLType.VARCHAR);
        col.setLength(44);
        cols.add(col);
        this.createKeyProperty(entity, mainEO);
        Vector fields = entity.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            col = new ColumnInfo();
            col.setName(field.getFieldName());
            col.setTypeName(SQLType.NVARCHAR);
            col.setMultilingual(field.isMulLanguage());
            col.setLength(100);
            cols.add(col);
            this.createDynamicProperty(ctx, entity, mainEO, field);
        }
    }

    private void createDynamicProperty(Context ctx, Entity entity, EntityObjectInfo mainEO, Field field) {
        ColumnInfo column;
        if (field.getElementType() == 14) {
            return;
        }
        DataType dataType = DataMappingUtil.getDataTypeForElementType(field.getElementType());
        if (dataType == null || field.getPropertyName() == null) {
            return;
        }
        OwnPropertyInfo thisProp = null;
        if (dataType.equals((Object)DataType.OBJECTVALUE)) {
            LookUpObject lookupObj = this.businessInfo.getLookUpObject(field.getLookUpObjectID());
            if (lookupObj == null || lookupObj.getBosType() == null) {
                return;
            }
            String supplierBosType = lookupObj.getBosType();
            LinkPropertyInfo property = new LinkPropertyInfo();
            RelationshipInfo relation = new RelationshipInfo();
            relation.setType(RelationshipType.ASSOCIATION);
            relation.setPackage(mainEO.getPackage());
            String supplierEntity = "";
            if (lookupObj.getBusinessImplName() != null) {
                supplierEntity = lookupObj.getBusinessImplName().substring(lookupObj.getBusinessImplName().lastIndexOf(46));
            }
            relation.setName("R_" + mainEO.getName() + "_" + supplierEntity + "_" + field.getPropertyName());
            relation.setClientObject(mainEO);
            EntityObjectInfo supplierEO = BusinessProcessUtil.getEntityInfo((Context)ctx, (BOSObjectType)BOSObjectType.create((String)supplierBosType));
            relation.setSupplierObject(supplierEO);
            relation.setClientCardinality(CardinalityType.ZERO_TO_UNBOUNDED);
            if (field.isMustInput()) {
                relation.setSupplierCardinality(CardinalityType.ONE);
            } else {
                relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
            }
            property.setRelationship(relation);
            thisProp = property;
        } else {
            OwnPropertyInfo property = new OwnPropertyInfo();
            property.setDataType(dataType);
            property.setMultilingual(field.isMulLanguage());
            if (dataType == DataType.ENUM && field.getEnumType() > 0) {
                EnumObject enumInfo = this.businessInfo.getEnumInfo().get(String.valueOf(field.getEnumType()));
                if (enumInfo != null && enumInfo.getEnumClassName() != null) {
                    property.setMetadataRef(enumInfo.getEnumClassName());
                } else {
                    property.setDataType(DataType.STRING);
                }
            } else if (dataType == DataType.ENUM) {
                property.setDataType(DataType.STRING);
            }
            thisProp = property;
        }
        thisProp.setConfigured(true);
        thisProp.setName(field.getPropertyName());
        if (field.getFieldName() != null && (column = mainEO.getTable().getColumnByName(field.getFieldName())) != null) {
            thisProp.setMappingField(column);
        }
        mainEO.getProperties().add((PropertyInfo)thisProp);
    }

    private void createKeyProperty(Entity entity, EntityObjectInfo mainEO) {
        OwnPropertyInfo property = new OwnPropertyInfo();
        property.setDataType(DataType.BOSUUID);
        property.setConfigured(true);
        property.setName("id");
        ColumnInfo column = mainEO.getTable().getColumnByName(entity.getPkFieldName());
        if (column != null) {
            property.setMappingField(column);
        }
        LogicalKeyInfo keyinfo = new LogicalKeyInfo();
        keyinfo.setName("id");
        keyinfo.getKeyPropertys().add((PropertyInfo)property);
        mainEO.setLogicalKey(keyinfo);
        mainEO.getProperties().add((PropertyInfo)property);
    }
}

