/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import com.kingdee.eas.base.form.core.PropertyUtil;
import com.kingdee.eas.base.form.metadata.AbstractElement;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.ButtonAppearance;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.FormAppearance;
import com.kingdee.eas.base.form.metadata.KeyChangeListener;
import com.kingdee.eas.base.form.metadata.RadioButtonAppearance;
import com.kingdee.eas.base.form.metadata.TabControlAppearance;
import com.kingdee.eas.base.form.metadata.TabIndexCompare;
import com.kingdee.eas.base.form.metadata.TabPageAppearance;
import com.kingdee.eas.dynbusiness.util.ObjectListMap;
import com.kingdee.util.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class LayoutInfo
implements Serializable,
KeyChangeListener {
    protected HashMap appearanceinfo;
    private ArrayList controls;
    private String key;
    private String id;
    private String caption;
    private String listCaption;
    private String formId;
    private Map actionMap = new ObjectListMap(2);
    private Map buttonMap = new HashMap();

    public String getListCaption() {
        return this.listCaption;
    }

    public void setListCaption(String listCaption) {
        this.listCaption = listCaption;
    }

    public LayoutInfo(String key, String id) {
        this.appearanceinfo = new HashMap();
        this.controls = new ArrayList();
        this.key = key;
        this.id = id;
    }

    public LayoutInfo(String key) {
        this.appearanceinfo = new HashMap();
        this.controls = new ArrayList();
        this.key = key;
        this.id = "";
    }

    public void addOperation(String operation, ControlAppearance button) {
        this.actionMap.put(operation, button);
    }

    public ButtonAppearance[] getButtonByOperation(String operation) {
        List list = (List)this.actionMap.get(operation);
        if (list == null) {
            return new ButtonAppearance[0];
        }
        return list.toArray(new ButtonAppearance[0]);
    }

    public HashMap getAppearanceinfo() {
        return this.appearanceinfo;
    }

    public FormAppearance getFormAppearance() {
        return (FormAppearance)this.getAppearance("_Bill");
    }

    public Appearance getAppearance(String key) {
        return (Appearance)this.appearanceinfo.get(key.toUpperCase());
    }

    public ButtonAppearance getButtonAppearance(String key) {
        return (ButtonAppearance)this.buttonMap.get(key.toUpperCase());
    }

    public ControlAppearance getControlAppearance(String key) {
        if (key == null) {
            return null;
        }
        if (key.indexOf(",") >= 0) {
            key = key.split(",")[0];
        }
        return (ControlAppearance)this.appearanceinfo.get(key.toUpperCase());
    }

    public EntityAppearance getEntityAppearance(String key) {
        return (EntityAppearance)this.appearanceinfo.get(key.toUpperCase());
    }

    public FieldAppearance getFieldAppearance(String key) {
        return (FieldAppearance)this.appearanceinfo.get(key.toUpperCase());
    }

    public void remove(Appearance appearance) {
        if (appearance instanceof TabPageAppearance) {
            this.appearanceinfo.remove(appearance.getKey().toUpperCase());
            return;
        }
        if (appearance instanceof ControlAppearance) {
            ControlAppearance ctl = (ControlAppearance)appearance;
            EntityAppearance billEntryCtl = null;
            if (!(appearance instanceof EntityAppearance)) {
                billEntryCtl = this.getEntityAppearance(ctl.getEntityKey());
            }
            if (billEntryCtl != null) {
                billEntryCtl.getLayoutinfo().remove(appearance);
            } else {
                this.controls.remove(appearance);
            }
        }
        if (appearance instanceof TabControlAppearance) {
            TabControlAppearance tabAp = (TabControlAppearance)appearance;
            Iterator it = tabAp.getTabPages().iterator();
            while (it.hasNext()) {
                this.remove((Appearance)it.next());
            }
        }
        this.appearanceinfo.remove(appearance.getKey().toUpperCase());
    }

    public void add(Appearance appearance) {
        if (appearance instanceof TabPageAppearance) {
            appearance.addKeyChangeListener(this);
            this.appearanceinfo.put(appearance.getKey().toUpperCase(), appearance);
            return;
        }
        if (appearance instanceof ControlAppearance) {
            ControlAppearance ctl = (ControlAppearance)appearance;
            EntityAppearance billEntryCtl = null;
            if (!(ctl instanceof EntityAppearance)) {
                billEntryCtl = this.getEntityAppearance(ctl.getEntityKey());
            } else if (ctl.getControlType() != -1) {
                billEntryCtl = this.getEntityAppearance("FBillHead");
            }
            if (billEntryCtl != null && !(appearance instanceof EntityAppearance)) {
                billEntryCtl.getLayoutinfo().add(appearance);
            } else {
                this.controls.add(appearance);
            }
        }
        appearance.addKeyChangeListener(this);
        this.appearanceinfo.put(appearance.getKey().toUpperCase(), appearance);
        if (appearance instanceof EntityAppearance) {
            EntityAppearance billEntryCtl = (EntityAppearance)appearance;
            ArrayList ctls = billEntryCtl.getLayoutinfo().getControls();
            for (int i = 0; i < ctls.size(); ++i) {
                Appearance ap = (Appearance)ctls.get(i);
                if (this.appearanceinfo.containsKey(ap.getKey().toUpperCase())) continue;
                ap.addKeyChangeListener(this);
                this.appearanceinfo.put(ap.getKey().toUpperCase(), ap);
            }
        }
        if (appearance instanceof TabControlAppearance) {
            TabControlAppearance tabAp = (TabControlAppearance)appearance;
            Iterator it = tabAp.getTabPages().iterator();
            while (it.hasNext()) {
                this.add((Appearance)it.next());
            }
        }
        if (appearance instanceof ButtonAppearance) {
            this.buttonMap.put(appearance.getKey().toUpperCase(), appearance);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ArrayList getControls() {
        Collections.sort(this.controls, new TabIndexCompare(this));
        return this.controls;
    }

    public List getSignControls() {
        ArrayList<Appearance> signControlList = new ArrayList<Appearance>();
        Collections.sort(this.controls, new TabIndexCompare(this));
        for (Appearance ap : this.controls) {
            if (ap == null || !(ap instanceof EntityAppearance)) continue;
            EntityAppearance eap = (EntityAppearance)ap;
            for (Appearance ap1 : eap.getLayoutinfo().getControls()) {
                if (ap1 == null || ap1.getElementType() != 1023) continue;
                signControlList.add(ap1);
            }
        }
        return signControlList;
    }

    public List getMultiApproveControls() {
        ArrayList<Appearance> multiApproveList = new ArrayList<Appearance>();
        Collections.sort(this.controls, new TabIndexCompare(this));
        for (Appearance ap : this.controls) {
            if (ap == null || !(ap instanceof EntityAppearance)) continue;
            EntityAppearance eap = (EntityAppearance)ap;
            for (Appearance ap1 : eap.getLayoutinfo().getControls()) {
                if (ap1 == null || ap1.getElementType() != 1019) continue;
                multiApproveList.add(ap1);
            }
        }
        return multiApproveList;
    }

    public String getTabPath(ControlAppearance ctl) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (ctl != null && ctl.getControlType() != -1) {
            list.add(new Integer(ctl.getTabindex()));
            ctl = this.getControlAppearance(ctl.getContainer());
        }
        StringBuffer sb = new StringBuffer();
        for (int i = list.size() - 1; i > 0; --i) {
            int obj = (Integer)list.get(i);
            String str = obj + "";
            if (obj < 10) {
                str = "000" + str;
            } else if (obj >= 10 && obj < 100) {
                str = "00" + str;
            } else if (obj >= 100 && obj < 1000) {
                str = "0" + str;
            }
            sb.append(str);
            sb.append('.');
        }
        if (list.size() > 0) {
            int obj = (Integer)list.get(0);
            String str = obj + "";
            if (obj < 10) {
                str = "000" + str;
            } else if (obj >= 10 && obj < 100) {
                str = "00" + str;
            } else if (obj >= 100 && obj < 1000) {
                str = "0" + str;
            }
            sb.append(str);
        } else {
            sb.append("0");
        }
        return sb.toString();
    }

    public List getFieldAppearances() {
        ArrayList<Appearance> fieldAppearanceList = new ArrayList<Appearance>();
        for (Appearance ap : this.controls) {
            if (ap == null || !(ap instanceof EntityAppearance)) continue;
            EntityAppearance eap = (EntityAppearance)ap;
            for (Appearance ap1 : eap.getLayoutinfo().getControls()) {
                if (ap1 == null || !(ap1 instanceof FieldAppearance)) continue;
                fieldAppearanceList.add(ap1);
            }
        }
        return fieldAppearanceList;
    }

    public boolean containsKey(String key) {
        return this.appearanceinfo.containsKey(key);
    }

    public Object clone() throws CloneNotSupportedException {
        LayoutInfo cloneLayout = (LayoutInfo)ObjectUtils.createCopy((Object)this);
        cloneLayout.id = "";
        if (cloneLayout.appearanceinfo != null) {
            for (Object key : cloneLayout.appearanceinfo.keySet()) {
                Appearance ap = cloneLayout.getAppearance(key.toString());
                this.clearID(ap);
            }
        }
        return cloneLayout;
    }

    public Object cloneWithNewKey() throws CloneNotSupportedException {
        String newKey;
        LayoutInfo cloneLayout = (LayoutInfo)ObjectUtils.createCopy((Object)this);
        cloneLayout.key = newKey = this.createKey();
        cloneLayout.id = "";
        FormAppearance bap = (FormAppearance)cloneLayout.getAppearance("_Bill");
        bap.setId("");
        bap.setLayoutKey(newKey);
        if (cloneLayout.controls != null) {
            for (Appearance ap : cloneLayout.controls) {
                this.clearID(ap);
            }
        }
        if (cloneLayout.appearanceinfo != null) {
            for (Object key : cloneLayout.appearanceinfo.keySet()) {
                Appearance ap = cloneLayout.getAppearance(key.toString());
                this.clearID(ap);
            }
        }
        return cloneLayout;
    }

    private String createKey() {
        Random ra = new Random();
        int tmp = ra.nextInt(1000);
        String key = "layoutKey" + tmp;
        return key;
    }

    public void clearID(Appearance appearance) {
        appearance.setId("");
        if (appearance instanceof EntityAppearance) {
            EntityAppearance billEntryCtl = (EntityAppearance)appearance;
            ArrayList ctls = billEntryCtl.getLayoutinfo().getControls();
            for (int i = 0; i < ctls.size(); ++i) {
                Appearance ap = (Appearance)ctls.get(i);
                ap.setId("");
            }
        }
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String toString() {
        return this.caption;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    @Override
    public void keyChanged(AbstractElement element, String newKey, String oldKey) {
        Appearance el;
        this.appearanceinfo.remove(oldKey.toUpperCase());
        this.appearanceinfo.put(newKey.toUpperCase(), element);
        if (element instanceof EntityAppearance) {
            EntityAppearance eap = (EntityAppearance)element;
            for (ControlAppearance ctl : eap.getLayoutinfo().getControls()) {
                ctl.setEntityKey(newKey);
            }
        }
        if (element.getElementType() == 32) {
            for (Object obj : this.appearanceinfo.keySet()) {
                el = (Appearance)this.appearanceinfo.get(obj);
                if (el.getElementType() != 25 || ((RadioButtonAppearance)el).getButtonGroup() == null || !((RadioButtonAppearance)el).getButtonGroup().equalsIgnoreCase(oldKey)) continue;
                ((RadioButtonAppearance)el).setButtonGroup(newKey);
            }
        }
        for (Object obj : this.appearanceinfo.keySet()) {
            el = (Appearance)this.appearanceinfo.get(obj);
            PropertyUtil.dealAction(el, newKey, oldKey);
        }
    }

    public ButtonAppearance[] getAllButtonAppearances() {
        return this.buttonMap.values().toArray(new ButtonAppearance[0]);
    }
}

