/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model;

import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.metadata.EnumBarItemStyle;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.BarItemPropertyChangedListener;
import com.kingdee.eas.base.form.model.BarModelListener;
import java.util.List;
import java.util.Map;

public abstract class BarBuilderBase
implements BarModelListener,
BarItemPropertyChangedListener {
    private BarDataManager barDataMgr;

    public BarDataManager getBarBuilder() {
        return this.barDataMgr;
    }

    public BarBuilderBase(BarDataManager barBuilder) {
        this.barDataMgr = barBuilder;
    }

    public void loadBarItems() {
        if (this.barDataMgr == null) {
            return;
        }
        Map topItems = this.barDataMgr.getTopLevelBarItems();
        for (Map.Entry entry : topItems.entrySet()) {
            BarItem item = (BarItem)entry.getValue();
            if (item.getVisible() != 1) continue;
            this.createBar(item);
        }
    }

    protected abstract Object getMainMenu();

    protected abstract Object getToolbar();

    protected void createMainMenu(BarItem barItem) {
        List children = barItem.getChildren();
        for (BarItem item : children) {
            if (!this.createInvisibleBarItem() && item.getVisible() != 1) continue;
            this.add2Parent(this.getMainMenu(), this.createSubMenuStruct(item));
        }
    }

    protected Object createSubMenuStruct(BarItem barItem) {
        Object subMenu = this.createSubMenu(barItem);
        List children = barItem.getChildren();
        for (BarItem item : children) {
            if (!this.createInvisibleBarItem() && item.getVisible() != 1) continue;
            if (EnumBarItemStyle.Seperator.equals(barItem.getStyle())) {
                this.add2Parent(this.getSubMenuContainer(subMenu), this.createMenuSeparator(item));
                continue;
            }
            this.add2Parent(this.getSubMenuContainer(subMenu), this.createMenuItem(item));
        }
        return subMenu;
    }

    protected abstract Object createSubMenu(BarItem var1);

    protected abstract Object createMenuItem(BarItem var1);

    protected abstract Object createMenuSeparator(BarItem var1);

    protected abstract Object createToolbarSeparator(BarItem var1);

    protected abstract Object createToolbarButton(BarItem var1);

    protected abstract void add2Parent(Object var1, Object var2);

    protected Object getSubMenuContainer(Object subMenu) {
        return subMenu;
    }

    protected boolean createInvisibleBarItem() {
        return true;
    }

    protected void createToolbar(BarItem barItem) {
        List children = barItem.getChildren();
        for (BarItem item : children) {
            if (!this.createInvisibleBarItem() && item.getVisible() != 1) continue;
            switch (item.getStyle().getValue()) {
                case 11: {
                    this.add2Parent(this.getToolbar(), this.createToolbarSeparator(item));
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    break;
                }
                case 0: {
                    this.add2Parent(this.getToolbar(), this.createToolbarButton(item));
                }
            }
        }
    }

    private void createBar(BarItem barItem) {
        if (barItem == null) {
            return;
        }
        switch (barItem.getStyle().getValue()) {
            case 7: {
                this.createMainMenu(barItem);
                break;
            }
            case 12: {
                this.createToolbar(barItem);
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
    }

    protected BarItem getBarItem(String name) {
        return this.barDataMgr.getBarItem(name);
    }
}

