/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.BusinessServiceFactory;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.DynamicFormEventsProxy;
import com.kingdee.eas.base.form.model.GetFieldFilterException;
import com.kingdee.eas.base.form.model.IDynamicFormModel;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.util.ExpressionUtil;
import com.kingdee.eas.base.form.util.NewF7Utils;
import com.kingdee.eas.base.form.util.StringUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DynamicFormModel
implements IDynamicFormModel {
    private static final Logger logger = Logger.getLogger(DynamicFormModel.class);
    protected DynamicFormApplication application;
    protected HashMap hsData;
    protected BusinessInfo businessInfo;
    protected DynamicFormEventsProxy.ModelEventsProxy eventsProxy;
    private OrgUnitInfo mainOrgUnit;
    protected boolean isInitialize;

    public DynamicFormModel(BusinessInfo businessInfo) {
        this.businessInfo = businessInfo;
    }

    @Override
    public void beginIniti() {
        this.isInitialize = true;
    }

    @Override
    public void endIniti() {
        this.isInitialize = false;
    }

    @Override
    public Object getValue(String key, int row) {
        return this.getValue(key, row, 0);
    }

    public Object getValue(String key, int row, int valueType) {
        HashMap dctValue = this.getValueObject(key, row);
        Object retVal = null;
        if (dctValue != null) {
            switch (valueType) {
                case 0: {
                    retVal = dctValue.get("Value");
                    break;
                }
                case 1: {
                    retVal = dctValue.get("DSPValue");
                    break;
                }
                case 2: {
                    retVal = dctValue.get("NUMValue");
                }
            }
            return retVal;
        }
        return null;
    }

    @Override
    public void setValue(String key, Object value, int row) throws BOSException, EASBizException {
        this.setValue(key, row, value, 0);
    }

    public void setValue(String key, int row, Object value, int valueType) {
        HashMap dctValue = this.getValueObject(key, row);
        String valueKey = null;
        Object oldValue = null;
        if (dctValue != null) {
            switch (valueType) {
                case 0: {
                    valueKey = "Value";
                    break;
                }
                case 1: {
                    valueKey = "DSPValue";
                    break;
                }
                case 2: {
                    valueKey = "NUMValue";
                }
            }
            oldValue = dctValue.get(valueKey);
            dctValue.put(valueKey, value);
            if (this.eventsProxy != null) {
                this.eventsProxy.fireDataChanged(new DataChangeCommandArg(key, oldValue, value));
            }
        }
    }

    public HashMap getValueObject(String key, int row) {
        Field fld;
        HashMap dctValue = null;
        if (this.businessInfo.getElement(key) instanceof Field && (fld = (Field)this.businessInfo.getElement(key)) != null) {
            ArrayList listObj = (ArrayList)this.hsData.get(fld.getEntityKey().toUpperCase());
            if (listObj == null) {
                listObj = (ArrayList)this.hsData.get(fld.getEntityKey());
            }
            if (listObj != null) {
                HashMap dct = (HashMap)listObj.get(row);
                dctValue = (HashMap)dct.get(fld.getKey());
            } else {
                System.out.println("-------------Fatal error ,getValueObject --" + fld.getEntityKey().toUpperCase() + " or -" + fld.getEntityKey() + "--not in hsData");
            }
        }
        return dctValue;
    }

    @Override
    public void setEventsProxy(DynamicFormEventsProxy.ModelEventsProxy eventsProxy) {
        this.eventsProxy = eventsProxy;
    }

    @Override
    public String getDisplayValue(Object objValue, Field field, String displayPattern) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public IObjectCollection getEntryData(Entity entity) {
        return null;
    }

    @Override
    public int getEntryRowCount(Entity entity) {
        return 0;
    }

    @Override
    public OrgUnitInfo getMainOrgUnit() {
        if (this.mainOrgUnit != null) {
            logger.info((Object)("DynamicFormModel::getMainOrgUnit()----11-----mainOrgUnit.id=" + this.mainOrgUnit.getId().toString()));
            return this.mainOrgUnit;
        }
        logger.info((Object)"DynamicFormModel::getMainOrgUnit()----00-----mainOrgUnit=");
        this.mainOrgUnit = (OrgUnitInfo)this.application.getContext().get((Object)this.getMainOrgType());
        if (this.mainOrgUnit != null) {
            logger.info((Object)("DynamicFormModel::getMainOrgUnit()----22-----mainOrgUnit.id=" + this.mainOrgUnit.getId().toString()));
            return this.mainOrgUnit;
        }
        logger.info((Object)("DynamicFormModel::getMainOrgUnit()----33-----mainOrgUnit=" + this.mainOrgUnit));
        this.mainOrgUnit = (OrgUnitInfo)this.application.getContext().get((Object)"CurOU");
        logger.info((Object)("DynamicFormModel::getMainOrgUnit()----44-----mainOrgUnit=" + this.mainOrgUnit));
        return this.mainOrgUnit;
    }

    public void setMainOrgUnit(OrgUnitInfo mainOrgUnit) {
        Thread.dumpStack();
        logger.info((Object)("DynamicFormModel::setMainOrgUnit()-----mainOrgUnit=" + mainOrgUnit));
        this.mainOrgUnit = mainOrgUnit;
    }

    @Override
    public void getItemByKey(String key, String filterName, String value, int row) throws BOSException, EASBizException {
        Field field = (Field)this.businessInfo.getElement(key);
        LookUpObject lookupObj = this.businessInfo.getLookUpObject(field.getLookUpObjectID());
        if (lookupObj == null) {
            return;
        }
        if (value == null || value.trim().length() == 0) {
            this.application.setValue(key, null, row);
            return;
        }
        String[] selectors = null;
        List list = field.getSelectors();
        if (list != null) {
            selectors = list.toArray(new String[0]);
        }
        if (field.getElementType() != 24) {
            Entity entity = this.businessInfo.getEntity(field.getEntityKey());
            if (field.isMulLines() && value.indexOf(44) > 0 && entity.getEntityType() == 1) {
                IObjectCollection objCollection = BusinessServiceFactory.getBusinessService().getBaseDatasByKeys(this.application.getContext(), lookupObj, filterName, value, null, selectors);
                this.inputMultiLines(field, objCollection.toArray(), row);
            } else {
                IObjectValue baseData = BusinessServiceFactory.getBusinessService().getBaseDataByKey(this.application.getContext(), lookupObj, filterName, value, null, selectors);
                this.application.setValue(key, baseData, row);
            }
        } else {
            IObjectCollection objCollection = BusinessServiceFactory.getBusinessService().getBaseDatasByKeys(this.application.getContext(), lookupObj, filterName, value, null, selectors);
            String values = StringUtil.buildStringForObjNameAndNumber(new NewF7Utils().getSortedListOfInputOrder(objCollection, filterName, value).toArray());
            this.application.setValue(key, values, row);
        }
    }

    protected void inputMultiLines(Field field, Object[] values, int row) throws EASBizException, BOSException {
        if (values.length > 0) {
            this.application.setValue(field.getKey(), values[0], row);
        }
    }

    @Override
    public void setApplication(DynamicFormApplication application) {
        this.application = application;
    }

    @Override
    public String getFieldFilter(String key, int row) throws BOSException {
        Field ctrlField;
        Field field = (Field)this.businessInfo.getElement(key);
        LookUpObject lookup = this.businessInfo.getLookUpObject(field.getLookUpObjectID());
        String lookupObjFilter = lookup.getCtlFieldFiler();
        String filter = field.getFilter();
        boolean filterIsEmpty = StringUtils.isEmpty((String)filter);
        boolean lookupObjIsEmpty = StringUtils.isEmpty((String)lookupObjFilter);
        if (filterIsEmpty && lookupObjIsEmpty) {
            throw new GetFieldFilterException("\u5b57\u6bb5\uff1a" + key + " \u8bbe\u7f6e\u4e86\u8054\u52a8\u5b57\u6bb5\uff0c\u4f46\u662f\u6ca1\u6709\u5728f7\u57fa\u7840\u8d44\u6599\u4e2d\u8bbe\u7f6e\u7528\u4e8e\u5173\u8054\u8054\u52a8\u5b57\u6bb5\u7684\u5c5e\u6027.", 3);
        }
        if (!filterIsEmpty) {
            try {
                filter = ExpressionUtil.handleParamFillingValue(this.application, field.getFilter(), row, false);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (!lookupObjIsEmpty && !StringUtils.isEmpty((String)field.getControlFieldKey()) && (ctrlField = this.businessInfo.getField(field.getControlFieldKey())) != null) {
            String filterValue = this.getControlKeyValue(field, row);
            if (filterValue == null) {
                throw new GetFieldFilterException(ctrlField.getKey(), 1);
            }
            filter = !filterIsEmpty ? "(" + filter + ") and " + lookupObjFilter + "='" + filterValue + "'" : lookupObjFilter + "='" + filterValue + "'";
        }
        return filter;
    }

    private String getControlKeyValue(Field field, int row) {
        String retValue = null;
        String ctrlKey = field.getControlFieldKey();
        Object filterValue = null;
        if (ctrlKey != null && ctrlKey.trim().length() > 0) {
            filterValue = this.getValue(ctrlKey, row);
        }
        if (filterValue instanceof ObjectBaseInfo) {
            retValue = ((ObjectBaseInfo)filterValue).get("id").toString();
        } else if (filterValue != null) {
            retValue = filterValue.toString();
        }
        return retValue;
    }

    @Override
    public void createNewData() throws BOSException, EASBizException {
        this.hsData = new HashMap();
        List entitys = this.businessInfo.getEntrys();
        for (int i = 0; i < entitys.size(); ++i) {
            Entity entity = (Entity)entitys.get(i);
            ArrayList<HashMap> list = new ArrayList<HashMap>();
            list.add(this.createNewEntryRow(entity));
            this.hsData.put(entity.getKey(), list);
        }
    }

    @Override
    public void createNewEntryRow(String entityKey) throws BOSException, EASBizException {
        Entity entity = (Entity)this.businessInfo.getElement(entityKey);
        this.createNewEntryRow(entity);
        this.hsData = new HashMap();
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        list.add(this.createNewEntryRow(entity));
        this.hsData.put(entity.getKey(), list);
    }

    private HashMap createNewEntryRow(Entity entity) {
        HashMap dct = new HashMap();
        Vector vctFields = entity.getFields();
        for (int i = 0; i < vctFields.size(); ++i) {
            Field fld = (Field)vctFields.get(i);
            HashMap dctValue = new HashMap();
            dct.put(fld.getKey(), dctValue);
        }
        return dct;
    }

    @Override
    public String getPKValue() {
        return null;
    }

    @Override
    public OrgType getMainOrgType() {
        OrgType mainOrgType = null;
        logger.info((Object)("DynamicFormModel::getMainOrgType()---------this.businessInfo.getForm().getBosType()=" + this.businessInfo.getForm().getBosType()));
        if (!StringUtils.isEmpty((String)this.businessInfo.getForm().getBosType())) {
            mainOrgType = BusinessProcessUtil.getOrgTypeFromEntity((Context)this.application.getContext(), (BOSObjectType)BOSObjectType.create((String)this.businessInfo.getForm().getBosType()));
        }
        if (null != mainOrgType) {
            logger.info((Object)("DynamicFormModel::getMainOrgType()---------mainOrgType.getName()=" + mainOrgType.getName()));
        } else {
            logger.info((Object)"DynamicFormModel::getMainOrgType()---------mainOrgType is null");
        }
        return mainOrgType;
    }

    @Override
    public BusinessInfo getBusinessInfo() {
        return this.businessInfo;
    }

    @Override
    public Object getModelValue() {
        return null;
    }
}

