/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.expression.ExpressionEvaluator;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.condition.ObjectValueSearcher;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import com.kingdee.eas.dynbusiness.util.ValidationUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public final class ExpressionUtil {
    static final Logger logger = Logger.getLogger(ExpressionUtil.class);

    public static String handleParamFillingValue(DynamicFormApplication application, String urlParam, int row, boolean stringWithMark) throws BOSException, EASBizException {
        String rep;
        Object value;
        if (urlParam == null) {
            return null;
        }
        IObjectValue objValue = null;
        Object modelValue = application.getDynamicFormModel().getModelValue();
        if (modelValue instanceof IObjectValue) {
            objValue = (IObjectValue)modelValue;
        }
        String result = urlParam;
        ExpressionParser expParser = ExpressionParser.getInstance();
        String[] funcs = expParser.parseFunctions(result);
        if (funcs.length > 0) {
            for (int i = 0; i < funcs.length; ++i) {
                ExpressionEvaluator evaluator = new ExpressionEvaluator(application, application.getDynamicFormModel().getBusinessInfo(), objValue, funcs[i], row);
                value = evaluator.evaluate();
                rep = null;
                rep = funcs[i].startsWith("AppendFilter") ? value.toString() : ExpressionUtil.toStringParam(stringWithMark, value);
                result = result.replaceAll(expParser.castRegular(funcs[i]), rep);
            }
        }
        String[] vars = expParser.splitBracesVariables(result);
        for (int i = 0; i < vars.length; ++i) {
            if (vars[i] == null) continue;
            value = ExpressionUtil.searchVariableValue(application, vars[i], objValue, row, true);
            rep = ExpressionUtil.toStringParam(stringWithMark, value);
            result = result.replaceAll(expParser.castRegular(vars[i]), rep);
        }
        return result;
    }

    public static Object searchVariableValue(DynamicFormApplication application, String expr, IObjectValue objValue, int row, boolean insteadOfNull) throws BOSException {
        if (StringUtils.isEmpty((String)expr)) {
            return null;
        }
        Object value = null;
        String var = null;
        boolean isField = ExpressionUtil.isFieldName(expr);
        if (isField) {
            var = ExpressionUtil.removeFormatSymbol(expr);
            value = application.searchValue(var, row);
        } else if (ExpressionUtil.isPropertyName(expr)) {
            var = ExpressionUtil.removeFormatSymbol(expr);
            value = ObjectValueSearcher.searchValue((Object)objValue, (String)var, (int)0, null, null, (int)row);
        }
        if (value == null && insteadOfNull) {
            value = ExpressionUtil.insteadOfNull(application, var, isField);
        }
        return value;
    }

    private static String toStringParam(boolean stringWithMark, Object value) throws BOSException {
        String rep;
        if (value instanceof IObjectValue) {
            IObjectValue ov = (IObjectValue)value;
            value = ov.get(ov.getPKField()).toString();
        } else if (value instanceof BOSUuid) {
            value = value.toString();
        }
        if (value instanceof String && stringWithMark && !ExpressionUtil.isSqlText((String)value)) {
            rep = "'" + value + "'";
        } else if (value instanceof Date || value instanceof Timestamp) {
            SimpleDateFormat formatter = new SimpleDateFormat("{yyyy-MM-dd}");
            rep = formatter.format(value);
        } else {
            rep = value != null ? value.toString() : "null";
        }
        return rep;
    }

    private static Object insteadOfNull(DynamicFormApplication billApp, String key, boolean isField) throws BOSException {
        Object value = null;
        DataType dataType = null;
        if (isField) {
            Field field = billApp.getDynamicFormModel().getBusinessInfo().getField(key);
            if (field == null) {
                logger.error((Object)("setValue\u9519\u8bef\uff1a\u4e0d\u5b58\u5728Key\u4e3a" + key + "\u7684\u5b57\u6bb5"));
                return null;
            }
            int elementType = field.getElementType();
            dataType = DataMappingUtil.getDataTypeForElementType(elementType);
        } else {
            PropertyInfo property = BusinessProcessUtil.getPropertyInfo((Context)billApp.getContext(), (BOSObjectType)BOSObjectType.create((String)billApp.getDynamicFormModel().getBusinessInfo().getForm().getBosType()), (String)key);
            if (property instanceof OwnPropertyInfo) {
                dataType = ((OwnPropertyInfo)property).getDataType();
            }
        }
        if (dataType != null) {
            value = ValidationUtils.insteadOfNull(null, (DataType)dataType);
        }
        return value;
    }

    public static boolean isFieldName(String name) {
        return name != null && name.startsWith("[") && name.endsWith("]");
    }

    public static boolean isPropertyName(String name) {
        return name != null && name.startsWith("{") && name.endsWith("}");
    }

    public static boolean isSqlText(String name) {
        return name != null && name.startsWith("'") && name.endsWith("'");
    }

    public static String removeFormatSymbol(String text) {
        return text.substring(1, text.length() - 1);
    }

    public static boolean isStringConstant(String str) {
        return str != null && str.startsWith("\"") && str.endsWith("\"");
    }
}

