/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.core.OpenModeEnum;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.metadata.ButtonAppearance;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.IFormBusiness;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public final class FormActionUtil {
    public static void invokeAction(IFormApplication application, ActionArgs args) throws BOSException, EASBizException {
        try {
            Class<?> clz = Class.forName(args.getAction().getClassName());
            Constructor<?> constructor = clz.getConstructor(IFormApplication.class);
            IFormBusiness iBillBusiness = (IFormBusiness)constructor.newInstance(application);
            iBillBusiness.doAction(args);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void invokeAction(IFormApplication application, Object source, Action action, Object value, int row) throws BOSException, EASBizException {
        ActionArgs args = new ActionArgs(source, action, row, value);
        FormActionUtil.invokeAction(application, args);
    }

    public static void invokeActions(IFormApplication application, Object source, List actions, Object value, int actionType, int row) throws BOSException, EASBizException {
        if (actions == null) {
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            Action action = (Action)actions.get(i);
            if (actionType != action.getType()) continue;
            FormActionUtil.invokeAction(application, source, action, value, row);
        }
    }

    public static void invokeAction(IFormApplication application, Object source, Action action, Object value) throws BOSException, EASBizException {
        ActionArgs args = new ActionArgs(source, action, 0, value);
        FormActionUtil.invokeAction(application, args);
    }

    public static void invokeActions(IFormApplication application, Object source, List actions, Object value, int actionType) throws BOSException, EASBizException {
        if (actions == null) {
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            Action action = (Action)actions.get(i);
            if (actionType != action.getType()) continue;
            FormActionUtil.invokeAction(application, source, action, value);
        }
    }

    public static void invokeShowPopupAction(IFormApplication application, String urlParam, String winParam, String url, OpenModeEnum openMode) throws BOSException, EASBizException {
        JSONArray jsa = new JSONArray();
        jsa.put("Custom");
        jsa.put(openMode.getValue());
        jsa.put(url);
        jsa.put(urlParam);
        jsa.put(winParam);
        Action action = new Action("com.kingdee.eas.base.form.plugin.ShowPopupAction", jsa.toString());
        FormActionUtil.invokeAction(application, null, action, null);
    }

    public static String getFormOperationName(Appearance button, String className) {
        if (button == null || className == null) {
            return null;
        }
        ArrayList actions = null;
        if (button instanceof BarItem) {
            actions = ((BarItem)button).getClickActions();
        } else if (button instanceof ButtonAppearance) {
            actions = ((ButtonAppearance)button).getClickActions();
        } else if (button instanceof EntityAppearance) {
            actions = ((EntityAppearance)button).getDblClickActions();
        }
        if (actions == null || actions.size() == 0) {
            return null;
        }
        for (int i = 0; i < actions.size(); ++i) {
            String[] parameters;
            Action action = (Action)actions.get(i);
            if (!className.equals(action.getClassName()) || (parameters = action.getParameters()).length == 0) continue;
            return parameters[0];
        }
        return null;
    }

    public static void invokeBillFunction(IFormApplication application, String function, String entityKey) throws EASBizException, BOSException {
        JSONArray jsa = new JSONArray();
        jsa.put(function);
        if (!StringUtils.isEmpty((String)entityKey)) {
            jsa.put(entityKey);
        }
        Action action = new Action("com.kingdee.eas.base.form.plugin.BillAction", jsa.toString());
        ActionArgs args = new ActionArgs(null, action, 0);
        FormActionUtil.invokeAction(application, args);
    }

    public static void invokeElectronicSignAction(IFormApplication application, String key) throws BOSException, EASBizException {
        FormActionUtil.invokeElectronicSignAction(application, key, Boolean.FALSE);
    }

    public static void invokeElectronicSignAction(IFormApplication application, String key, Boolean isDeleteSign) throws BOSException, EASBizException {
        if (key == null || key.trim().length() <= 0) {
            throw new ActionCommonException(null, "\u5f53\u524d\u5ba1\u6279\u6ca1\u6709\u8bbe\u5b9a\u7535\u5b50\u7b7e\u7ae0\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff01");
        }
        Action action = new Action("com.kingdee.eas.base.form.extend.plugins.ElectronicSignatureAction", null);
        FormActionUtil.invokeAction(application, key, action, isDeleteSign);
    }
}

