/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.app.CommonQueryUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.service.CoopOrgHelper;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgDataPermissionService;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.OrgUnitUtil;
import com.kingdee.eas.dynbusiness.util.SortUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class PermissionHelper {
    public static String getPersmissionRule(Context ctx, String permItemName, List orgList, String mainOrgPropertyName) throws BOSException {
        String rule = null;
        try {
            PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, permItemName);
            if (orgList.size() > 1) {
                rule = PermissionHelper.getDataPermissionRule(ctx, permItemInfo, orgList, mainOrgPropertyName);
            } else if (orgList.size() == 1) {
                ObjectUuidPK orgPk = new ObjectUuidPK((String)orgList.get(0));
                rule = PermissionHelper.getDataPermissionRule(ctx, permItemInfo, (IObjectPK)orgPk);
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return rule;
    }

    private static String getDataPermissionRule(Context ctx, PermItemInfo permItemInfo, IObjectPK orgPK) throws EASBizException, BOSException {
        String rule = null;
        if (!StringUtils.isEmpty((String)permItemInfo.getObjectType()) && permItemInfo.isEnableDataPermission()) {
            IObjectPK userPK = ctx.getCaller();
            IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
            rule = provider.getPermissionRule(userPK, orgPK, permItemInfo.getName());
            if (StringUtils.isEmpty((String)rule)) {
                rule = null;
            }
        }
        return rule;
    }

    private static String getDataPermissionRule(Context ctx, PermItemInfo permItemInfo, List orgList, String mainOrgPropertyName) throws EASBizException, BOSException, ParserException {
        IObjectPK userPK = ctx.getCaller();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)permItemInfo.getOrgRelation()));
        FullOrgUnitCollection fullOrgCol = iPermission.getAuthorizedOrg(userPK, permItemInfo.getOrgRelation(), (IObjectPK)treePK, permItemInfo.getName());
        List authorizedOrgs = ToolUtils.transCol2ListByPeroperty((IObjectCollection)fullOrgCol, (IObjectCol2List)new IObjectCol2List(){

            public String getList(Object obj) {
                return ((FullOrgUnitInfo)obj).getId().toString();
            }
        });
        Collection lastPermCol = CollectionUtils.intersection((Collection)authorizedOrgs, (Collection)orgList);
        if (lastPermCol == null || lastPermCol.isEmpty()) {
            return " WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' AND id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )";
        }
        String rule = PermissionHelper.getMultiOrgPermissionRule(ctx, userPK, lastPermCol, permItemInfo, mainOrgPropertyName);
        return rule;
    }

    private static String getMultiOrgPermissionRule(Context ctx, IObjectPK userPK, Collection orgCollection, PermItemInfo permItemInfo, String mainOrgPropertyName) throws EASBizException, BOSException, ParserException {
        String ruleStr = "";
        String orgFieldName = mainOrgPropertyName + ".id";
        MultiOrgDataPermissionService mpService = new MultiOrgDataPermissionService(ctx);
        ruleStr = mpService.getPermissionRule(userPK, orgCollection, permItemInfo.getName(), orgFieldName);
        if (ruleStr != null && ruleStr.indexOf("$currentUser$") > 0) {
            ruleStr = CommonQueryUtil.getInnerFilterInfo((Context)ctx, (String)ruleStr);
        }
        String[] coopOrgFieldName = CoopOrgHelper.appendPropID((String[])PermissionHelper.getCoopFieldNameFromCtx(ctx, permItemInfo));
        return PermissionHelper.getMergedRule(ctx, orgCollection, orgFieldName, coopOrgFieldName, ruleStr);
    }

    private static String[] getCoopFieldNameFromCtx(Context ctx, PermItemInfo permItemInfo) throws EASBizException {
        String[] orgFieldStr = PermissionUtil.getBizOrgCoopPropertyName((Context)ctx, (BOSObjectType)BOSObjectType.create((String)permItemInfo.getObjectType()));
        return orgFieldStr;
    }

    private static String getMergedRule(Context ctx, Collection orgCollection, String orgFieldName, String[] coopFieldName, String ruleStr) throws BOSException, ParserException {
        FilterInfo coOrgFI;
        EntityViewInfo evi = null;
        IPermissionServiceProvider iPermissionService = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(orgFieldName, (Object)ToolUtils.aryToStr((Collection)orgCollection, (boolean)false), CompareType.INCLUDE));
        if (!StringUtils.isEmpty((String)ruleStr)) {
            evi = new EntityViewInfo(ruleStr);
            evi.getFilter().mergeFilter(filterInfo, "AND");
        } else {
            evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
        }
        if (coopFieldName != null && (coOrgFI = CoopOrgHelper.getCoopOrgFilterInfo((String[])coopFieldName, (Collection)orgCollection)) != null) {
            evi.getFilter().mergeFilter(coOrgFI, "OR");
        }
        return evi.toString();
    }

    public static OrgUnitInfo getDefaultMainOrg(Context ctx, OrgType orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitInfo loginOrg = (OrgUnitInfo)ctx.get((Object)orgType);
        OrgUnitCollection collection = OrgUnitUtil.getAuthOrgByPermItem((Context)ctx, (OrgType)orgType, (String)permissionItem);
        OrgUnitCollection bizOrgs = OrgUnitUtil.getOrgUnitInfosByType((Context)ctx, (OrgUnitCollection)collection, (OrgType)orgType);
        if (bizOrgs == null) {
            return null;
        }
        int size = bizOrgs.size();
        if (size > 0) {
            OrgUnitInfo[] mainOrgs = new OrgUnitInfo[size];
            if (size > 0) {
                Object[] objects = bizOrgs.toArray();
                System.arraycopy(objects, 0, mainOrgs, 0, size);
            }
            if (loginOrg != null) {
                String loginOrgId = loginOrg.getId().toString();
                for (int i = 0; i < mainOrgs.length; ++i) {
                    if (!loginOrgId.equals(mainOrgs[i].getId().toString())) continue;
                    return mainOrgs[i];
                }
            }
            mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            return mainOrgs[0];
        }
        return loginOrg;
    }
}

