/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.dynbusiness.util.ResourceUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Locale;

public final class ResourceUtil {
    public static String FORMRESOURCE = "com.kingdee.eas.base.form.core.FormResource";

    public static String getLanguage(Context ctx) {
        Locale locale = ctx.getLocale();
        String language = locale.getLanguage();
        return language.toUpperCase();
    }

    public static String getMessage(Context ctx, String msgName, String[] parameters) {
        return ResourceUtils.getMessageInOrder((Context)ctx, (String)FORMRESOURCE, (String)msgName, (String[])parameters);
    }

    public static String getMessage(Context ctx, String msgName) {
        return ResourceUtils.getMessage((Context)ctx, (String)FORMRESOURCE, (String)msgName);
    }

    public static String buildUrlEncodeParam(String url, String param) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(url);
        if (param != null) {
            try {
                JSONObject js = new JSONObject(param);
                Iterator iter = js.keys();
                if (js.length() > 0) {
                    sb.append("?");
                }
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    sb.append(key).append("=").append(ResourceUtil.encodeParam(js.getString(key)));
                    sb.append("&");
                }
                if (js.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
            }
            catch (JSONException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return sb.toString();
    }

    public static void encodeParam(JSONObject param) throws BOSException {
        if (param == null) {
            return;
        }
        Iterator iter = param.keys();
        try {
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object value = param.get(key);
                if (!(value instanceof String)) continue;
                param.put(key, ResourceUtil.encodeParam((String)value));
            }
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String encodeParam(String value) throws BOSException {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

