/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.EnumItem;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.dynbusiness.util.DataConverter;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.util.List;

public class UnifiedEnumUtils {
    public static int getFieldEnumColType(BusinessInfo bizInfo, Field field) {
        int fieldColType = field.getFieldColType();
        return fieldColType;
    }

    public static int getEnumColType(EnumObject enumObj) {
        List enumItems;
        int fieldColType = 10;
        if (UnifiedEnumUtils.isEnumClassType(enumObj) && (enumItems = EnumUtils.getEnumList((String)enumObj.getEnumClassName())).size() > 0 && enumItems.get(0) instanceof StringEnum) {
            fieldColType = 500;
        }
        return fieldColType;
    }

    public static boolean isEnumClassType(String enumClassName) {
        return !StringUtils.isEmpty((String)enumClassName);
    }

    public static boolean isEnumClassType(EnumObject enumObj) {
        return UnifiedEnumUtils.isEnumClassType(enumObj.getEnumClassName());
    }

    public static String getDisplayString(EnumObject enumObj, int elementType, Object value) throws DataConverter.DataConvertException {
        if (value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            return "";
        }
        if (elementType == 9) {
            return UnifiedEnumUtils.getDisplayStringOfSingleEnumItem(enumObj, value);
        }
        if (elementType == 29) {
            return UnifiedEnumUtils.getDisplayStringOfMultiEnumItem(enumObj, value);
        }
        return "";
    }

    public static String getDisplayStringOfSingleEnumItem(EnumObject enumObj, Object value) throws DataConverter.DataConvertException {
        if (StringUtils.isEmpty((String)enumObj.getEnumClassName())) {
            return UnifiedEnumUtils.getDisplayStringFromCustomizedEnum(enumObj, value);
        }
        return UnifiedEnumUtils.getDisplayStringFromEnumClass(value, enumObj.getEnumClassName());
    }

    public static String getDisplayStringOfMultiEnumItem(EnumObject enumObj, Object value) throws DataConverter.DataConvertException {
        if (value instanceof String) {
            String[] items = ((String)value).split(",");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < items.length; ++i) {
                sb.append(",").append(UnifiedEnumUtils.getDisplayStringOfSingleEnumItem(enumObj, items[i]));
            }
            return sb.substring(1);
        }
        return "";
    }

    public static String getDisplayStringFromEnumClass(Object value, String className) throws DataConverter.DataConvertException {
        if (value instanceof Enum) {
            return ((Enum)value).getAlias();
        }
        if (value instanceof String && StringUtils.isEmpty((String)((String)value))) {
            return "";
        }
        Object enumValue = DataConverter.convertToRealType((Object)value, (DataType)DataType.ENUM, (String)className);
        if (enumValue instanceof Enum) {
            return ((Enum)enumValue).getAlias();
        }
        return "";
    }

    public static String getDisplayStringFromCustomizedEnum(EnumObject enumObj, Object value) {
        int enumValue;
        if (value instanceof Integer) {
            enumValue = (Integer)value;
        } else if (value instanceof String) {
            enumValue = Integer.parseInt((String)value);
        } else if (value instanceof BigDecimal) {
            enumValue = ((BigDecimal)value).intValue();
        } else {
            return "";
        }
        EnumItem item = enumObj.getEnumItem(enumValue);
        if (item == null) {
            return "";
        }
        return item.getDisplayValue();
    }
}

