/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.eas.base.commonquery.QueryUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class Util {
    private static Logger logger = Logger.getLogger(Util.class);

    public static String processEntityPropertyAlias(EntityObjectInfo entity, String property, String alias) {
        if (Util.isMultiKey(entity)) {
            return alias;
        }
        if (Util.isEntityPK(entity, property)) {
            int sep = alias.lastIndexOf(".");
            alias = sep == -1 ? Util.getEntityAlias(entity) : alias.substring(0, sep);
        }
        return alias;
    }

    public static boolean isMultiKey(EntityObjectInfo entity) {
        if (entity.getLogicalKey() == null) {
            return false;
        }
        PropertyCollection propertyCollection = entity.getLogicalKey().getKeyPropertys();
        int size = propertyCollection.size();
        return size > 1;
    }

    public static boolean isEntityPK(EntityObjectInfo entity, String propertyName) {
        if (entity.getLogicalKey() == null) {
            return false;
        }
        return QueryUtils.isEntityPK((EntityObjectInfo)entity, (String)propertyName);
    }

    public static String getEntityAlias(EntityObjectInfo entity) {
        String alias = entity.getAlias();
        if (alias == null || alias.trim().equalsIgnoreCase("")) {
            return entity.getName();
        }
        return alias;
    }

    public static PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    public static boolean isExtendDataBase(EntityObjectInfo entity) {
        String bosType = "";
        while (entity.getBaseEntity() != null) {
            bosType = (entity = entity.getBaseEntity()).get("bosType").toString();
            if (!bosType.equals("229FBE5D")) continue;
            return true;
        }
        return false;
    }

    public static void getChildEntitys(EntityObjectInfo entity, List cacheBosList) {
        if (cacheBosList == null) {
            cacheBosList = new ArrayList<String>();
        }
        if (!cacheBosList.contains(entity.getType().toString())) {
            String[] str = new String[2];
            str[0] = entity.getType().toString();
            cacheBosList.add(entity.getType().toString());
        }
        PropertyCollection properties = entity.getProperties();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            EntityObjectInfo entity2;
            RelationshipInfo ship;
            PropertyInfo propertyInfo = properties.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo) || (ship = ((LinkPropertyInfo)propertyInfo).getRelationship()).getType() != RelationshipType.COMPOSITION || (entity2 = ship.getSupplierObject()).equals((Object)entity)) continue;
            Util.getChildEntitys(entity2, cacheBosList);
        }
    }

    public static boolean isSameOrAncestor(EntityObjectInfo srcEntity, EntityObjectInfo targetEntity) {
        boolean result = false;
        if (srcEntity.getType().equals((Object)targetEntity.getType())) {
            result = true;
        } else {
            while (targetEntity.getBaseEntity() != null) {
                targetEntity = targetEntity.getBaseEntity();
                if (!srcEntity.getType().equals((Object)targetEntity.getType())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQLType getSQLType(DataType dataType, PropertyInfo property) {
        if (dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.CHAR) || dataType.equals((Object)DataType.SHORT) || dataType.equals((Object)DataType.INTEGER) || dataType.equals((Object)DataType.LONG)) {
            return SQLType.INT;
        }
        if (dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.DECIMAL)) {
            return SQLType.NUMERIC;
        }
        if (dataType.equals((Object)DataType.DATE) || dataType.equals((Object)DataType.TIME) || dataType.equals((Object)DataType.TIMESTAMP)) {
            return SQLType.DATETIME;
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return SQLType.INT;
        }
        if (dataType.equals((Object)DataType.STRING)) {
            if (!(property instanceof OwnPropertyInfo)) return SQLType.VARCHAR;
            return SQLType.NVARCHAR;
        }
        if (dataType.equals((Object)DataType.BOSUUID) || dataType.equals((Object)DataType.UUID)) {
            return SQLType.VARCHAR;
        }
        if (!dataType.equals((Object)DataType.ENUM)) return null;
        if (!property.containsKey("enum_type")) return SQLType.VARCHAR;
        int enumType = (Integer)property.get("enum_type");
        if (enumType == 1) {
            return SQLType.INT;
        }
        if (enumType != 0) return null;
        return SQLType.VARCHAR;
    }

    public static String getEntityTableName(EntityObjectInfo entity) {
        String result = "";
        if (entity != null && entity.getTable() != null && entity.getTable().getName() != null) {
            result = entity.getTable().getName();
        }
        return result;
    }
}

