/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.metas.ProcDefCollection;
import com.kingdee.bos.workflow.metas.ProcDefInfo;
import com.kingdee.bos.workflow.store.util.WfBOSObjectTypeUtil;
import com.kingdee.eas.base.form.util.SortUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;

public final class WorkFlowUtil {
    public static ProcessDefInfo[] getAllProcessDef(Context ctx, String packageName) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String oql = "select procDefId,name,description,verdesc where enable=1";
        if (packageName != null) {
            oql = oql + " and packageName='" + packageName + "'";
        }
        oql = oql + " order by innerversion desc";
        IORMappingDAO ormdao = ORMappingDAO.getInstance((BOSObjectType)WfBOSObjectTypeUtil.PROCESSDEFBOT, (Context)ctx, (Connection)cn);
        ProcDefCollection collection = (ProcDefCollection)ormdao.getCollection(oql);
        if (collection == null || collection.size() == 0) {
            return new ProcessDefInfo[0];
        }
        Object[] values = collection.toArray();
        HashSet<BOSUuid> idSet = new HashSet<BOSUuid>();
        ArrayList<ProcDefInfo> list = new ArrayList<ProcDefInfo>();
        Object[] sortValues = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            ProcDefInfo procDef = (ProcDefInfo)values[i];
            if (idSet.contains(procDef.getProcdefID())) continue;
            idSet.add(procDef.getProcdefID());
            list.add(procDef);
        }
        sortValues = list.toArray();
        SortUtil.sortByPinYin(sortValues, "name", true);
        ProcessDefInfo[] procDefs = new ProcessDefInfo[sortValues.length];
        for (int i = 0; i < sortValues.length; ++i) {
            procDefs[i] = new ProcessDefInfo((ProcDefInfo)sortValues[i]);
        }
        return procDefs;
    }

    public static ProcessDefInfo getProcessDef(Context ctx, String id) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String oql = "select procDefId,name,description,verdesc where enable=1";
        if (!StringUtils.isEmpty((String)id)) {
            oql = oql + " and procDefId='" + id + "'";
        }
        oql = oql + " order by innerversion desc";
        IORMappingDAO ormdao = ORMappingDAO.getInstance((BOSObjectType)WfBOSObjectTypeUtil.PROCESSDEFBOT, (Context)ctx, (Connection)cn);
        ProcDefCollection collection = (ProcDefCollection)ormdao.getCollection(oql);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Object[] values = collection.toArray();
        ProcessDefInfo[] procDefs = new ProcessDefInfo[values.length];
        for (int i = 0; i < values.length; ++i) {
            procDefs[i] = new ProcessDefInfo((ProcDefInfo)values[i]);
        }
        HashSet<String> idSet = new HashSet<String>();
        ArrayList<ProcessDefInfo> list = new ArrayList<ProcessDefInfo>();
        for (int i = 0; i < procDefs.length; ++i) {
            ProcessDefInfo procDef = procDefs[i];
            if (idSet.contains(procDef.getProcDefId())) continue;
            idSet.add(procDef.getProcDefId());
            list.add(procDef);
        }
        return (ProcessDefInfo)list.get(0);
    }
}

