/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.web;

import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.metadata.EnumBarItemStyle;
import com.kingdee.eas.base.form.model.BarBuilderBase;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.BarItemEvent;
import com.kingdee.eas.base.form.model.BarItemLinkEvent;
import com.kingdee.eas.base.form.model.BarItemPropertyChangedEvent;

public class WebBarBuilder
extends BarBuilderBase {
    private JSONObject mainMenu;
    private JSONObject toolbar;

    public WebBarBuilder(BarDataManager barDataMgr, JSONObject toolbar) {
        super(barDataMgr);
        this.toolbar = toolbar;
    }

    public WebBarBuilder(BarDataManager barDataMgr) {
        super(barDataMgr);
    }

    @Override
    public void loadBarItems() {
        try {
            if (this.mainMenu == null) {
                this.mainMenu = new JSONObject();
                this.mainMenu.put("id", "MainMenu");
                this.mainMenu.put("xtype", "toolbar");
            }
            if (this.toolbar == null) {
                this.toolbar = new JSONObject();
                this.toolbar.put("id", "Toolbar");
                this.toolbar.put("xtype", "toolbar");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        super.loadBarItems();
    }

    private JSONObject createMenuCommand(BarItem barItem) throws JSONException {
        JSONObject menuCommand = this.createCommonCommand(barItem);
        menuCommand.put("text", barItem.getCaption().replaceFirst("&", ""));
        if (barItem.getMnemonicKey() != '\f') {
            menuCommand.put("accessKey", barItem.getMnemonicKey());
        }
        return menuCommand;
    }

    private JSONObject createCommonCommand(BarItem barItem) throws JSONException {
        JSONObject cmd = new JSONObject();
        cmd.put("id", barItem.getName());
        if (barItem.getVisible() == 0) {
            cmd.put("hidden", true);
        }
        if (barItem.getEnabled() == 0) {
            cmd.put("disabled", true);
        }
        return cmd;
    }

    @Override
    public Object getMainMenu() {
        return this.mainMenu;
    }

    @Override
    public Object getToolbar() {
        return this.toolbar;
    }

    @Override
    protected void add2Parent(Object parent, Object child) {
        JSONObject jsonParent = (JSONObject)parent;
        JSONArray items = null;
        try {
            if (jsonParent.has("items")) {
                items = (JSONArray)jsonParent.get("items");
            } else {
                items = new JSONArray();
                jsonParent.put("items", items);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (items != null) {
            items.put(child);
        }
    }

    @Override
    protected Object createMenuItem(BarItem barItem) {
        JSONObject menuitem = null;
        try {
            menuitem = this.createMenuCommand(barItem);
            if (EnumBarItemStyle.BarCheckItem.equals(barItem.getStyle())) {
                menuitem.put("checked", barItem.getChecked());
            }
            if (barItem.getImageKey() != null && barItem.getImageKey().length() > 0) {
                String img = barItem.getImageKey().substring(3) + ".gif";
                menuitem.put("icon", img);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return menuitem;
    }

    @Override
    protected Object createMenuSeparator(BarItem barItem) {
        return "-";
    }

    @Override
    protected Object createSubMenu(BarItem barItem) {
        JSONObject menuCommand = null;
        try {
            menuCommand = this.createCommonCommand(barItem);
            menuCommand.put("text", barItem.getCaption().replaceFirst("&", ""));
            if (barItem.getMnemonicKey() != '\f') {
                menuCommand.put("accessKey", barItem.getMnemonicKey());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return menuCommand;
    }

    @Override
    protected Object getSubMenuContainer(Object subMenu) {
        JSONObject jsonSubMenu = (JSONObject)subMenu;
        JSONObject container = null;
        try {
            if (jsonSubMenu.has("menu")) {
                container = (JSONObject)jsonSubMenu.get("menu");
            } else {
                container = new JSONObject();
                jsonSubMenu.put("menu", container);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return container;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object createToolbarButton(BarItem barItem) {
        JSONObject toolCommand = null;
        try {
            toolCommand = this.createCommonCommand(barItem);
            if (EnumBarItemStyle.BarTextFieldItem.equals(barItem.getStyle())) {
                toolCommand.put("xtype", "textfield");
                return toolCommand;
            }
            String tooltip = barItem.getToolTip_L2();
            String desc = "";
            desc = barItem.getCaption_L2();
            if (desc != null && desc.length() > 0) {
                toolCommand.put("text", desc.replaceFirst("&", ""));
            }
            toolCommand.put("Tooltip", tooltip != null && tooltip.length() > 0 ? tooltip : desc);
            if (!EnumBarItemStyle.BarCheckItem.equals(barItem.getStyle())) return toolCommand;
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return toolCommand;
    }

    @Override
    protected Object createToolbarSeparator(BarItem barItem) {
        return "-";
    }

    @Override
    public void barItemAdded(BarItemEvent e) {
    }

    @Override
    public void barItemLinkAdded(BarItemLinkEvent e) {
    }

    @Override
    public void barItemLinkRemoved(BarItemLinkEvent e) {
    }

    @Override
    public void barItemRemoved(BarItemEvent e) {
    }

    @Override
    public void barItemPropertyChanged(BarItemPropertyChangedEvent e) {
    }

    public JSONObject getUIMainMenu() throws JSONException {
        JSONArray items = new JSONArray();
        JSONObject mainMenu = new JSONObject();
        mainMenu.put("items", items);
        mainMenu.put("imagepath", "IMAGES/ToolBar/chs/");
        items.put(this.getMainMenu());
        items.put(this.getToolbar());
        return mainMenu;
    }
}

