/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.core.FormFactory;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.FormAppearance;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.util.WorkCalendarFacade;
import com.kingdee.eas.base.form.web.ExtUIBuilder;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebUIFactory {
    public static String getAdvFilterParams(Context ctx) throws UnsupportedEncodingException {
        String urlParam = "lang=" + ctx.getLocale().toString() + "&" + "uitype" + "=" + 1 + "&" + "dbid" + "=" + URLEncoder.encode(ctx.getAIS(), "US-ASCII");
        return urlParam;
    }

    public static String getBillUIReqParams(String formId, Context ctx) throws UnsupportedEncodingException {
        String urlParam = "formID=" + URLEncoder.encode(formId, "US-ASCII") + "&" + "lang" + "=" + ctx.getLocale().toString() + "&" + "uitype" + "=" + 1 + "&" + "dbid" + "=" + URLEncoder.encode(ctx.getAIS(), "US-ASCII");
        return urlParam;
    }

    public static String createBillUI(FormMetaData formMeta, String lang) throws BOSException {
        String metaString;
        LayoutInfo layoutInfo = formMeta.getLayoutInfo();
        ExtUIBuilder uiBuilder = new ExtUIBuilder(layoutInfo, formMeta.getBusinessInfo());
        try {
            uiBuilder.addControls();
            JSONObject meta = new JSONObject();
            meta.put("billMetaData", uiBuilder.getPanel());
            meta.put("billTitle", layoutInfo.getCaption());
            meta.put("shownavibar", layoutInfo.getFormAppearance().isShowNavigation());
            Appearance form = layoutInfo.getAppearance("_BILL");
            JSONObject rect = new JSONObject();
            rect.put("width", form.getWidth());
            rect.put("height", form.getHeight());
            if (((FormAppearance)form).getUILayout() == 1) {
                meta.put("isEditingOfficeDocOnline", 1);
            }
            meta.put("validateBeforeSaving", layoutInfo.getFormAppearance().isValidateBeforeSaving());
            meta.put("billRect", rect);
            metaString = WebUIFactory.constructVarString(meta.toString());
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        return metaString;
    }

    public static String getAssistDataReqParams(String auxDataType, Context ctx) throws UnsupportedEncodingException {
        String urlParam = "lang=" + ctx.getLocale().toString() + "&" + "uitype" + "=" + 4 + "&" + "adt" + "=" + URLEncoder.encode(auxDataType, "US-ASCII") + "&" + "dbid" + "=" + URLEncoder.encode(ctx.getAIS(), "US-ASCII");
        return urlParam;
    }

    public static String getAssistDataReqParamsWithCU(String auxDataType, Context ctx) throws UnsupportedEncodingException {
        OrgUnitInfo cu = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        String cuid = cu.getId().toString();
        String urlParam = "lang=" + ctx.getLocale().toString() + "&" + "uitype" + "=" + 4 + "&" + "adt" + "=" + URLEncoder.encode(auxDataType, "US-ASCII") + "&" + "dbid" + "=" + URLEncoder.encode(ctx.getAIS(), "US-ASCII") + "&" + "cu" + "=" + URLEncoder.encode(cuid, "US-ASCII");
        return urlParam;
    }

    public static String getHolidayReqParams(Context ctx) throws UnsupportedEncodingException {
        OrgUnitInfo cu = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        String cuid = cu.getId().toString();
        String urlParam = "lang=" + ctx.getLocale().toString() + "&" + "uitype" + "=" + 5 + "&" + "dbid" + "=" + URLEncoder.encode(ctx.getAIS(), "US-ASCII") + "&" + "cu" + "=" + URLEncoder.encode(cuid, "US-ASCII");
        return urlParam;
    }

    public static String getAssistData(String dataType, Context ctx) throws SQLException {
        StringBuffer data = new StringBuffer("var KD;\nif(!KD) KD={};\nif(!KD.assistDatas) KD.assistDatas={};\n");
        data.append("KD.assistDatas['").append(dataType).append("']={");
        ResultSet rs = FormFactory.getAssistantData(dataType, ctx);
        int i = 0;
        while (rs.next()) {
            data.append("'").append(rs.getString("FId")).append("':[").append("'").append(rs.getString("FDesc")).append("',");
            String str = rs.getString("FParentId");
            if (str == null) {
                data.append("null,");
            } else {
                data.append("'").append(rs.getString("FParentId")).append("',");
            }
            data.append(i++).append("],\n");
        }
        int len = data.length();
        if (data.charAt(len - 2) == ',') {
            data.replace(len - 2, len, "};\n");
        } else {
            data.append("};\n");
        }
        return data.toString();
    }

    public static String getAssistData(String dataType, String cu, String longNumber, Context ctx) throws SQLException {
        StringBuffer data = new StringBuffer("if(!KD.cuAssistDatas) KD.cuAssistDatas={};\n");
        data.append("KD.cuAssistDatas['").append(dataType).append("']=[");
        ResultSet rs = FormFactory.getAssistantData(dataType, cu, longNumber, ctx);
        while (rs.next()) {
            data.append("'").append(rs.getString("FId")).append("',");
        }
        int len = data.length();
        if (data.charAt(len - 1) == ',') {
            data.replace(len - 1, len, "];\n");
        } else {
            data.append("];\n");
        }
        data.append("KD.addAssistantData('" + dataType + "');");
        return data.toString();
    }

    public static String getHolidays(String org, String year) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer(400);
        sb.append("{'results':");
        WorkCalendarFacade wc = new WorkCalendarFacade();
        HashMap holidays = org == null || org.trim().length() == 0 ? new HashMap() : wc.getHolidays(org, Integer.parseInt(year));
        sb.append(holidays.size());
        sb.append(",'rows':[");
        int i = 0;
        for (Map.Entry entry : holidays.entrySet()) {
            sb.append("{'id':").append(i++);
            sb.append(",'name':'").append(entry.getKey() == null || "null".equals((String)entry.getKey()) ? "" : (String)entry.getKey());
            sb.append("','days':[");
            List days = (List)entry.getValue();
            for (Calendar day : days) {
                sb.append(day.get(1) * 10000 + (day.get(2) + 1) * 100 + day.get(5)).append(",");
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]},");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }

    public static String constructVarString(String value) {
        return "var formMeta='" + value + "';";
    }
}

