/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.extend.flow.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.extend.flow.FlowException;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.extend.flow.TemplateTypeInfo;
import com.kingdee.eas.base.form.extend.flow.app.AbstractTemplateFacadeControllerBean;
import com.kingdee.eas.base.form.util.WorkFlowUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TemplateFacadeControllerBean
extends AbstractTemplateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.form.extend.flow.app.TemplateFacadeControllerBean");

    @Override
    protected String _deployTemplates(Context ctx, IObjectValue info, List shareOrgs, List deleteOrgs) throws BOSException, EASBizException {
        String result = "";
        boolean hasShareCU = shareOrgs != null && shareOrgs.contains("eThjryu4wEKoEK1veu3ZzDUlqpQ=");
        TemplateInfo templateInfo = (TemplateInfo)info;
        if (templateInfo == null) {
            return null;
        }
        Connection conn = null;
        try {
            String typeId = templateInfo.getTemplateType().getId().toString();
            String sql = " select count(fid) cnt from t_bas_templatetype  where fid = ? and fusedstate = 1";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{typeId});
            int count = 0;
            if (rs.next()) {
                count = rs.getInt("cnt");
            }
            if (count <= 0) {
                throw new FlowException(FlowException.TMPTYPENOTENABLE);
            }
            conn = EJBFactory.getConnection((Context)ctx);
            this.dealDelOrShareInExist(ctx, conn, templateInfo, deleteOrgs, 1);
            this.dealShare(ctx, conn, templateInfo, shareOrgs, deleteOrgs);
            this.dealLoginCU(ctx, conn, templateInfo, hasShareCU);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    private void dealLoginCU(Context ctx, Connection conn, TemplateInfo info, boolean hasShareCU) throws BOSException {
        if (hasShareCU) {
            String formid = info.getFormID();
            String layoutid = info.getLayoutID();
            String logincuid = info.getLoginCU().getId().toString();
            String sql1 = " update T_BAS_Template set flogincuid = ?  where fformid = ? and flayoutid = ? and fcontrolunitId = ? ";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new String[]{logincuid, formid, layoutid, "eThjryu4wEKoEK1veu3ZzDUlqpQ="});
        }
    }

    private void dealShare(Context ctx, Connection conn, TemplateInfo info, List shareOrgs, List deleteOrgs) throws BOSException, EASBizException {
        String formid = info.getFormID();
        String layoutid = info.getLayoutID();
        if (StringUtils.isEmpty((String)formid)) {
            this.dealShareNotExist(ctx, conn, info, shareOrgs);
        } else {
            ArrayList<String> existOrgs = new ArrayList<String>();
            String sql1 = " select FControlUnitID from T_BAS_Template where fformid = ? and flayoutid = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{formid, layoutid});
            try {
                while (rs.next()) {
                    String orgid = rs.getString("FControlUnitID");
                    if (!shareOrgs.contains(orgid)) continue;
                    if (!deleteOrgs.contains(orgid)) {
                        existOrgs.add(orgid);
                    }
                    shareOrgs.remove(orgid);
                }
            }
            catch (SQLException e1) {
                logger.error((Object)e1);
                throw new BOSException((Throwable)e1);
            }
            this.dealDelOrShareInExist(ctx, conn, info, existOrgs, 0);
            this.dealShareNotExist(ctx, conn, info, shareOrgs);
        }
    }

    private void dealShareNotExist(Context ctx, Connection conn, TemplateInfo info, List shareOrgs) throws BOSException {
        PreparedStatement ps = null;
        try {
            BOSObjectType bostype = info.getBOSType();
            ArrayList<String> templateIdList = new ArrayList<String>();
            String sql = " INSERT INTO T_BAS_Template  ( FID, FName_l1, FName_l2, FName_l3, FNumber, FDescription_l1, FDescription_l2, FDescription_l3, FSimpleName, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID,  FProposerID, FTemplateTypeID , FFormID, FIsDelete,  fflowid, FProposerKey, FProposerDateKey,  FFlowDescKey, FTitleKey, FKnowledgePKey, FLayoutID, FBillNumberKey, FFlowNodeKey, FFormWidth,  FFormHeight, FFlowDirID, FFlowDirStr, FLoginCUID, FDocumentEditor, FRelaBillPanel, FDocumentPKey,FUrgencyLevelKey, FSecretLevelKey,FSafeDocKey,FDocumentDateKey,FDocumentOrgKey,FCommingDocNoKey)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            ps = conn.prepareStatement(sql);
            Locale l1 = new Locale("l1");
            Locale l2 = new Locale("l2");
            Locale l3 = new Locale("l3");
            for (int i = 0; shareOrgs != null && i < shareOrgs.size(); ++i) {
                String id = BOSUuid.create((BOSObjectType)bostype).toString();
                templateIdList.add(id);
                String name_l1 = info.getName(l1);
                String name_l2 = info.getName(l2);
                String name_l3 = info.getName(l3);
                String number = info.getNumber();
                String desc_l1 = info.getDescription(l1);
                String desc_l2 = info.getDescription(l2);
                String desc_l3 = info.getDescription(l3);
                String simpleName = info.getSimpleName();
                String creatorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                String updatorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                String ctrlUnitId = shareOrgs.get(i).toString();
                PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                String personId = person == null ? null : person.getId().toString();
                String typeId = info.getTemplateType().getId().toString();
                String formId = info.getFormID();
                String layoutId = info.getLayoutID();
                String loginCUID = info.getLoginCU() == null ? null : info.getLoginCU().getId().toString();
                String documentEditor = info.getDocumentEditor();
                String relatedBillPanel = info.getRelatedBillPanel();
                ps.setString(1, id);
                ps.setString(2, name_l1);
                ps.setString(3, name_l2);
                ps.setString(4, name_l3);
                ps.setString(5, number);
                ps.setString(6, desc_l1);
                ps.setString(7, desc_l2);
                ps.setString(8, desc_l3);
                ps.setString(9, simpleName);
                ps.setString(10, creatorId);
                ps.setTimestamp(11, new Timestamp(System.currentTimeMillis()));
                ps.setString(12, updatorId);
                ps.setTimestamp(13, new Timestamp(System.currentTimeMillis()));
                ps.setString(14, ctrlUnitId);
                ps.setString(15, personId);
                ps.setString(16, typeId);
                ps.setString(17, formId);
                ps.setInt(18, 0);
                ps.setString(19, info.getFlowId());
                ps.setString(20, info.getProposerKey());
                ps.setString(21, info.getProposerDateKey());
                ps.setString(22, info.getFlowDescKey());
                ps.setString(23, info.getTitleKey());
                ps.setString(24, info.getKnowledgePKey());
                ps.setString(25, layoutId);
                ps.setString(26, info.getBillNumberKey());
                ps.setString(27, info.getFlowNodeKey());
                ps.setInt(28, info.getFormWidth());
                ps.setInt(29, info.getFormHeight());
                ps.setString(30, info.getFlowDirID());
                ps.setString(31, info.getFlowDirStr());
                ps.setString(32, loginCUID);
                ps.setString(33, documentEditor);
                ps.setString(34, relatedBillPanel);
                ps.setString(35, info.getDocumentPKey());
                ps.setString(36, info.getUrgencyLevelKey());
                ps.setString(37, info.getSecretLevelKey());
                ps.setString(38, info.getSafeDocKey());
                ps.setString(39, info.getDocumentDateKey());
                ps.setString(40, info.getDocumentOrgKey());
                ps.setString(41, info.getCommingDocNoKey());
                ps.addBatch();
            }
            if (shareOrgs != null && !shareOrgs.isEmpty()) {
                ps.executeBatch();
            }
            sql = " INSERT INTO T_BAS_TemplateWorkFlow  ( FID, FParentID, FFlowId, FStartConditionID, FSeq )  VALUES (?,?,?,?,?)";
            ps = conn.prepareStatement(sql);
            int count = 0;
            for (int i = 0; shareOrgs != null && i < shareOrgs.size(); ++i) {
                String id = BOSUuid.create((String)"9A7EAE92").toString();
                String parentID = templateIdList.get(i).toString();
                String flowId = info.getFlowId();
                if (StringUtils.isEmpty((String)flowId)) continue;
                String startConditionID = null;
                int seq = 1;
                ps.setString(1, id);
                ps.setString(2, parentID);
                ps.setString(3, flowId);
                ps.setString(4, startConditionID);
                ps.setInt(5, seq);
                ps.addBatch();
                ++count;
            }
            if (count > 0) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    private void dealDelOrShareInExist(Context ctx, Connection conn, TemplateInfo info, List deleteOrgs, int isDelete) throws BOSException, EASBizException {
        String formid = info.getFormID();
        String layoutid = info.getLayoutID();
        if (StringUtils.isEmpty((String)formid)) {
            return;
        }
        PreparedStatement ps = null;
        try {
            int oriDelete;
            String orgid;
            int i;
            HashMap<String, Integer> deleteMap = new HashMap<String, Integer>();
            HashMap<String, Integer> usedMap = new HashMap<String, Integer>();
            String sql1 = " select FControlUnitID, FIsDelete, FUsedState from T_BAS_Template  where fformid = ? and flayoutid = ? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{formid, layoutid});
            while (rs.next()) {
                deleteMap.put(rs.getString("FControlUnitID"), new Integer(rs.getInt("FIsDelete")));
                usedMap.put(rs.getString("FControlUnitID"), new Integer(rs.getInt("FUsedState")));
            }
            String creatorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String updatorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String loginCUID = info.getLoginCU() == null ? null : info.getLoginCU().getId().toString();
            sql1 = "update T_BAS_Template set fisdelete = ?,  FProposerKey = ? , FProposerDateKey = ? , FFlowDescKey = ? ,  FTitleKey = ? , FKnowledgePKey = ? , FBillNumberKey = ? , FFlowNodeKey = ? ,  FFormWidth = ? , FFormHeight = ? , FDocumentEditor = ?, FRelaBillPanel = ? , FDocumentPKey = ? , FUrgencyLevelKey = ? , FSecretLevelKey = ? , FSafeDocKey = ? , FDocumentDateKey = ? , FDocumentOrgKey = ? , FCommingDocNoKey = ?  where FControlUnitID = ? and fformid = ? and flayoutid = ? ";
            ps = conn.prepareStatement(sql1);
            for (i = 0; deleteOrgs != null && i < deleteOrgs.size(); ++i) {
                orgid = deleteOrgs.get(i).toString();
                oriDelete = (Integer)deleteMap.get(orgid);
                sql1 = "update T_BAS_Template set fisdelete = ?,  FProposerKey = ? , FProposerDateKey = ? , FFlowDescKey = ? ,  FTitleKey = ? , FKnowledgePKey = ? , FBillNumberKey = ? , FFlowNodeKey = ? ,  FFormWidth = ? , FFormHeight = ? , FDocumentEditor = ?, FRelaBillPanel = ?, FDocumentPKey = ?,  FUrgencyLevelKey = ? , FSecretLevelKey = ? , FSafeDocKey = ? , FDocumentDateKey = ? , FDocumentOrgKey = ? , FCommingDocNoKey = ? ,";
                sql1 = oriDelete == 1 ? sql1 + " FCreatorID = ? , FCreateTime = ? , FLastUpdateUserID = ?, FLastUpdateTime = ?, FLoginCUID = ?" : sql1 + " FLastUpdateUserID = ? , FLastUpdateTime = ?, FLoginCUID = ?";
                sql1 = sql1 + " where FControlUnitID = ? and fformid = ? and flayoutid = ? ";
                ps = conn.prepareStatement(sql1);
                ps.setInt(1, isDelete);
                ps.setString(2, info.getProposerKey());
                ps.setString(3, info.getProposerDateKey());
                ps.setString(4, info.getFlowDescKey());
                ps.setString(5, info.getTitleKey());
                ps.setString(6, info.getKnowledgePKey());
                ps.setString(7, info.getBillNumberKey());
                ps.setString(8, info.getFlowNodeKey());
                ps.setInt(9, info.getFormWidth());
                ps.setInt(10, info.getFormHeight());
                ps.setString(11, info.getDocumentEditor());
                ps.setString(12, info.getRelatedBillPanel());
                ps.setString(13, info.getDocumentPKey());
                ps.setString(14, info.getUrgencyLevelKey());
                ps.setString(15, info.getSecretLevelKey());
                ps.setString(16, info.getSafeDocKey());
                ps.setString(17, info.getDocumentDateKey());
                ps.setString(18, info.getDocumentOrgKey());
                ps.setString(19, info.getCommingDocNoKey());
                if (oriDelete == 1) {
                    ps.setString(20, creatorId);
                    ps.setTimestamp(21, new Timestamp(System.currentTimeMillis()));
                    ps.setString(22, updatorId);
                    ps.setTimestamp(23, new Timestamp(System.currentTimeMillis()));
                    ps.setString(24, loginCUID);
                    ps.setString(25, orgid);
                    ps.setString(26, formid);
                    ps.setString(27, layoutid);
                } else {
                    ps.setString(20, updatorId);
                    ps.setTimestamp(21, new Timestamp(System.currentTimeMillis()));
                    ps.setString(22, loginCUID);
                    ps.setString(23, orgid);
                    ps.setString(24, formid);
                    ps.setString(25, layoutid);
                }
                ps.addBatch();
            }
            if (deleteOrgs != null && !deleteOrgs.isEmpty()) {
                ps.executeBatch();
            }
            sql1 = "update T_BAS_Template set fusedstate = ? where FControlUnitID = ? and fformid = ?  and flayoutid = ? ";
            ps = conn.prepareStatement(sql1);
            for (i = 0; deleteOrgs != null && i < deleteOrgs.size(); ++i) {
                orgid = deleteOrgs.get(i).toString();
                oriDelete = (Integer)deleteMap.get(orgid);
                int oriUsedState = (Integer)usedMap.get(orgid);
                int usedState = 1;
                if (oriDelete == 0) {
                    usedState = isDelete == 1 ? 1 : oriUsedState;
                } else if (isDelete != 1) {
                    usedState = 0;
                }
                ps.setInt(1, usedState);
                ps.setString(2, orgid);
                ps.setString(3, formid);
                ps.setString(4, layoutid);
                ps.addBatch();
            }
            if (deleteOrgs != null && !deleteOrgs.isEmpty()) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
    }

    @Override
    protected IObjectValue _getDeployedTemplate(Context ctx, String formId, String layoutID) throws BOSException, EASBizException {
        TemplateInfo tempInfo = null;
        String sql1 = " select top 1 a.fid tmpid, a.FName_" + ctx.getLocale() + " tmpName, a.FDescription_" + ctx.getLocale() + " tmpdesc, " + " a.fnumber tmpnumber, a.FTemplateTypeID typeid , " + " a.fflowid tmpflow, a.FProposerKey tmpProposerKey , a.FDocumentEditor tmpDocumentEditor, " + " a.FRelaBillPanel tmpRelaBillPanel, a.FProposerDateKey tmpProposerDateKey, a.FFlowDescKey tmpFlowDescKey , " + " a.FTitleKey tmpTitleKey, a.FKnowledgePKey tmpKnowledgePKey, a.FDocumentPKey tmpDocumentPKey," + " a.FBillNumberKey tmpBillNumberKey, a.FFlowNodeKey tmpFlowNodeKey, " + " a.FFormWidth tmpFormWidth, a.FFormHeight tmpFormHeight, " + " a.FFlowDirID tmpFlowDirID, a.FFlowDirStr tmpFlowDirStr, a.FLoginCUID tmpLoginCUID, " + " b.FName_" + ctx.getLocale() + " typeName, " + " a.FUrgencyLevelKey tmpUrgencyLevelKey , a.FSecretLevelKey tmpSecretLevelKey, a.FSafeDocKey tmpSafeDocKey, " + " a.FDocumentDateKey tmpDocumentDateKey , a.FDocumentOrgKey tmpDocumentOrgKey, a.FCommingDocNoKey tmpCommingDocNoKey " + " from T_BAS_template a, T_BAS_templateType b " + " where a.fisdelete = 0 and a.FTemplateTypeID = b.fid and a.fformid = ? and a.flayoutid = ? ";
        String sql2 = " select a.FControlUnitID tmpcu, b.fname_" + ctx.getLocale() + " cuName, a.FisDelete isdelete " + " from T_BAS_template a , t_org_ctrlunit b " + " where a.FControlUnitID = b.fid and a.fformid = ?  and a.flayoutid = ? order by b.flongnumber";
        String sql3 = " select count(a.FControlUnitID) tmpcucnt  from T_BAS_template a  where a.fformid = ?  and a.flayoutid = ? and fisdelete = 0 and a.FControlUnitID = 'eThjryu4wEKoEK1veu3ZzDUlqpQ='";
        String sql4 = " select top 1 a.FLoginCUID tmpcu, b.fname_" + ctx.getLocale() + " cuName , b.fnumber cuNumber" + " from T_BAS_template a left join t_org_ctrlunit b on a.FLoginCUID = b.fid" + " where  a.fformid = ?  and a.flayoutid = ? and a.fcontrolunitid = '" + "eThjryu4wEKoEK1veu3ZzDUlqpQ=" + "'";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{formId, layoutID});
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new String[]{formId, layoutID});
        IRowSet rs3 = DbUtil.executeQuery((Context)ctx, (String)sql3, (Object[])new String[]{formId, layoutID});
        IRowSet rs4 = DbUtil.executeQuery((Context)ctx, (String)sql4, (Object[])new String[]{formId, layoutID});
        try {
            String cuid;
            CtrlUnitInfo cu;
            int cnt;
            if (rs1.next()) {
                tempInfo = new TemplateInfo();
                tempInfo.setId(BOSUuid.read((String)rs1.getString("tmpid")));
                tempInfo.setName(rs1.getString("tmpName"));
                tempInfo.setDescription(rs1.getString("tmpdesc"));
                tempInfo.setNumber(rs1.getString("tmpnumber"));
                tempInfo.setFlowId(rs1.getString("tmpflow"));
                tempInfo.setProposerKey(rs1.getString("tmpProposerKey"));
                tempInfo.setProposerDateKey(rs1.getString("tmpProposerDateKey"));
                tempInfo.setFlowDescKey(rs1.getString("tmpFlowDescKey"));
                tempInfo.setTitleKey(rs1.getString("tmpTitleKey"));
                tempInfo.setKnowledgePKey(rs1.getString("tmpKnowledgePKey"));
                tempInfo.setBillNumberKey(rs1.getString("tmpBillNumberKey"));
                tempInfo.setFlowNodeKey(rs1.getString("tmpFlowNodeKey"));
                tempInfo.setDocumentEditor(rs1.getString("tmpDocumentEditor"));
                tempInfo.setRelatedBillPanel(rs1.getString("tmpRelaBillPanel"));
                tempInfo.setDocumentPKey(rs1.getString("tmpDocumentPKey"));
                tempInfo.setFormWidth(rs1.getInt("tmpFormWidth"));
                tempInfo.setFormHeight(rs1.getInt("tmpFormHeight"));
                tempInfo.setFlowDirID(rs1.getString("tmpFlowDirID"));
                tempInfo.setFlowDirStr(rs1.getString("tmpFlowDirStr"));
                TemplateTypeInfo type = new TemplateTypeInfo();
                type.setId(BOSUuid.read((String)rs1.getString("typeid")));
                type.setName(rs1.getString("typeName"));
                tempInfo.setTemplateType(type);
                tempInfo.setFormID(formId);
                tempInfo.setLayoutID(layoutID);
                tempInfo.setUrgencyLevelKey(rs1.getString("tmpUrgencyLevelKey"));
                tempInfo.setSecretLevelKey(rs1.getString("tmpSecretLevelKey"));
                tempInfo.setSafeDocKey(rs1.getString("tmpSafeDocKey"));
                tempInfo.setDocumentDateKey(rs1.getString("tmpDocumentDateKey"));
                tempInfo.setDocumentOrgKey(rs1.getString("tmpDocumentOrgKey"));
                tempInfo.setCommingDocNoKey(rs1.getString("tmpCommingDocNoKey"));
            }
            ArrayList<CtrlUnitInfo> shareOrgs = new ArrayList<CtrlUnitInfo>();
            ArrayList<CtrlUnitInfo> deleteOrgs = new ArrayList<CtrlUnitInfo>();
            if (rs3.next() && (cnt = rs3.getInt(1)) == 1) {
                cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)"eThjryu4wEKoEK1veu3ZzDUlqpQ="));
                cu.setName(null);
                shareOrgs.add(cu);
            }
            if (rs4.next() && !StringUtils.isEmpty((String)(cuid = rs4.getString("tmpcu")))) {
                cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)cuid));
                cu.setName(rs4.getString("cuName"));
                cu.setNumber(rs4.getString("cuNumber"));
                tempInfo.setLoginCU(cu);
            }
            while (rs2.next()) {
                int isdelete = rs2.getInt("isdelete");
                String cuid2 = rs2.getString("tmpcu");
                String cuName = rs2.getString("cuName");
                CtrlUnitInfo cu2 = new CtrlUnitInfo();
                cu2.setId(BOSUuid.read((String)cuid2));
                cu2.setName(cuName);
                if (isdelete == 1) {
                    deleteOrgs.add(cu2);
                    continue;
                }
                shareOrgs.add(cu2);
            }
            if (tempInfo != null) {
                tempInfo.put("shareOrgs", shareOrgs);
                tempInfo.put("deleteOrgs", deleteOrgs);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return tempInfo;
    }

    @Override
    protected ProcessDefInfo[] _getProcessDefInfos(Context ctx, String packageName) throws BOSException, EASBizException {
        ProcessDefInfo[] result = WorkFlowUtil.getAllProcessDef((Context)ctx, (String)packageName);
        return result;
    }

    @Override
    protected ProcessDefInfo _getProcessDefInfo(Context ctx, String procId) throws BOSException, EASBizException {
        ProcessDefInfo result = WorkFlowUtil.getProcessDef((Context)ctx, (String)procId);
        return result;
    }

    @Override
    protected boolean _isExistsSameNumber(Context ctx, IObjectValue objectValue) throws BOSException {
        return BusinessSeviceUtil.isExistsForData((Context)ctx, (IObjectValue)objectValue, (String)"number", (String[])new String[0]);
    }
}

