/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.handler;

import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.define.AssignmentEvent;
import com.kingdee.bos.workflow.enactment.IWfAssignment;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.handler.AbstractAssignmentEventHandler;
import com.kingdee.sns.task.util.utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AssignmentHandlerPub
extends AbstractAssignmentEventHandler {
    private Logger logger = Logger.getLogger(AssignmentHandlerPub.class);

    public void execute(AssignmentEvent assignmentEvent, IWfAssignment assignment) {
        if (AssignmentEvent.OnAssignmentComplete.equals((Object)assignmentEvent)) {
            try {
                this.logger.error((Object)"AssignmentHandler  assignmentCompleted begin");
                this.assignmentCompleted(assignment);
                this.logger.error((Object)"AssignmentHandler  assignmentCompleted end");
            }
            catch (IOException e) {
                this.logger.error((Object)"AssignmentHandler  assignmentCompleted error");
                e.printStackTrace();
            }
        } else if (AssignmentEvent.OnAssignmentAborted.equals((Object)assignmentEvent)) {
            try {
                this.logger.error((Object)"AssignmentHandler  assignmentAborted begin");
                this.assignmentAborted(assignment);
                this.logger.error((Object)"AssignmentHandler  assignmentAborted end");
            }
            catch (IOException e) {
                this.logger.error((Object)"AssignmentHandler  assignmentAborted error");
                e.printStackTrace();
            }
        }
    }

    private void assignmentAborted(IWfAssignment assignment) throws IOException {
        WfAssignment assign = (WfAssignment)assignment;
        Context ctx = assign.getContext();
        String dbCode = ctx.getAIS();
        String assignId = assign.getAssignmentInfo().getAssignmentId();
        String re = utils.changgebyassign(ctx, assignId);
    }

    private void assignmentCompleted(IWfAssignment assignment) throws IOException {
        WfAssignment assign = (WfAssignment)assignment;
        Context ctx = assign.getContext();
        String dbCode = ctx.getAIS();
        String assignId = assign.getAssignmentInfo().getAssignmentId();
        String re = utils.changgebyassign(ctx, assignId);
    }

    public static String encode(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (encoded == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                buf.append("%2A");
                continue;
            }
            if (focus == '+') {
                buf.append("%20");
                continue;
            }
            if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
                continue;
            }
            buf.append(focus);
        }
        return buf.toString();
    }

    public static String shaHex(String[] data) {
        Arrays.sort(data);
        String join = StringUtils.join((Object[])data);
        String sign = DigestUtils.shaHex((String)join);
        return sign;
    }

    public static String constructRequestURL(String url) {
        int slashIndex;
        String baseURL;
        int colonIndex;
        int index = url.indexOf("?");
        if (-1 != index) {
            url = url.substring(0, index);
        }
        if (-1 != (colonIndex = (baseURL = url.substring(0, slashIndex = url.indexOf("/", 8)).toLowerCase(Locale.ENGLISH)).indexOf(":", 8))) {
            if (baseURL.startsWith("http://") && baseURL.endsWith(":80")) {
                baseURL = baseURL.substring(0, colonIndex);
            } else if (baseURL.startsWith("https://") && baseURL.endsWith(":443")) {
                baseURL = baseURL.substring(0, colonIndex);
            }
        }
        url = baseURL + url.substring(slashIndex);
        return url;
    }

    public static String sha(String[] data) {
        Arrays.sort(data);
        return DigestUtils.shaHex((String)StringUtils.join((Object[])data));
    }
}

