/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.lightapp.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WFMessageAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFMessageAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum MESSAGEMODEL = null;
    private Map<String, Object> contents = null;

    public WFMessageAdapter(Message message) {
        logger.debug((Object)"WFMessageAdapter init");
        this.message = message;
        this.ctx = WFMessageAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    public boolean isNeedSendXT() {
        return true;
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    public MessageModelEnum getModel() {
        return this.MESSAGEMODEL;
    }

    public Map<String, Object> getContent() {
        if (this.contents != null) {
            return this.contents;
        }
        this.contents = new HashMap<String, Object>();
        String content = this.parseContent();
        try {
            String title;
            this.contents.put("text", content);
            String assignId = this.message.getStringHeader("assignid");
            String dbCode = this.ctx.getAIS();
            XTServiceConfig instance = XTServiceConfig.getInstance();
            String eid = instance.getEidByDbCode(dbCode);
            String host = instance.getPubAcctProperty(eid, "WFMessage", "host", "");
            String appId = instance.getPubAcctProperty(eid, "WFMessage", "appId", "");
            String url = this.getUrl(assignId, eid, host, appId);
            String itemtitle = title = this.message.getStringHeader("predetailsl2");
            String msgShow = instance.getPubAcctProperty(eid, "WFMessage", "MsgShow", "");
            if ("1".equals(msgShow)) {
                itemtitle = StringUtils.isEmpty((CharSequence)title) ? "\u6d41\u7a0b\u52a9\u624b" : title.substring(title.lastIndexOf("\u7684") + 1, title.length());
            }
            this.contents.put("itemtitle", itemtitle);
            this.contents.put("title", this.message.getStringHeader("sendNamel1"));
            this.contents.put("sendId", this.message.getStringHeader("sendId"));
            this.contents.put("receiver", this.message.getStringHeader("receiver"));
            this.contents.put("url", url);
            String bizfunction = this.message.getStringHeader("bizfunction");
            String passUrl = this.getPassUrl(assignId, eid, bizfunction);
            if (passUrl != null) {
                this.contents.put("passUrl", passUrl);
            }
            this.contents.put("assignId", assignId);
            this.contents.put("appid", appId);
            this.contents.put("todoPriStatus", "undo");
            this.contents.put("billID", this.message.getStringHeader("billID"));
            logger.info((Object)("XT Message URL: " + url));
            String WXMsgType = instance.getPubAcctProperty(eid, "WFMessage", "WXMsgType", "");
            if (!StringUtils.isEmpty((CharSequence)WXMsgType) && "MultiApproveUIFunction".equalsIgnoreCase(bizfunction)) {
                this.contents.put("WXMsgType", WXMsgType);
            }
            if (!StringUtils.isEmpty((CharSequence)title)) {
                String sendName = title.substring(0, title.lastIndexOf("\u7684")).replace("\u63d0\u4ea4", "");
                this.contents.put("sendName", sendName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getContent() error!", (Throwable)e);
        }
        return this.contents;
    }

    private String getPassUrl(String assignId, String eid, String bizfunction) {
        String passUrl = null;
        String signKey = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "signKey", "");
        try {
            if (!StringUtils.isEmpty((CharSequence)signKey) && "MultiApproveUIFunction".equalsIgnoreCase(bizfunction)) {
                String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                Map actmap = service.getActivityDefAndActivityInstInfo(assignId);
                ActivityDef def = (ActivityDef)actmap.get("ACTIVITYDEF");
                ExtendedAttributeDef ed = def.getActivityHeader().getExtendedAttributes().get("customUIStatus");
                if (ed == null || StringUtils.isEmpty((CharSequence)ed.getValue()) || "view".equalsIgnoreCase(ed.getValue())) {
                    passUrl = host.indexOf("?") > -1 ? host.substring(0, host.lastIndexOf("/page")) + "/auth/batchDealTodo?eid=" + eid : host + "/batchDealTodo.action";
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getPassUrl for yunzhijia failed", (Throwable)e);
        }
        return passUrl;
    }

    private String getUrl(String assignid, String eid, String host, String appId) throws BOSException {
        String newEid = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "eid", "");
        logger.info((Object)("XT Message newEidnewEid=" + newEid));
        String url = host;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo info = svc.getAssignmentById(assignid);
        String billID = this.message.getStringHeader("billID");
        if (host.indexOf("?") > -1) {
            String actdef = info.getActDefId();
            String procdef = info.getProcDefId();
            String mbosUrl = this.getMbosUrl(procdef, actdef);
            if (!StringUtils.isEmpty((CharSequence)mbosUrl)) {
                mbosUrl = mbosUrl.replace("page/loadPage", "mbosw/getWorkflowUrl");
                url = mbosUrl + "&eid=" + newEid + "&assignId=" + assignid + "&appid=" + appId + "&billID=" + URLEncoder.encode(billID);
                return url;
            }
        }
        url = host.indexOf("?") > -1 ? url + "&storeEid=21231&name=approveui.navui&eid=" + newEid + "&assignId=" + assignid + "&appid=" + appId : url + "/dealWithNotice.html?eid=" + newEid + "&assignId=" + assignid + "&appid=" + appId;
        return url;
    }

    private boolean getIfTry(String reciver) {
        boolean ifTry = false;
        try {
            Object[] a = new Object[]{reciver};
            String sql = "select fpersonid,fuserid from t_wfr_mbos_try where fuserid =?";
            IRowSet re = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])a);
            if (re.size() > 0) {
                ifTry = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ifTry;
    }

    private String getMbosUrl(String procid, String actDefId) {
        String url = "";
        try {
            IRowSet rowSet;
            StringBuffer sql = new StringBuffer("SELECT url FROM T_WFR_MBOS_WORKFLOW  ");
            if (!StringUtils.isEmpty((CharSequence)actDefId)) {
                sql.append(" WHERE actDefId in ('" + actDefId + "')");
            }
            if (!StringUtils.isEmpty((CharSequence)procid)) {
                sql.append(" and procdefid in ('" + procid + "')");
            }
            if ((rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString())).next()) {
                url = rowSet.getString("url");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return url;
    }

    private String parseContent() {
        String msgContent = null;
        String dbCode = this.ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        try {
            msgContent = this.message.getLocaleStringHeader("body", new Locale("L2"));
            if (MessageModelEnum.FLOWCENTERTODO == this.MESSAGEMODEL || msgContent == null || msgContent.equals("")) {
                msgContent = this.message.getLocaleStringHeader("title", new Locale("L2"));
            }
            logger.debug((Object)("body=" + this.message.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + this.message.getLocaleStringHeader("title", new Locale("L2"))));
        }
        catch (Exception e) {
            logger.error((Object)"XT Message parseContent() error!", (Throwable)e);
        }
        String result = "";
        result = msgContent;
        return result;
    }

    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IUser user = UserFactory.getLocalInstance((Context)this.ctx);
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message getUsers() msgReceiver: " + msgReceiver));
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() error!", (Throwable)e);
        }
        return list;
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private void initMessageModel() {
        boolean ifInit = false;
        String apiVersion = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        try {
            if ("flowcenter".equalsIgnoreCase(apiVersion)) {
                String sendId = this.message.getStringHeader("sendId");
                String quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? ";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)quarySql, (Object[])new Object[]{sendId, sendId});
                if (rowSet.next()) {
                    ifInit = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ifInitFlowCenterMoudle error!", (Throwable)e);
        }
        if (ifInit) {
            this.MESSAGEMODEL = MessageModelEnum.FLOWCENTERTODO;
        }
    }

    public static void main(String[] args) {
        Message newMessage = MessageFactory.newMessage();
        Locale locale = new Locale("L2");
        newMessage.setLocaleStringHeader("title", "aaa", locale);
        newMessage.setLocaleStringHeader("body", "bbb", locale);
        newMessage.setLocaleStringHeader("sender", "ccc", locale);
    }
}

