/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WFPassAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFPassAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum messageModel = null;
    Map<String, Object> contents = null;
    private String itemtitle;

    public boolean isNeedSendXT() {
        return true;
    }

    public WFPassAdapter(Message message) {
        logger.debug((Object)"WFPassAdapter init");
        this.message = message;
        this.ctx = WFPassAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    public MessageModelEnum getModel() {
        return this.messageModel;
    }

    public Map<String, Object> getContent() {
        if (this.contents != null) {
            return this.contents;
        }
        this.contents = new HashMap<String, Object>();
        Map<String, Object> parseContent = this.parseContent();
        this.contents.putAll(parseContent);
        String dbCode = this.ctx.getAIS();
        String sourceIDs = this.message.getStringHeader("sourceIDs");
        String[] sourcdids = sourceIDs.replace("PASS::", "").split(":");
        String[] sourcdidsnew = sourceIDs.split("\\|");
        String fproinstid = sourcdids.length == 1 && sourcdidsnew.length > 1 ? sourcdidsnew[1] : sourcdids[0];
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
        String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
        String newEid = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "eid", "");
        String url = "";
        String assignId = "";
        String receiver = this.message.getStringHeader("receiver");
        if (this.message.getStringHeader("titlel2").indexOf("\u4f20\u9605\u53cd\u9988") > -1) {
            String billID = sourcdidsnew[2];
            fproinstid = sourcdidsnew[1];
            url = host.indexOf("?") > -1 ? host + "&storeEid=21231&name=approveui.navui&eid=" + newEid + "&type=mysend&billID=" + URLEncoder.encode(billID) + "&appid=" + appId + "&fprocinstid=" + fproinstid + "&personName=senderl2&personID=" + receiver : host + "/passAssignDetail.html?eid=" + newEid + "&type=mysend&billID=" + URLEncoder.encode(billID) + "&appid=" + appId + "&fprocinstid=" + fproinstid + "&personName=senderl2&personID=" + receiver;
        } else if (host.indexOf("?") > -1) {
            assignId = "null".equals(sourcdids[5]) ? "" : sourcdids[5];
            url = host + "&storeEid=21231&name=approveui.navui&eid=" + newEid + "&type=myreceive&appid=" + appId + "&billID=" + URLEncoder.encode(sourcdids[1]) + "&assignID=" + sourcdids[5] + "&fprocinstid=" + fproinstid + "&personID=" + sourcdids[2] + "&isAllowrepass=" + sourcdids[4] + "&passId=" + sourcdids[6];
        } else {
            url = host + "/passAssignDetail.html?eid=" + newEid + "&type=myreceive&appid=" + appId + "&billID=" + URLEncoder.encode(sourcdids[1]) + "&assignID=" + sourcdids[5] + "&fprocinstid=" + fproinstid + "&personID=" + sourcdids[2] + "&isAllowrepass=" + sourcdids[4] + "&passId=" + sourcdids[6];
        }
        this.contents.put("url", url);
        this.contents.put("wxtitle", "\u60a8\u6709\u4f20\u9605\u6d88\u606f");
        this.contents.put("assignId", assignId);
        this.contents.put("procinstid", fproinstid);
        this.contents.put("sendId", this.message.getStringHeader("initiatorId"));
        this.contents.put("receiver", receiver);
        this.contents.put("todo", "0");
        this.contents.put("appid", appId);
        if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)this.messageModel)) {
            String text = (String)parseContent.get("text");
            String itemtitle = text.replaceAll("\n[\\s\\S]*", "");
            this.contents.put("itemtitle", itemtitle);
            this.contents.put("text", text.replace(itemtitle + "\n", ""));
            this.contents.put("tagId", "notify");
        }
        return this.contents;
    }

    private Map<String, Object> parseContent() {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String msgContent = "";
        String opinion = "";
        String userName = "";
        if (this.message.getStringHeader("titlel2").indexOf("\u4f20\u9605\u53cd\u9988") > -1) {
            userName = this.message.getLocaleStringHeader("sender", new Locale("L2"));
            opinion = this.message.getLocaleStringHeader("body", new Locale("L2"));
            userName = StringUtils.isEmpty((String)userName) ? "" : userName + "\u7684";
            msgContent = msgContent + userName + "\u4f20\u9605\u53cd\u9988";
            msgContent = msgContent + "\n" + this.message.getLocaleStringHeader("title", new Locale("L2"));
            opinion = StringUtils.isEmpty((String)userName) ? "" : opinion.replaceFirst("\u6536\u5230\u6765\u81ea[\\s\\S]+\u7684\u4f20\u9605\u53cd\u9988\u4fe1\u606f", "");
            opinion = opinion.replaceFirst("\u4f20\u9605\u53cd\u9988\\[[\\s\\S]+\\]", "");
            opinion = opinion.replaceFirst("\u4f20\u9605\u53cd\u9988\u4eba\uff1a[\\s\\S]*", "").replaceAll("\n", "").replaceAll("\r", "");
            msgContent = msgContent + "\n\u4f20\u9605\u53cd\u9988\u610f\u89c1\uff1a" + opinion;
        } else {
            String body = this.message.getLocaleStringHeader("body", new Locale("L2"));
            if (body.matches("\u4f20\u9605\\[[\\s\\S]+/\\*\u4ee5\u4e0b\u662f\u4f20\u9605\u610f\u89c1[\\s\\S]+\u4f20\u9605\u4eba :[\\s\\S]+\\*/")) {
                opinion = body.replaceAll("[\\s\\S]+/\\*\u4ee5\u4e0b\u662f\u4f20\u9605\u610f\u89c1", "").replaceAll("\u4f20\u9605\u4eba :[\\s\\S]+", "");
                userName = body.replaceAll("[\\s\\S]+\u4f20\u9605\u4eba :", "").replaceAll("\\*/", "").replaceAll("\n", "").replaceAll("\r", "");
            } else if (body.matches("\u4f20\u9605\\[[\\s\\S]+\u4f20\u9605\u4eba:[\\s\\S]+\u4f20\u9605\u610f\u89c1:[\\s\\S]+")) {
                opinion = body.replaceAll("[\\s\\S]+\u4f20\u9605\u610f\u89c1:", "").replaceAll("\"", "&quot;");
                userName = body.replaceAll("[\\s\\S]+\u4f20\u9605\u4eba:", "").replaceAll("\u4f20\u9605\u610f\u89c1:[\\s\\S]+", "").replaceAll("\n", "").replaceAll("\r", "");
            } else {
                String[] bodys = body.split("/*\u4ee5\u4e0b\u662f\u4f20\u9605\u610f\u89c1");
                if (bodys.length > 1) {
                    opinion = bodys[1].replaceAll("\n", "");
                    String[] opinions = opinion.split("\u4f20\u9605\u4eba :");
                    opinion = opinions[0];
                    userName = opinions[1].replace("*/", "");
                } else {
                    try {
                        String[] content = body.split("\u4f20\u9605\u4eba:");
                        String[] passInfo = content[1].split("\u4f20\u9605\u610f\u89c1:");
                        userName = passInfo[0].replace("\n", "");
                        opinion = passInfo[1];
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u4f20\u9605\u4fe1\u606f\u62fc\u63a5\u9519\u8bef\uff1a" + e.getMessage()));
                    }
                }
            }
            msgContent = msgContent + userName + "\u7684\u4f20\u9605";
            msgContent = msgContent + "\n" + this.message.getLocaleStringHeader("title", new Locale("L2"));
            msgContent = msgContent + "\n\u4f20\u9605\u610f\u89c1\uff1a" + opinion;
        }
        contents.put("text", msgContent);
        logger.info((Object)("XT Message parseContext() body=" + this.message.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + this.message.getLocaleStringHeader("title", new Locale("L2"))));
        return contents;
    }

    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String msgReceiver = this.message.getStringHeader("receiver");
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() get personID error!", (Throwable)e);
        }
        return list;
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private void initMessageModel() {
        boolean ifInit = false;
        String apiVersion = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        try {
            if ("flowcenter".equalsIgnoreCase(apiVersion)) {
                String sourceIDs = this.message.getStringHeader("sourceIDs");
                String[] sourcdids = sourceIDs.replace("PASS::", "").split(":");
                String[] sourcdidsnew = sourceIDs.split("\\|");
                String procinstid = sourcdids.length == 1 && sourcdidsnew.length > 1 ? sourcdidsnew[1] : sourcdids[0];
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                String initiatorId = service.getProcessInstInfo(procinstid).getInitiatorId();
                this.message.setStringHeader("initiatorId", initiatorId);
                String quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? ";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)quarySql, (Object[])new Object[]{initiatorId, initiatorId});
                if (rowSet.next()) {
                    ifInit = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ifInitFlowCenterMoudle error!", (Throwable)e);
        }
        if (ifInit) {
            this.messageModel = MessageModelEnum.FLOWCENTERNOTICE;
        }
    }

    public static void main(String[] args) {
        Message newMessage = MessageFactory.newMessage();
        Locale locale = new Locale("L2");
        newMessage.setLocaleStringHeader("title", "aaa", locale);
        newMessage.setLocaleStringHeader("body", "bbb", locale);
        newMessage.setLocaleStringHeader("sender", "ccc", locale);
    }
}

