/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message;

import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DumpDataDetail
implements Serializable {
    private static final long serialVersionUID = -8376541541766334438L;
    private String srcTable;
    private String destTable;
    private String[] columns;
    private String primaryKey;
    private String filter;
    private Object[] params;
    private String order;
    private int actualCount;
    private int numRestricted;
    private int numBatch;
    private List numDetail = new ArrayList();
    private int currBatchIndex;
    private int numSuccess;
    private boolean prepared = false;
    private boolean needDump = false;

    public DumpDataDetail() {
    }

    public DumpDataDetail(String srcTable, String destTable, String[] columns, String filter, Object[] params, String order, int actualCount, int numRestricted, int numBatch) {
        this.srcTable = srcTable;
        this.destTable = destTable;
        this.columns = columns;
        this.filter = filter;
        this.params = params;
        this.order = order;
        this.actualCount = actualCount;
        this.numRestricted = numRestricted;
        this.numBatch = numBatch;
    }

    public String getSrcTable() {
        return this.srcTable;
    }

    public void setSrcTable(String srcTable) {
        if (this.prepared) {
            return;
        }
        this.srcTable = srcTable;
    }

    public String getDestTable() {
        return this.destTable;
    }

    public void setDestTable(String destTable) {
        if (this.prepared) {
            return;
        }
        this.destTable = destTable;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        if (this.prepared) {
            return;
        }
        this.columns = columns;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        if (this.prepared) {
            return;
        }
        this.filter = filter;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setParams(Object[] params) {
        if (this.prepared) {
            return;
        }
        this.params = params;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        if (this.prepared) {
            return;
        }
        this.order = order;
    }

    public int getActualCount() {
        return this.actualCount;
    }

    public void setActualCount(int actualCount) {
        if (this.prepared) {
            return;
        }
        this.actualCount = actualCount;
    }

    public int getNumRestricted() {
        return this.numRestricted;
    }

    public void setNumRestricted(int numRestricted) {
        if (this.prepared) {
            return;
        }
        this.numRestricted = numRestricted;
    }

    public int getNumBatch() {
        return this.numBatch;
    }

    public void setNumBatch(int numBatch) {
        if (this.prepared) {
            return;
        }
        this.numBatch = numBatch;
    }

    public List getNumDetail() {
        return this.numDetail;
    }

    public int getNumSuccess() {
        return this.numSuccess;
    }

    public boolean isNeedDump() {
        return this.needDump;
    }

    public int getDumpTimes() {
        return this.numDetail.size();
    }

    public void prepare() {
        this.prepared = true;
        if (this.actualCount > 0) {
            this.needDump = true;
            this.initNumDetail();
        }
    }

    public void done() {
        this.numSuccess = this.getNumDump();
    }

    private void initNumDetail() {
        int num = this.getNumDump();
        if (this.numBatch == 0) {
            this.numDetail.add(new Integer(num));
        } else {
            for (int i = 0; i < num / this.numBatch; ++i) {
                this.numDetail.add(new Integer(this.numBatch));
            }
            int left = num % this.numBatch;
            if (left > 0) {
                this.numDetail.add(new Integer(left));
            }
        }
    }

    private int getNumDump() {
        return this.numRestricted == 0 || this.numRestricted > this.actualCount ? this.actualCount : this.numRestricted;
    }

    public String getSelectCountSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(*) FROM ").append(this.srcTable);
        if (!StringUtils.isEmpty((String)this.filter)) {
            sql.append(" WHERE ").append(this.filter);
        }
        return sql.toString();
    }

    public String[] getCurrSqls() {
        if (!this.needDump) {
            return null;
        }
        String insertSql = this.getCurrInsertSql();
        String deleteSql = this.getCurrDeleteSql();
        int preBatchIndex = this.currBatchIndex - 1;
        if (preBatchIndex >= 0) {
            this.numSuccess += ((Integer)this.numDetail.get(preBatchIndex)).intValue();
        }
        ++this.currBatchIndex;
        return new String[]{insertSql, deleteSql};
    }

    private String getCurrInsertSql() {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO ").append(this.destTable);
        String columnSql = this.getColumnSql();
        if (columnSql != null && columnSql.length() > 0) {
            insertSql.append("(").append(columnSql).append(")");
        } else {
            columnSql = "*";
        }
        insertSql.append(" SELECT");
        int numCurrDump = this.getNumCurrDump();
        if (this.numBatch > 0) {
            insertSql.append(" TOP ").append(numCurrDump);
        }
        insertSql.append(" ").append(columnSql);
        insertSql.append(" FROM ").append(this.srcTable);
        if (!StringUtils.isEmpty((String)this.filter)) {
            insertSql.append(" WHERE ").append(this.filter);
        }
        if (!StringUtils.isEmpty((String)this.order)) {
            insertSql.append(" ORDER BY ").append(this.order);
        }
        return insertSql.toString();
    }

    private String getCurrDeleteSql() {
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append("DELETE FROM ").append(this.srcTable);
        deleteSql.append(" WHERE ").append(this.primaryKey).append(" IN (");
        deleteSql.append("SELECT");
        int numCurrDump = this.getNumCurrDump();
        if (this.numBatch > 0) {
            deleteSql.append(" TOP ").append(numCurrDump);
        }
        deleteSql.append(" ").append(this.primaryKey);
        deleteSql.append(" FROM ").append(this.srcTable);
        if (!StringUtils.isEmpty((String)this.filter)) {
            deleteSql.append(" WHERE ").append(this.filter);
        }
        if (!StringUtils.isEmpty((String)this.order)) {
            deleteSql.append(" ORDER BY ").append(this.order);
        }
        deleteSql.append(")");
        return deleteSql.toString();
    }

    private String getColumnSql() {
        if (this.columns == null) {
            return null;
        }
        StringBuffer columnSql = new StringBuffer();
        for (int i = 0; i < this.columns.length; ++i) {
            if (i != 0) {
                columnSql.append(",");
            }
            columnSql.append(this.columns[i]);
        }
        return columnSql.toString();
    }

    private int getNumCurrDump() {
        return (Integer)this.numDetail.get(this.currBatchIndex);
    }
}

