/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.ORMServiceLocation;
import com.kingdee.eas.base.message.DBTempMsgAgent;
import com.kingdee.eas.base.message.ITempMsgAgent;
import com.kingdee.eas.base.message.TempMsgAgent;
import com.kingdee.eas.util.app.ClusterService;
import org.apache.log4j.Logger;

public class TempMsgAgentFactory {
    private static Logger logger = Logger.getLogger((String)TempMsgAgentFactory.class.getName());
    public static final String TEMP_MESSAGE_SERVER_LOCATION = "TempMsg";
    public static ClusterService cs = new ClusterService();

    public static ITempMsgAgent getInstance(Context ctx) {
        ITempMsgAgent agent = null;
        ORMServiceLocation location = new ORMServiceLocation(TEMP_MESSAGE_SERVER_LOCATION);
        if (location != null) {
            if (!location.isLocal()) {
                String url = location.getServiceURL();
                agent = TempMsgAgentFactory.getInstance(url, ctx);
            } else {
                boolean isCluster = cs.isCluster();
                agent = isCluster ? new DBTempMsgAgent(ctx) : new TempMsgAgent(ctx);
            }
        } else {
            logger.error((Object)"invalidate config file !");
        }
        return agent;
    }

    public static ITempMsgAgent getInstance(String url, Context ctx) {
        if (url == null || url.trim().length() == 1) {
            url = "tcp://localhost";
        }
        ITempMsgAgent agent = null;
        boolean isCluster = cs.isCluster();
        if (isCluster) {
            try {
                Class[] clazzes = new Class[]{Context.class};
                Object[] objects = new Object[]{ctx};
                agent = (ITempMsgAgent)BOSObjectFactory.createRemoteBOSObject((String)url, (String)"com.kingdee.eas.base.message.DBTempMsgAgent", ITempMsgAgent.class, (Class[])clazzes, (Object[])objects);
            }
            catch (BOSException e) {
                logger.error((Object)"getInstance(cluster) failed ", (Throwable)e);
            }
        } else {
            try {
                agent = (ITempMsgAgent)BOSObjectFactory.createRemoteBOSObject((String)url, (String)"com.kingdee.eas.base.message.TempMsgAgent", ITempMsgAgent.class);
            }
            catch (BOSException e) {
                logger.error((Object)"getInstance(not-cluster) failed ", (Throwable)e);
            }
        }
        return agent;
    }
}

