/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.billdigest.BillDigestUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.jms.TextMessage;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.thread.ScheduledApprove;
import com.kingdee.bos.workflow.lightapp.message.WFMessageHandler;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.bos.workflow.message.AssignmentDeletionEvent;
import com.kingdee.bos.workflow.message.IAssignmentListener;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.BillDigestFactory;
import com.kingdee.bos.workflow.monitor.SummaryProxy;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.util.WfMsgToOtherSys;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.IAssignRead;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgUnreadCountFactory;
import com.kingdee.eas.base.message.URLInfo;
import com.kingdee.eas.base.message.app.CheckerForAssignRead;
import com.kingdee.eas.base.message.app.HandlerContainer;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatCacheManager;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.message.webservice.MCInvoke;
import com.kingdee.eas.base.message.webservice.WebServiceControlUtil;
import com.kingdee.eas.base.multiapprove.ext.app.AutoApproveCheck;
import com.kingdee.eas.base.multiapprove.ext.app.AutoApproveForExecutor;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.cp.eip.mc.IJobDelegateManagerFacade;
import com.kingdee.eas.cp.eip.mc.JobDelegateManagerFacadeFactory;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class AssignReadListener
implements IAssignmentListener {
    private static Logger logger = Logger.getLogger((String)AssignReadListener.class.getName());
    private static final Locale[] locales = new Locale[]{new Locale("L1"), new Locale("L2"), new Locale("L3")};
    private static final String delSql = "delete from T_BAS_AssignRead where FAssignID = ?";
    private static final ExecutorService executorService = Executors.newFixedThreadPool(5);

    public void assignmentCreated(final AssignmentCreationEvent ed) throws BOSException {
        this.printHints(ed);
        Context ctx = AssignReadListener.getContext(ed.solution, ed.databaseCenter);
        String assignIDForLogger = ed.assignmentId;
        ClassificationStatCacheManager manager = ClassificationStatCacheManager.get(ctx);
        manager.expire(ed.receiver);
        if (ed.isJumpTo || ed.isDelegate) {
            return;
        }
        EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
        if (AssignReadListener.checkFinanceShare((IEnactmentService)iEnactmentService, ed.processInstId)) {
            return;
        }
        this.delegateAssign(ctx, (IEnactmentService)iEnactmentService, ed, assignIDForLogger);
        logger.debug((Object)"\u6d88\u606f\u4e2d\u5fc3\u5904\u7406\u4efb\u52a1\u6d88\u606f\u5b8c\u6bd5");
        if (ed.isDelegate) {
            return;
        }
        if (CheckerForAssignRead.isAutoApprove(ed, ctx, (IEnactmentService)iEnactmentService)) {
            return;
        }
        if (ed != null && !StringUtils.isEmpty((String)ed.assignmentId) && ed.isSendCommon && this.assignReadMainLogic(ed, ctx, assignIDForLogger, (IEnactmentService)iEnactmentService)) {
            return;
        }
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                HandlerContainer.getInstance().multiHandlersExecute(ed);
            }
        });
        logger.error((Object)"AssignReadListener.assignmentCreated--end--tss");
    }

    private void sendMessage2YZJ(Context ctx, IEnactmentService iEnactmentService, AssignmentCreationEvent ed) {
        boolean isAutoApprove = false;
        try {
            AssignmentInfo assInfo = iEnactmentService.getAssignmentById(ed.assignmentId);
            if (assInfo != null) {
                isAutoApprove = AutoApproveCheck.shouldAutoApprove((Context)ctx, (AssignmentInfo)assInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Send XT AutoApproveCheck Error:: ", (Throwable)e);
        }
        if (ed != null && !StringUtils.isEmpty((String)ed.assignmentId) && ed.isSendCommon && !isAutoApprove) {
            try {
                String dbCode = ctx.getAIS();
                String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
                if (XTServiceConfig.getInstance().getPubEnabled(eid, "WFMessage")) {
                    TextMessage message = new TextMessage();
                    message.setStringHeader("databaseCenter", ed.databaseCenter);
                    message.setStringHeader("solution", ed.solution);
                    message.setStringHeader("receiver", ed.receiver);
                    message.setStringHeader("assignid", ed.assignmentId);
                    Map name = ed.initiatorName;
                    String billID = ed.bizObjId;
                    String billAlias = "";
                    BOSObjectType bostype = null;
                    String pk = "";
                    boolean sendMessage = true;
                    if (billID != null) {
                        bostype = BOSUuid.getBOSObjectType((String)billID, (boolean)true);
                        EntityObjectInfo entityinfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bostype);
                        billAlias = entityinfo.getAlias();
                        pk = entityinfo.getFullName();
                    }
                    if (sendMessage) {
                        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String dateStr = dateformat.format(new Date());
                        for (int i = 1; i < 4; ++i) {
                            String localString = "L" + i;
                            Locale locale = new Locale(localString);
                            String initiatorName = (String)name.get(locale);
                            String pre = (initiatorName == null ? "" : String.valueOf(initiatorName) + "\u7684") + billAlias + "\n" + dateStr;
                            message.setLocaleStringHeader("predetails", pre, locale);
                            message.setLocaleStringHeader("title", (String)ed.titles.get(locale), locale);
                            message.setLocaleStringHeader("body", (String)ed.bodies.get(locale), locale);
                        }
                        if (bostype == null || bostype != null && !bostype.toString().equals("F4C22AF9")) {
                            WFMessageHandler.sendMessageToXT((Message)message, ctx);
                            logger.error((Object)"WFMessage is send XT success !");
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Send XT WorkFlow_Message Error:: ", (Throwable)e);
            }
        }
    }

    public static boolean checkFinanceShare(IEnactmentService iEnactmentService, String procInstId) {
        block4: {
            try {
                Object obj = iEnactmentService.getProcessContext(procInstId, "shareCenter");
                HashMap map = null;
                if (obj != null && obj instanceof HashMap) {
                    map = (HashMap)obj;
                    if (map.get("isTaskCenter") != null && map.get("isNode") != null) {
                        return (Boolean)map.get("isTaskCenter") != false && (Boolean)map.get("isNode") != false;
                    }
                    break block4;
                }
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"assignReadListener  \u5224\u65ad\u662f\u5426\u662f\u5171\u4eab\u7684\u8282\u70b9\uff0c\u662f\u5171\u4eab\u5c31\u4e0d\u53d1\u6d88\u606f:", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assignReadMainLogic(AssignmentCreationEvent ed, Context ctx, String assignIDForLogger, IEnactmentService iEnactmentService) throws BOSException {
        AssignReadInfo info = new AssignReadInfo();
        AssignmentInfo assInfo = null;
        info.setStatus(MsgStatus.UNREADED);
        info.setAssignID(BOSUuid.read((String)ed.assignmentId));
        try {
            OrgType orgType = OrgType.NONE;
            String orgID = "11111111-1111-1111-1111-111111111111CCE7AED4";
            IAssignRead iAssignRead = AssignReadFactory.getLocalInstance(ctx);
            Map m = iEnactmentService.getActivityDefAndActivityInstInfo(ed.assignmentId);
            boolean isWebSupport = false;
            Object act = m.get("ACTIVITYDEF");
            ExtendedAttributeCollection extendAttrCol = ((ActivityDef)act).getActivityHeader().getExtendedAttributes();
            ExtendedAttributeDef value = extendAttrCol.get("customUIStatus");
            String operateState = value == null ? "view" : value.getValue();
            String bosType = null;
            if (!StringUtils.isEmpty((String)ed.bizObjId)) {
                bosType = this.getObjBosType(ed.bizObjId);
                OrgType bizOrgType = this.getOrgTypeByBoid(ed.bizObjId, ctx);
                isWebSupport = this.isWebSupport(ctx, ed.bizObjId, operateState);
                if (!StringUtils.isEmpty((String)ed.orgId)) {
                    orgType = bizOrgType;
                    orgID = ed.orgId;
                } else {
                    BOSObjectType objectType = new ObjectUuidPK(ed.bizObjId).getObjectType();
                    if (bizOrgType.equals((Object)OrgType.Company) || bizOrgType.equals((Object)OrgType.ControlUnit)) {
                        IObjectValue objectValue = null;
                        try {
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("id"));
                            if (bizOrgType.equals((Object)OrgType.Company)) {
                                sic.add(new SelectorItemInfo("company.id"));
                            } else {
                                sic.add(new SelectorItemInfo("CU.id"));
                            }
                            Connection connection = null;
                            try {
                                connection = EJBFactory.getConnection((Context)ctx);
                                ORMappingDAO mappingDAO = new ORMappingDAO(objectType, ctx, connection);
                                objectValue = mappingDAO.getValue((IObjectPK)new ObjectUuidPK(ed.bizObjId), sic, true);
                            }
                            catch (SQLException e1) {
                                logger.error((Object)("transformMessage's error:" + assignIDForLogger), (Throwable)e1);
                            }
                            finally {
                                if (connection != null) {
                                    SQLUtils.cleanup((Connection)connection);
                                }
                            }
                        }
                        catch (BOSException e) {
                            logger.error((Object)("transformMessage's error:" + assignIDForLogger), (Throwable)e);
                        }
                        if (objectValue != null) {
                            String orgid = null;
                            if (objectValue.get("company") != null) {
                                orgid = ((ObjectBaseInfo)objectValue.get("company")).getId().toString();
                            } else if (objectValue.get("CU") != null) {
                                orgid = ((ObjectBaseInfo)objectValue.get("CU")).getId().toString();
                            }
                            if (!StringUtils.isEmpty(orgid)) {
                                orgType = bizOrgType;
                                orgID = orgid;
                            }
                        }
                    }
                }
            } else if (!StringUtils.isEmpty((String)ed.assignmentId)) {
                assInfo = iEnactmentService.getAssignmentById(ed.assignmentId);
                OperationInfo oper = null;
                if (!StringUtils.isEmpty((String)assInfo.getBizPackage()) && !StringUtils.isEmpty((String)assInfo.getBizFunction())) {
                    FunctionObjectInfo functionObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)new MetaDataPK(assInfo.getBizPackage(), assInfo.getBizFunction()));
                    OperationCollection operCol = functionObjectInfo.getOperation();
                    for (int i = 0; i < operCol.size(); ++i) {
                        if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)assInfo.getBizOperation())) continue;
                        oper = operCol.get(i);
                        break;
                    }
                }
                if (oper != null) {
                    bosType = oper.getEntityObjectRef().getType().toString();
                    String billId = assInfo.getBizObjectIds();
                    isWebSupport = this.isWebSupport(ctx, billId, oper.getEntityObjectRef().getType(), operateState);
                }
            }
            if (!isWebSupport) {
                URLInfo urlInfo = ProcessCenterUtil.getEditUrlInfoByAssign(ed.assignmentId, ctx);
                isWebSupport = !StringUtils.isEmpty((String)urlInfo.getURL());
            }
            info.setOrgType(orgType);
            info.setOrgID(orgID);
            info.setIsWebSupport(isWebSupport);
            info.setBosType(bosType);
            info.setSenderId(ed.initiatorId);
            String priorPerformerID = null;
            if (!StringUtils.isEmpty((String)ed.assignmentId)) {
                assInfo = iEnactmentService.getAssignmentById(ed.assignmentId);
            }
            priorPerformerID = assInfo != null && assInfo.getAssignInfo() != null ? assInfo.getAssignInfo().getPriorPerformerID() : ed.initiatorId;
            info.setPriorPerformerID(priorPerformerID);
            this.makeMultiLanguageInfo(ed, info, assInfo);
            logger.error((Object)("------iAssignRead.addnew  :" + assignIDForLogger));
            iAssignRead.addnew(info);
            this.messageToOtherSys(ed, ctx, assignIDForLogger, iEnactmentService, info, assInfo);
        }
        catch (Exception e1) {
            logger.error((Object)("add assignRead data error " + assignIDForLogger), (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        return false;
    }

    private void makeMultiLanguageInfo(AssignmentCreationEvent ed, AssignReadInfo info, AssignmentInfo assInfo) {
        for (int i = 0; i < locales.length; ++i) {
            info.setTag(ed.tags, locales[i]);
            Object initiatorNameLocale = ed.initiatorName.get(locales[i]);
            if (initiatorNameLocale != null) {
                info.setSender(ed.initiatorName.get(locales[i]).toString(), locales[i]);
            } else {
                info.setSender("", locales[i]);
            }
            String priorPerformName = null;
            if (assInfo != null && assInfo.getAssignInfo() != null) {
                priorPerformName = assInfo.getAssignInfo().getPriorPerformName(locales[i]);
            }
            if (StringUtils.isEmpty(priorPerformName)) {
                priorPerformName = (String)ed.initiatorName.get(locales[i]);
            }
            info.setPriorPerformName(priorPerformName, locales[i]);
        }
    }

    private void printHints(AssignmentCreationEvent ed) {
        logger.error((Object)"AssignReadListener.assignmentCreated--start--tss");
        logger.debug((Object)" will create assignread data");
        logger.debug((Object)"----------------------------------------------------------");
        logger.error((Object)("assignmentId                            " + ed.assignmentId));
        logger.error((Object)("isSendCommon                            " + ed.isSendCommon));
        logger.debug((Object)("solution                                " + ed.solution));
        logger.debug((Object)("databaseCenter                          " + ed.databaseCenter));
        logger.debug((Object)("orgId                                   " + ed.orgId));
        logger.debug((Object)"----------------------------------------------------------");
    }

    private void delegateAssign(Context ctx, IEnactmentService svc, AssignmentCreationEvent ed, String assignIDForLogger) {
        List delegateUser = this.getDelegateUser(ed.solution, ed.databaseCenter, ed.receiver, ed.assignmentId, ed.initiatorId);
        if (ed.isSendCommon) {
            if (delegateUser == null) {
                ed.isJumpTo = true;
            } else if (delegateUser.size() > 0) {
                for (Object obj : delegateUser) {
                    UserInfo u = (UserInfo)obj;
                    if (!AssignReadListener.checkIfHasBackDelegate(ctx, svc, ed.assignmentId, u.getId().toString())) continue;
                    return;
                }
                try {
                    if (this.disposeDelegate(ed.solution, ed.databaseCenter, delegateUser, ed.assignmentId)) {
                        ed.isDelegate = true;
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)("\u4efb\u52a1\u8f6c\u4ea4\u5931\u8d25 \uff1a" + assignIDForLogger), (Throwable)e1);
                }
            }
        }
    }

    private void messageToOtherSys(AssignmentCreationEvent ed, final Context ctx, String assignIDForLogger, IEnactmentService iEnactmentService, final AssignReadInfo info, AssignmentInfo assInfo) {
        try {
            if (WebServiceControlUtil.isToOtherSys()) {
                executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        MCInvoke.getInstance().wsImplRead(MCInvoke.intoMessage(info, ctx), ctx);
                    }
                });
            }
            if (WebServiceControlUtil.isLetOtherSysGet()) {
                if (assInfo == null) {
                    assInfo = iEnactmentService.getAssignmentById(ed.assignmentId);
                }
                MsgUnreadCountFactory.getLocalInstance(ctx).unReadCount(ed.receiver, assInfo.getCreatedTime());
            }
        }
        catch (Exception e) {
            logger.error((Object)("assignReadListener  \u7b2c\u4e09\u65b9\u6d88\u606f\u63a8\u9001\u5931\u8d25  \u5177\u4f53\u9519\u8bef:" + assignIDForLogger), (Throwable)e);
            logger.error((Object)e);
        }
    }

    public void assignmentBatchCreated(AssignmentCreationEvent[] events) throws BOSException {
        if (events != null && events.length > 0) {
            AssignmentCreationEvent ed = null;
            HashMap<String, Boolean> jumpAssignMap = new HashMap<String, Boolean>();
            HashMap<String, Boolean> delegateAssignMap = new HashMap<String, Boolean>();
            for (int i = 0; i < events.length; ++i) {
                ed = events[i];
                try {
                    Boolean jumpToAssign = (Boolean)jumpAssignMap.get(ed.assignmentId);
                    Boolean delegateAssign = (Boolean)delegateAssignMap.get(ed.assignmentId);
                    if (jumpToAssign != null) {
                        ed.isJumpTo = jumpToAssign;
                    }
                    if (delegateAssign != null) {
                        ed.isDelegate = delegateAssign;
                    }
                    this.assignmentCreated(ed);
                    jumpAssignMap.put(ed.assignmentId, ed.isJumpTo);
                    delegateAssignMap.put(ed.assignmentId, ed.isDelegate);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("-------\u521b\u5efa\u5f85\u529e\u4efb\u52a1\u53d1\u751f\u5f02\u5e38 " + ed.assignmentId), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public void assignmentDeleted(AssignmentDeletionEvent ed) throws BOSException {
        logger.debug((Object)" will delete assignread data");
        logger.debug((Object)"----------------------------------------------------------");
        logger.debug((Object)("assignmentId                            " + ed.assignmentId));
        logger.debug((Object)("solution                                " + ed.solution));
        logger.debug((Object)("databaseCenter                          " + ed.datacenter));
        logger.debug((Object)"----------------------------------------------------------");
        if (ed != null && !StringUtils.isEmpty((String)ed.assignmentId)) {
            Object[] params = new Object[]{ed.assignmentId};
            DbUtil.execute((Context)AssignReadListener.getContext(ed.solution, ed.datacenter), (String)delSql, (Object[])params);
        }
        LinkedList<String> IDList = new LinkedList<String>();
        IDList.add(ed.assignmentId);
    }

    public void assignmentBatchDeleted(AssignmentDeletionEvent[] events) throws BOSException {
        if (events != null && events.length > 0) {
            String solution = events[0].solution;
            String datacenter = events[0].datacenter;
            ArrayList<String> ids = new ArrayList<String>();
            ArrayList listMap = new ArrayList();
            String sql = "select FSenderId,FTag_l2 from T_BAS_AssignRead where FAssignID=? and FTag_l2 <> null";
            String delSQL = "delete from T_BAS_AssignRead where FAssignID=?";
            Context ctx = AssignReadListener.getContext(solution, datacenter);
            for (int i = 0; i < events.length; ++i) {
                ids.add(events[i].assignmentId);
                Object[] objectArray = new Object[]{events[i].assignmentId};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])objectArray);
                try {
                    if (rs.next()) {
                        HashMap<String, String> results = new HashMap<String, String>();
                        results.put("FAssignID", events[i].assignmentId);
                        results.put("FSenderId", rs.getString("FSenderId"));
                        results.put("FTag_l2", rs.getString("FTag_l2"));
                        listMap.add(results);
                    }
                }
                catch (SQLException results) {
                    // empty catch block
                }
                DbUtil.execute((Context)ctx, (String)delSQL, (Object[])objectArray);
            }
            if (listMap.size() > 0) {
                for (Map map : listMap) {
                    String insert = "insert into T_BAS_AssignDetailExp(FID,FAssignId,FInitiatorId,FTag_l1,FTag_l2,FTag_l3)values(?,?,?,?,?,?)";
                    String id = BOSUuid.create((String)"27031731").toString();
                    Object[] params = new Object[]{id, map.get("FAssignID"), map.get("FSenderId"), map.get("FTag_l2"), map.get("FTag_l2"), map.get("FTag_l2")};
                    DbUtil.execute((Context)AssignReadListener.getContext(solution, datacenter), (String)insert, (Object[])params);
                }
            }
            WfMsgToOtherSys.removeAssign4OtherSys((Context)AssignReadListener.getContext(solution, datacenter), ids);
        }
    }

    private static Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }

    private IJobDelegateManagerFacade getMyJobDelegate(String currentSolutionName, String currentDatabaseCenter) {
        IJobDelegateManagerFacade iJobDelegate = null;
        try {
            iJobDelegate = JobDelegateManagerFacadeFactory.getLocalInstance((Context)AssignReadListener.getContext(currentSolutionName, currentDatabaseCenter));
        }
        catch (BOSException e) {
            logger.error((Object)"getMyJobDelegate failed", e.getCause());
        }
        return iJobDelegate;
    }

    private List getDelegateUser(String currentSolutionName, String currentDatabaseCenter, String userID, String assignmentId, String initiatorId) {
        List delegateUser = new ArrayList();
        logger.debug((Object)("\u59d4\u6258\u4ebaID\uff1d" + userID + ",\u6d41\u7a0b\u53d1\u8d77ID\uff1d" + initiatorId + ",\u4efb\u52a1Id\uff1d" + assignmentId));
        if (assignmentId == null || assignmentId.trim().length() <= 0 || userID == null || userID.trim().length() <= 0 || initiatorId == null || initiatorId.trim().length() <= 0) {
            return delegateUser;
        }
        try {
            delegateUser = this.getMyJobDelegate(currentSolutionName, currentDatabaseCenter).getEntrustPerson(assignmentId, userID);
        }
        catch (Exception e) {
            logger.error((Object)e.getCause());
        }
        return delegateUser;
    }

    private static boolean checkIfHasBackDelegate(Context ctx, IEnactmentService svc, String assignmentId, String deleUserId) {
        try {
            AssignmentInfo assign = svc.getAssignmentById(assignmentId);
            ActivityInstInfo actInstInfo = svc.getActivityInstByActInstId(assign.getActInstId());
            WfActivity activity = new WfActivity(WfEngine.getEngine((Context)ctx), actInstInfo);
            Object obj = activity.getProcess().getDataField("backdele" + deleUserId + "$" + assignmentId);
            if (obj == null) {
                return false;
            }
            if (((Boolean)obj).booleanValue()) {
                return true;
            }
        }
        catch (WfException e) {
            logger.error((Object)e.getCause());
        }
        return false;
    }

    private boolean disposeDelegate(String currentSolutionName, String currentDatabaseCenter, List delegateUser, String assignmentId) throws BOSException {
        try {
            boolean isDevolve = true;
            String delegateUserID = null;
            IEnactmentService service = this.getEnactmentService(currentSolutionName, currentDatabaseCenter);
            AssignmentInfo assign = service.getAssignmentById(assignmentId);
            WfActivity act = WfEngine.getEngine((Context)service.getContext()).getActivityInst(assign.getActInstId());
            WfAssignmentState state = assign.getState();
            AutoApproveForExecutor autoApprove = new AutoApproveForExecutor();
            if (state.equals((Object)WfAssignmentState.ASSIGNED) || state.equals((Object)WfAssignmentState.ACCEPTED)) {
                for (int i = 0; i < delegateUser.size(); ++i) {
                    delegateUserID = ((UserInfo)delegateUser.get(i)).getId().toString();
                    if (service.devolve(assignmentId, delegateUserID) != null) continue;
                    isDevolve = false;
                    delegateUser.clear();
                }
                if (delegateUser.size() > 0) {
                    ScheduledApprove scheduledApprove = new ScheduledApprove(autoApprove, act);
                    Job job = new Job(act.getContext(), (IJobHandler)scheduledApprove, null, true);
                    job.setScheduledTime(new Date(System.currentTimeMillis() + 5000L));
                    JobManager.instance().add(job);
                }
            }
            return isDevolve;
        }
        catch (Exception e1) {
            logger.error((Object)"\u8f6c\u4ea4\u5de5\u4f5c\u6d41\u4efb\u52a1\u5931\u8d25", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
    }

    private IEnactmentService getEnactmentService(String currentSolutionName, String currentDatabaseCenter) throws Exception {
        String userName = "administrator";
        Context context = AssignReadListener.getContext(currentSolutionName, currentDatabaseCenter);
        context.setUserName(userName);
        IEnactmentService service = (IEnactmentService)BOSObjectFactory.createBOSObject((Context)context, (String)EnactmentServiceProxy.class.getName());
        return service;
    }

    private OrgType getOrgTypeByBoid(String bizObjectID, Context ctx) {
        OrgType orgType = OrgType.NONE;
        BOSObjectType objectType = new ObjectUuidPK(bizObjectID).getObjectType();
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(objectType);
        OrgType bizOrgType = this.getBizOrgType(entityObjectInfo);
        if (bizOrgType != null) {
            return bizOrgType;
        }
        return orgType;
    }

    private OrgType getBizOrgType(EntityObjectInfo entityObjectInfo) {
        String strOrgType;
        if (entityObjectInfo != null && !StringUtils.isEmpty((String)(strOrgType = entityObjectInfo.getExtendedProperty("OrgType")))) {
            Iterator iterator = OrgType.iterator();
            while (iterator.hasNext()) {
                OrgType orgType = (OrgType)iterator.next();
                if (!orgType.getName().equalsIgnoreCase(strOrgType)) continue;
                return orgType;
            }
        }
        return OrgType.NONE;
    }

    private boolean isWebSupport(Context ctx, String bizObjectID, String operateState) {
        BOSObjectType objectType = new ObjectUuidPK(bizObjectID).getObjectType();
        return this.isWebSupport(ctx, bizObjectID, objectType, operateState);
    }

    private boolean isWebSupport(Context ctx, String bizObjectID, BOSObjectType objectType, String operateState) {
        boolean isWebSupport = false;
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(objectType);
        if (entityObjectInfo != null) {
            String isDynamic = entityObjectInfo.getExtendedProperty("isDynamic");
            if ("true".equalsIgnoreCase(isDynamic)) {
                return true;
            }
            String webEditPage = entityObjectInfo.getExtendedProperty("webEditPage");
            if (!StringUtils.isEmpty((String)webEditPage)) {
                return true;
            }
            String webSupport = entityObjectInfo.getExtendedProperty("isSupportWeb");
            if (!StringUtils.isEmpty((String)webSupport)) {
                return "true".equals(webSupport);
            }
            if (StringUtils.isEmpty((String)operateState) || "view".equalsIgnoreCase(operateState)) {
                try {
                    SummaryProxy proxy = BillDigestFactory.getLocalInstance((Context)ctx).getSummaryByUUIDAndDigType(bizObjectID, 2, null);
                    String messageDigest = BillDigestUtil.getDigest((Context)ctx, (String)bizObjectID, (String)"wf");
                    return proxy != null || messageDigest != null;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    isWebSupport = false;
                }
            }
        }
        return isWebSupport;
    }

    private String getObjBosType(String bizObjectID) {
        if (StringUtils.isEmpty((String)bizObjectID)) {
            return null;
        }
        return BOSUuid.read((String)bizObjectID).getType().toString();
    }
}

