/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.freechart.util.Log;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryInfo;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.BaseMessageException;
import com.kingdee.eas.base.message.DumpDataDetail;
import com.kingdee.eas.base.message.IBMCMessageHistory;
import com.kingdee.eas.base.message.IMAGroup;
import com.kingdee.eas.base.message.IMAGroupEntry;
import com.kingdee.eas.base.message.IMAGroupResolventEntry;
import com.kingdee.eas.base.message.MAGroupEntryFactory;
import com.kingdee.eas.base.message.MAGroupEntryInfo;
import com.kingdee.eas.base.message.MAGroupFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MAGroupResolventEntryFactory;
import com.kingdee.eas.base.message.MAGroupResolventEntryInfo;
import com.kingdee.eas.base.message.MAGroupResolventFactory;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgSendRecordFactory;
import com.kingdee.eas.base.message.MsgSendRecordInfo;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.MsgUnreadCountFactory;
import com.kingdee.eas.base.message.app.AbstractBMCMessageControllerBean;
import com.kingdee.eas.base.message.app.ReceiversUtil;
import com.kingdee.eas.base.message.webservice.MCInvoke;
import com.kingdee.eas.base.message.webservice.WebServiceControlUtil;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.receiver.BasReceiverCollection;
import com.kingdee.eas.base.receiver.BasReceiverInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BMCMessageControllerBean
extends AbstractBMCMessageControllerBean {
    private static final long serialVersionUID = -6767282413710565926L;
    private static Logger logger = Logger.getLogger(BMCMessageControllerBean.class);
    public static final int NUM_PIGEONHOLE_PER_TIME = 500;

    @Override
    protected void _processUpdatedMsg(Context ctx, String sourceID, int sourceStatus, int msgType) throws BOSException, BaseMessageException {
        if (sourceStatus == 4) {
            String strSql = "delete from T_BAS_Message  WHERE FSourceID =? ";
            Object[] params = new Object[]{sourceID};
            DbUtil.execute((Context)ctx, (String)strSql, (Object[])params);
        } else {
            String strSql = null;
            Object params = null;
            strSql = msgType == 30 ? "UPDATE T_BAS_Message SET FSourceStatus = " + sourceStatus + ", FStatus = 10 WHERE FSourceID ='" + sourceID + "'" : "UPDATE T_BAS_Message SET FSourceStatus = " + sourceStatus + ", FStatus = 10 WHERE FSourceID ='" + sourceID + "' and FSourceStatus < " + sourceStatus;
            DbUtil.execute((Context)ctx, (String)strSql);
        }
    }

    private void checkCanDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BMCMessageInfo msg = this.getBMCMessageInfo(ctx, pk);
        if (msg.getType().equals((Object)MsgType.TASK) && msg.getBizType().equals((Object)MsgBizType.WORKFLOW) && (msg.getSourceStatus().equals((Object)MsgSourceStatus.ASSIGNED) || msg.getSourceStatus().equals((Object)MsgSourceStatus.ACCEPTED))) {
            throw new BaseMessageException(BaseMessageException.UNDISPOSED_TASK_CAN_DEL);
        }
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkCanDelete(ctx, pk);
        BMCMessageInfo msgInfo = this.getBMCMessageInfo(ctx, pk);
        if (WebServiceControlUtil.isToOtherSys()) {
            MCInvoke.getInstance().wsImplRemoveBMC(msgInfo, ctx);
        }
        super.delete(ctx, pk);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        long start = System.currentTimeMillis();
        BMCMessageInfo messageInfo = (BMCMessageInfo)model;
        Locale l1 = new Locale("L1");
        Locale l2 = new Locale("L2");
        Locale l3 = new Locale("L3");
        BMCMessageInfo messageInfo2 = new BMCMessageInfo();
        messageInfo2.setBody(messageInfo.getBody(l1), l1);
        messageInfo2.setBody(messageInfo.getBody(l2), l2);
        messageInfo2.setBody(messageInfo.getBody(l3), l3);
        messageInfo2.setSourceIDs(messageInfo.getSourceIDs());
        messageInfo.remove("body", l1);
        messageInfo.remove("body", l2);
        messageInfo.remove("body", l3);
        messageInfo.remove("sourceIDs");
        IObjectPK pk = super._addnew(ctx, (IObjectValue)messageInfo);
        StringBuffer sqlBf = new StringBuffer();
        sqlBf.append(" update T_BAS_Message set FBody_L1 = ?, FBody_L2 = ?, FBody_L3 = ?, FSourceIDs = ?, FReceiveTime=? where FID = ?");
        Connection conn = null;
        PreparedStatement ps = null;
        Object sbin = null;
        Timestamp time = null;
        try {
            conn = EJBFactory.getConnnection((Context)ctx);
            ps = conn.prepareStatement(sqlBf.toString());
            ps.setString(1, messageInfo2.getBody(l1));
            ps.setString(2, messageInfo2.getBody(l2));
            ps.setString(3, messageInfo2.getBody(l3));
            ps.setString(4, messageInfo2.getSourceIDs());
            time = new Timestamp(new Date().getTime());
            ps.setTimestamp(5, time);
            ps.setString(6, pk.toString());
            ps.executeUpdate();
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)"_addnew failed !", (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        messageInfo.setBody(messageInfo2.getBody(l1), l1);
        messageInfo.setBody(messageInfo2.getBody(l2), l2);
        messageInfo.setBody(messageInfo2.getBody(l3), l3);
        messageInfo.setSourceIDs(messageInfo2.getSourceIDs());
        messageInfo.setReceiveTime(time);
        logger.debug((Object)("----controlBean add message cost:" + (System.currentTimeMillis() - start)));
        return pk;
    }

    @Override
    protected void _msgPigeonhole(Context ctx, int day, boolean unreadPigeonhole) throws BOSException, EASBizException {
        this._msgPigeonhole(ctx, day, unreadPigeonhole, 0);
    }

    @Override
    protected void _msgPigeonhole(Context ctx, int day, boolean unreadPigeonhole, int numTotal) throws BOSException, EASBizException {
        if (day > 0 && numTotal >= 0) {
            Calendar now = Calendar.getInstance();
            now.add(5, -day);
            Timestamp checkTimestamp = new Timestamp(now.getTimeInMillis());
            Object[] params = new Object[]{checkTimestamp};
            DumpDataDetail msrDetail = new DumpDataDetail();
            msrDetail.setSrcTable("T_BAS_MsgSendRecord");
            msrDetail.setDestTable("T_BAS_MsgSendRecordHst");
            msrDetail.setColumns(new String[]{"FID", "FSenderID", "FReciever_l1", "FReciever_l2", "FReciever_l3", "FTitle_l1", "FTitle_l2", "FTitle_l3", "FBody_l1", "FBody_l2", "FBody_l3", "FSendTime", "FPriority", "FSourceID"});
            msrDetail.setPrimaryKey("FID");
            msrDetail.setFilter("FSendTime < ?");
            msrDetail.setParams(params);
            msrDetail.setOrder("FSendTime ASC");
            msrDetail.setNumRestricted(numTotal);
            msrDetail.setNumBatch(500);
            String statusCondition = " AND FStatus = 10";
            String msgFilter = "FReceiveTime < ?";
            String msgyrFilter = "FReceiveTime < ?";
            if (!unreadPigeonhole) {
                msgFilter = msgFilter + statusCondition;
                msgyrFilter = msgyrFilter + statusCondition;
            }
            DumpDataDetail msgDetail = new DumpDataDetail();
            msgDetail.setSrcTable("T_BAS_Message");
            msgDetail.setDestTable("T_BAS_MessageHst");
            msgDetail.setColumns(new String[]{"FID", "FType", "FBizType", "FSender_L1", "FSender_L2", "FSender_L3", "FPriority", "FStatus", "FSourceStatus", "FTitle_L1", "FTitle_L2", "FTitle_L3", "FBody_L1", "FBody_L2", "FBody_L3", "FSendTime", "FReceiveTime", "FSourceID", "FReceiver", "FOrgType", "FOrgID", "FSourceIDs", "FBizPackage", "FReceivers", "FNreceivers"});
            msgDetail.setPrimaryKey("FID");
            msgDetail.setFilter(msgFilter);
            msgDetail.setParams(params);
            msgDetail.setOrder("FReceiveTime ASC");
            msgDetail.setNumRestricted(numTotal);
            msgDetail.setNumBatch(500);
            DumpDataDetail msgyrDetail = new DumpDataDetail();
            msgyrDetail.setSrcTable("T_BAS_Messageyr");
            msgyrDetail.setDestTable("T_BAS_MessageyrHst");
            msgyrDetail.setColumns(new String[]{"FID", "FType", "FBizType", "FSender", "FPriority", "FStatus", "FSourceStatus", "FTitle", "FBody", "FReceiveTime", "FSourceID", "FReceiver"});
            msgyrDetail.setPrimaryKey("FID");
            msgyrDetail.setFilter(msgyrFilter);
            msgyrDetail.setParams(params);
            msgyrDetail.setOrder("FReceiveTime ASC");
            msgyrDetail.setNumRestricted(numTotal);
            msgyrDetail.setNumBatch(500);
            DumpDataDetail[] details = new DumpDataDetail[]{msrDetail, msgDetail, msgyrDetail};
            try {
                for (int i = 0; i < details.length; ++i) {
                    this.batchDumpData(ctx, details[i]);
                }
            }
            catch (BOSException e) {
                StringBuffer msg = new StringBuffer();
                DumpDataDetail detail = null;
                for (int i = 0; i < details.length; ++i) {
                    detail = details[i];
                    msg.append("[");
                    msg.append(detail.getSrcTable());
                    msg.append(":");
                    msg.append(detail.getNumSuccess());
                    msg.append("] ");
                }
                Log.error((Object)msg.toString(), (Exception)((Object)e));
                throw new BaseMessageException(BaseMessageException.PIGEONHOLE_MSG_ERROR, e, new Object[]{msg.toString()});
            }
        }
    }

    private void batchDumpData(Context ctx, DumpDataDetail dumpDataDetail) throws BOSException, EASBizException {
        IRowSet sendRs = DbUtil.executeQuery((Context)ctx, (String)dumpDataDetail.getSelectCountSql(), (Object[])dumpDataDetail.getParams());
        try {
            sendRs.next();
            int actualCount = sendRs.getInt(1);
            dumpDataDetail.setActualCount(actualCount);
            logger.info((Object)("Pigeonholing table [" + dumpDataDetail.getSrcTable() + "]"));
            logger.info((Object)("Actual count (need pigeonhole): " + actualCount));
            logger.info((Object)("Number restricted: " + dumpDataDetail.getNumRestricted()));
            dumpDataDetail.prepare();
            if (dumpDataDetail.isNeedDump()) {
                logger.info((Object)("Number detail: " + dumpDataDetail.getNumDetail()));
                for (int i = 0; i < dumpDataDetail.getDumpTimes(); ++i) {
                    BMCMessageFactory.getLocalInstance(ctx).dumpData(dumpDataDetail);
                    logger.info((Object)("[" + (i + 1) + "] Number success: " + dumpDataDetail.getNumDetail().get(i)));
                }
            }
            dumpDataDetail.done();
        }
        catch (SQLException e) {
            StringBuffer errMsg = new StringBuffer();
            errMsg.append("SQL Execute Exception: ");
            errMsg.append(dumpDataDetail.getSelectCountSql());
            errMsg.append(", params is: ");
            errMsg.append(dumpDataDetail.getParams().toString());
            Log.error((Object)errMsg.toString(), (Exception)e);
            throw new BOSException(errMsg.toString(), (Throwable)e);
        }
    }

    @Override
    protected void _dumpData(Context ctx, DumpDataDetail dumpDataDetail) throws BOSException, EASBizException {
        String[] sqls = dumpDataDetail.getCurrSqls();
        DbUtil.execute((Context)ctx, (String)sqls[0], (Object[])dumpDataDetail.getParams());
        DbUtil.execute((Context)ctx, (String)sqls[1], (Object[])dumpDataDetail.getParams());
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, BaseMessageException, EASBizException {
        boolean flag = super.exists(ctx, pk);
        if (flag) {
            return super._getValue(ctx, pk);
        }
        IBMCMessageHistory history = BMCMessageHistoryFactory.getLocalInstance(ctx);
        BMCMessageHistoryInfo hInfo = history.getBMCMessageHistoryInfo(pk);
        return this.historyMsgToMsg(hInfo);
    }

    public boolean exists(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IBMCMessageHistory history;
        boolean flag = super.exists(ctx, pk);
        if (!flag && (history = BMCMessageHistoryFactory.getLocalInstance(ctx)).exists(pk)) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, BaseMessageException, EASBizException {
        boolean flag = super.exists(ctx, pk);
        if (flag) {
            return super._getValue(ctx, pk, selector);
        }
        IBMCMessageHistory history = BMCMessageHistoryFactory.getLocalInstance(ctx);
        BMCMessageHistoryInfo hInfo = history.getBMCMessageHistoryInfo(pk, selector);
        return this.historyMsgToMsg(hInfo);
    }

    protected BMCMessageInfo historyMsgToMsg(BMCMessageHistoryInfo hInfo) {
        if (hInfo != null) {
            BMCMessageInfo info = new BMCMessageInfo();
            info.setId(hInfo.getId());
            info.setTitle(hInfo.getTitle());
            info.setReceiver(hInfo.getReceiver());
            info.setReceiveTime(hInfo.getReceiveTime());
            info.setSendTime(hInfo.getSendTime());
            info.setStatus(hInfo.getStatus());
            info.setSourceStatus(hInfo.getSourceStatus());
            info.setSourceID(hInfo.getSourceID());
            info.setSourceIDs(hInfo.getSourceIDs());
            info.setBizType(hInfo.getBizType());
            info.setSender(hInfo.getSender());
            info.setBody(hInfo.getBody());
            return info;
        }
        return null;
    }

    @Override
    protected void _addHandMsg(Context ctx, IObjectValue msgInfo, IObjectCollection receiverCollection) throws BOSException {
        BMCMessageInfo mInfo = (BMCMessageInfo)msgInfo;
        Timestamp cuttentDate = new Timestamp(new Date().getTime());
        mInfo.setReceiveTime(cuttentDate);
        mInfo.setSendTime(cuttentDate);
        mInfo.setBizType(MsgBizType.ONLINE);
        mInfo.setSenderId(ctx.getCaller().toString());
        BasReceiverCollection receivers = (BasReceiverCollection)receiverCollection;
        BasReceiverInfo info = null;
        HashMap userIdMap = new HashMap();
        ReceiversUtil util = new ReceiversUtil();
        util.setCtx(ctx);
        ArrayList list = null;
        MsgSendRecordInfo msrInfo = new MsgSendRecordInfo();
        ObjectUuidPK recordPk = new ObjectUuidPK(BOSUuid.create((BOSObjectType)msrInfo.getBOSType()));
        Locale l1 = new Locale("L1");
        Locale l2 = new Locale("L2");
        Locale l3 = new Locale("L3");
        if (receivers != null && receivers.size() > 0) {
            for (int i = 0; i < receivers.size(); ++i) {
                info = receivers.get(i);
                if (info.getType().equals("1") || info.getType().equals("3")) {
                    userIdMap.put(info.getValue(), null);
                    continue;
                }
                if (info.getType().equals("0") || info.getType().equals("5")) {
                    try {
                        list = util.getUserIDsByAdminOrgUnit(info.getValue());
                        for (int j = 0; j < list.size(); ++j) {
                            userIdMap.put((String)list.get(j), null);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                if (info.getType().equals("2")) {
                    IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
                    IMAGroupResolventEntry ire = MAGroupResolventEntryFactory.getLocalInstance(ctx);
                    IMAGroup im = MAGroupFactory.getLocalInstance(ctx);
                    IMAGroupEntry ime = MAGroupEntryFactory.getLocalInstance(ctx);
                    String personid = "";
                    String sql1 = "select FID from T_PM_User where FPersonId=?";
                    StringBuffer sb = new StringBuffer();
                    try {
                        MAGroupResolventInfo mainfo = MAGroupResolventFactory.getLocalInstance(ctx).getMAGroupResolventInfo("select * where id = '" + info.getValue() + "'");
                        for (int n = 0; n < mainfo.getEntries().size(); ++n) {
                            MAGroupResolventEntryInfo entryInfo = ire.getMAGroupResolventEntryInfo((IObjectPK)new ObjectUuidPK(mainfo.getEntries().get(n).getId().toString()));
                            MAGroupInfo magroupInfo = im.getMAGroupInfo((IObjectPK)new ObjectUuidPK(entryInfo.getGroup().getId().toString()));
                            if (magroupInfo == null) continue;
                            for (int j = 0; j < magroupInfo.getEntries().size(); ++j) {
                                MAGroupEntryInfo magroupeinfo = ime.getMAGroupEntryInfo((IObjectPK)new ObjectUuidPK(magroupInfo.getEntries().get(j).getId().toString()));
                                if (magroupeinfo.getPersonnel() == null || magroupeinfo.getPersonnel().getId() == null || StringUtils.isEmpty((String)(personid = magroupeinfo.getPersonnel().getId().toString()))) continue;
                                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{personid});
                                try {
                                    while (rs.next()) {
                                        userIdMap.put(rs.getString("FID"), null);
                                    }
                                    continue;
                                }
                                catch (SQLException e) {
                                    logger.error((Object)"_addHandMsg SQLException failed!", (Throwable)e);
                                }
                            }
                        }
                        continue;
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"_addHandMsg EASBizException failed!", (Throwable)e);
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)"_addHandMsg BOSException failed!", (Throwable)e);
                        continue;
                    }
                }
                if (info.getType().equals("8")) {
                    UserCollection usercol = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select * where person = '" + info.getValue().toString() + "'");
                    for (UserInfo userInfo : usercol) {
                        if (userInfo == null) continue;
                        userIdMap.put(userInfo.getId().toString(), null);
                    }
                    continue;
                }
                if (!info.getType().equals("9")) continue;
                UserCollection uc = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select * where type <> 20 and isDelete = 0 and isLocked = 0 and isForbidden = 0 and cu = '" + info.getValue().toString() + "'");
                Iterator it1 = uc.iterator();
                UserInfo ui = null;
                while (it1.hasNext()) {
                    ui = (UserInfo)it1.next();
                    userIdMap.put(ui.getId().toString(), null);
                }
            }
        }
        String id = mInfo.getId().toString();
        Iterator ids = userIdMap.keySet().iterator();
        if (ids.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            mInfo.setReceiver((String)ids.next());
            try {
                this.addnew(ctx, (IObjectPK)pk, mInfo);
                msrInfo.setSenderID(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
                msrInfo.setSendTime(new Timestamp(new Date().getTime()));
                msrInfo.setTitle(mInfo.getTitle(), l1);
                msrInfo.setTitle(mInfo.getTitle(), l2);
                msrInfo.setTitle(mInfo.getTitle(), l3);
                msrInfo.setBody(mInfo.getBody(), l1);
                msrInfo.setBody(mInfo.getBody(), l2);
                msrInfo.setBody(mInfo.getBody(), l3);
                msrInfo.setReciever(mInfo.getNreceivers(), l1);
                msrInfo.setReciever(mInfo.getNreceivers(), l2);
                msrInfo.setReciever(mInfo.getNreceivers(), l3);
                msrInfo.setPriority(mInfo.getPriority());
                msrInfo.setSourceID(mInfo.getId());
                if (WebServiceControlUtil.isToOtherSys()) {
                    MCInvoke.getInstance().wsImplRead(MCInvoke.intoMessage(mInfo, ctx), ctx);
                }
                if (WebServiceControlUtil.isLetOtherSysGet()) {
                    MsgUnreadCountFactory.getLocalInstance(ctx).unReadCount(mInfo.getReceiver(), mInfo.getReceiveTime());
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        AttachmentServerManager attmanager = AttachmentManagerFactory.getServerManager((Context)ctx);
        while (ids.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.create((BOSObjectType)mInfo.getBOSType()));
            mInfo.setReceiver((String)ids.next());
            try {
                this.addnew(ctx, (IObjectPK)pk, mInfo);
                attmanager.copyBizRelation(id, pk.toString());
                if (WebServiceControlUtil.isToOtherSys()) {
                    MCInvoke.getInstance().wsImplRead(MCInvoke.intoMessage(mInfo, ctx), ctx);
                }
                if (!WebServiceControlUtil.isLetOtherSysGet()) continue;
                MsgUnreadCountFactory.getLocalInstance(ctx).unReadCount(mInfo.getReceiver(), mInfo.getReceiveTime());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        try {
            attmanager.copyBizRelation(id, recordPk.toString());
            MsgSendRecordFactory.getLocalInstance(ctx).addnew((IObjectPK)recordPk, msrInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_addHandMsg Exception failed!", (Throwable)e);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BMCMessageInfo info = this.getBMCMessageInfo(ctx, "select type where id='" + pk.toString() + "'");
        if (info != null && info.getType().getValue() == 40) {
            AttachmentServerManager attmanager = AttachmentManagerFactory.getServerManager((Context)ctx);
            attmanager.deleteAttachemtsByBoID(pk.toString());
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _delCompleteTaskMsg(Context ctx, String id) throws BOSException {
    }

    public void updatePartial(Context ctx, CoreBaseInfo model, SelectorItemCollection selector) throws BOSException, EASBizException {
        super.updatePartial(ctx, model, selector);
        BMCMessageInfo messaegInfo = (BMCMessageInfo)model;
    }

    public void _delete(Context ctx, IObjectPK[] array) throws EASBizException, BOSException {
        if (WebServiceControlUtil.isToOtherSys()) {
            BMCMessageInfo msgInfo = null;
            IObjectPK pk = null;
            for (int i = 0; i < array.length; ++i) {
                pk = array[i];
                msgInfo = this.getBMCMessageInfo(ctx, pk);
                MCInvoke.getInstance().wsImplRemoveBMC(msgInfo, ctx);
            }
        }
        super._delete(ctx, array);
    }
}

