/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.MessageListener;
import com.kingdee.eas.base.message.IProcessMessageFacade;
import com.kingdee.eas.base.message.ProcessMessageFacadeFactory;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BMCMessageListener
implements MessageListener {
    private static Logger logger = Logger.getLogger(BMCMessageListener.class);

    public int onMessage(Message message) {
        try {
            Context ctx = BMCMessageListener.getContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
            IProcessMessageFacade iMsg = ProcessMessageFacadeFactory.getLocalInstance(ctx);
            iMsg.processMsg(message);
            logger.info((Object)"msg process success!");
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)"msg process failed!", (Throwable)e);
            return 0;
        }
    }

    private static Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }
}

