/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.ProcDefCollection;
import com.kingdee.bos.workflow.metas.ProcDefInfo;
import com.kingdee.eas.base.message.ICommonInvoker;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommonInvoker
implements ICommonInvoker {
    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this;
    }

    @Override
    public ProcDefCollection getProcDefCollectionByCommonProcess() throws BOSException {
        Context ctx = ConfigMDUtil.getContext();
        String sql = "select fprocdefid, finnerversion, fname_l2, fproccode from t_wfr_procdef where fenable=1 and fprocdefid in (select fprocdefid from  t_wfr_bizproc where fbizpackage='com.kingdee.eas.base.message' and fbizfunc='WfCommonProcessFunction') order by fprocdefid, finnerversion desc";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ProcDefCollection collection = new ProcDefCollection();
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            String lastProcDefId = null;
            while (rs.next()) {
                String fprocdefid = rs.getString("fprocdefid");
                if (fprocdefid.equals(lastProcDefId)) continue;
                String fname = rs.getString("fname_l2");
                String fproccode = rs.getString("fproccode");
                ProcDefInfo info = new ProcDefInfo();
                info.setProcCode(fproccode);
                info.setProcdefID(BOSUuid.read((String)fprocdefid));
                info.setName(fname);
                collection.add(info);
                lastProcDefId = fprocdefid;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return collection;
    }
}

