/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.bos.workflow.service.DynamicActDef;
import com.kingdee.bos.workflow.service.DynamicWfCfg;
import com.kingdee.bos.workflow.service.IDynamicWfService;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.cbos.process.vm.runtime.Execution;
import com.kingdee.cbos.process.vm.runtime.FlowContext;
import com.kingdee.eas.base.message.app.ITaskHandler;
import com.kingdee.eas.base.multiapprove.app.AppendActivityUIFacade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicAppendActHandler
implements ITaskHandler {
    protected static final Logger logger = Logger.getLogger(DynamicAppendActHandler.class);

    @Override
    public void execute(AssignmentCreationEvent ed) {
        Context ctx = this.getContext(ed.solution, ed.databaseCenter);
        if (this.isAlreadyAppend(ctx, ed.actvityInstId, ed.processInstId)) {
            return;
        }
        DynamicWfCfg dynWfCfg = new DynamicWfCfg(ctx);
        if (!dynWfCfg.lock(ed.bizObjId, ed.activityDefId, ed.actvityInstId)) {
            return;
        }
        List listActs = dynWfCfg.getDynamicCfgs(ed.bizObjId);
        if (listActs.size() == 0) {
            return;
        }
        try {
            Map<String, Object> map = this.toDynamicActivityDefs(ctx, listActs, ed);
            IDynamicWfService.DynamicActivityDef[] activities = (IDynamicWfService.DynamicActivityDef[])map.get("activities");
            if (activities.length > 0) {
                ctx.setCaller((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)map.get("creator")))));
                AssignmentInfo assign = WfEngine.getEngine((Context)ctx).getAssignment(ed.assignmentId).getAssignmentInfo();
                EnactmentServiceFactory.createEnactService((Context)ctx).appendActivity(assign, activities, ((Boolean)map.get("isPriorAppend")).booleanValue(), ((Boolean)map.get("isSequencial")).booleanValue(), false);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
        }
    }

    private Map<String, Object> toDynamicActivityDefs(Context ctx, List<DynamicActDef> listActs, AssignmentCreationEvent ed) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<IDynamicWfService.DynamicActivityDef> dynamicActivityDefList = new ArrayList<IDynamicWfService.DynamicActivityDef>();
        for (DynamicActDef def : listActs) {
            if (!def.getActDefId().equals(ed.activityDefId)) continue;
            for (String pid : def.getPerformerIds()) {
                IDynamicWfService.DynamicActivityDef dynamicActivityDef = new IDynamicWfService.DynamicActivityDef();
                dynamicActivityDef.allowJumpTo = false;
                IDynamicWfService.Performer performer = new IDynamicWfService.Performer();
                performer.personId = pid;
                performer.personName = this.getPersonName(ed.databaseCenter, pid);
                dynamicActivityDef.performers = new IDynamicWfService.Performer[]{performer};
                dynamicActivityDef.actName = this.getPositionName(ctx, pid) + "\u5ba1\u6279";
                dynamicActivityDefList.add(dynamicActivityDef);
                map.put("isPriorAppend", def.isPriorAppend());
                map.put("isSequencial", def.isSequencial());
                map.put("creator", def.getCreator());
            }
        }
        IDynamicWfService.DynamicActivityDef[] activities = dynamicActivityDefList.toArray(new IDynamicWfService.DynamicActivityDef[dynamicActivityDefList.size()]);
        map.put("activities", activities);
        return map;
    }

    private String getPersonName(String dc, String personId) {
        String sql = "select fname_l2  from t_bd_person where fid =?";
        try {
            ArrayList list = SQL.executeQuery((String)dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{personId});
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                Object obj = iterator.next();
                return (String)((Map)obj).get("fname_l2");
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    private String getPositionName(Context ctx, String personId) throws Exception {
        return new AppendActivityUIFacade(ctx).getPositionByPersonId(personId);
    }

    private boolean spin(String dc, String assignId) {
        for (int times = 5; times > 0; --times) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.checkIfAssignInDB(dc, assignId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfAssignInDB(String dc, String assignId) {
        String sql = "select 1 from t_wfr_assign where fassignid =?";
        try {
            ArrayList list = SQL.executeQuery((String)dc, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{assignId});
            return list.size() > 0;
        }
        catch (BOSException bOSException) {
            return false;
        }
    }

    private Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }

    private boolean isAlreadyAppend(Context ctx, String actInstId, String procInstId) {
        try {
            WfEngine engine = WfEngine.getEngine((Context)ctx);
            WfProcess process = engine.getProcessInst(procInstId);
            FlowContext runtime = process.getProcessContext().loadFlowContext();
            Execution e = runtime.getExecution(actInstId);
            return "true".equals(e.getProperty("$appended"));
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            return true;
        }
    }
}

