/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.message.app.AbstractMessageStatusSyncFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.sns.task.util.MessageStatusHelper;
import com.kingdee.sns.task.util.YZJFlowCenterDeal;
import com.kingdee.sns.task.util.YZJMessageDeal;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class MessageStatusSyncFacadeControllerBean
extends AbstractMessageStatusSyncFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.message.app.MessageStatusSyncFacadeControllerBean");

    @Override
    protected void _executeSync(Context ctx, int startDays) throws BOSException {
        if (startDays > 31) {
            throw new BOSException("\u540c\u6b65\u7684\u5929\u6570\u8fc7\u957f\uff0c\u9650\u5236\u5929\u6570\u4e0d\u5927\u4e8e31\u5929");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(5, -startDays);
        Date beginTime = calendar.getTime();
        String begin = dateFormat.format(beginTime);
        String qry = "SELECT w.FASSIGNID,a.MSGID FROM t_wfr_assigndetail w INNER JOIN  t_assign_xtmsg a ON w.FASSIGNID = a.FASSIGNID WHERE w.FENDTIME > {TS '" + begin + "'} AND a.FSTATE is null";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)qry);
            while (result.next()) {
                String assignId = result.getString("FASSIGNID");
                try {
                    if (MessageStatusHelper.checkAssignSentFlowCenter(ctx, assignId)) {
                        String change2Done = YZJFlowCenterDeal.change2Done(ctx, assignId);
                        logger.error((Object)("MessageStatusSyncFacade YZJFlowCenter change2Done:" + change2Done));
                        continue;
                    }
                    String response = YZJMessageDeal.Deal(assignId, ctx);
                    JSONObject map = JSON.parseObject((String)response);
                    if (!"true".equals(map.get("success"))) continue;
                    String msgId = result.getString("MSGID");
                    String insertXtmsgbackstage = " insert into t_assign_xtmsgbackstage(msgid,fassignid,fuserid,ftype,fyzjresult,fsendtime) values('" + msgId + "','" + assignId + "','','\u5f85\u529e\u8f6c\u5df2\u529e','" + response + "',GETDATE())";
                    DbUtil.execute((Context)ctx, (String)insertXtmsgbackstage);
                }
                catch (Exception e) {
                    logger.error((Object)("insert t_assign_xtmsgbackstage error" + e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"changgebyassign fail", (Throwable)e);
        }
        this.executeBackup(ctx, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBackup(Context ctx, int batchCount) {
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            String msgids = this.qryMsgidsFromXtmsg(con, batchCount);
            while (!StringUtils.isEmpty((String)msgids)) {
                this.transferData(con, msgids);
                msgids = this.qryMsgidsFromXtmsg(con, batchCount);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"executeBackup fail", (Throwable)e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    System.out.println("connection close failed");
                    logger.error((Object)"close connection fail", (Throwable)e);
                }
                con = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String qryMsgidsFromXtmsg(Connection con, int batchCount) throws SQLException {
        String msgids = "";
        StringBuffer msgidBuffer = new StringBuffer();
        String fromXtmsg = "SELECT TOP " + batchCount + " MSGID FROM t_assign_xtmsg  WHERE FSTATE ='1'";
        PreparedStatement statement = null;
        ResultSet queryResult = null;
        try {
            statement = con.prepareStatement(fromXtmsg);
            queryResult = statement.executeQuery();
            while (queryResult.next()) {
                String msgid = queryResult.getString("MSGID");
                if (msgid == null || "".equals(msgid)) continue;
                msgidBuffer.append("'" + msgid + "',");
            }
        }
        finally {
            queryResult.close();
            statement.close();
        }
        if (msgidBuffer.length() > 0) {
            msgidBuffer.deleteCharAt(msgidBuffer.length() - 1);
            msgids = "(" + msgidBuffer.toString() + ")";
        }
        return msgids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferData(Connection con, String msgids) throws SQLException {
        if (StringUtils.isEmpty((String)msgids)) {
            return;
        }
        try (Statement ps = null;){
            String backupSql = "INSERT INTO t_assign_xtmsghst(MSGID,FASSIGNID,FUSERID,PROCINSTID,FSTATE,INFO,FBACKUPTIME)SELECT MSGID,FASSIGNID,FUSERID,PROCINSTID,FSTATE,INFO,GETDATE() FROM t_assign_xtmsg  WHERE (MSGID IN " + msgids + ")";
            ps = con.prepareStatement(backupSql);
            ps.execute();
            String clearSql = "DELETE FROM t_assign_xtmsg WHERE (MSGID IN " + msgids + ")";
            ps = con.prepareStatement(clearSql);
            ps.execute();
        }
    }
}

