/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.jms.TextMessage;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.eas.base.message.app.CheckerForAssignRead;
import com.kingdee.eas.base.message.app.ITaskHandler;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.mobile.msg.IMobileAppMsgFacade;
import com.kingdee.eas.mobile.msg.MobileAppMsgFacadeFactory;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class MobileMessageHandler
implements ITaskHandler {
    private static final Logger logger = Logger.getLogger(MobileMessageHandler.class);
    private static final String TYPE = "type";
    private static final String SOLUTION = "solution";
    private static final String DATABASECENTER = "databaseCenter";
    private static IObjectPK loginUserPk = MobileMessageHandler.getLoginUserID();
    private static boolean isAllowMobile = false;
    private static boolean isAllowEmail = false;

    public static void sendMessage(AssignmentCreationEvent ed) {
        if (isAllowMobile || isAllowEmail) {
            logger.info((Object)"\u79fb\u52a8\u5e73\u53f0\u5f00\u59cb\u5904\u7406\u4efb\u52a1\u6d88\u606f");
            try {
                Message message = MobileMessageHandler.getInitialMessage(ed);
                Context ctx = MobileMessageHandler.getContextForMobiel(ed.solution, ed.databaseCenter);
                String mobileMsgOrgId = MobileMessageHandler.getCUIDByBizObjectId(ctx, ed.bizObjId);
                if (!StringUtils.isEmpty((String)mobileMsgOrgId)) {
                    message.setStringHeader("orgId", mobileMsgOrgId);
                }
                logger.info((Object)"\u8fdb\u5165\u79fb\u52a8\u4e1a\u52a1\u5904\u7406mobileAppListener");
                IMobileAppMsgFacade iMsg = MobileAppMsgFacadeFactory.getLocalInstance((Context)ctx);
                iMsg.mobileAppListener(message);
                logger.info((Object)"\u9000\u51fa\u79fb\u52a8\u4e1a\u52a1\u5904\u7406mobileAppListener");
            }
            catch (Exception e) {
                logger.error((Object)"\u79fb\u52a8\u5e73\u53f0\u5904\u7406\u4efb\u52a1\u6d88\u606f\u5931\u8d25:", (Throwable)e);
            }
            logger.info((Object)"\u79fb\u52a8\u5e73\u53f0\u5904\u7406\u4efb\u52a1\u6d88\u606f\u6210\u529f");
        }
    }

    private static final IObjectPK getLoginUserID() {
        String RSC_PATH = "com.kingdee.eas.mobile.msg.LoginConstant";
        String USERID_KEY = "loginUserId";
        String DEFAULT_USER_PK = "00000000-0000-0000-0000-00000000000013B7DE7F";
        logger.debug((Object)"\u53d6\u5f97\u7528\u6237ID");
        String id = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("com.kingdee.eas.mobile.msg.LoginConstant", new Locale("l1"));
            id = bundle.getString("loginUserId");
        }
        catch (Exception e) {
            logger.error((Object)"getLoginUserID failed !", (Throwable)e);
        }
        if (id == null) {
            logger.warn((Object)"Config File not set,a Login by default userid 00000000-0000-0000-0000-00000000000013B7DE7F");
            return new ObjectStringPK("00000000-0000-0000-0000-00000000000013B7DE7F");
        }
        return new ObjectStringPK(id);
    }

    private static Message getInitialMessage(AssignmentCreationEvent ed) {
        TextMessage message = new TextMessage();
        message.setStringHeader(DATABASECENTER, ed.databaseCenter);
        message.setStringHeader(SOLUTION, ed.solution);
        message.setStringHeader("ProcessInstId", ed.processInstId);
        message.setStringHeader("activityInstId", ed.actvityInstId);
        message.setStringHeader("processDefHashValue", ed.processDefHashValue);
        message.setStringHeader("operation", ed.operationName);
        message.setStringHeader("function", ed.functionName);
        message.setStringHeader("bizPackage", ed.bizPackage);
        message.setStringHeader("processDefHashValue", ed.processDefHashValue);
        message.setIntHeader(TYPE, 10);
        message.setIntHeader("priority", 10);
        message.setStringHeader("receiver", ed.receiver);
        message.setStringHeader("sourceID", ed.assignmentId);
        message.setStringHeader("isSendEmail", Boolean.toString(ed.isSendEmail));
        message.setStringHeader("isSendMobile", Boolean.toString(ed.isSendMobile));
        for (int i = 1; i < 4; ++i) {
            String localString = "L" + i;
            Locale locale = new Locale(localString);
            message.setLocaleStringHeader("title", (String)ed.titles.get(locale), locale);
            message.setLocaleStringHeader("body", (String)ed.bodies.get(locale), locale);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCUIDByBizObjectId(Context ctx, String bizObjId) {
        String mobileMsgOrgId = null;
        BOSObjectType objectType = new ObjectUuidPK(bizObjId).getObjectType();
        IObjectValue objectValue = null;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("CU.id"));
            Connection connection = null;
            try {
                connection = EJBFactory.getConnection((Context)ctx);
                ORMappingDAO mappingDAO = new ORMappingDAO(objectType, ctx, connection);
                objectValue = mappingDAO.getValue((IObjectPK)new ObjectUuidPK(bizObjId), sic, true);
            }
            catch (SQLException e1) {
                logger.error((Object)"transformMessage's error:", (Throwable)e1);
            }
            finally {
                if (connection != null) {
                    SQLUtils.cleanup((Connection)connection);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"get objectValue error:", (Throwable)e);
        }
        if (objectValue != null && objectValue instanceof ObjectBaseInfo) {
            try {
                mobileMsgOrgId = ((ObjectBaseInfo)objectValue).getCU().getId().toString();
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u5f97\u77ed\u4fe1\u9700\u8981\u7684CU\u51fa\u9519", (Throwable)e);
            }
        }
        return mobileMsgOrgId;
    }

    private static Context getContextForMobiel(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context(loginUserPk, currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }

    @Override
    public void execute(AssignmentCreationEvent ed) {
        MobileMessageHandler.sendMessage(ed);
    }

    static {
        try {
            Configuration bosConfig = Configuration.getInstance();
            ConfigurationItem sln = bosConfig.getConfigItem("PortalInfo");
            if (sln != null) {
                isAllowMobile = CheckerForAssignRead.checkIfMobile(sln);
                isAllowEmail = CheckerForAssignRead.checkIfEmail(sln);
            }
        }
        catch (Exception e) {
            logger.error((Object)"MobileMessageHandler init failed !", (Throwable)e);
            isAllowMobile = false;
            isAllowEmail = false;
        }
    }
}

