/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.MsgUnreadCountFactory;
import com.kingdee.eas.base.message.app.AbstractProcessMessageFacadeControllerBean;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatCacheManager;
import com.kingdee.eas.base.message.webservice.MCInvoke;
import com.kingdee.eas.base.message.webservice.MessageToOtherSys;
import com.kingdee.eas.base.message.webservice.WebServiceControlUtil;
import com.kingdee.eas.base.message.webservice.WfMsgThreadPool;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.mc.IJobDelegate;
import com.kingdee.eas.cp.eip.mc.JobDelegateFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ProcessMessageFacadeControllerBean
extends AbstractProcessMessageFacadeControllerBean {
    private static final long serialVersionUID = 5636462885030849733L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.message.app.ProcessMessageFacadeControllerBean");
    private static final String SEPATATOR = ";";
    private static final Locale[] locales = new Locale[]{new Locale("L1"), new Locale("L2"), new Locale("L3")};

    @Override
    protected void _processMsg(Context ctx, Message message) throws BOSException {
        logger.debug((Object)("isSendCommon                       " + message.getBooleanheader("isSendCommon")));
        logger.debug((Object)("isSendEmail                   " + message.getBooleanheader("isSendEmail")));
        logger.debug((Object)("isSendMobile     " + message.getBooleanheader("isSendMobile")));
        boolean isSendCommon = message.getBooleanheader("isSendCommon");
        if (!isSendCommon && (message.getBooleanheader("isSendEmail") || message.getBooleanheader("isSendMobile"))) {
            return;
        }
        long start1 = System.currentTimeMillis();
        logger.info((Object)"--------------------------------------message listener --------------------------------------");
        if (message.getStringHeader("databaseCenter") != null && !message.getStringHeader("databaseCenter").trim().equals("") && message.getStringHeader("solution") != null && !message.getStringHeader("solution").trim().equals("")) {
            String currentSolutionName = message.getStringHeader("solution");
            String currentDatabaseCenter = message.getStringHeader("databaseCenter");
            int type = message.getIntHeader("type");
            logger.debug((Object)("message type                       " + type));
            logger.debug((Object)("message solution                   " + currentSolutionName));
            logger.debug((Object)("message databaseCenter     " + currentDatabaseCenter));
            logger.debug((Object)("message sourceID                   " + message.getStringHeader("sourceID")));
            logger.debug((Object)("message receiver                   " + message.getStringHeader("receiver")));
            logger.debug((Object)("message bizPackage                 " + message.getStringHeader("bizPackage")));
            logger.debug((Object)("message category                 " + message.getStringHeader("category")));
            logger.debug((Object)("message extendParam                 " + message.getStringHeader("extendParam")));
            logger.debug((Object)"--------------------------------------------------------------------------------------------------------");
            long start = System.currentTimeMillis();
            message = this.processTilte(currentSolutionName, currentDatabaseCenter, message);
            long end = System.currentTimeMillis();
            logger.debug((Object)("----processTilte---cost:" + (end - start)));
            start = end;
            ArrayList messages = this.parseMessage(message);
            end = System.currentTimeMillis();
            logger.debug((Object)("----processTilte---cost:" + (end - start)));
            start = end;
            if (messages == null) {
                return;
            }
            ClassificationStatCacheManager manager = ClassificationStatCacheManager.get(ctx);
            int size = messages.size();
            for (int i = 0; i < size; ++i) {
                Message msg = (Message)messages.get(i);
                if (type != 0) continue;
                start = System.currentTimeMillis();
                BMCMessageInfo messageInfo = this.transformMessage(msg, false, currentSolutionName, currentDatabaseCenter);
                manager.expire(messageInfo.getReceiver());
                end = System.currentTimeMillis();
                logger.debug((Object)("--NOTICE_VALUE--transformMessage---cost:" + (end - start)));
                start = end;
                this.addMessage(currentSolutionName, currentDatabaseCenter, messageInfo);
                if (WebServiceControlUtil.isToOtherSys()) {
                    WfMsgThreadPool.execute(new MessageToOtherSys(ctx, MCInvoke.intoMessage(messageInfo, ctx), "addMessage"));
                }
                if (WebServiceControlUtil.isLetOtherSysGet()) {
                    MsgUnreadCountFactory.getLocalInstance(ctx).unReadCount(messageInfo.getReceiver(), messageInfo.getReceiveTime());
                }
                end = System.currentTimeMillis();
                logger.debug((Object)("--NOTICE_VALUE--addMessage---cost:" + (end - start)));
                start = end;
                String delegateUserID = this.getDelegateUser(currentSolutionName, currentDatabaseCenter, msg.getStringHeader("receiver"), message.getStringHeader("grandProcessDefId"), message.getStringHeader("initiatorId"));
                end = System.currentTimeMillis();
                logger.debug((Object)("--NOTIC_VALUE--getDelegateUser---cost:" + (end - start)));
                if (delegateUserID == null || delegateUserID.trim().equalsIgnoreCase("")) continue;
                try {
                    this.disposeDelegate(currentSolutionName, currentDatabaseCenter, delegateUserID, msg.getStringHeader("sourceID"));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"\u6d88\u606f\u8f6c\u4ea4\u5931\u8d25 ", (Throwable)e);
                }
            }
        }
        logger.debug((Object)("----onMessage---cost:" + (System.currentTimeMillis() - start1)));
    }

    private String getDelegateUser(String currentSolutionName, String currentDatabaseCenter, String userID, String processDefId, String initiatorId) {
        logger.info((Object)("\u59d4\u6258\u4ebaID\uff1d" + userID + ",\u6d41\u7a0b\u53d1\u8d77\u4ebaID\uff1d" + initiatorId + ",\u6d41\u7a0bID\uff1d" + processDefId));
        if (processDefId == null || processDefId.trim().length() <= 0 || userID == null || userID.trim().length() <= 0 || initiatorId == null || initiatorId.trim().length() <= 0) {
            return null;
        }
        String delegateUserID = null;
        try {
            delegateUserID = this.getMyJobDelegate(currentSolutionName, currentDatabaseCenter).getConsignorId(processDefId, userID, initiatorId);
            logger.info((Object)("\u88ab\u59d4\u6258\u4ebaID\uff1d" + delegateUserID));
        }
        catch (Exception e) {
            logger.error((Object)e.getCause());
        }
        return delegateUserID;
    }

    private void disposeDelegate(String currentSolutionName, String currentDatabaseCenter, String delegateUserID, String assignmentId) throws BOSException {
        try {
            IEnactmentService service = this.getEnactmentService(currentSolutionName, currentDatabaseCenter);
            WfAssignmentState state = service.getAssignmentById(assignmentId).getState();
            if (state.equals((Object)WfAssignmentState.ASSIGNED) || state.equals((Object)WfAssignmentState.ACCEPTED)) {
                service.devolve(assignmentId, delegateUserID);
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1.getCause());
            throw new BOSException((Throwable)e1);
        }
    }

    private IEnactmentService getEnactmentService(String currentSolutionName, String currentDatabaseCenter) throws Exception {
        String userName = "administrator";
        Context context = ProcessMessageFacadeControllerBean.getContext(currentSolutionName, currentDatabaseCenter);
        context.setUserName(userName);
        IEnactmentService service = (IEnactmentService)BOSObjectFactory.createBOSObject((Context)context, (String)EnactmentServiceProxy.class.getName());
        return service;
    }

    private static Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }

    private static IBMCMessage getBMCMessage(String currentSolutionName, String currentDatabaseCenter) {
        IBMCMessage message = null;
        try {
            message = BMCMessageFactory.getLocalInstance(ProcessMessageFacadeControllerBean.getContext(currentSolutionName, currentDatabaseCenter));
        }
        catch (BOSException e) {
            logger.error((Object)e.getCause());
        }
        return message;
    }

    private IJobDelegate getMyJobDelegate(String currentSolutionName, String currentDatabaseCenter) {
        IJobDelegate iJobDelegate = null;
        try {
            iJobDelegate = JobDelegateFactory.getLocalInstance((Context)ProcessMessageFacadeControllerBean.getContext(currentSolutionName, currentDatabaseCenter));
        }
        catch (BOSException e) {
            logger.error((Object)e.getCause());
        }
        return iJobDelegate;
    }

    private BMCMessageInfo transformMessage(Message message, boolean isUpdate, String currentSolutionName, String currentDataBaseName) {
        String forewarnDynVarsId;
        if (!isUpdate) {
            String[] bizObjectIDs;
            String forewarnDynVarsId2;
            BMCMessageInfo messageInfo = new BMCMessageInfo();
            messageInfo.setType(MsgType.getEnum(message.getIntHeader("type")));
            messageInfo.setBizType(MsgBizType.getEnum(message.getIntHeader("bizType")));
            if (messageInfo.getBizType() == MsgBizType.WORKFLOW && message.getStringHeader("category") == null) {
                messageInfo.setCategory(MsgBizType.WORKFLOW.getName().toLowerCase());
            } else {
                messageInfo.setCategory(message.getStringHeader("category"));
            }
            messageInfo.setExtendParam(message.getStringHeader("extendParam"));
            String url = message.getStringHeader("url");
            if (!StringUtils.isEmpty((String)url)) {
                messageInfo.setUrl(url);
            }
            if (!StringUtils.isEmpty((String)(forewarnDynVarsId2 = message.getStringHeader("forewarnDynVarsId")))) {
                messageInfo.setBizCustomizedFlag(forewarnDynVarsId2);
            }
            Context ctx = ProcessMessageFacadeControllerBean.getContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
            messageInfo.setDefaultLocale(ctx.getLocale());
            int priority = message.getIntHeader("priority");
            if (priority != 0 && priority != 10 && priority != 20) {
                priority = 10;
            }
            messageInfo.setPriority(MsgPriority.getEnum(priority));
            messageInfo.setSourceStatus(MsgSourceStatus.getEnum(message.getIntHeader("sourceStatus")));
            messageInfo.setSendTime(new Timestamp(message.getTimestamp()));
            messageInfo.setStatus(MsgStatus.UNREADED);
            for (int i = 0; i < locales.length; ++i) {
                Locale locale = locales[i];
                messageInfo.setSender(message.getLocaleStringHeader("initiatorName", locale), locale);
                int type = message.getIntHeader("type");
                if (type == 0 && !"WfAdmin".equals(message.getStringHeader("sender"))) {
                    messageInfo.setSender(message.getLocaleStringHeader("sender", locale), locale);
                }
                messageInfo.setTitle(message.getLocaleStringHeader("title", locale), locale);
                if (message.getLocaleStringHeader("body", locale) == null) continue;
                messageInfo.setBody(message.getLocaleStringHeader("body", locale), locale);
            }
            messageInfo.setReceiver(message.getStringHeader("receiver"));
            if (message.getStringHeader("senderId") != null) {
                messageInfo.setSenderId(message.getStringHeader("senderId"));
            } else if (message.getStringHeader("initiatorId") != null) {
                messageInfo.setSenderId(message.getStringHeader("initiatorId"));
            }
            if (message.getStringHeader("bizCustomizedFlag") != null) {
                messageInfo.setBizCustomizedFlag(message.getStringHeader("bizCustomizedFlag"));
            }
            messageInfo.setSourceID(message.getStringHeader("sourceID"));
            messageInfo.setBizPackage(message.getStringHeader("realBizPackage"));
            messageInfo.setSourceIDs(message.getStringHeader("sourceIDs"));
            messageInfo.setSourceID(message.getStringHeader("sourceID"));
            String bizObjectID = message.getStringHeader("bizObjectId");
            long start = System.currentTimeMillis();
            long end = 0L;
            OrgType orgType = OrgType.NONE;
            String orgID = "11111111-1111-1111-1111-111111111111CCE7AED4";
            if (!StringUtils.isEmpty((String)bizObjectID) && (bizObjectIDs = StringUtils.split((String)bizObjectID, (String)",")).length > 0 && !StringUtils.isEmpty((String)bizObjectIDs[0])) {
                bizObjectID = bizObjectIDs[0];
                Context currentCtx = ProcessMessageFacadeControllerBean.getContext(currentSolutionName, currentDataBaseName);
                BOSObjectType objectType = new ObjectUuidPK(bizObjectID).getObjectType();
                end = System.currentTimeMillis();
                EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)currentCtx).getEntity(objectType);
                end = System.currentTimeMillis();
                logger.debug((Object)("---get EntityObjectInfo cost:" + (end - start)));
                start = System.currentTimeMillis();
                OrgType bizOrgType = this.getBizOrgType(entityObjectInfo);
                end = System.currentTimeMillis();
                logger.debug((Object)("---get bizOrgType cost:" + (end - start)));
                if (!StringUtils.isEmpty((String)message.getStringHeader("orgid"))) {
                    orgID = message.getStringHeader("orgid");
                    orgType = bizOrgType;
                }
            }
            logger.info((Object)("orgType=" + orgType + ",orgID=" + orgID));
            messageInfo.setOrgType(orgType);
            messageInfo.setOrgID(orgID);
            return messageInfo;
        }
        BMCMessageInfo messageInfo = new BMCMessageInfo();
        messageInfo.setSourceID(message.getStringHeader("sourceID"));
        messageInfo.setSourceStatus(MsgSourceStatus.getEnum(message.getIntHeader("sourceStatus")));
        messageInfo.setType(MsgType.getEnum(message.getIntHeader("type")));
        String url = message.getStringHeader("url");
        if (!StringUtils.isEmpty((String)url)) {
            messageInfo.setUrl(url);
        }
        if (!StringUtils.isEmpty((String)(forewarnDynVarsId = message.getStringHeader("forewarnDynVarsId")))) {
            messageInfo.setBizCustomizedFlag(forewarnDynVarsId);
        }
        return messageInfo;
    }

    private boolean isInheritFromBillBase(EntityObjectInfo entityObjectInfo) {
        if (entityObjectInfo != null) {
            for (EntityObjectInfo entity = entityObjectInfo; entity != null; entity = entity.getBaseEntity()) {
                if (!"com.kingdee.eas.framework.app.BillBase".equals(entity.getFullName())) continue;
                return true;
            }
        }
        return false;
    }

    private OrgType getBizOrgType(EntityObjectInfo entityObjectInfo) {
        String strOrgType;
        if (entityObjectInfo != null && !StringUtils.isEmpty((String)(strOrgType = entityObjectInfo.getExtendedProperty("OrgType")))) {
            Iterator iterator = OrgType.iterator();
            while (iterator.hasNext()) {
                OrgType orgType = (OrgType)iterator.next();
                if (!orgType.getName().equalsIgnoreCase(strOrgType)) continue;
                return orgType;
            }
        }
        return OrgType.NONE;
    }

    private ArrayList parseMessage(Message message) {
        Context ctx = ProcessMessageFacadeControllerBean.getContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        ArrayList<Message> messages = new ArrayList<Message>();
        String receivers = message.getStringHeader("receiver");
        String sources = message.getStringHeader("sourceID");
        MsgType type = MsgType.getEnum(message.getIntHeader("type"));
        ArrayList receiverIDs = this.parseReceivers(receivers);
        ArrayList sourceIDs = this.parseSourceIDs(sources);
        int receiverSize = receiverIDs.size();
        int sourceSize = sourceIDs.size();
        if (receiverSize == 0) {
            return null;
        }
        if (receiverSize == 1) {
            message.setStringHeader("receiver", String.valueOf(receiverIDs.get(0)));
            if (type.equals((Object)MsgType.TASK)) {
                if (sourceSize == 1) {
                    message.setStringHeader("sourceID", String.valueOf(sourceIDs.get(0)));
                } else {
                    logger.error((Object)("error workflow message:receiver=" + receivers + ",sourcesID=" + sources));
                    return null;
                }
            }
            messages.add(message);
            return messages;
        }
        if (type.equals((Object)MsgType.NOTICE)) {
            for (int i = 0; i < receiverSize; ++i) {
                Message newMessage = this.copyMessage(message);
                newMessage.setStringHeader("receiver", receiverIDs.get(i).toString());
                messages.add(newMessage);
            }
            return messages;
        }
        if (receiverSize == sourceSize) {
            for (int i = 0; i < receiverSize; ++i) {
                Message newMessage = this.copyMessage(message);
                newMessage.setStringHeader("receiver", receiverIDs.get(i).toString());
                newMessage.setStringHeader("sourceID", sourceIDs.get(i).toString());
                messages.add(newMessage);
            }
            return messages;
        }
        logger.error((Object)("error workflow message:receiver=" + receivers + ",sourcesID=" + sources));
        return null;
    }

    private Message copyMessage(Message message) {
        Message newMessage = MessageFactory.newMessage();
        newMessage.setStringHeader("databaseCenter", message.getStringHeader("databaseCenter"));
        newMessage.setStringHeader("solution", message.getStringHeader("solution"));
        newMessage.setStringHeader("sourceID", message.getStringHeader("sourceID"));
        newMessage.setStringHeader("sourceIDs", message.getStringHeader("sourceIDs"));
        newMessage.setStringHeader("receiver", message.getStringHeader("receiver"));
        newMessage.setIntHeader("type", message.getIntHeader("type"));
        newMessage.setIntHeader("bizType", message.getIntHeader("bizType"));
        newMessage.setIntHeader("sourceStatus", message.getIntHeader("sourceStatus"));
        newMessage.setIntHeader("priority", message.getIntHeader("priority"));
        newMessage.setStringHeader("bizObjectId", message.getStringHeader("bizObjectId"));
        newMessage.setStringHeader("realBizPackage", message.getStringHeader("realBizPackage"));
        newMessage.setStringHeader("sender", message.getStringHeader("sender"));
        newMessage.setStringHeader("category", message.getStringHeader("category"));
        newMessage.setStringHeader("extendParam", message.getStringHeader("extendParam"));
        newMessage.setStringHeader("initiatorId", message.getStringHeader("initiatorId"));
        newMessage.setStringHeader("url", message.getStringHeader("url"));
        newMessage.setStringHeader("forewarnDynVarsId", message.getStringHeader("forewarnDynVarsId"));
        for (int j = 0; j < locales.length; ++j) {
            Locale locale = locales[j];
            newMessage.setLocaleStringHeader("title", message.getLocaleStringHeader("title", locale), locale);
            newMessage.setLocaleStringHeader("body", message.getLocaleStringHeader("body", locale), locale);
            newMessage.setLocaleStringHeader("sender", message.getLocaleStringHeader("sender", locale), locale);
            newMessage.setLocaleStringHeader("initiatorName", message.getLocaleStringHeader("initiatorName", locale), locale);
        }
        return newMessage;
    }

    private ArrayList parseReceivers(String str) {
        ArrayList<String> receiverIDs = new ArrayList<String>();
        if (str != null && !str.trim().equalsIgnoreCase("")) {
            if (str.indexOf(SEPATATOR) != -1) {
                StringTokenizer stReveivers = null;
                stReveivers = new StringTokenizer(str, SEPATATOR);
                while (stReveivers.hasMoreTokens()) {
                    receiverIDs.add(stReveivers.nextToken());
                }
            } else {
                receiverIDs.add(str);
            }
        }
        return receiverIDs;
    }

    private ArrayList parseSourceIDs(String str) {
        ArrayList<String> sourceIDs = new ArrayList<String>();
        if (str != null && !str.trim().equalsIgnoreCase("")) {
            if (str.indexOf(SEPATATOR) != -1) {
                StringTokenizer stSourceIDs = null;
                stSourceIDs = new StringTokenizer(str, SEPATATOR);
                while (stSourceIDs.hasMoreTokens()) {
                    sourceIDs.add(stSourceIDs.nextToken());
                }
            } else {
                sourceIDs.add(str);
            }
        }
        return sourceIDs;
    }

    private void addMessage(String currentSolutionName, String currentDatabaseCenter, BMCMessageInfo messageInfo) throws BOSException {
        try {
            long start = System.currentTimeMillis();
            IBMCMessage iMessage = ProcessMessageFacadeControllerBean.getBMCMessage(currentSolutionName, currentDatabaseCenter);
            logger.debug((Object)("---getBMCMessage---" + (System.currentTimeMillis() - start)));
            iMessage.addnew(messageInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getCause());
            throw new BOSException((Throwable)e);
        }
    }

    private void processUpdatedMsg(String currentSolutionName, String currentDatabaseCenter, String soruceID, int soruceStatus, int msgType) throws BOSException {
        try {
            IBMCMessage message = ProcessMessageFacadeControllerBean.getBMCMessage(currentSolutionName, currentDatabaseCenter);
            message.processUpdatedMsg(soruceID, soruceStatus, msgType);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Message processTilte(String currentSolutionName, String currentDatabaseCenter, Message message) {
        for (int j = 0; j < locales.length; ++j) {
            Locale locale = locales[j];
            String title = message.getLocaleStringHeader("title", locale);
            if (title == null || title.length() <= 200) continue;
            title = title.substring(0, 200);
            message.setLocaleStringHeader("title", title, locale);
        }
        return message;
    }

    private String getReallyBizPackage(String msgPackage, String operation, String boid, Context context) {
        String packageName = null;
        String package1 = "com.kingdee.eas.base.multiapprove.client";
        if (boid == null || boid.equals("")) {
            return null;
        }
        if (package1.equals(msgPackage) && ("MultiApproveUIFunction.ActionSubmit".equals(operation) || "ManualDecisionUIFunction.ConfirmAction".equals(operation))) {
            ObjectUuidPK pk = new ObjectUuidPK(boid);
            BOSObjectType bosType = pk.getObjectType();
            BusinessObjectInfo boInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)context).getBusinessObject(bosType);
            packageName = boInfo.getBusinessImplName();
            logger.debug((Object)("reallyBizPackage name is:" + packageName));
        } else {
            packageName = msgPackage;
        }
        return packageName;
    }

    @Override
    protected int _getBMCMessageCount(Context ctx, String userId, String type, String bizType, String state) throws BOSException {
        int count = 0;
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("SELECT COUNT(*) FROM T_BAS_Message where FReceiver = '").append(userId).append("' ");
        if (!StringUtils.isEmpty((String)type)) {
            sqlStr.append(" AND FType = ").append(type);
        }
        if (!StringUtils.isEmpty((String)bizType)) {
            if (bizType.equalsIgnoreCase("others")) {
                sqlStr.append(" AND FBizType NOT IN(0,10,40) ");
            } else {
                sqlStr.append(" AND FBizType = ").append(bizType);
            }
        }
        if (state.equals("0")) {
            sqlStr.append(" AND FStatus = 0 ");
        } else if (state.equals("1")) {
            sqlStr.append(" AND FStatus = 10 ");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        }
        catch (BOSException e) {
            logger.error((Object)("DbUtil.executeQuery exception:" + e.getMessage()), (Throwable)e);
        }
        try {
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("SQLException:" + e.getMessage()), (Throwable)e);
        }
        return count;
    }

    @Override
    protected int _getDisposeAssignCount(Context ctx, String userId) throws BOSException {
        int count = 0;
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("SELECT COUNT(*) FROM T_WFR_AssignDetail where FIsSendMsg=1 and FSTATE in(4,8,16) ");
        if (!StringUtils.isEmpty((String)userId)) {
            sqlStr.append(" AND FPERSONUSERID = '").append(userId).append("' ");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        }
        catch (BOSException e) {
            logger.error((Object)("DbUtil.executeQuery exception:" + e.getMessage()), (Throwable)e);
        }
        try {
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("SQLException:" + e.getMessage()), (Throwable)e);
        }
        return count;
    }

    @Override
    protected int _getUndiposeAssignCount(Context ctx, String status, String userId) throws BOSException {
        int count = 0;
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append("SELECT COUNT(*) FROM T_WFR_Assign A WHERE A.FSTATE in(1,2) AND A.FIsSendMsg=1 ");
        if (!StringUtils.isEmpty((String)userId)) {
            sqlStr.append(" AND A.FPERSONUSERID = '").append(userId).append("' ");
        }
        sqlStr.append(" AND A.FASSIGNID IN(SELECT B.FASSIGNID FROM T_BAS_AssignRead B WHERE A.FASSIGNID = B.FASSIGNID ");
        if (status.equals("0")) {
            sqlStr.append(" AND B.FStatus = 0");
        } else if (status.equals("1")) {
            sqlStr.append(" AND B.FStatus = 10");
        }
        sqlStr.append(")");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        }
        catch (BOSException e) {
            logger.error((Object)("DbUtil.executeQuery exception:" + e.getMessage()), (Throwable)e);
        }
        try {
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("SQLException:" + e.getMessage()), (Throwable)e);
        }
        return count;
    }

    @Override
    protected int _getOAMsgCount(Context ctx, String userId, String state) throws BOSException {
        int count = 0;
        String haseOA = "false";
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            haseOA = iParam.getParamValue(null, "OFFICE001");
        }
        catch (EASBizException e) {
            logger.error((Object)("IParamControl.getParamValue:OFFICE001 error:" + e.getMessage()), (Throwable)e);
        }
        if ("true".equalsIgnoreCase(haseOA)) {
            StringBuffer sqlOABf = new StringBuffer();
            sqlOABf.append(" select count(FID) from T_BAS_Messageyr where FType=50 ");
            if (state.equals("0")) {
                sqlOABf.append(" and FStatus=0 ");
            } else if (state.equals("1")) {
                sqlOABf.append(" and FStatus=10 ");
            }
            if (!StringUtils.isEmpty((String)userId)) {
                sqlOABf.append(" AND FReceiver = '").append(userId).append("' ");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlOABf.toString());
            try {
                while (rs.next()) {
                    count = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return count;
    }
}

