/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.app.AbstractWFSsclogDumpFacadeControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class WFSsclogDumpFacadeControllerBean
extends AbstractWFSsclogDumpFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.message.app.WFSsclogDumpFacadeControllerBean");
    private int days = 15;

    @Override
    protected void _dumpData(Context ctx) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            this.clearDirtyLogDataBatch(cn);
            String dumpLogIDs = this.getWFSsclogIDs(cn);
            if (StringUtils.isEmpty((String)dumpLogIDs)) {
                logger.info((Object)"Finish dump WFSsclog, total 0 records.");
                return;
            }
            String tmpIDs = dumpLogIDs.substring(1, dumpLogIDs.length() - 1);
            String[] tmpIDsArr = tmpIDs.split(",");
            if (tmpIDsArr.length > 500) {
                int i = 0;
                while (i * 500 < tmpIDsArr.length) {
                    StringBuffer tmpDumpIDs = new StringBuffer("(");
                    for (int j = 0; j < 500 && i * 500 + j < tmpIDsArr.length; ++j) {
                        tmpDumpIDs.append(tmpIDsArr[i * 500 + j]).append(",");
                    }
                    this.transferWfLogDataBatch(cn, tmpDumpIDs.substring(0, tmpDumpIDs.length() - 1) + ")");
                    ++i;
                }
            } else {
                this.transferWfLogDataBatch(cn, dumpLogIDs);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWFSsclogIDs(Connection cn) throws SQLException {
        String fids = "";
        StringBuffer tWFSsclogIDs = new StringBuffer();
        String tSql = " select fid from t_wfr_ssclog where DATEDIFF(Day,flastupdatetime,GETDATE())>" + this.days;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = cn.prepareStatement(tSql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String fId = rs.getString(1);
                if (tWFSsclogIDs.length() > 0) {
                    tWFSsclogIDs.append("','");
                }
                tWFSsclogIDs.append(fId);
            }
            if (tWFSsclogIDs.length() > 0) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("('");
                buffer.append(tWFSsclogIDs);
                buffer.append("')");
                fids = buffer.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"query getWFSsclogIDs error -------");
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
        return fids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDirtyLogDataBatch(Connection cn) throws SQLException {
        try (PreparedStatement ps = null;){
            String sql = "delete  t_wfr_sscloghst where fid in( select fid from t_wfr_ssclog)";
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferWfLogDataBatch(Connection cn, String dumpLogIDs) throws SQLException {
        if (StringUtils.isEmpty((String)dumpLogIDs)) {
            return;
        }
        try (Statement ps = null;){
            StringBuffer tStrBuffer = new StringBuffer();
            tStrBuffer.append("insert into t_wfr_sscloghst ");
            tStrBuffer.append("select * from t_wfr_ssclog where fid in " + dumpLogIDs);
            ps = cn.prepareStatement(tStrBuffer.toString());
            ps.execute();
            tStrBuffer = new StringBuffer();
            tStrBuffer.append(" delete t_wfr_ssclog where fid in " + dumpLogIDs);
            ps = cn.prepareStatement(tStrBuffer.toString());
            ps.execute();
        }
    }
}

