/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.WebBillManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.monitor.ApproveUtil;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.eas.base.message.BillWebUtil;
import com.kingdee.eas.base.message.URLInfo;
import com.kingdee.eas.base.message.app.AbstractWebViewMessageFacadeControllerBean;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.message.web.WebMessageUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.log4j.Logger;

public class WebViewMessageFacadeControllerBean
extends AbstractWebViewMessageFacadeControllerBean {
    private static final long serialVersionUID = -1914918884146748516L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.message.app.WebViewMessageFacadeControllerBean");
    public static final String EASWEB_PATH = "/easweb";
    public static final String APPROVE_FUNCTION = "MultiApproveUIFunction";
    public static final String MANUALDECISION_FUNCTION = "ManualDecisionUIFunction";

    @Override
    protected boolean _isWebMessage(Context ctx, String messageId, String nodeType, String ifHistory, String assigmentId, String proName) throws BOSException {
        String status;
        int type;
        IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
        boolean tag = false;
        if (StringUtils.isEmpty((String)assigmentId)) {
            tag = this.isViewInWeb(ctx, messageId, nodeType, ifHistory);
        } else if (!WebMessageUtils.canHandleAssignment(ctx, assigmentId)) {
            tag = this.isViewInWeb(ctx, messageId, nodeType, ifHistory);
        } else if (BillWebUtil.isHasWebHtml(ctx, assigmentId, proName) && 3 == (type = service.getActTypeByAssignment(assigmentId)) && null == (status = service.getStatusByAssignment(assigmentId))) {
            tag = true;
        }
        return tag;
    }

    private boolean isViewInWeb(Context ctx, String messageId, String nodeType, String ifHistory) {
        int noticeType;
        boolean tag = true;
        if (nodeType.equals("1")) {
            tag = false;
        }
        if (nodeType.equals("3") && (noticeType = WebMessageUtils.getNoticeType(ctx, messageId, Boolean.valueOf(ifHistory))) == WebMessageUtils.PASS_NOTICE) {
            tag = false;
        }
        return tag;
    }

    @Override
    protected String _getUrlByBillID(Context ctx, String billID) throws BOSException {
        EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
        ProcessInstInfo[] instInfos = iEnactmentService.getProcessInstanceByHoldedObjectId(billID);
        logger.info((Object)("_getUrlByBillID-instInfos.length = " + instInfos.length));
        if (instInfos.length == 0) {
            instInfos = iEnactmentService.getAllProcessInstancesByBizobjId(billID);
        }
        logger.info((Object)("_getUrlByBillID-instInfos.length 2 = " + instInfos.length));
        for (int k = 0; k < instInfos.length; ++k) {
            String hashValue = instInfos[k].getProcDefHashValue();
            String proInstId = instInfos[k].getProcInstId();
            ProcessDef def = iEnactmentService.getProcessDefByDefineHashValue(hashValue);
            ActivityCollection actColl = def.getActivitys();
            logger.info((Object)("_getUrlByBillID-actColl.size() = " + actColl.size()));
            for (int i = 0; i < actColl.size(); ++i) {
                String actDefId;
                ActivityInstInfo[] actinst;
                ApproveActivityDef approDef;
                ExtendedAttributeDef extend;
                ActivityDef act = actColl.get(i);
                if (act instanceof WebBillManpowerActivityDef) {
                    StringBuffer webUrl = new StringBuffer(((WebBillManpowerActivityDef)act).getUrl());
                    logger.info((Object)("webUrl = " + webUrl));
                    if (webUrl.length() > 0) {
                        if (webUrl.indexOf("?") > 0) {
                            webUrl.append("&pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                        } else {
                            webUrl.append("?pk=").append(StringUtils.replace((String)billID, (String)"+", (String)"%2B"));
                        }
                        logger.info((Object)("_getUrlByBillID-WebBillManpowerActivityDef webUrl = " + webUrl));
                        return webUrl.toString();
                    }
                } else if (act instanceof ApproveActivityDef && (extend = (approDef = (ApproveActivityDef)act).getActivityHeader().getExtendedAttributes().get("isWebBillApprove")) != null && "true".equalsIgnoreCase(extend.getValue())) {
                    ExtendedAttributeDef extend1 = approDef.getActivityHeader().getExtendedAttributes().get("WebBillApproveUrl");
                    logger.info((Object)("extend1.getValue() = " + extend1.getValue()));
                    if (extend1 != null && !StringUtils.isEmpty((String)extend1.getValue())) {
                        String extUrl = extend1.getValue();
                        if (extUrl.indexOf("?") > 0) {
                            extUrl = extUrl + "&pk=";
                            extUrl = extUrl + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                        } else {
                            extUrl = extUrl + "?pk=";
                            extUrl = extUrl + StringUtils.replace((String)billID, (String)"+", (String)"%2B");
                        }
                        logger.info((Object)("_getUrlByBillID-ApproveActivityDef url by billid = " + extUrl));
                        return extUrl;
                    }
                }
                if (!(act instanceof ManpowerActivityDef) || (actinst = iEnactmentService.getActInstMetaByDefId(actDefId = ((ManpowerActivityDef)act).getID(), proInstId, false)).length <= 0) continue;
                try {
                    String url = this.getWaf2DynamicPageURL((IEnactmentService)iEnactmentService, actinst[0]);
                    if (StringUtils.isEmpty((String)url)) continue;
                    url = url + "&operateState=VIEW";
                    return url;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        String url = this.getWebBillURL(ctx, billID);
        if (!StringUtils.isEmpty((String)url)) {
            logger.info((Object)("_getUrlByBillID myUrl = " + url));
            return url;
        }
        BOSUuid uuid = BOSUuid.read((String)billID);
        url = this.getEditUrlByBOSType(ctx, uuid.getType().toString());
        return url;
    }

    private String getWaf2DynamicPageURL(IEnactmentService service, ActivityInstInfo activityInstInfo) throws Exception {
        ActivityInstInfo instInfo = service.getActivityInstByActInstId(activityInstInfo.getActInstId());
        ActivityDef def = service.getActDefByActInstInfo(instInfo);
        if (def instanceof ManpowerActivityDef) {
            ExtendedAttributeCollection extendAttrCol = ((ManpowerActivityDef)def).getRelatedApplication().getExtendedAttributes();
            ExtendedAttributeDef waf2UiPK = extendAttrCol.get("Waf2UIPK");
            if (waf2UiPK != null && !"".equals(waf2UiPK.getValue())) {
                StringBuffer url = new StringBuffer("dynamicForm.do");
                this.appendParam(url, "method", "initalize", false);
                this.appendParam(url, "event", "initialize", false);
                this.appendParam(url, "uipk", waf2UiPK.getValue(), true);
                this.appendParam(url, "inwafpage", "true", false);
                return url.toString();
            }
            Context ctx = service.getContext();
            String sql = "select distinct fparentprocdefid from t_wfr_procinst where fprocinstid='" + activityInstInfo.getProcInstId() + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            String procDefIds = null;
            ProcessDefInfo processDefInfo = null;
            while (rowSet.next()) {
                procDefIds = rowSet.getString("fparentprocdefid");
            }
            processDefInfo = procDefIds == null ? service.getProcessDefInfo(activityInstInfo.getProcDefId()) : service.getProcessDefInfo(procDefIds);
            ProcessDef processDef = service.getProcessDefByDefineHashValue(processDefInfo.getMd5HashValue());
            ExtendedAttributeCollection procExAttributeCollection = processDef.getExtendedAttributes();
            ExtendedAttributeDef procWaf2UiPK = procExAttributeCollection.get("Waf2UIPK");
            if (procWaf2UiPK != null && !"".equals(procWaf2UiPK.getValue())) {
                StringBuffer url = new StringBuffer("dynamicForm.do");
                this.appendParam(url, "method", "initalize", false);
                this.appendParam(url, "event", "initialize", false);
                this.appendParam(url, "uipk", procWaf2UiPK.getValue(), true);
                this.appendParam(url, "inwafpage", "true", false);
                return url.toString();
            }
        }
        return "";
    }

    private OperationInfo getOperation(String bizOperation, FunctionObjectInfo function) {
        OperationInfo oper = null;
        OperationCollection operCol = function.getOperation();
        for (int i = 0; i < operCol.size(); ++i) {
            if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)bizOperation)) continue;
            oper = operCol.get(i);
            break;
        }
        return oper;
    }

    private String getEditUrlByBOSType(Context ctx, String bosType) {
        EntityObjectInfo entityInfo = this.getEntityInfoByBOSType(ctx, bosType);
        String rootPackage = this.rootPackage(entityInfo);
        String srcEditUrl = this.rootUrl(rootPackage) + this.startLowerCase(entityInfo.getName()) + "Edit.jsf";
        return srcEditUrl;
    }

    private EntityObjectInfo getEntityInfoByBOSType(Context ctx, String bosType) {
        IMetaDataLoader mdLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BOSObjectType bosObjectType = BOSObjectType.create((String)bosType);
        EntityObjectInfo entityInfo = mdLoader.getEntity(bosObjectType);
        return entityInfo;
    }

    private String rootPackage(EntityObjectInfo entityInfo) {
        String str = entityInfo.getPackage();
        int index = str.lastIndexOf(".");
        if (index == -1) {
            return str;
        }
        return str.substring(0, index);
    }

    private String rootUrl(String packageName) {
        String url;
        String prefix = "com.kingdee.eas";
        if (packageName.startsWith(prefix)) {
            packageName = packageName.substring(prefix.length());
        }
        if (!(url = packageName.replace('.', '/')).startsWith("/")) {
            url = "/" + url;
        }
        return url + "/";
    }

    private String startLowerCase(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    @Override
    protected String _getUrlByAssignID(Context ctx, String AssignID) throws BOSException {
        return this.getUrlByAssignIds(ctx, AssignID);
    }

    private String getWebBillURL(Context ctx, String billID) {
        String[] dynamicEditUrl = ProcessCenterUtil.getDynamicEditURLByBillId(billID, ctx);
        if (dynamicEditUrl != null && dynamicEditUrl.length == 2) {
            StringBuffer urlStr = new StringBuffer(dynamicEditUrl[0]);
            if (!StringUtils.isEmpty((String)dynamicEditUrl[1])) {
                urlStr.append(urlStr.indexOf("?") < 0 ? "?" : "&").append("uipk").append("=").append(dynamicEditUrl[1]);
            }
            logger.info((Object)("gui getWebBillURL-urlStr.toString()= " + urlStr.toString()));
            return urlStr.toString();
        }
        String webUIurl = StoreUtils.getWebUIurl((String)billID, (Context)ctx);
        if (webUIurl != null) {
            logger.info((Object)("gui getWebBillURL-webUIurl= " + webUIurl));
            return webUIurl;
        }
        return "";
    }

    @Override
    protected String _getUrlByAssignIds(Context ctx, String AssignIds) throws BOSException {
        String url = "";
        String assignUrl = "";
        String[] idArray = AssignIds.split(";");
        EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
        for (int i = 0; i < idArray.length; ++i) {
            String webUrl;
            Map m = iEnactmentService.getActivityDefAndActivityInstInfo(idArray[i]);
            Object act = m.get("ACTIVITYDEF");
            if (act instanceof WebBillManpowerActivityDef && (webUrl = ((WebBillManpowerActivityDef)act).getUrl()) != null && !webUrl.equals("")) {
                url = EASWEB_PATH + webUrl;
                logger.info((Object)("---getUrlByAssignID url=" + url));
            }
            if (!StringUtils.isEmpty((String)url)) continue;
            String billID = "";
            AssignmentInfo assInfo = iEnactmentService.getAssignmentById(idArray[i]);
            String bizPackgeName = assInfo.getBizPackage();
            String bizFunName = assInfo.getBizFunction();
            String bizOperation = assInfo.getBizOperation();
            String[] bizObjectID = assInfo.getBizObjectIdArray();
            if (bizObjectID != null && bizObjectID[0] != null) {
                billID = bizObjectID[0];
            }
            MetaDataPK metaPK = new MetaDataPK(bizPackgeName, bizFunName);
            FunctionObjectInfo function = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)metaPK);
            OperationInfo oper = this.getOperation(bizOperation, function);
            if (oper == null || oper.getUiActionRef() == null) {
                throw new WfException("UI is null");
            }
            UIObjectInfo ui = oper.getUiActionRef().getUIObjectRef();
            Map map = null;
            if (!StringUtils.isEmpty((String)billID)) {
                url = this.getWebBillURL(ctx, billID);
            }
            if (ui != null && StringUtils.isEmpty((String)url) && (map = ui.getExtendedProperties()) != null && map.size() > 0 && map.get("url") != null) {
                url = (String)map.get("url");
            }
            if (i == 0) {
                assignUrl = url;
                continue;
            }
            if (assignUrl.equals(url)) continue;
            return null;
        }
        logger.info((Object)("---getUrlByAssignIds url=" + url));
        return url;
    }

    @Override
    protected String _getPortalDisposeUrl(Context ctx, String assignIds, String assignType) throws BOSException {
        String type = null;
        if (assignIds == null || assignIds.length() == 0) {
            return null;
        }
        type = this.getAssignType(ctx, assignIds);
        if (APPROVE_FUNCTION.equals(type)) {
            return this.getApproveUrl(ctx, assignIds);
        }
        if (MANUALDECISION_FUNCTION.equals(type)) {
            return this.getManualDecisionUrl(assignIds);
        }
        return this.getUrlByDealingWithAssignment(ctx, assignIds);
    }

    private String getManualDecisionUrl(String assignIds) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(EASWEB_PATH).append("/workflow/manualDecision.jsp?assignmentId=").append(assignIds);
        return buffer.toString();
    }

    private String getApproveUrl(Context ctx, String assignIds) {
        String url = "";
        String defaultURL = "/easweb/workflow/approve.jsp";
        url = ConfigLoader.getConfig4Server().getString("default.multiapprove.url", "", defaultURL);
        StringBuffer buffer = new StringBuffer();
        if (defaultURL.equals(url)) {
            buffer.append(url).append("?assignmentId=").append(assignIds);
            return buffer.toString();
        }
        String billEditUrl = null;
        buffer.append(url);
        this.appendParam(buffer, "assignmentId", assignIds, true);
        this.appendParam(buffer, "v", "750", false);
        try {
            String billId;
            String s;
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            AssignmentInfo assign = svc.getAssignmentById(assignIds);
            Map argumentMap = svc.getAssignmentArgument(assignIds, true);
            String editUIName = (String)argumentMap.get("UIClassName");
            ActivityInstInfo instInfo = svc.getActivityInstByActInstId(assign.getActInstId());
            ActivityDef def = svc.getActDefByActInstInfo(instInfo);
            ExtendedAttributeCollection extendAttrCol = def.getActivityHeader().getExtendedAttributes();
            ExtendedAttributeDef value = extendAttrCol.get("customUIStatus");
            String string = s = value == null ? "" : value.getValue();
            if (editUIName != null && editUIName.length() > 0) {
                billEditUrl = WebViewMessageFacadeControllerBean.getURLfromEditUI(ctx, editUIName);
            }
            if (StringUtils.isEmpty(billEditUrl) && !StringUtils.isEmpty((String)(billId = assign.getBizObjectIds()))) {
                billEditUrl = ApproveUtil.getEditUrl((Context)ctx, (String)billId, (String)s);
            }
            if (!StringUtils.isEmpty(billEditUrl)) {
                this.appendParam(buffer, "billEditUrl", billEditUrl, true);
            }
            if (value != null) {
                this.appendParam(buffer, "operateState", value.getValue(), false);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return buffer.toString();
    }

    private String getAssignType(Context ctx, String assignIds) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bizFunction");
        try {
            AssignInfo info = AssignFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(assignIds), sic);
            return info.getBizFunction();
        }
        catch (BOSException bOSException) {
            return null;
        }
    }

    public void appendParam(StringBuffer buffer, String key, String value, boolean encode) {
        if (value == null) {
            return;
        }
        try {
            if (encode) {
                value = URLEncoder.encode(value, "utf-8");
            }
            buffer.append(buffer.indexOf("?") < 0 ? "?" : "&");
            buffer.append(key + "=" + value);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static String getURLfromEditUI(Context ctx, String editUi) throws BOSException {
        UIObjectCtrl ctrl = new UIObjectCtrl(ctx);
        MetaDataPK metaPK = MetaDataPK.create((String)editUi);
        Object o = ctrl.getValue((IMetaDataPK)metaPK).getExtendedProperties().get("url");
        String url = o == null ? "" : o.toString().trim();
        return url;
    }

    public String getUrlByDealingWithAssignment(Context ctx, String assignmentId) {
        StringBuffer url = new StringBuffer();
        URLInfo urlInfo = null;
        try {
            urlInfo = ProcessCenterUtil.getUrlInfos(assignmentId, ctx);
            if (urlInfo != null) {
                String objUrl = urlInfo.getURL();
                logger.error((Object)("forwordURL" + objUrl));
                url.append("/workflow/WFServlet?UIStatus=").append(urlInfo.getUIStatus()).append("&forwordURL=").append(URLEncoder.encode(objUrl, "UTF-8")).append("&assignmentID=").append(URLEncoder.encode(assignmentId, "UTF-8")).append("&billID=").append(URLEncoder.encode(urlInfo.getBillID(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)"error when get the url -0000000000   ");
        }
        if (StringUtils.isEmpty((String)urlInfo.getErrorMsg())) {
            logger.error((Object)urlInfo.getErrorMsg());
        }
        return url.toString();
    }
}

