/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.WfCommonProcessFactory;
import com.kingdee.eas.base.message.WfCommonProcessInfo;
import com.kingdee.eas.base.message.app.AbstractWfCommonProcessServiceControllerBean;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class WfCommonProcessServiceControllerBean
extends AbstractWfCommonProcessServiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.message.app.WfCommonProcessServiceControllerBean");

    @Override
    protected String _submitProcess(Context ctx, String srcId, String srcType, String number, String name, String description, String contentType, String content, String procAppConfigNumber, String userId) throws BOSException {
        UserInfo userInfo;
        Context newCtx = new Context((IObjectPK)new ObjectUuidPK(userId), ctx.getSolution(), ctx.getAIS(), ctx.getLocale());
        String easId = null;
        try {
            easId = this.findEASId(ctx, srcId, srcType);
        }
        catch (SQLException e1) {
            throw new BOSException(e1.getMessage(), (Throwable)e1);
        }
        WfCommonProcessInfo info = new WfCommonProcessInfo();
        info.setSrcId(srcId);
        info.setType(srcType);
        info.setName(name);
        info.setNumber(number);
        info.setDescription(description);
        info.setContent(content);
        info.setContentType(contentType);
        BOSUuid uuid = null;
        if (easId != null) {
            uuid = BOSUuid.read((String)easId);
            info.setId(uuid);
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userId));
            info.setLastUpdateUser(userInfo);
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            info.setLastUpdateTime(ts);
        } else {
            uuid = BOSUuid.create((BOSObjectType)info.getBOSType());
            info.setId(uuid);
            userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)userId));
            info.setCreator(userInfo);
            info.setLastUpdateUser(userInfo);
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            info.setCreateTime(ts);
            info.setLastUpdateTime(ts);
            info.setCU((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit));
            if (procAppConfigNumber == null || procAppConfigNumber.trim().length() == 0) {
                throw new BOSException("procAppConfigNumber can't be null.");
            }
            try {
                String procDefId = this.getProcDefId(ctx, procAppConfigNumber);
                if (procDefId == null) {
                    throw new BOSException("Can't find process define by procAppConfigNumber:" + procAppConfigNumber);
                }
                info.setExtendedProperty("workflowDirectCreateProcessDefId", procDefId);
            }
            catch (SQLException e2) {
                throw new BOSException(e2.getMessage(), (Throwable)e2);
            }
        }
        try {
            WfCommonProcessFactory.getLocalInstance(newCtx).submit((CoreBaseInfo)info);
            if (easId == null) {
                this.insertRelation(ctx, srcId, srcType, uuid.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return uuid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProcDefId(Context ctx, String procAppConfigNumber) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement("select fprocdefid from t_wf_commonprocessappconfig where fnumber=?");
            ps.setString(1, procAppConfigNumber);
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRelation(Context ctx, String srcId, String srcType, String easId) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement("insert into t_wf_cprelation(feasid, fsrcid, fsrctype) values(?,?,?)");
            ps.setString(1, easId);
            ps.setString(2, srcId);
            ps.setString(3, srcType);
            ps.executeUpdate();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String findEASId(Context ctx, String srcId, String srcType) throws SQLException {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement("select feasid from t_wf_cprelation where fsrcid=? and fsrctype=?");
            ps.setString(1, srcId);
            ps.setString(2, srcType);
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

