/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.ext.app.Sql;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IMsgUnreadCount;
import com.kingdee.eas.base.message.IProcessMessageFacade;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.MsgUnreadCountFactory;
import com.kingdee.eas.base.message.MsgUnreadCountInfo;
import com.kingdee.eas.base.message.ProcessMessageFacadeFactory;
import com.kingdee.eas.base.message.URLInfo;
import com.kingdee.eas.base.message.WebServiceMessageFactory;
import com.kingdee.eas.base.message.WebServiceMessageInfo;
import com.kingdee.eas.base.message.app.AbstractWsMessageCenterFacadeControllerBean;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WsMessageCenterFacadeControllerBean
extends AbstractWsMessageCenterFacadeControllerBean {
    private static final long serialVersionUID = -5883636091525757492L;
    private static final String RESOURCE = "com.kingdee.eas.base.message.MessageCenter";
    private static Logger logger = Logger.getLogger(WsMessageCenterFacadeControllerBean.class);
    private String[] procInstKey = new String[]{"fcode", "FPROCINSTTOPIC_L2", "fprocinstid", "fstate", "fcreatedtime"};
    private String[] procinstXmlNode = new String[]{"procCode", "procSubject", "procInstId", "procState", "createdtime"};
    private String ErrorMSg = "";

    @Override
    protected boolean _updateMessageStatus(Context ctx, String msgID, int state) throws BOSException {
        logger.debug((Object)"-----------updateMessageStatus----------");
        StringBuffer sql = new StringBuffer();
        sql.append("update T_BAS_Message set FStatus=" + state + "");
        sql.append(" where FID='");
        sql.append(msgID);
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return true;
    }

    @Override
    protected boolean _removeMsgBySID(Context ctx, String sourceID) throws BOSException {
        logger.debug((Object)"-----------_removeMsgBySID----------");
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_BAS_WebServiceMessage where FSourceID='");
        sql.append(sourceID);
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return true;
    }

    @Override
    protected int _checkMessageCount(Context ctx, String userID) throws BOSException {
        logger.debug((Object)"-----------_checkMessageCount----------");
        StringBuffer sql = new StringBuffer();
        int sum = 0;
        sql.append("select FAccount from T_BAS_MsgUnreadCount where FUserNumber='");
        sql.append(userID);
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (!rs.next()) {
                return 0;
            }
            sum = rs.getInt(1);
        }
        catch (SQLException e) {
            sum = 0;
            logger.error((Object)"\u67e5\u8be2\u672a\u8bfb\u6d88\u606f\u8bb0\u5f55\u6570\u76ee\u65f6\u51fa\u9519", (Throwable)e);
        }
        return sum;
    }

    @Override
    protected boolean _clearMessageCount(Context ctx, String userID) throws BOSException {
        logger.debug((Object)"-----------_clearMessageCount----------");
        MsgUnreadCountInfo info = this.getUnreadCountInfo(ctx, userID);
        if (info == null) {
            return false;
        }
        info.setAccount(info.getAccount() - info.getSendMsgNum());
        info.setLastUpdateTime(info.getSendTime());
        IMsgUnreadCount imuc = MsgUnreadCountFactory.getLocalInstance(ctx);
        boolean bflag = true;
        try {
            imuc.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
        }
        catch (Exception e) {
            bflag = false;
            logger.error((Object)"update\u672a\u8bfb\u8bb0\u5f55info\u5bf9\u8c61\u65f6\u51fa\u9519", (Throwable)e);
        }
        return bflag;
    }

    @Override
    protected boolean _removeMsgByID(Context ctx, String messageID) throws BOSException {
        logger.debug((Object)"-----------_removeMsgByID----------");
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_BAS_WebServiceMessage where FID='");
        sql.append(messageID);
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return true;
    }

    @Override
    protected boolean _addMessage(Context ctx, String userID, String title, String senderID, int priority, int status, String body, String sourceID, String type, String bizType, String url, String sysSign, String recieveTime) throws BOSException {
        logger.debug((Object)"-----------_addMessage---start-------");
        WebServiceMessageInfo messageInfo = new WebServiceMessageInfo();
        messageInfo.setUserNumber(userID);
        messageInfo.setTitle(title);
        messageInfo.setSenderNumber(senderID);
        messageInfo.setPriority(MsgPriority.getEnum(priority));
        messageInfo.setStatus(MsgStatus.getEnum(status));
        messageInfo.setBody(body);
        messageInfo.setSourceID(sourceID);
        messageInfo.setType(type);
        messageInfo.setBizType(bizType);
        messageInfo.setUrl(url);
        messageInfo.setSysSign(sysSign);
        messageInfo.setReceiveTime(recieveTime);
        boolean bflag = true;
        try {
            WebServiceMessageFactory.getLocalInstance(ctx).addnew(messageInfo);
        }
        catch (Exception e) {
            bflag = false;
            logger.error((Object)"\u63d2\u5165\u7b2c\u4e09\u65b9\u6d88\u606f\u65f6\u51fa\u9519", (Throwable)e);
        }
        logger.debug((Object)("-----------_addMessage--------end----" + bflag));
        return bflag;
    }

    @Override
    protected String _getMessageList(Context ctx, String userNumber) throws BOSException {
        logger.debug((Object)"-----------_getMessageList----------");
        Timestamp sendtime = new Timestamp(new Date().getTime());
        MsgUnreadCountInfo unReadInfo = this.getUnreadCountInfo(ctx, userNumber);
        if (unReadInfo == null) {
            throw new BOSException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"readCurrentUserMessageListError"), userNumber));
        }
        unReadInfo.setSendMsgNum(unReadInfo.getAccount());
        unReadInfo.setSendTime(sendtime);
        IMsgUnreadCount imuc = MsgUnreadCountFactory.getLocalInstance(ctx);
        ObjectUuidPK unReadPK = new ObjectUuidPK(unReadInfo.getId().toString());
        try {
            imuc.update((IObjectPK)unReadPK, unReadInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)"\u66f4\u65b0\u672a\u8bfb\u8bb0\u5f55\uff08\u5199\u5165\u53d6\u6570\u636e\u65f6\u4fe1\u606f\uff09\u65f6\u51fa\u9519", (Throwable)e);
        }
        Timestamp lastUpdataTime = unReadInfo.getLastUpdateTime();
        if (lastUpdataTime == null) {
            lastUpdataTime = new Timestamp(new Date().getTime());
        }
        UserInfo userInfo = null;
        try {
            userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(userNumber);
        }
        catch (EASBizException e1) {
            logger.error((Object)"\u7528\u7528\u6237\u540d\u83b7\u53d6\u63a5\u6536\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e1);
        }
        String userID = userInfo.getId().toString();
        IQueryExecutor exec = null;
        IRowSet wfRowSet = null;
        IRowSet bmcRowSet = null;
        MetaDataPK WFQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "WFAssignQuery");
        EntityViewInfo WFEntityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("type", (Object)new Integer(10));
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("sourceStatus", (Object)new Integer(1));
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("sourceStatus", (Object)new Integer(2));
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("receiver", (Object)userID, CompareType.EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("receiveTime", (Object)lastUpdataTime, CompareType.GREATER_EQUALS);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterInfo.setMaskString(" #0 AND ( #1 OR #2 ) AND #3 AND #4");
        SorterItemInfo sorterItemInfo = null;
        sorterItemInfo = new SorterItemInfo("receiveTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        WFEntityView.getSorter().add(sorterItemInfo);
        WFEntityView.setFilter(filterInfo);
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)WFQueryPK);
        exec.setObjectView(WFEntityView);
        wfRowSet = exec.executeQuery();
        MetaDataPK BMCMsgPk = new MetaDataPK("com.kingdee.eas.base.message.app", "BMCMessageQuery");
        EntityViewInfo BMCEntityView = new EntityViewInfo();
        FilterInfo BMCFilter = new FilterInfo();
        FilterItemInfo BMCFilterItemInfo = null;
        BMCFilterItemInfo = new FilterItemInfo("receiver", (Object)userID, CompareType.EQUALS);
        BMCFilter.getFilterItems().add(BMCFilterItemInfo);
        BMCFilterItemInfo = new FilterItemInfo("receiveTime", (Object)lastUpdataTime, CompareType.GREATER_EQUALS);
        BMCFilter.getFilterItems().add(BMCFilterItemInfo);
        BMCFilter.setMaskString("#0 and #1");
        BMCEntityView.setFilter(BMCFilter);
        BMCEntityView.getSorter().add(sorterItemInfo);
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)BMCMsgPk);
        exec.setObjectView(BMCEntityView);
        bmcRowSet = exec.executeQuery();
        StringBuffer data = new StringBuffer();
        try {
            if (wfRowSet != null && bmcRowSet != null) {
                String bizType;
                String type;
                int num = 1;
                data.append("<?xml version=\"1.0\" encoding=\"GBK\" ?>");
                data.append("\n");
                data.append("<ROWSET>");
                data.append("\n");
                while (wfRowSet.next()) {
                    data.append("<ROW num=\"" + num + "\">");
                    data.append("\n");
                    data.append("<ID>" + wfRowSet.getString("id") + "</ID>");
                    data.append("\n");
                    type = MsgType.getEnum(wfRowSet.getInt("type")).getAlias();
                    data.append("<TYPE>" + type + "</TYPE>");
                    data.append("\n");
                    bizType = MsgBizType.getEnum(wfRowSet.getInt("bizType")).getAlias();
                    data.append("<BIZTYPE>" + bizType + "</BIZTYPE>");
                    data.append("\n");
                    data.append("<PRIORITY>" + MsgPriority.MIDDLE.getAlias() + "</PRIORITY>");
                    data.append("\n");
                    String status = MsgStatus.getEnum(wfRowSet.getInt("status")).getAlias();
                    data.append("<STATUS>" + status + "</STATUS>");
                    data.append("\n");
                    data.append("<SOURCEIDS></SOURCEIDS>");
                    data.append("\n");
                    data.append("<TITLE>" + wfRowSet.getString("title") + "</TITLE>");
                    data.append("\n");
                    data.append("<BODY>" + wfRowSet.getString("body") + "</BODY>");
                    data.append("\n");
                    data.append("<SENDER>" + wfRowSet.getString("sender") + "</SENDER>");
                    data.append("\n");
                    String time = wfRowSet.getTimestamp("receiveTime").toString();
                    int location = time.lastIndexOf(".");
                    time = time.substring(0, location);
                    data.append("<RTIME>" + time + "</RTIME>");
                    data.append("\n");
                    data.append("</ROW>");
                    data.append("\n");
                    ++num;
                }
                while (bmcRowSet.next()) {
                    data.append("<ROW num=\"" + num + "\">");
                    data.append("\n");
                    data.append("<ID>" + bmcRowSet.getString("id") + "</ID>");
                    data.append("\n");
                    type = MsgType.getEnum(bmcRowSet.getInt("type")).getAlias();
                    data.append("<TYPE>" + type + "</TYPE>");
                    data.append("\n");
                    bizType = MsgBizType.getEnum(bmcRowSet.getInt("bizType")).getAlias();
                    data.append("<BIZTYPE>" + bizType + "</BIZTYPE>");
                    data.append("\n");
                    String pri = MsgPriority.getEnum(bmcRowSet.getInt("priority")).getAlias();
                    data.append("<PRIORITY>" + pri + "</PRIORITY>");
                    data.append("\n");
                    String status = MsgStatus.getEnum(bmcRowSet.getInt("status")).getAlias();
                    data.append("<STATUS>" + status + "</STATUS>");
                    data.append("\n");
                    data.append("<SOURCEIDS>" + bmcRowSet.getString("sourceIDs") + "</SOURCEIDS>");
                    data.append("\n");
                    data.append("<TITLE>" + bmcRowSet.getString("title") + "</TITLE>");
                    data.append("\n");
                    data.append("<BODY>" + bmcRowSet.getString("body") + "</BODY>");
                    data.append("\n");
                    data.append("<SENDER>" + bmcRowSet.getString("sender") + "</SENDER>");
                    data.append("\n");
                    String time = bmcRowSet.getTimestamp("receiveTime").toString();
                    int location = time.lastIndexOf(".");
                    time = time.substring(0, location);
                    data.append("<RTIME>" + time + "</RTIME>");
                    data.append("\n");
                    data.append("</ROW>");
                    data.append("\n");
                    ++num;
                }
                data.append("</ROWSET>");
                return data.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u62fc\u88c5\u8fd4\u56de\u6570\u636e\u6d41\u65f6\u51fa\u9519", (Throwable)e);
        }
        return "";
    }

    private MsgUnreadCountInfo getUnreadCountInfo(Context ctx, String userNumber) throws BOSException {
        MsgUnreadCountInfo info = null;
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        sql.append("select FID from T_BAS_MsgUnreadCount where FUserNumber='");
        sql.append(userNumber);
        sql.append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String id = "";
        try {
            if (rs.size() == 0) {
                return null;
            }
            if (!rs.next()) {
                return null;
            }
            id = rs.getString("FID");
        }
        catch (SQLException e) {
            logger.error((Object)"\u83b7\u53d6\u672a\u8bfb\u6d88\u606f\u8bb0\u5f55id\u65f6\u51fa\u9519", (Throwable)e);
            return null;
        }
        IMsgUnreadCount imuc = MsgUnreadCountFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        try {
            info = imuc.getMsgUnreadCountInfo((IObjectPK)pk);
        }
        catch (EASBizException e) {
            logger.error((Object)"\u83b7\u53d6\u672a\u8bfb\u8bb0\u5f55info\u5bf9\u8c61\u65f6\u51fa\u9519", (Throwable)e);
            return null;
        }
        return info;
    }

    @Override
    protected String _getMessageXML(Context ctx, String userNumber, String type, String bizType, String readStatus, String sourceStatus, String nodeType, String orgNumber, boolean ifHistory) throws BOSException {
        UserInfo userInfo = null;
        try {
            userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(userNumber);
        }
        catch (EASBizException e) {
            logger.error((Object)("\u6839\u636e\u7f16\u7801\u83b7\u53d6\u63a5\u6536\u7528\u6237\u65f6\u51fa\u9519,userNumber = " + userNumber), (Throwable)e);
            return "";
        }
        String userID = userInfo.getId().toString();
        try {
            if ("1".equals(nodeType) && !ifHistory) {
                return this.getUnDisposeTaskXML(ctx, sourceStatus, orgNumber, userID, readStatus);
            }
            if ("2".equals(nodeType) && !ifHistory) {
                return this.getDisposeTaskXML(ctx, sourceStatus, orgNumber, userID);
            }
            if ("3".equals(nodeType)) {
                return this.getNoticeXML(ctx, type, bizType, readStatus, userID);
            }
        }
        catch (Exception e) {
            StringBuffer methodParam = new StringBuffer("_getMessageXML error!");
            methodParam.append("\n").append("ctx=").append(ctx).append("\n").append("userNumber=").append(userNumber).append("\n").append("type=").append(type).append("\n").append("bizType").append(bizType).append("\n").append("readStatus=").append(readStatus).append("\n").append("sourceStatus=").append(sourceStatus).append("\n").append("nodeType=").append(nodeType).append("\n").append("orgNumber=").append(orgNumber).append("\n").append("ifHistory=").append(ifHistory).append("\n");
            logger.error((Object)methodParam.toString(), (Throwable)e);
            return "";
        }
        return "";
    }

    private String getNoticeXML(Context ctx, String type, String bizType, String readStatus, String userID) throws BOSException, SQLException {
        MetaDataPK BMCMsgPk = new MetaDataPK("com.kingdee.eas.base.message.app", "BMCMessageQuery");
        EntityViewInfo BMCEntityView = new EntityViewInfo();
        FilterInfo bMCFilter = new FilterInfo();
        FilterItemInfo bMCFilterItemInfo = null;
        bMCFilterItemInfo = new FilterItemInfo("receiver", (Object)userID);
        bMCFilter.getFilterItems().add(bMCFilterItemInfo);
        bMCFilterItemInfo = new FilterItemInfo("type", (Object)new Integer(type));
        bMCFilter.getFilterItems().add(bMCFilterItemInfo);
        if (!"-1".equals(bizType)) {
            bMCFilterItemInfo = new FilterItemInfo("bizType", (Object)new Integer(bizType));
            bMCFilter.getFilterItems().add(bMCFilterItemInfo);
        }
        if (!StringUtils.isEmpty((String)readStatus)) {
            bMCFilterItemInfo = new FilterItemInfo("status", (Object)new Integer(readStatus));
            bMCFilter.getFilterItems().add(bMCFilterItemInfo);
        }
        BMCEntityView.setFilter(bMCFilter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("receiveTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        BMCEntityView.getSorter().add(sorterItemInfo);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)BMCMsgPk);
        exec.setObjectView(BMCEntityView);
        IRowSet rowSet = exec.executeQuery();
        return this.buildXMLfromRowSet(rowSet);
    }

    private String getDisposeTaskXML(Context ctx, String sourceStatus, String orgNumber, String userID) throws BOSException, SQLException {
        MetaDataPK WFQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "AssignDetailQuery");
        EntityViewInfo WFEntityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("type", (Object)new Integer(10));
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("receiver", (Object)userID);
        filterInfo.getFilterItems().add(filterItemInfo);
        String maskString = " #0 AND #1 ";
        if ("-1".equals(sourceStatus)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceStatus", (Object)new Integer("4")));
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceStatus", (Object)new Integer("8")));
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceStatus", (Object)new Integer("16")));
            maskString = maskString + " AND (#2 or #3 or #4) ";
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceStatus", (Object)new Integer(sourceStatus)));
            maskString = maskString + " AND #2";
        }
        if (!StringUtils.isEmpty((String)orgNumber)) {
            FullOrgUnitInfo orgUnitInfo = null;
            try {
                orgUnitInfo = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance((Context)ctx).getValue("select FID where Fnumber = '" + orgNumber + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)"\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7\u65f6\u51fa\u9519", (Throwable)e);
            }
            filterItemInfo = new FilterItemInfo("orgID", (Object)orgUnitInfo.getId().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            maskString = "-1".equals(sourceStatus) ? maskString + " AND #5 " : maskString + " AND #3 ";
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo("receiveTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        WFEntityView.getSorter().add(sorterItemInfo);
        filterInfo.setMaskString(maskString);
        WFEntityView.setFilter(filterInfo);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)WFQueryPK);
        exec.setObjectView(WFEntityView);
        IRowSet rowSet = exec.executeQuery();
        return this.buildXMLfromRowSet(rowSet);
    }

    private String getUnDisposeTaskXML(Context ctx, String sourceStatus, String orgNumber, String userID, String readStatus) throws BOSException, SQLException {
        MetaDataPK WFQueryPK = new MetaDataPK("com.kingdee.eas.base.message", "WFAssignQuery");
        EntityViewInfo WFEntityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("type", (Object)new Integer(10));
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("receiver", (Object)userID);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (!"-1".equals(sourceStatus)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceStatus", (Object)new Integer(sourceStatus)));
        }
        if (!StringUtils.isEmpty((String)readStatus)) {
            filterItemInfo = new FilterItemInfo("status", (Object)new Integer(readStatus));
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        if (!StringUtils.isEmpty((String)orgNumber)) {
            FullOrgUnitInfo orgUnitInfo = null;
            try {
                orgUnitInfo = (FullOrgUnitInfo)FullOrgUnitFactory.getLocalInstance((Context)ctx).getValue("select FID where Fnumber = '" + orgNumber + "'");
            }
            catch (EASBizException e) {
                logger.error((Object)"\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7\u65f6\u51fa\u9519", (Throwable)e);
            }
            filterItemInfo = new FilterItemInfo("orgID", (Object)orgUnitInfo.getId().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
        }
        SorterItemInfo sorterItemInfo = new SorterItemInfo("receiveTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        WFEntityView.getSorter().add(sorterItemInfo);
        WFEntityView.setFilter(filterInfo);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)WFQueryPK);
        exec.setObjectView(WFEntityView);
        IRowSet rowSet = exec.executeQuery();
        return this.buildXMLfromRowSet(rowSet);
    }

    private String buildXMLfromRowSet(IRowSet rowSet) throws SQLException {
        String sourceID = "";
        String sourceIDs = "";
        String body = "";
        StringBuffer data = new StringBuffer();
        int num = 1;
        data.append("<?xml version=\"1.0\" encoding=\"GBK\" ?>");
        data.append("\n");
        data.append("<ROWSET>");
        data.append("\n");
        while (rowSet.next()) {
            try {
                sourceID = rowSet.getString("sourceID");
            }
            catch (Throwable e) {
                sourceID = "";
            }
            try {
                sourceIDs = rowSet.getString("sourceIDs");
            }
            catch (Throwable e) {
                sourceIDs = "";
            }
            try {
                sourceIDs = rowSet.getString("sourceIDs");
            }
            catch (Throwable e) {
                sourceIDs = "";
            }
            try {
                body = rowSet.getString("body");
            }
            catch (Throwable e) {
                sourceIDs = "";
            }
            data.append("<ROW num=\"" + num + "\">");
            data.append("\n");
            data.append("<ID>" + rowSet.getString("id") + "</ID>");
            data.append("\n");
            String type = MsgType.getEnum(rowSet.getInt("type")).getAlias();
            data.append("<TYPE>" + type + "</TYPE>");
            data.append("\n");
            String bizType = MsgBizType.getEnum(rowSet.getInt("bizType")).getAlias();
            data.append("<BIZTYPE>" + bizType + "</BIZTYPE>");
            data.append("\n");
            data.append("<PRIORITY>" + MsgPriority.MIDDLE.getAlias() + "</PRIORITY>");
            data.append("\n");
            String status = MsgStatus.getEnum(rowSet.getInt("status")).getAlias();
            data.append("<STATUS>" + status + "</STATUS>");
            data.append("\n");
            data.append("<SOURCEID>" + sourceID + "</SOURCEID>");
            data.append("\n");
            data.append("<SOURCEIDS>" + sourceIDs + "</SOURCEIDS>");
            data.append("\n");
            data.append("<TITLE>" + rowSet.getString("title") + "</TITLE>");
            data.append("\n");
            data.append("<BODY>" + body + "</BODY>");
            data.append("\n");
            data.append("<SENDER>" + rowSet.getString("sender") + "</SENDER>");
            data.append("\n");
            String time = rowSet.getTimestamp("receiveTime").toString();
            int location = time.lastIndexOf(".");
            time = time.substring(0, location);
            data.append("<RTIME>" + time + "</RTIME>");
            data.append("\n");
            data.append("</ROW>");
            data.append("\n");
            ++num;
        }
        data.append("</ROWSET>");
        return data.toString();
    }

    @Override
    protected int _getBMCMessageCount(Context ctx, String userId, String type, String bizType, String state) throws BOSException {
        int count = 0;
        IProcessMessageFacade processMessageFacade = ProcessMessageFacadeFactory.getLocalInstance(ctx);
        count = processMessageFacade.getBMCMessageCount(userId, type, bizType, state);
        return count;
    }

    @Override
    protected int _getDisposeAssignCount(Context ctx, String userId) throws BOSException {
        int count = 0;
        IProcessMessageFacade processMessageFacade = ProcessMessageFacadeFactory.getLocalInstance(ctx);
        count = processMessageFacade.getDisposeAssignCount(userId);
        return count;
    }

    @Override
    protected int _getUndiposeAssignCount(Context ctx, String status, String userId) throws BOSException {
        int count = 0;
        IProcessMessageFacade processMessageFacade = ProcessMessageFacadeFactory.getLocalInstance(ctx);
        count = processMessageFacade.getUndiposeAssignCount(status, userId);
        return count;
    }

    @Override
    protected boolean _addBMCMessage(Context ctx, int type, int bizType, String senderId, int priority, int status, int sourceStatus, String title, String body, Timestamp sendTime, Timestamp receiveTime, String sourceID, String receiver, int orgType, String orgID, String sourceIDs) throws BOSException {
        logger.info((Object)"-----------_addBMCMessage---start-------");
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo userInfo = null;
        try {
            ObjectStringPK pk = new ObjectStringPK(senderId);
            userInfo = iUser.getUserByID((IObjectPK)pk);
        }
        catch (Exception e1) {
            logger.error((Object)("\u67e5\u8be2\u7528\u6237ID\u51fa\u9519" + e1.getMessage()), (Throwable)e1);
            userInfo = this.getUserInfoByNum(ctx, senderId);
        }
        String userName = "";
        if (userInfo != null) {
            userName = userInfo.getName();
        }
        BMCMessageInfo messageInfo = new BMCMessageInfo();
        messageInfo.setType(MsgType.getEnum(type));
        messageInfo.setBizType(MsgBizType.getEnum(bizType));
        messageInfo.setSender(userName);
        messageInfo.setPriority(MsgPriority.getEnum(priority));
        messageInfo.setStatus(MsgStatus.getEnum(status));
        messageInfo.setSourceStatus(MsgSourceStatus.getEnum(sourceStatus));
        messageInfo.setTitle(title);
        messageInfo.setBody(body);
        messageInfo.setSendTime(sendTime);
        messageInfo.setReceiveTime(receiveTime);
        messageInfo.setSourceID(sourceID);
        messageInfo.setReceiver(receiver);
        messageInfo.setOrgType(OrgType.getEnum((int)orgType));
        messageInfo.setOrgID(orgID);
        boolean bflag = false;
        try {
            BMCMessageFactory.getLocalInstance(ctx).addnew(messageInfo);
            bflag = true;
        }
        catch (Exception e) {
            bflag = false;
            logger.error((Object)("\u63d2\u5165\u6d88\u606f\u4e2d\u5fc3\u51fa\u9519" + e.getMessage()), (Throwable)e);
        }
        logger.info((Object)("-----------_addBMCMessage--------end----" + bflag));
        return bflag;
    }

    @Override
    protected String _getBillUrl(Context ctx, String assignId, String procinstId) throws BOSException {
        String billUrl = "";
        String billId = "";
        if (assignId != null && assignId.length() > 0) {
            try {
                URLInfo urlInfo = ProcessCenterUtil.getEditUrlInfoByAssign(assignId, ctx);
                billUrl = urlInfo.getURL();
                billId = urlInfo.getBillID();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "\u83b7\u53d6\u5355\u636eurl\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a:" + e;
            }
        } else if (procinstId != null && procinstId.length() > 0) {
            URLInfo urlInfo = ProcessCenterUtil.getEditUrlInfoByProcInst(procinstId, ctx);
            billUrl = urlInfo.getURL();
            billId = urlInfo.getBillID();
        } else {
            throw new WfException("\u9700\u8981\u4f20\u5165\u6d41\u7a0b\u5b9e\u4f8bid\u6216\u8005\u4efb\u52a1id!");
        }
        return this.formatBillUrl(billUrl, billId);
    }

    private String formatBillUrl(String billUrl, String billId) throws WfException {
        if (billUrl == null) {
            throw new WfException("\u5355\u636eurl\u83b7\u53d6\u4e3a\u7a7a");
        }
        String url = "";
        if (billUrl.indexOf("pureWFBillUrl") != -1) {
            url = billUrl;
        } else if (billUrl.indexOf("dynamicForm.do") != -1) {
            url = "/easweb/" + billUrl + "&operateState=VIEW";
        } else if (billUrl.substring(billUrl.length() - ".do".length()).equals(".do") || billUrl.substring(billUrl.length() - ".jsp".length()).equals(".jsp")) {
            if (billUrl.substring(billUrl.length() - "Page.do".length()).equals("Page.do")) {
                url = "/easweb/" + billUrl + "?billId=" + billUrl;
            } else {
                if (billId == null) {
                    throw new WfException("\u5355\u636eid\u83b7\u53d6\u4e3a\u7a7a");
                }
                url = "/easportal/" + billUrl + "?id=" + billId;
            }
        } else if (billUrl.indexOf(".do?") > 0 || billUrl.indexOf(".jsp?") > 0) {
            if (billId == null) {
                throw new WfException("\u5355\u636eid\u83b7\u53d6\u4e3a\u7a7a");
            }
            url = billUrl.indexOf("Page.do?") > 0 ? "/easweb/" + billUrl + "&billId=" + billId : "/easportal/" + billUrl + "&id=" + billId;
        } else {
            url = "/easweb/" + billUrl;
        }
        if (url.indexOf("operateState") == -1) {
            url = url + "&operateState=VIEW";
        }
        return url;
    }

    @Override
    @Deprecated
    protected String _addNewAssign(Context ctx, String subject, String lastUserNumber, String initiatorNumber, String billId, String userNumber, String billUrl) throws BOSException {
        return "method is already marked by @Deprecated";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordBillUrl(Context ctx, String billId, String billUrl) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = "insert into T_WFR_OtherSysBurl(FbillId,FbillUrl) values(?,?)";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, billId);
            stmt.setString(2, billUrl);
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _dumpCompleteAssign(Context ctx, String assignId) throws BOSException {
        HashSet set = new HashSet();
        try {
            if (assignId == null || assignId.length() == 0) {
                this.ErrorMSg = "\u4efb\u52a1id\u4e3a\u7a7a";
                String string = this.xmlStr("1", this.ErrorMSg);
                return string;
            }
            ObjectUuidPK assignPK = new ObjectUuidPK(assignId);
            AssignInfo tempAsg = AssignFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)assignPK);
            tempAsg.setState(WfAssignmentState.COMPLETED);
            AssignFactory.getLocalInstance((Context)ctx).update((IObjectPK)assignPK, tempAsg);
            this.insertAssignDetail(ctx, assignId);
            if (this.ErrorMSg != null && this.ErrorMSg.length() > 0) {
                String string = this.xmlStr("1", this.ErrorMSg);
                return string;
            }
        }
        finally {
            set.clear();
            this.ErrorMSg = "";
        }
        return this.xmlStr("0", "");
    }

    private String addAssignDetailSQL(String assignid) {
        String DUMP_ASSIGN_SQL = new StringBuffer(500).append("INSERT INTO T_WFR_AssignDetail ").append(" (FASSIGNID, FBODY_L1, FBODY_L2,  FBODY_L3,  FSTATE,  FPERSONUSERID, ").append(" FPERSONUSERNAME_L1, FPERSONUSERNAME_L2, FPERSONUSERNAME_L3, ").append(" FPERSONEMPID, FPERSONEMPNAME_L1, FPERSONEMPNAME_L2, FPERSONEMPNAME_L3, ").append(" FPERFORMERUID, FPERFORMERUNAME_L1, FPERFORMERUNAME_L2, FPERFORMERUNAME_L3, ").append(" FPERFORMEREID, FPERFORMERENAME_L1, FPERFORMERENAME_L2 ,FPERFORMERENAME_L3, ").append(" FACTINSTID, FACTDEFID, FACTDEFNAME_L1, FACTDEFNAME_L2, FACTDEFNAME_L3, ").append(" FPROCDEFHASH, FPROCDEFID, FPROCDEFNAME_L1, FPROCDEFNAME_L2, FPROCDEFNAME_L3, ").append(" FPROCINSTID, FENDTIME, FLASTSTATETIME, FCREATEDTIME, FFORWARDPATH, FEXTATTR, ").append(" FACCEPTTIME, FBIZPACKAGE, FBIZFUNCTION,  FBIZOPERATION, FBIZOBJID, FAPPDEFID, FPRIORITY, ").append(" FDURATION, FWORKINGTIME, FWAITINGTIME, FISSENDMSG, ").append(" FORGID, FORGTYPE, FISOTHERSYS,FOTHERSYSNUMBER,FOTHERSYSOPERATION, ").append(" FINITIATORNAME_L1, FINITIATORNAME_L2, FINITIATORNAME_L3, ").append(" FSUBJECT_L1, FSUBJECT_L2, FSUBJECT_L3,FPRIORPERFORMER, FPRIORPERFORMERNAME_l1, FPRIORPERFORMERNAME_l2, FPRIORPERFORMERNAME_l3, FBILLENTITY").append(" ,FResponsibleEmpId, FSourceAssignId").append(" ) ").append(" SELECT Assign.FASSIGNID , Assign.FBODY_L1, Assign.FBODY_L2, Assign.FBODY_L3, Assign.FSTATE, Assign.FPERSONUSERID, ").append(" Assign.FPERSONUSERNAME_L1, Assign.FPERSONUSERNAME_L2, Assign.FPERSONUSERNAME_L3, ").append(" Assign.FPERSONEMPID, Assign.FPERSONEMPNAME_L1, Assign.FPERSONEMPNAME_L2, Assign.FPERSONEMPNAME_L3, ").append(" Assign.FPERFORMERUID, Assign.FPERFORMERUNAME_L1, Assign.FPERFORMERUNAME_L2, Assign.FPERFORMERUNAME_L3, ").append(" Assign.FPERFORMEREID, Assign.FPERFORMERENAME_L1, Assign.FPERFORMERENAME_L2, Assign.FPERFORMERENAME_L3, ").append(" Assign.FACTINSTID, Assign.FACTDEFID, Assign.FACTDEFNAME_L1, Assign.FACTDEFNAME_L2, Assign.FACTDEFNAME_L3, ").append(" Assign.FPROCDEFHASH, Assign.FPROCDEFID, Assign.FPROCDEFNAME_L1, Assign.FPROCDEFNAME_L2, Assign.FPROCDEFNAME_L3, ").append(" Assign.FPROCINSTID, Assign.FENDTIME, Assign.FLASTSTATETIME, Assign.FCREATEDTIME, Assign.FFORWARDPATH, Assign.FEXTATTR, ").append(" Assign.FACCEPTTIME, Assign.FBIZPACKAGE, Assign.FBIZFUNCTION, Assign.FBIZOPERATION, Assign.FBIZOBJID, Assign.FAPPDEFID, Assign.FPRIORITY, ").append(" Assign.FDURATION, Assign.FWORKINGTIME, Assign.FWAITINGTIME, Assign.FISSENDMSG, ").append("AssignRead.FOrgID, AssignRead.FOrgType , Assign.FISOTHERSYS,Assign.FOTHERSYSNUMBER,Assign.FOTHERSYSOPERATION, ").append(" AssignRead.fsender_l1, AssignRead.fsender_l2 , AssignRead.fsender_l3, ").append(" Assign.FSUBJECT_L1, Assign.FSUBJECT_L2, Assign.FSUBJECT_L3, Assign.FPRIORPERFORMER, Assign.FPRIORPERFORMERNAME_l1, Assign.FPRIORPERFORMERNAME_l2, Assign.FPRIORPERFORMERNAME_l3, Assign.FBILLENTITY ").append(" ,Assign.FResponsibleEmpId, Assign.FSourceAssignId ").append(" FROM T_WFR_Assign Assign ").append(" LEFT OUTER JOIN T_BAS_AssignRead AssignRead ON  AssignRead.FAssignID = Assign.FAssignID WHERE Assign.FASSIGNID = '" + assignid + "'").toString();
        return DUMP_ASSIGN_SQL.toString();
    }

    private void insertAssignDetail(Context ctx, String assignId) {
        try {
            String sql = this.addAssignDetailSQL(assignId);
            int effectCount = Sql.execute((Context)ctx, (String)sql);
            if (effectCount != 1) {
                logger.error((Object)("************dump error in WsMessageCenterFacadeControllerBean: effectCount = " + effectCount + " AssignId:" + assignId));
            } else {
                ObjectUuidPK assignPK = new ObjectUuidPK(assignId);
                AssignFactory.getLocalInstance((Context)ctx).delete((IObjectPK)assignPK);
            }
        }
        catch (Exception e) {
            this.ErrorMSg = e.toString();
            logger.error((Object)e);
        }
    }

    @Deprecated
    private boolean saveAsgInfo(Context ctx, HashMap<String, String> assignInfos) {
        return false;
    }

    private boolean saveAsgReadInfo(Context ctx, HashMap<String, String> assignInfos) {
        AssignReadInfo asgread = new AssignReadInfo();
        asgread.setAssignID(BOSUuid.read((String)assignInfos.get("assignId")));
        asgread.setStatus(MsgStatus.UNREADED);
        UserInfo sender = this.getUserInfoByNum(ctx, assignInfos.get("initiatorNumber"));
        asgread.setSender(sender.getName(ctx.getLocale()), ctx.getLocale());
        asgread.setSenderId(sender.getId().toString());
        asgread.setOrgID(sender.getDefOrgUnit().getId().toString());
        asgread.setOrgType(OrgType.Admin);
        String lastUserNumber = assignInfos.get("lastUserNumber");
        UserInfo lastuo = this.getUserInfoByNum(ctx, lastUserNumber);
        asgread.setPriorPerformerID(lastuo.getId().toString());
        asgread.setPriorPerformName(lastuo.getName(ctx.getLocale()), ctx.getLocale());
        asgread.setPriorPerformName(lastuo.getName(), new Locale("l1"));
        asgread.setPriorPerformName(lastuo.getName(), new Locale("l3"));
        IObjectPK pk = null;
        try {
            pk = AssignReadFactory.getLocalInstance(ctx).save(asgread);
        }
        catch (Exception e) {
            this.ErrorMSg = "\u7b2c\u4e09\u65b9\u6d88\u606f\u96c6\u6210  \u5b58\u50a8AssignReadInfo\u5bf9\u8c61\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e;
            logger.error((Object)this.ErrorMSg);
            return false;
        }
        return true;
    }

    private UserInfo getUserInfoByNum(Context ctx, String userNum) {
        UserInfo userInfo = null;
        try {
            userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfoByNumber(userNum);
        }
        catch (Exception e) {
            logger.error((Object)("\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7528\u6237\u65f6\u51fa\u9519,userNumber = " + userNum), (Throwable)e);
        }
        return userInfo;
    }

    private String xmlStr(String retType, String errMsg) {
        StringBuffer data = new StringBuffer();
        data.append("<?xml version=\"1.0\" encoding=\"GBK\" ?>");
        data.append("\n");
        data.append("<data>\n");
        data.append("<resultType>");
        data.append(retType);
        data.append("</resultType>\n");
        data.append("<errorMessage>\n");
        data.append(errMsg + "\n");
        data.append("</errorMessage>\n");
        data.append("<data>\n");
        return data.toString();
    }
}

