/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.app.msgcount;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.cbos.process.vm.utils.cache.Cache;
import com.kingdee.cbos.process.vm.utils.cache.GroupCache;
import com.kingdee.cbos.process.vm.utils.cache.LocalCache;
import com.kingdee.cbos.process.vm.utils.cache.SmartCache;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatLoader;
import com.kingdee.eas.base.message.app.msgcount.ClassificationStatRefreshJob;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClassificationStatCacheManager {
    private static final HashMap<String, ClassificationStatCacheManager> managers = new HashMap();
    private static final int TIMEOUT = 1800;
    private static final int CAPACITY = 5000;
    private LocalCache<String, Boolean> onlineUsers;
    private Cache<String, Map<String, Integer>> statCache;
    private HashSet<String> users4refresh;
    private Context ctx;

    public static synchronized ClassificationStatCacheManager get(Context ctx) {
        ClassificationStatCacheManager manager = managers.get(ctx.getAIS());
        if (manager == null) {
            manager = new ClassificationStatCacheManager(Ctx.toShadowContext((Context)ctx));
            managers.put(ctx.getAIS(), manager);
            Job job = manager.newJob();
            JobManager.instance().add(job);
        }
        return manager;
    }

    private ClassificationStatCacheManager(Context ctx) {
        this.ctx = ctx;
        this.onlineUsers = new LocalCache(ClassificationStatCacheManager.class, 5000, 1800);
        ClassificationStatLoader loader = new ClassificationStatLoader(ctx);
        LocalCache inner = new LocalCache(ClassificationStatCacheManager.class, 5000, 1800);
        this.statCache = new GroupCache(ctx.getAIS() + "@SORT", (Cache)new SmartCache((Cache)inner, (SmartCache.Loader)loader));
        this.getUsers4Refresh();
    }

    public Map<String, Integer> getStat(String userId) {
        try {
            Map map = (Map)this.statCache.get((Object)userId);
            return map;
        }
        finally {
            this.onlineUsers.put((Object)userId, (Object)Boolean.TRUE);
        }
    }

    public void expire(String userId) {
        this.statCache.remove((Object)userId);
        if (this.onlineUsers.exists((Object)userId)) {
            this.regUserId4Refresh(userId);
        }
    }

    private synchronized void regUserId4Refresh(String userId) {
        this.users4refresh.add(userId);
    }

    public void refresh() {
        HashSet<String> list = this.getUsers4Refresh();
        for (String userId : list) {
            this.statCache.get((Object)userId);
        }
    }

    private synchronized HashSet<String> getUsers4Refresh() {
        HashSet<String> list = this.users4refresh;
        this.users4refresh = new HashSet(500);
        return list;
    }

    public List<String> getOnlineUserIds() {
        return this.onlineUsers.keys();
    }

    public Job newJob() {
        ClassificationStatRefreshJob h = new ClassificationStatRefreshJob(this);
        Job job = new Job(this.ctx, (IJobHandler)h, null, false);
        return job;
    }
}

