/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.content.json;

import com.google.gson.Gson;
import com.kingdee.eas.base.message.content.Content;
import com.kingdee.eas.base.message.content.ContentDetail;
import com.kingdee.eas.base.message.content.ContentHeader;
import com.kingdee.eas.base.message.content.ContentParser;
import com.kingdee.eas.base.message.content.json.JSONContent;
import com.kingdee.eas.base.message.content.json.JSONContentDetail;
import com.kingdee.eas.base.message.content.json.JSONContentHeader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONParser
implements ContentParser {
    @Override
    public Content parse(String src) {
        JSONContent content = new JSONContent(src);
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(src, Map.class);
        content.header = this.parseHeader(map);
        content.details = this.parseDetail(map);
        return content;
    }

    private ContentDetail[] parseDetail(Map map) {
        if (map.containsKey("detail")) {
            return new ContentDetail[]{this.parseOneDetail((Map)map.get("detail"))};
        }
        if (map.containsKey("details")) {
            List list = (List)map.get("details");
            ContentDetail[] details = new ContentDetail[list.size()];
            for (int i = 0; i < details.length; ++i) {
                details[i] = this.parseOneDetail((Map)list.get(i));
            }
            return details;
        }
        return null;
    }

    private ContentDetail parseOneDetail(Map map) {
        List listRows;
        JSONContentDetail detail = new JSONContentDetail();
        detail.caption = (String)map.get("caption");
        List listCaptions = (List)map.get("columnCaptions");
        if (listCaptions != null) {
            String[] columnCaptions = new String[listCaptions.size()];
            for (int i = 0; i < columnCaptions.length; ++i) {
                columnCaptions[i] = (String)listCaptions.get(i);
            }
            detail.columnCaptions = columnCaptions;
        }
        if ((listRows = (List)map.get("rows")) != null) {
            ArrayList<String[]> listRowsResult = new ArrayList<String[]>();
            for (int i = 0; i < listRows.size(); ++i) {
                List listRow = (List)listRows.get(i);
                listRowsResult.add(listRow.toArray(new String[listRow.size()]));
            }
            detail.listRows = listRowsResult;
        }
        return detail;
    }

    private ContentHeader parseHeader(Map map) {
        List list = (List)map.get("header");
        if (list == null) {
            return null;
        }
        JSONContentHeader header = new JSONContentHeader();
        String[] keys = new String[list.size()];
        HashMap valueMap = new HashMap();
        for (int i = 0; i < keys.length; ++i) {
            Map kv = (Map)list.get(i);
            Map.Entry entry = kv.entrySet().iterator().next();
            keys[i] = (String)entry.getKey();
            valueMap.put(entry.getKey(), entry.getValue());
        }
        header.itemKeys = keys;
        header.map = valueMap;
        return header;
    }
}

