/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.base.message.util.sendmsg.hrcloud.KDCloudServiceConfig;
import com.kingdee.eas.base.message.util.sendmsg.pa.MessageModelEnum;
import com.kingdee.eas.base.message.util.sendmsg.pa.MessageTypeEnum;
import com.kingdee.eas.base.message.util.sendmsg.pa.api.IMessageAdapter;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WFPassAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFPassAdapter.class);
    private Message message = null;
    private Context ctx = null;

    @Override
    public boolean isNeedSendXT() {
        return true;
    }

    public WFPassAdapter(Message message) {
        logger.debug((Object)"WfNoticeAdapter init");
        this.message = message;
        this.ctx = WFPassAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
    }

    @Override
    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    @Override
    public MessageModelEnum getModel() {
        return null;
    }

    @Override
    public Map<String, Object> getContent() {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String content = this.parseContent();
        contents.put("text", content);
        String assignid = this.message.getStringHeader("assignid");
        String dbCode = this.ctx.getAIS();
        String sourceIDs = this.message.getStringHeader("sourceIDs");
        String[] sourcdids = sourceIDs.replace("PASS::", "").split(":");
        String[] sourcdidsnew = sourceIDs.split("\\|");
        String fproinstid = "";
        fproinstid = sourcdids.length == 1 && sourcdidsnew.length > 1 ? sourcdidsnew[1] : sourcdids[0];
        String host = KDCloudServiceConfig.getInstance().getPropertiesItem("billRedirectUrl");
        if (this.message.getStringHeader("titlel2").indexOf("\u4f20\u9605\u53cd\u9988") > -1) {
            String senderl2 = this.message.getStringHeader("senderl2");
            String receiver = this.message.getStringHeader("receiver");
            String billID = sourcdidsnew[2];
            String procinstId = sourcdidsnew[1];
            String url = host + "/passAssignDetail.html?type=mysend&billID=" + billID + "&appid=10036&fprocinstid=" + procinstId + "&personName=senderl2&personID=" + receiver;
            contents.put("url", url);
        } else {
            String url = host + "/passAssignDetail.html?type=myreceive&appid=10036&billID=" + sourcdids[1] + "&assignID=" + sourcdids[5] + "&fprocinstid=" + fproinstid + "&personID=" + sourcdids[2] + "&isAllowrepass=" + sourcdids[4] + "&passId=" + sourcdids[6];
            contents.put("url", url);
        }
        contents.put("appid", "10036");
        return contents;
    }

    private String parseContent() {
        String msgContent = "";
        String opinion = "";
        String userName = "";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.message.getStringHeader("titlel2").indexOf("\u4f20\u9605\u53cd\u9988") > -1) {
            userName = this.message.getLocaleStringHeader("sender", new Locale("L2"));
            opinion = this.message.getLocaleStringHeader("body", new Locale("L2"));
            msgContent = msgContent + userName + "\u7684\u4f20\u9605\u53cd\u9988";
            msgContent = msgContent + "\n" + df.format(new Date()) + "\n\n";
            msgContent = msgContent + this.message.getLocaleStringHeader("title", new Locale("L2"));
            msgContent = msgContent + "\n\n\u4f20\u9605\u53cd\u9988\u610f\u89c1\uff1a" + opinion;
        } else {
            String[] bodys = this.message.getLocaleStringHeader("body", new Locale("L2")).split("/*\u4ee5\u4e0b\u662f\u4f20\u9605\u610f\u89c1");
            if (bodys.length > 1) {
                opinion = bodys[1].replaceAll("\n", "");
                String[] opinions = opinion.split("\u4f20\u9605\u4eba :");
                opinion = opinions[0];
                userName = opinions[1].replace("*/", "");
            }
            msgContent = msgContent + userName + "\u7684\u4f20\u9605";
            msgContent = msgContent + "\n" + df.format(new Date()) + "\n\n";
            msgContent = msgContent + this.message.getLocaleStringHeader("title", new Locale("L2"));
            msgContent = msgContent + "\n\u4f20\u9605\u610f\u89c1\uff1a" + opinion;
        }
        logger.info((Object)("XT Message parseContext() body=" + this.message.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + this.message.getLocaleStringHeader("title", new Locale("L2"))));
        return msgContent;
    }

    @Override
    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IUser user = UserFactory.getLocalInstance((Context)this.ctx);
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message getUsers() msgReceiver: " + msgReceiver));
            UserInfo userInfo = (UserInfo)user.getValue((IObjectPK)new ObjectStringPK(msgReceiver));
            if (userInfo != null && userInfo.getPerson() != null) {
                list.add(userInfo.getPerson().getId().toString());
                logger.info((Object)("XT Message getUsers() personID:" + userInfo.getPerson().getId().toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() get personID error!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Date getUpdateTime() {
        return new Date();
    }

    @Override
    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    public static void main(String[] args) {
        Message newMessage = MessageFactory.newMessage();
        Locale locale = new Locale("L2");
        newMessage.setLocaleStringHeader("title", "aaa", locale);
        newMessage.setLocaleStringHeader("body", "bbb", locale);
        newMessage.setLocaleStringHeader("sender", "ccc", locale);
    }
}

