/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.util;

import com.kingdee.eas.base.message.util.sendmsg.pa.api.IMessageAdapter;
import com.kingdee.eas.base.message.util.sendmsg.util.FileUtil;
import com.kingdee.eas.base.message.util.sendmsg.util.RSAUtils;
import com.kingdee.eas.base.message.util.sendmsg.util.StringUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SignUtil {
    private static Logger logger = Logger.getLogger((String)SignUtil.class.getName());

    private SignUtil() {
    }

    public static PrivateKey getPrivateKey(String eID, String keyPath) throws Exception {
        PrivateKey privateKey = null;
        String fileName = keyPath + "/" + eID + ".key";
        try {
            privateKey = RSAUtils.restorePrivateKey(FileUtil.readFile(fileName));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)String.format("error message:can't find private key file[%s]!", fileName));
            throw new Exception(String.format("\u627e\u4e0d\u5230\u4f01\u4e1a\u5ba2\u6237\u7684\u79c1\u94a5\u6587\u4ef6[%s]!", fileName), e);
        }
        catch (IOException e) {
            logger.error((Object)String.format("error message:private key file[%s] read error!", fileName));
            throw new Exception(String.format("\u8bfb\u53d6\u4f01\u4e1a\u5ba2\u6237\u7684\u79c1\u94a5\u6587\u4ef6[%s]\u51fa\u9519!", fileName), e);
        }
        catch (Exception e) {
            logger.error((Object)String.format("error message:private key file[%s] format error!", fileName));
            throw new Exception(String.format("\u89e3\u91ca\u4f01\u4e1a\u5ba2\u6237\u7684\u79c1\u94a5\u6587\u4ef6[%s]\u51fa\u9519!", fileName), e);
        }
        return privateKey;
    }

    public static String getSignString(String source, String eID, String keyPath) {
        if (StringUtil.isEmpty(source)) {
            return "";
        }
        String check = null;
        PrivateKey prvKey = null;
        byte[] sign = null;
        try {
            prvKey = SignUtil.getPrivateKey(eID, keyPath);
            if (prvKey != null) {
                sign = RSAUtils.sign(source.getBytes("UTF-8"), prvKey);
                check = StringUtil.getBase64FromByte(sign);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"error message", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            logger.error((Object)"error message", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"error message", (Throwable)e);
        }
        return check;
    }

    public static boolean isTokenValid(IMessageAdapter adapter, String token, String eID, String keyPath) {
        if (adapter == null || StringUtil.isEmpty(token)) {
            return false;
        }
        return token.equals(SignUtil.getSignString(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(adapter.getUpdateTime()), eID, keyPath));
    }

    public static String getPubtoken(String eid, String openid, String pubacckey, String nonce, String timestamp) {
        Object[] data = new String[]{eid, openid, pubacckey, nonce, timestamp};
        Arrays.sort(data);
        String pubtoken = DigestUtils.shaHex((String)StringUtils.join((Object[])data));
        return pubtoken;
    }
}

