/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util.sendmsg.util.stream;

import com.kingdee.eas.base.message.util.sendmsg.util.stream.ByteWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class SectionByteInputStream
extends InputStream {
    public static final int DEFAULT_SECTION_LENGTH = 131072;
    private int sectionLength = 131072;
    private ArrayList sections = new ArrayList();
    protected int pos = 0;
    protected int mark = 0;
    protected int count;

    public void addBytes(byte[] bytes) {
        this.sections.add(new ByteWrapper(bytes));
        this.count += bytes.length;
    }

    public void addBytes(byte[] bytes, int length) {
        this.sections.add(new ByteWrapper(bytes));
        this.count += length;
    }

    public int getSectionLength() {
        return this.sectionLength;
    }

    public void setSectionLength(int sectionLength) {
        this.sectionLength = sectionLength;
    }

    protected int posTosection(int bytePos) {
        return bytePos / this.sectionLength;
    }

    protected int posInsection(int bytePos) {
        return bytePos % this.sectionLength;
    }

    protected ByteWrapper getByteWrapperByBytePos(int bytePos) {
        int sectionPos = this.posTosection(bytePos);
        return (ByteWrapper)this.sections.get(sectionPos);
    }

    protected ByteWrapper getByteWrapperBySecPos(int sectionPos) {
        return (ByteWrapper)this.sections.get(sectionPos);
    }

    protected byte getByte(int bytePos) {
        return this.getByteWrapperByBytePos(bytePos).get(this.posInsection(bytePos));
    }

    protected void copyToByteArray(byte[] b, int pos, int off, int len) {
        int startSec = this.posTosection(pos);
        int endSec = this.posTosection(pos + len - 1);
        int destoff = off;
        for (int i = startSec; i <= endSec; ++i) {
            int l;
            int spos;
            if (i == startSec) {
                l = (this.count < this.sectionLength ? this.count : this.sectionLength) - (spos = this.posInsection(pos));
                if (destoff + l >= off + len) {
                    l = off + len - destoff;
                }
                System.arraycopy(this.getByteWrapperBySecPos(i).getBytes(), spos, b, destoff, l);
                destoff += l;
                continue;
            }
            if (i == endSec) {
                spos = 0;
                l = this.posInsection(pos + len - 1) - spos + 1;
                if (destoff + l >= off + len) {
                    l = off + len - destoff;
                }
                System.arraycopy(this.getByteWrapperBySecPos(i).getBytes(), spos, b, destoff, l);
                destoff += l;
                continue;
            }
            spos = 0;
            l = this.sectionLength;
            if (destoff + l >= off + len) {
                l = off + len - destoff;
            }
            System.arraycopy(this.getByteWrapperBySecPos(i).getBytes(), spos, b, destoff, l);
            destoff += l;
        }
    }

    @Override
    public synchronized int read() {
        return this.pos < this.count ? this.getByte(this.pos++) & 0xFF : -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        this.copyToByteArray(b, this.pos, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public synchronized long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }

    public int getCount() {
        return this.count;
    }
}

