/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryFactory;
import com.kingdee.eas.base.message.BillWebUtil;
import com.kingdee.eas.base.message.IMAGroup;
import com.kingdee.eas.base.message.IMAGroupEntry;
import com.kingdee.eas.base.message.IMAGroupResolvent;
import com.kingdee.eas.base.message.IMAGroupResolventEntry;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.IVaryTaskFacade;
import com.kingdee.eas.base.message.MAGroupEntryFactory;
import com.kingdee.eas.base.message.MAGroupEntryInfo;
import com.kingdee.eas.base.message.MAGroupFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.message.MAGroupResolventEntryFactory;
import com.kingdee.eas.base.message.MAGroupResolventEntryInfo;
import com.kingdee.eas.base.message.MAGroupResolventFactory;
import com.kingdee.eas.base.message.MAGroupResolventInfo;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.MessageViewConfig;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.VaryTaskFacadeFactory;
import com.kingdee.eas.base.message.WebViewMessageFacadeFactory;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.message.web.BillWebAuditConfig;
import com.kingdee.eas.base.message.web.WebMessageUtils;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.IMobileMessageAssign;
import com.kingdee.eas.mobile.MobileMessageAssignFactory;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class MessageCenterWebService
extends BuffaloService {
    private static Logger logger = Logger.getLogger((String)MessageCenterWebService.class.getName());

    public boolean sendMsg(boolean canBack, String content, String receivers) {
        try {
            boolean result = MessageCenterFactory.getRemoteInstance().sendMsg(canBack, content, receivers);
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean sendMsgHasAppend(boolean canBack, boolean isAppendRevert, boolean isAppendUserName, boolean isAppendCompanyName, boolean isAppendReceiverNumberFlag, boolean isAppendReceiverNameFlag, String content, String receivers) {
        SendMessageParamInfo sendMsParamInfo = new SendMessageParamInfo();
        sendMsParamInfo.setCanback(canBack);
        sendMsParamInfo.setAppendRevert(isAppendRevert);
        sendMsParamInfo.setAppendUserName(isAppendUserName);
        sendMsParamInfo.setAppendCompanyName(isAppendCompanyName);
        sendMsParamInfo.setAppendNumber(isAppendReceiverNumberFlag);
        sendMsParamInfo.setAppendPersonName(isAppendReceiverNameFlag);
        sendMsParamInfo.setContent(content);
        sendMsParamInfo.setReceiver(receivers);
        try {
            boolean result = MsgFacadeFactory.getRemoteInstance().sendMsg(sendMsParamInfo);
            return result;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getMagColtoPerson(String mag) throws BOSException, EASBizException {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        StringTokenizer st = new StringTokenizer(mag, ",");
        String magid = "";
        StringBuffer sb = new StringBuffer();
        IMAGroupResolvent imag = MAGroupResolventFactory.getRemoteInstance();
        while (st.hasMoreElements()) {
            magid = st.nextElement().toString();
            if (StringUtils.isEmpty((String)sb.toString())) {
                sb.append(this.getMagtoPerson(ctx, imag, magid));
                continue;
            }
            sb.append(",");
            sb.append(this.getMagtoPerson(ctx, imag, magid));
        }
        return sb.toString();
    }

    public String getMagColtoPersonID(String mag) throws BOSException, EASBizException {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        StringTokenizer st = new StringTokenizer(mag, ",");
        String magid = "";
        StringBuffer sb = new StringBuffer();
        IMAGroupResolvent imag = MAGroupResolventFactory.getRemoteInstance();
        while (st.hasMoreElements()) {
            magid = st.nextElement().toString();
            if (StringUtils.isEmpty((String)sb.toString())) {
                sb.append(this.getMagtoPersonId(ctx, imag, magid));
                continue;
            }
            sb.append(",");
            sb.append(this.getMagtoPersonId(ctx, imag, magid));
        }
        return sb.toString();
    }

    private String getMagtoPersonId(Context ctx, IMAGroupResolvent imag, String magid) throws EASBizException, BOSException {
        IPerson ip = PersonFactory.getRemoteInstance();
        IMAGroupResolventEntry ire = MAGroupResolventEntryFactory.getRemoteInstance();
        IMAGroup im = MAGroupFactory.getRemoteInstance();
        IMAGroupEntry ime = MAGroupEntryFactory.getRemoteInstance();
        String personid = "";
        StringBuffer sb = new StringBuffer();
        MAGroupResolventInfo info = imag.getMAGroupResolventInfo("select * where number = '" + magid + "'");
        for (int i = 0; i < info.getEntries().size(); ++i) {
            MAGroupResolventEntryInfo entryInfo = ire.getMAGroupResolventEntryInfo((IObjectPK)new ObjectUuidPK(info.getEntries().get(i).getId().toString()));
            MAGroupInfo magroupInfo = im.getMAGroupInfo((IObjectPK)new ObjectUuidPK(entryInfo.getGroup().getId().toString()));
            if (magroupInfo == null) continue;
            for (int j = 0; j < magroupInfo.getEntries().size(); ++j) {
                PersonInfo personInfo;
                MAGroupEntryInfo magroupeinfo = ime.getMAGroupEntryInfo((IObjectPK)new ObjectUuidPK(magroupInfo.getEntries().get(j).getId().toString()));
                if (magroupeinfo.getPersonnel() == null || magroupeinfo.getPersonnel().getId() == null || StringUtils.isEmpty((String)(personid = magroupeinfo.getPersonnel().getId().toString())) || (personInfo = ip.getPersonInfo((IObjectPK)new ObjectUuidPK(personid))) == null) continue;
                if (StringUtils.isEmpty((String)sb.toString())) {
                    sb.append(personInfo.getId());
                    continue;
                }
                sb.append(",");
                sb.append(personInfo.getId());
            }
        }
        return sb.toString();
    }

    private String getMagtoPerson(Context ctx, IMAGroupResolvent imag, String magid) throws EASBizException, BOSException {
        IPerson ip = PersonFactory.getRemoteInstance();
        IMAGroupResolventEntry ire = MAGroupResolventEntryFactory.getRemoteInstance();
        IMAGroup im = MAGroupFactory.getRemoteInstance();
        IMAGroupEntry ime = MAGroupEntryFactory.getRemoteInstance();
        String personid = "";
        StringBuffer sb = new StringBuffer();
        MAGroupResolventInfo info = imag.getMAGroupResolventInfo("select * where number = '" + magid + "'");
        for (int i = 0; i < info.getEntries().size(); ++i) {
            MAGroupResolventEntryInfo entryInfo = ire.getMAGroupResolventEntryInfo((IObjectPK)new ObjectUuidPK(info.getEntries().get(i).getId().toString()));
            MAGroupInfo magroupInfo = im.getMAGroupInfo((IObjectPK)new ObjectUuidPK(entryInfo.getGroup().getId().toString()));
            if (magroupInfo == null) continue;
            for (int j = 0; j < magroupInfo.getEntries().size(); ++j) {
                PersonInfo personInfo;
                MAGroupEntryInfo magroupeinfo = ime.getMAGroupEntryInfo((IObjectPK)new ObjectUuidPK(magroupInfo.getEntries().get(j).getId().toString()));
                if (magroupeinfo.getPersonnel() == null || magroupeinfo.getPersonnel().getId() == null || StringUtils.isEmpty((String)(personid = magroupeinfo.getPersonnel().getId().toString())) || (personInfo = ip.getPersonInfo((IObjectPK)new ObjectUuidPK(personid))) == null) continue;
                if (StringUtils.isEmpty((String)sb.toString())) {
                    sb.append(personInfo.getName());
                    continue;
                }
                sb.append(",");
                sb.append(personInfo.getName());
            }
        }
        return sb.toString();
    }

    public String getCellByNames(String names) throws BOSException, EASBizException {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String result = "";
        boolean isSuppTelNo = this.isSMSSupportInputTelNo(ctx);
        if (!StringUtils.isEmpty((String)names)) {
            String[] receiverArray = names.split(",");
            StringBuffer phoneStrBf = new StringBuffer();
            StringBuffer receiverBf = new StringBuffer();
            for (int i = 0; i < receiverArray.length; ++i) {
                if (MessageCenterWebService.isDigitStr(receiverArray[i]) && this.isCellphoneNumber(receiverArray[i]) && isSuppTelNo) {
                    if (phoneStrBf.length() == 0) {
                        phoneStrBf.append(receiverArray[i]);
                        continue;
                    }
                    phoneStrBf.append(",");
                    phoneStrBf.append(receiverArray[i]);
                    continue;
                }
                if (receiverBf.length() == 0) {
                    receiverBf.append(receiverArray[i]);
                    continue;
                }
                receiverBf.append(",");
                receiverBf.append(receiverArray[i]);
            }
            if (!StringUtils.isEmpty((String)receiverBf.toString())) {
                result = MessageCenterFactory.getRemoteInstance().getPhoneNumberByName(receiverBf.toString());
            }
            int index = -1;
            if (!StringUtils.isEmpty((String)result)) {
                index = result.indexOf("&");
            }
            if (!StringUtils.isEmpty((String)phoneStrBf.toString())) {
                if (index == -1) {
                    result = phoneStrBf + "&" + result;
                } else if (index >= 0) {
                    result = phoneStrBf + "," + result;
                }
            }
        }
        return result;
    }

    private boolean isCellphoneNumber(String str) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        String number = str.trim();
        try {
            new Long(number);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return number.length() == 11;
    }

    public Boolean isWebMessage(String messageId, String nodeType, String ifHistory, String assigmentId, String proName) {
        boolean isWebTag = false;
        try {
            messageId = WebMessageUtils.recoverRequestParam(messageId);
            assigmentId = WebMessageUtils.recoverRequestParam(assigmentId);
            isWebTag = WebViewMessageFacadeFactory.getRemoteInstance().isWebMessage(messageId, nodeType, ifHistory, assigmentId, proName);
        }
        catch (BOSException e) {
            return new Boolean(isWebTag);
        }
        return new Boolean(isWebTag);
    }

    public boolean isWebTask(String assignmentId, String proName) {
        boolean webTag = false;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            IEnactmentService service = EnactmentServiceProxy.getEnacementService((Context)ctx);
            if (BillWebUtil.isHasWebHtml(ctx, assignmentId, proName)) {
                int type = service.getActTypeByAssignment(assignmentId);
                logger.info((Object)("type is " + type));
                if (3 == type) {
                    String status = service.getStatusByAssignment(assignmentId);
                    logger.info((Object)("status is " + status));
                    if (null == status) {
                        webTag = true;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"isWebTask", (Throwable)ex);
        }
        logger.info((Object)("webTag is " + webTag));
        return webTag;
    }

    public boolean isWebBill(String assignmentId, String proName) {
        boolean webTag = false;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            if (BillWebUtil.isHasWebHtml(ctx, assignmentId, proName)) {
                webTag = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"isWebBill", (Throwable)ex);
        }
        return webTag;
    }

    public boolean canHandTask(String assignmentId) {
        boolean canHandTag = false;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            if (WebMessageUtils.canHandleAssignment(ctx, assignmentId)) {
                canHandTag = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"canHandTask", (Throwable)ex);
        }
        return canHandTag;
    }

    private static boolean isDigitStr(String str) {
        return Character.isDigit(str.charAt(0));
    }

    public String[] checkSendMsg(String receives, String content) {
        String[] checkData = new String[2];
        int sendCountUser = receives.split(",").length;
        int sengCount = (content.length() - 1) / 70 + 1;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            if (this.isLimitSendCount(ctx)) {
                String userId = ctx.getCaller().toString();
                IMobileMessageAssign iMobile = MobileMessageAssignFactory.getRemoteInstance();
                String cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                int sendCount = sendCountUser * sengCount;
                int sendedCount = iMobile.getSendedCountByUserId(userId, cuID);
                int cansendCount = iMobile.canSendCount(userId, cuID);
                String msg = "\u6b64\u6761\u77ed\u4fe1\u8981\u53d1\u7ed9" + sendCountUser + "\u4e2a\u7528\u6237,\u5171\u53d1\u9001\u77ed\u4fe1" + sendCount + "\u6761,\u5728\u8be5\u7cfb\u7edf\u4e2d\u8fd8\u53ef\u4ee5\u53d1\u9001" + (cansendCount - sendedCount) + "\u6761\u77ed\u4fe1";
                if (sendCount + sendedCount > cansendCount) {
                    checkData[0] = "false";
                    msg = msg + ",\u77ed\u4fe1\u5df2\u8d85\u8fc7\u9650\u5236\u6570,\u4e0d\u80fd\u53d1\u9001!";
                } else {
                    checkData[0] = "true";
                }
                checkData[1] = msg;
            } else {
                checkData[0] = "true";
                checkData[1] = "";
            }
        }
        catch (Exception e) {
            logger.error((Object)"WEB\u77ed\u4fe1\u53d1\u9001\u68c0\u67e5\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
        return checkData;
    }

    private boolean isLimitSendCount(Context ctx) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"MobileSendLimit");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6\u5f97MobileSendLimit\u53c2\u6570\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    private boolean isSMSSupportInputTelNo(Context ctx) {
        try {
            ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            String paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"SMSSupportInputTelNo");
            return Boolean.valueOf(paramValue);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d6\u5f97SMSSupportInputTelNo\u53c2\u6570\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    public String getProDefIdByAssign(String assignId) {
        String defId = null;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
            AssignmentInfo wholeInfo = service.getAssignmentById(assignId);
            defId = wholeInfo.getProcDefId();
        }
        catch (BOSException e) {
            logger.error((Object)"\u521d\u59cb\u5316\u5de5\u4f5c\u6d41\u670d\u52a1\u9519\u8bef", (Throwable)e);
        }
        return defId;
    }

    public String getProNameByAssign(String assignId) {
        String defName = null;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
            AssignmentInfo wholeInfo = service.getAssignmentById(assignId);
            Locale locale = WebContextUtil.getEasContext((HttpServletRequest)request).getLocale();
            defName = wholeInfo.getProcDefName(locale);
        }
        catch (BOSException e) {
            logger.error((Object)"\u521d\u59cb\u5316\u5de5\u4f5c\u6d41\u670d\u52a1\u9519\u8bef", (Throwable)e);
        }
        return defName;
    }

    public String isNeedNotify() {
        boolean result = BillWebAuditConfig.getInstance().isNeedNotify();
        if (result) {
            return "true";
        }
        return "false";
    }

    public boolean isShowNoConnection() {
        boolean isShow = true;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            ObjectUuidPK pk = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            String value = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)"isShowNoConnection");
            if (StringUtils.isEmpty((String)value)) {
                value = "true";
            }
            isShow = Boolean.valueOf(value);
        }
        catch (Exception e) {
            logger.error((Object)("get param isShowNoConnection error:" + e.getMessage()), (Throwable)e);
        }
        if (!this.isConnection(ctx)) {
            return isShow;
        }
        return false;
    }

    public boolean isConnection(Context ctx) {
        ServerCenter serverCenter = ServerCenter.getInstance((Context)ctx);
        boolean succeed = false;
        try {
            succeed = serverCenter.isConnect();
        }
        catch (Exception e) {
            logger.error((Object)("check connection error:" + e.getMessage()), (Throwable)e);
        }
        return succeed;
    }

    public boolean canGetWebUrl(String assignId) {
        boolean result = false;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
            String[] assignmentIds = new String[]{assignId};
            String uiName = (String)service.getEASWfServiceData(assignmentIds, false).getAssignmentArgs().get("UIClassName");
            if (!StringUtils.isEmpty((String)uiName)) {
                logger.info((Object)("UIClassName -> " + uiName));
                String name = uiName.substring(uiName.lastIndexOf(".") + 1, uiName.length());
                String bizPackgeName = uiName.substring(0, uiName.lastIndexOf("."));
                MetaDataPK metaPK = new MetaDataPK(bizPackgeName, name);
                UIObjectCtrl ctrl = new UIObjectCtrl(ctx);
                UIObjectInfo ui = ctrl.getValue((IMetaDataPK)metaPK);
                Map map = ui.getExtendedProperties();
                if (map != null && map.size() > 0 && !StringUtils.isEmpty((String)((String)map.get("url")))) {
                    logger.info((Object)("URL -> " + (String)map.get("url")));
                    result = true;
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"\u521d\u59cb\u5316\u5de5\u4f5c\u6d41\u670d\u52a1\u9519\u8bef", (Throwable)e);
        }
        return result;
    }

    public String getMessageViewConfigByMsgId(String idStr, String ifHistory) {
        String sourceIds = "";
        try {
            CoreBaseInfo msgInfo;
            if (!StringUtils.isEmpty((String)ifHistory) && ifHistory.equals("true")) {
                msgInfo = BMCMessageHistoryFactory.getRemoteInstance().getBMCMessageHistoryInfo("where id='" + idStr + "'");
                sourceIds = msgInfo.getSourceIDs();
            } else {
                msgInfo = BMCMessageFactory.getRemoteInstance().getBMCMessageInfo("where id='" + idStr + "'");
                sourceIds = msgInfo.getSourceIDs();
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            return null;
        }
        StringBuffer jsonStr = new StringBuffer();
        String[] info = new String[]{"", "", "", "", ""};
        String prefix = sourceIds.substring(0, sourceIds.indexOf("::"));
        Object obj = MessageViewConfig.getInstance(true).getConfigByPrefix(prefix);
        jsonStr.append("{");
        if (obj != null) {
            HashMap map = (HashMap)obj;
            if (map.get("web") != null) {
                info[0] = map.get("web").toString();
                jsonStr.append("web").append(":\"").append(map.get("web").toString()).append("\"");
            } else {
                jsonStr.append("web").append(":\"\"");
            }
            if (map.get("viewweb") != null) {
                Map tempMap = (Map)map.get("viewweb");
                if (tempMap.get("pageparams") != null) {
                    jsonStr.append(",").append("pageparams").append(":\"").append(tempMap.get("pageparams")).append("\"");
                }
                if (tempMap.get("model") != null) {
                    jsonStr.append(",openway:\"");
                    if (tempMap.get("model").toString().equalsIgnoreCase("true")) {
                        jsonStr.append("0\"");
                    } else {
                        jsonStr.append("2\"");
                    }
                }
            } else {
                if (map.get("width") != null && map.get("height") != null) {
                    jsonStr.append(",").append("width").append(":\"").append(map.get("width").toString()).append("\",");
                    jsonStr.append("height").append(":\"").append(map.get("height").toString()).append("\"");
                } else {
                    jsonStr.append(",").append("width").append(":\"\",").append("height").append(":\"\"");
                }
                if (map.get("model") != null) {
                    jsonStr.append(",openway:\"");
                    if (map.get("model").toString().equalsIgnoreCase("true")) {
                        jsonStr.append("0\"");
                    } else {
                        jsonStr.append("2\"");
                    }
                } else {
                    jsonStr.append(",openway:\"2\"");
                }
            }
            logger.info((Object)("--getMessageViewConfig--webUrl--" + map.get("web")));
            logger.info((Object)("--getMessageViewConfig--sourceIds--" + sourceIds));
        } else {
            jsonStr.append("web:\"\",pageparams:\"\",openway:\"2\",errorlog:\"no message view config\"");
        }
        jsonStr.append("}");
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            IMessageCenter messageCenter = MessageCenterFactory.getLocalInstance(WebContextUtil.getEasContext((HttpServletRequest)request));
            messageCenter.setReadStatus("'" + idStr + "'", MsgStatus.getEnum(10), MsgType.getEnum(0));
        }
        catch (Exception e) {
            logger.error((Object)"getMessageViewConfig\u8bbe\u7f6e\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u62a5\u9519", (Throwable)e);
        }
        return jsonStr.toString();
    }

    public String getMessageViewConfig(String idStr, String sourceIds) {
        StringBuffer jsonStr = new StringBuffer();
        String[] info = new String[]{"", "", "", "", ""};
        String prefix = sourceIds.substring(0, sourceIds.indexOf("::"));
        Object obj = MessageViewConfig.getInstance(true).getConfigByPrefix(prefix);
        jsonStr.append("{");
        if (obj != null) {
            HashMap map = (HashMap)obj;
            if (map.get("web") != null) {
                info[0] = map.get("web").toString();
                jsonStr.append("web").append(":\"").append(map.get("web").toString()).append("\"");
            } else {
                jsonStr.append("web").append(":\"\"");
            }
            if (map.get("viewweb") != null) {
                Map tempMap = (Map)map.get("viewweb");
                if (tempMap.get("pageparams") != null) {
                    jsonStr.append(",").append("pageparams").append(":\"").append(tempMap.get("pageparams")).append("\"");
                }
                if (tempMap.get("model") != null) {
                    jsonStr.append(",openway:\"");
                    if (tempMap.get("model").toString().equalsIgnoreCase("true")) {
                        jsonStr.append("0\"");
                    } else {
                        jsonStr.append("2\"");
                    }
                }
            } else {
                if (map.get("width") != null && map.get("height") != null) {
                    jsonStr.append(",").append("width").append(":\"").append(map.get("width").toString()).append("\",");
                    jsonStr.append("height").append(":\"").append(map.get("height").toString()).append("\"");
                } else {
                    jsonStr.append(",").append("width").append(":\"\",").append("height").append(":\"\"");
                }
                if (map.get("model") != null) {
                    jsonStr.append(",openway:\"");
                    if (map.get("model").toString().equalsIgnoreCase("true")) {
                        jsonStr.append("0\"");
                    } else {
                        jsonStr.append("2\"");
                    }
                } else {
                    jsonStr.append(",openway:\"2\"");
                }
            }
            logger.info((Object)("--getMessageViewConfig--webUrl--" + map.get("web")));
            logger.info((Object)("--getMessageViewConfig--sourceIds--" + sourceIds));
        } else {
            jsonStr.append("web:\"\",pageparams:\"\",openway:\"2\",errorlog:\"no message view config\"");
        }
        jsonStr.append("}");
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            IMessageCenter messageCenter = MessageCenterFactory.getLocalInstance(WebContextUtil.getEasContext((HttpServletRequest)request));
            messageCenter.setReadStatus("'" + idStr + "'", MsgStatus.getEnum(10), MsgType.getEnum(0));
        }
        catch (Exception e) {
            logger.error((Object)"getMessageViewConfig\u8bbe\u7f6e\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u62a5\u9519", (Throwable)e);
        }
        return jsonStr.toString();
    }

    public String getOpenBillConfigByMsgId(String idStr, String ifHistory) {
        StringBuffer jsonStr = new StringBuffer();
        String sourceIds = "";
        try {
            CoreBaseInfo msgInfo;
            if (!StringUtils.isEmpty((String)ifHistory) && ifHistory.equals("true")) {
                msgInfo = BMCMessageHistoryFactory.getRemoteInstance().getBMCMessageHistoryInfo("where id='" + idStr + "'");
                sourceIds = msgInfo.getSourceIDs();
            } else {
                msgInfo = BMCMessageFactory.getRemoteInstance().getBMCMessageInfo("where id='" + idStr + "'");
                sourceIds = msgInfo.getSourceIDs();
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            return null;
        }
        String prefix = sourceIds.substring(0, sourceIds.indexOf("::"));
        Object obj = MessageViewConfig.getInstance(true).getConfigByPrefix(prefix);
        jsonStr.append("{");
        if (obj != null) {
            HashMap map = (HashMap)obj;
            if (map.get("billweb") != null) {
                Map tempMap = (Map)map.get("billweb");
                if (tempMap.get("billweb") != null) {
                    jsonStr.append("billweb:").append("\"").append(tempMap.get("billweb").toString()).append("\",");
                } else {
                    jsonStr.append("billweb:\"\",");
                }
                if (tempMap.get("pageparams") != null) {
                    jsonStr.append("pageparams:").append("\"").append(tempMap.get("pageparams").toString()).append("\",");
                } else {
                    jsonStr.append("pageparams:\"\",");
                }
                String isModel = "";
                if (tempMap.get("model") != null) {
                    isModel = tempMap.get("model").toString();
                }
                if (isModel.equalsIgnoreCase("true")) {
                    jsonStr.append("openway:\"0\"");
                } else {
                    jsonStr.append("openway:\"2\"");
                }
            } else {
                jsonStr.append("billweb:\"\",pageparams:\"\",openway:\"2\"");
            }
            logger.info((Object)("--getMessageViewConfig--webUrl--" + map.get("web")));
            logger.info((Object)("--getMessageViewConfig--sourceIds--" + sourceIds));
        } else {
            jsonStr.append("billweb:\"\",pageparams:\"\",openway:\"2\",errorlog:\"no message view config\"");
        }
        jsonStr.append("}");
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            IMessageCenter messageCenter = MessageCenterFactory.getLocalInstance(WebContextUtil.getEasContext((HttpServletRequest)request));
            messageCenter.setReadStatus("'" + idStr + "'", MsgStatus.getEnum(10), MsgType.getEnum(0));
        }
        catch (Exception e) {
            logger.error((Object)"getOpenBillConfig\u8bbe\u7f6e\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u62a5\u9519", (Throwable)e);
            return jsonStr.toString();
        }
        return jsonStr.toString();
    }

    public String getOpenBillConfig(String idStr, String sourceIds) {
        StringBuffer jsonStr = new StringBuffer();
        String prefix = sourceIds.substring(0, sourceIds.indexOf("::"));
        Object obj = MessageViewConfig.getInstance(true).getConfigByPrefix(prefix);
        jsonStr.append("{");
        if (obj != null) {
            HashMap map = (HashMap)obj;
            if (map.get("billweb") != null) {
                Map tempMap = (Map)map.get("billweb");
                if (tempMap.get("billweb") != null) {
                    jsonStr.append("billweb:").append("\"").append(tempMap.get("billweb").toString()).append("\",");
                } else {
                    jsonStr.append("billweb:\"\",");
                }
                if (tempMap.get("pageparams") != null) {
                    jsonStr.append("pageparams:").append("\"").append(tempMap.get("pageparams").toString()).append("\",");
                } else {
                    jsonStr.append("pageparams:\"\",");
                }
                String isModel = "";
                if (tempMap.get("model") != null) {
                    isModel = tempMap.get("model").toString();
                }
                if (isModel.equalsIgnoreCase("true")) {
                    jsonStr.append("openway:\"0\"");
                } else {
                    jsonStr.append("openway:\"2\"");
                }
            } else {
                jsonStr.append("billweb:\"\",pageparams:\"\",openway:\"2\"");
            }
            logger.info((Object)("--getMessageViewConfig--webUrl--" + map.get("web")));
            logger.info((Object)("--getMessageViewConfig--sourceIds--" + sourceIds));
        } else {
            jsonStr.append("billweb:\"\",pageparams:\"\",openway:\"2\",errorlog:\"no message view config\"");
        }
        jsonStr.append("}");
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            IMessageCenter messageCenter = MessageCenterFactory.getLocalInstance(WebContextUtil.getEasContext((HttpServletRequest)request));
            messageCenter.setReadStatus("'" + idStr + "'", MsgStatus.getEnum(10), MsgType.getEnum(0));
        }
        catch (Exception e) {
            logger.error((Object)"getOpenBillConfig\u8bbe\u7f6e\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u62a5\u9519", (Throwable)e);
            return jsonStr.toString();
        }
        return jsonStr.toString();
    }

    public String getWebfullyBillProcName(String assignId) {
        String procDefName = this.getProNameByAssign(assignId);
        if (!StringUtils.isEmpty((String)procDefName) && this.isWebBill(assignId, procDefName)) {
            logger.info((Object)("getWebfullyBillProcName procDefName: " + procDefName));
            return procDefName;
        }
        return "";
    }

    public String getWebfullyTaskProcName(String assignId) {
        String procDefName = this.getProNameByAssign(assignId);
        if (!StringUtils.isEmpty((String)procDefName) && this.isWebTask(assignId, procDefName)) {
            logger.info((Object)("getWebfullyTaskProcName procDefName: " + procDefName));
            return procDefName;
        }
        return "";
    }

    private String isWebSupport(String billID) {
        try {
            BOSObjectType objectType = new ObjectUuidPK(billID).getObjectType();
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(objectType);
            if (entityObjectInfo != null) {
                String isDynamic = entityObjectInfo.getExtendedProperty("isDynamic");
                if ("true".equalsIgnoreCase(isDynamic)) {
                    return "true";
                }
                String webSupport = entityObjectInfo.getExtendedProperty("isSupportWeb");
                if ("true".equalsIgnoreCase(webSupport)) {
                    return "true";
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"get entity by bill id error", (Throwable)ex);
            return "false";
        }
        return "false";
    }

    public String isBillSupportWeb(String assignId) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            AssignmentInfo assInfo = iEnactmentService.getAssignmentById(assignId);
            String[] bizObjectID = assInfo.getBizObjectIdArray();
            if (bizObjectID != null && bizObjectID[0] != null) {
                return this.isWebSupport(bizObjectID[0]);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"isBillSupportWeb\u5224\u65ad\u5df2\u529e\u6d41\u7a0b\u5355\u636e\u662f\u5426\u652f\u6301web\u51fa\u9519", (Throwable)e);
        }
        return "false";
    }

    public boolean ifShowCounterSignBtn(String assignId) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        boolean isDynamicSign = false;
        IVaryTaskFacade varyTaskFacade = null;
        try {
            varyTaskFacade = VaryTaskFacadeFactory.getLocalInstance(ctx);
            isDynamicSign = varyTaskFacade.ifShowCounterSignBtn(assignId);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            isDynamicSign = false;
        }
        return isDynamicSign;
    }

    public String getAssignStateByMsgId(String msgId) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String msgSourceStatus = "";
        msgSourceStatus = ProcessCenterUtil.getAssignStateByMsgId(msgId, ctx);
        return msgSourceStatus;
    }
}

