/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WfState;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.webservice.MessageServiceConfig;
import com.kingdee.eas.base.message.webservice.WSConfigInfo;
import com.kingdee.eas.base.message.webservice.WSMessage;
import com.kingdee.eas.base.message.webservice.WfrAssignMessage;
import com.kingdee.eas.base.message.webservice.WfrProcMessage;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MCInvoke {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.message.webservice.MCInvoke");
    private static final MCInvoke invoke = new MCInvoke();
    private static List configList = null;

    private MCInvoke() {
    }

    public static WSMessage intoMessage(BMCMessageInfo messageInfo, Context ctx) {
        WSMessage message = new WSMessage();
        message.setMsgID(messageInfo.getId().toString());
        message.setRecieverID(messageInfo.getReceiver());
        message.setBizType(messageInfo.getBizType());
        message.setType(messageInfo.getType());
        message.setTitle(messageInfo.getTitle());
        message.setBody(messageInfo.getBody());
        message.setPriority(messageInfo.getPriority());
        message.setSendTime(messageInfo.getSendTime());
        message.setReceiveTime(messageInfo.getReceiveTime());
        message.setSourceID(messageInfo.getSourceID());
        message.setSender(messageInfo.getSender());
        message.setState(messageInfo.getStatus());
        message.setOrgID(messageInfo.getOrgID());
        message.setLocale(ctx.getLocale());
        message.setContext(ctx);
        try {
            logger.debug((Object)("Receiver ID :" + messageInfo.getReceiver()));
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(messageInfo.getReceiver()));
            logger.debug((Object)"String number = userInfo.getNumber();");
            String number = userInfo.getNumber();
            message.setRecieveNumber(number);
            message.setReceivers(userInfo.getName(ctx.getLocale()));
            String senderId = "";
            senderId = !StringUtils.isEmpty((String)messageInfo.getSenderId()) ? messageInfo.getSenderId() : ctx.getCaller().toString();
            message.setSenderNumber(UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(senderId)).getNumber());
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519:" + e.getMessage()), (Throwable)e);
        }
        return message;
    }

    public static WSMessage intoMessage(AssignReadInfo messageInfo, Context ctx) {
        WSMessage message = new WSMessage();
        AssignmentInfo assInfo = null;
        Locale locale = ctx.getLocale();
        try {
            EnactmentServiceProxy iEnactmentService = new EnactmentServiceProxy(ctx);
            assInfo = iEnactmentService.getAssignmentById(messageInfo.getAssignID().toString());
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6\u4efb\u52a1\u6d88\u606fInfo\u5bf9\u8c61\u51fa\u9519:" + e.getMessage()), (Throwable)e);
        }
        message.setMsgID(messageInfo.getId().toString());
        message.setBizType(MsgBizType.WORKFLOW);
        message.setType(MsgType.TASK);
        message.setTitle(assInfo.getSubject(locale));
        message.setBody(assInfo.getBody(locale));
        message.setPriority(MsgPriority.MIDDLE);
        message.setOrgID(messageInfo.getOrgID());
        message.setSender(messageInfo.getSender());
        message.setState(messageInfo.getStatus());
        message.setSendTime(assInfo.getCreatedTime());
        message.setReceiveTime(new Timestamp(new Date().getTime()));
        message.setRecieverID(assInfo.getUserId());
        message.setLocale(locale);
        message.setReceivers(assInfo.getUserName(locale));
        message.setSourceID(messageInfo.getAssignID().toString());
        message.setSender(messageInfo.getSender());
        message.setContext(ctx);
        message.setProcInstId(assInfo.getProcInstId());
        String billID = assInfo.getBizObjectIds();
        message.setBillId(billID);
        message.setActName(assInfo.getActDefName(locale));
        message.setBillNumber(MCInvoke.getBillNumber(ctx, billID));
        try {
            message.setRecieveNumber(UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(assInfo.getUserId())).getNumber());
            message.setSenderNumber(UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(messageInfo.getSenderId())).getNumber());
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u65f6\u51fa\u9519:" + e.getMessage()), (Throwable)e);
        }
        return message;
    }

    public WfrProcMessage intoWfrProcMessage(ProcessInstInfo processInstInfo, HashMap<String, String> extInfoMap, Context ctx) {
        String billId = extInfoMap.get("billId");
        String orgId = extInfoMap.get("orgId");
        int isAdd = Integer.parseInt(extInfoMap.get("isAdd"));
        WfrProcMessage wfrProcMsg = new WfrProcMessage();
        wfrProcMsg.setProcCode(processInstInfo.getCode());
        wfrProcMsg.setProcInstId(processInstInfo.getProcInstId());
        wfrProcMsg.setProcState(processInstInfo.getState());
        wfrProcMsg.setProcStateName(WfState.getEnum((String)processInstInfo.getState()).getAlias());
        wfrProcMsg.setProcSubject(processInstInfo.getInstTopic(ctx.getLocale()));
        wfrProcMsg.setCreatedtime(processInstInfo.getCreatedTime());
        wfrProcMsg.setUpdateTime(processInstInfo.getLastStateTime());
        wfrProcMsg.setBillID(billId);
        wfrProcMsg.setBillNumber(MCInvoke.getBillNumber(ctx, billId));
        wfrProcMsg.setInitiator(processInstInfo.getInitiatorName(ctx.getLocale()));
        wfrProcMsg.setInitiatorNumber(this.getPersonNumByUid(ctx, processInstInfo.getInitiatorId()).getNumber());
        wfrProcMsg.setInitiatorId(processInstInfo.getInitiatorId());
        wfrProcMsg.setOrgID(orgId);
        wfrProcMsg.setIsAdd(isAdd);
        return wfrProcMsg;
    }

    private static String getBillNumber(Context ctx, String billId) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("number"));
        IObjectValue o = null;
        try {
            o = ScriptUtil.getBizObject((Context)ctx, (String)billId, (SelectorItemCollection)selectors, (boolean)false);
        }
        catch (WfException e) {
            logger.error((Object)"\u83b7\u53d6\u5355\u636e\u5bf9\u8c61\u5931\u8d25\u3002");
        }
        return (String)o.get("number");
    }

    public WfrAssignMessage intoWfrAssignMessage(AssignmentInfo assignInfo, HashMap<String, String> extInfoMap, Context ctx) {
        WfrAssignMessage wfrAssignMsg = new WfrAssignMessage();
        wfrAssignMsg.setAssignId(assignInfo.getAssignmentId());
        wfrAssignMsg.setAssignSubject(assignInfo.getSubject(ctx.getLocale()));
        wfrAssignMsg.setProcInstId(assignInfo.getProcInstId());
        wfrAssignMsg.setState(assignInfo.getState().getName());
        wfrAssignMsg.setStateName(WfAssignmentState.getEnum((int)assignInfo.getState().getValue()).getAlias());
        wfrAssignMsg.setAcceptTime(assignInfo.getAcceptTime());
        wfrAssignMsg.setDealTime(assignInfo.getEndTime());
        String billId = assignInfo.getBizObjectIds();
        wfrAssignMsg.setBillID(billId);
        wfrAssignMsg.setBillNumber(MCInvoke.getBillNumber(ctx, billId));
        String[] user = this.getInitorByAssignInfo(assignInfo, ctx);
        if (user != null) {
            wfrAssignMsg.setInitiator(user[0]);
            wfrAssignMsg.setInitiatorNumber(user[1]);
        }
        wfrAssignMsg.setHandler(assignInfo.getUserName(ctx.getLocale()));
        wfrAssignMsg.setHandlerId(assignInfo.getUserId());
        wfrAssignMsg.setActName(assignInfo.getActDefName(ctx.getLocale()));
        wfrAssignMsg.setHandlerNumber(this.getPersonNumByUid(ctx, assignInfo.getUserId()).getNumber());
        String orgId = "";
        if (extInfoMap != null) {
            orgId = extInfoMap.get("orgId");
        }
        wfrAssignMsg.setOrgID(orgId);
        return wfrAssignMsg;
    }

    public void wsImplReadCplAssign(AssignmentInfo assignInfo, HashMap<String, String> extMapInfo, Context ctx) {
        WfrAssignMessage wfrAssignMsg = this.intoWfrAssignMessage(assignInfo, extMapInfo, ctx);
        String methodName = "addCompletedMessage";
        this.parseCfgAndInvoke(methodName, wfrAssignMsg, ctx);
    }

    public void wsImplReadMyProcInfo(ProcessInstInfo processInstInfo, HashMap<String, String> extInfoMap, Context ctx) {
        WfrProcMessage wfrProcMsg = this.intoWfrProcMessage(processInstInfo, extInfoMap, ctx);
        String methodName = "addInitiatorMessage";
        this.parseCfgAndInvoke(methodName, wfrProcMsg, ctx);
    }

    public void wsImplRead(WSMessage message, Context ctx) {
        if (configList == null) {
            return;
        }
        if (configList.size() == 0) {
            logger.error((Object)"WSConfig\u914d\u7f6e\u4fe1\u606f\u4e0d\u6b63\u786e");
            return;
        }
        for (WSConfigInfo configInfo : configList) {
            if (configInfo.getClassName() == null || configInfo.getClassName().trim().length() == 0) {
                logger.error((Object)"WSConfig\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u9519\u8bef\uff01");
                throw new RuntimeException("wrong config in the WSConfig.xml");
            }
            if (!this.ifExecute(configInfo, message, ctx)) continue;
            try {
                message.setUrl(configInfo.getServerPath());
                configInfo.getMessServiceDao().addMessage(message);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void wsImplRemoveBMC(BMCMessageInfo messageInfo, Context ctx) {
        if (configList == null) {
            return;
        }
        if (configList.size() == 0) {
            logger.error((Object)"\u914d\u7f6e\u4fe1\u606f\u4e0d\u6b63\u786e");
            return;
        }
        WSMessage message = new WSMessage();
        message.setType(messageInfo.getType());
        message.setBizType(messageInfo.getBizType());
        for (WSConfigInfo configInfo : configList) {
            if (configInfo.getClassName() == null || configInfo.getClassName().trim().length() == 0) {
                logger.error((Object)"\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u9519\u8bef\uff01");
                throw new RuntimeException("wrong config in the WSConfig.xml");
            }
            if (!this.ifExecute(configInfo, message, ctx)) continue;
            try {
                try {
                    Class.forName(configInfo.getClassName()).getDeclaredMethod("removeMessage", String.class, Context.class);
                    configInfo.getMessServiceDao().removeMessage(messageInfo.getId().toString(), ctx);
                }
                catch (NoSuchMethodException e) {
                    configInfo.getMessServiceDao().removeMessage(messageInfo.getId().toString());
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void wsImplRemoveAss(List IDList, Context ctx) {
        if (configList == null) {
            return;
        }
        if (configList.size() == 0) {
            logger.error((Object)"\u914d\u7f6e\u4fe1\u606f\u4e0d\u6b63\u786e");
            return;
        }
        WSMessage message = new WSMessage();
        message.setType(MsgType.TASK);
        message.setBizType(MsgBizType.WORKFLOW);
        for (WSConfigInfo configInfo : configList) {
            if (configInfo.getClassName() == null || configInfo.getClassName().trim().length() == 0) {
                logger.error((Object)"\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u9519\u8bef\uff01");
                throw new RuntimeException("wrong config in the WSConfig.xml");
            }
            if (configInfo.getMessServiceDao() == null) {
                logger.error((Object)("\u672a\u80fd\u6210\u529f\u52a0\u8f7d" + configInfo.getClassName()));
                continue;
            }
            if (!this.ifExecute(configInfo, message, ctx)) continue;
            try {
                try {
                    Class.forName(configInfo.getClassName()).getDeclaredMethod("removeMessage", String.class, Context.class);
                    for (int i = 0; i < IDList.size(); ++i) {
                        configInfo.getMessServiceDao().removeMessage((String)IDList.get(i), ctx);
                    }
                }
                catch (NoSuchMethodException e) {
                    for (int i = 0; i < IDList.size(); ++i) {
                        configInfo.getMessServiceDao().removeMessage((String)IDList.get(i));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void wsImplUpdate(WSMessage message, Context ctx) {
        if (configList == null) {
            return;
        }
        if (configList.size() == 0) {
            logger.error((Object)"\u914d\u7f6e\u4fe1\u606f\u4e0d\u6b63\u786e");
            return;
        }
        for (WSConfigInfo configInfo : configList) {
            if (configInfo.getClassName() == null || configInfo.getClassName().trim().length() == 0) {
                logger.error((Object)"\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u9519\u8bef\uff01");
                throw new RuntimeException("wrong config in the WSConfig.xml");
            }
            if (!this.ifExecute(configInfo, message, ctx)) continue;
            try {
                try {
                    configInfo.getMessServiceDao().updateMessage(message.getMsgID(), ctx);
                }
                catch (AbstractMethodError e) {
                    configInfo.getMessServiceDao().updateMessage(message.getMsgID());
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void wsImplUpdateMulti(String IDs, MsgStatus state, Context ctx) {
        if (configList == null) {
            return;
        }
        if (configList.size() == 0) {
            logger.error((Object)"\u914d\u7f6e\u4fe1\u606f\u4e0d\u6b63\u786e");
            return;
        }
        for (WSConfigInfo configInfo : configList) {
            if (configInfo.getClassName() == null || configInfo.getClassName().trim().length() == 0) {
                logger.error((Object)"\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u9519\u8bef\uff01");
                throw new RuntimeException("wrong config in the WSConfig.xml");
            }
            if (configInfo.getMessServiceDao() == null) {
                logger.error((Object)("\u672a\u80fd\u6210\u529f\u52a0\u8f7d" + configInfo.getClassName()));
                continue;
            }
            try {
                try {
                    configInfo.getMessServiceDao().updateMessages(IDs, state, ctx);
                }
                catch (AbstractMethodError e) {
                    configInfo.getMessServiceDao().updateMessages(IDs, state);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean ifExecute(WSConfigInfo configInfo, WSMessage messageInfo, Context ctx) {
        boolean push = false;
        if (!ctx.getAIS().equals(configInfo.getDataCenter())) {
            return push;
        }
        push = configInfo.isTask() && MsgType.TASK.equals((Object)messageInfo.getType()) ? true : (configInfo.isNotice() && MsgType.NOTICE.equals((Object)messageInfo.getType()) ? (configInfo.isNotice_workFlow() && MsgBizType.WORKFLOW.equals((Object)messageInfo.getBizType()) ? true : (configInfo.isNotice_Forwarn() && MsgBizType.FORWARN.equals((Object)messageInfo.getBizType()) ? true : (configInfo.isNotice_online() && !MsgBizType.ONLINE.equals((Object)messageInfo.getBizType()) ? true : (configInfo.isNotice_office() && !MsgBizType.OFFICE.equals((Object)messageInfo.getBizType()) ? true : (configInfo.isNotice_Urgent() && MsgBizType.URGENT.equals((Object)messageInfo.getBizType()) ? true : (configInfo.isNotice_async() && !MsgBizType.ASYNCHRONISM.equals((Object)messageInfo.getBizType()) ? true : (configInfo.isNotice_xitongoffice() && !MsgBizType.XITONGOFFICE.equals((Object)messageInfo.getBizType()) ? true : configInfo.isNotice_hr() && !MsgBizType.HR.equals((Object)messageInfo.getBizType())))))))) : configInfo.isOnline() && MsgType.ONLINE.equals((Object)messageInfo.getType()));
        return push;
    }

    public static MCInvoke getInstance() {
        return invoke;
    }

    private UserInfo getPersonNumByUid(Context ctx, String userId) {
        if (userId == null) {
            logger.error((Object)("\u7b2c\u4e09\u65b9\u6d88\u606f\u63a8\u9001\uff1a\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u7528\u6237id\u4e3a\uff1a" + userId));
            return null;
        }
        UserInfo userInfo = null;
        try {
            userInfo = UserFactory.getLocalInstance((Context)ctx).getUserByID((IObjectPK)new ObjectStringPK(userId));
        }
        catch (EASBizException e) {
            logger.error((Object)("\u7b2c\u4e09\u65b9\u6d88\u606f\u63a8\u9001\uff1a\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u7528\u6237id\u4e3a\uff1a" + userId));
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)("\u7b2c\u4e09\u65b9\u6d88\u606f\u63a8\u9001\uff1a\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u7528\u6237id\u4e3a\uff1a" + userId));
            logger.error((Object)e);
        }
        return userInfo;
    }

    private void parseCfgAndInvoke(String methodName, Object obj, Context ctx) {
        if (configList == null) {
            return;
        }
        if (configList.size() == 0) {
            logger.error((Object)"WSConfig.xml\u914d\u7f6e\u4fe1\u606f\u4e0d\u6b63\u786e");
            return;
        }
        for (WSConfigInfo configInfo : configList) {
            if (configInfo.getClassName() == null || configInfo.getClassName().trim().length() == 0) {
                logger.error((Object)"WSConfig.xml\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e\u9519\u8bef\uff01");
                throw new RuntimeException("wrong config in the WSConfig.xml");
            }
            if (configInfo.getMessServiceDao() == null) {
                logger.error((Object)("\u672a\u80fd\u6210\u529f\u52a0\u8f7d" + configInfo.getClassName()));
                continue;
            }
            if (!configInfo.getDataCenter().equals(ctx.getAIS())) continue;
            try {
                if ("addInitiatorMessage".equals(methodName)) {
                    WfrProcMessage wfrProcMsg = (WfrProcMessage)obj;
                    wfrProcMsg.setCtx(ctx);
                    configInfo.getMessServiceDao().addInitiatorMessage(wfrProcMsg);
                    continue;
                }
                if (!"addCompletedMessage".equals(methodName)) continue;
                WfrAssignMessage wfrAssignMsg = (WfrAssignMessage)obj;
                wfrAssignMsg.setCtx(ctx);
                configInfo.getMessServiceDao().addCompletedMessage(wfrAssignMsg);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private String[] getInitorByAssignInfo(AssignmentInfo assignInfo, Context ctx) {
        String fnumber = "";
        String fname_l2 = "";
        String procinstId = assignInfo.getProcInstId();
        String procSql = "select fnumber,fname_l2 from t_pm_user a left join t_wfr_procinst b on a.fid = b.FINITIATORID where b.FPROCINSTID ='" + procinstId + "'";
        try {
            fnumber = (String)((Map)SQL.executeQuery((Context)ctx, (String)procSql).get(0)).get("fnumber");
            fname_l2 = (String)((Map)SQL.executeQuery((Context)ctx, (String)procSql).get(0)).get("fname_l2");
        }
        catch (Exception e) {
            logger.error((Object)("\u7b2c\u4e09\u65b9\u6d88\u606f\u63a8\u9001\uff1a\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25,\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a\uff1a" + procinstId + ";\u5f02\u5e38\u4fe1\u606f\u4e3a" + e));
            return null;
        }
        return new String[]{fname_l2, fnumber};
    }

    static {
        configList = MessageServiceConfig.getMSConfig().LoadConfig();
    }
}

