/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.webservice.IOtherAssignHandler;
import com.kingdee.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OtherAssignHandlerManager {
    private static Map<String, IOtherAssignHandler> handlers = new ConcurrentHashMap<String, IOtherAssignHandler>();

    public static String getAssignHandleUrl(Context ctx, String otherType, String assignId) throws BOSException {
        if (StringUtils.isEmpty((String)otherType)) {
            throw new BOSException("otherType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        IOtherAssignHandler handler = handlers.get(otherType);
        if (handler == null) {
            handler = OtherAssignHandlerManager.initOtherAssignHandler(otherType);
        }
        return handler.getAssignHandleUrl(ctx, assignId);
    }

    public static String getAssignDetailHandleUrl(Context ctx, String otherType, String assignId) throws BOSException {
        if (StringUtils.isEmpty((String)otherType)) {
            throw new BOSException("otherType \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        IOtherAssignHandler handler = handlers.get(otherType);
        if (handler == null) {
            handler = OtherAssignHandlerManager.initOtherAssignHandler(otherType);
        }
        return handler.getAssignDetailHandleUrl(ctx, assignId);
    }

    private static IOtherAssignHandler initOtherAssignHandler(String otherType) throws BOSException {
        IOtherAssignHandler handler;
        try {
            String clazz = otherType.toUpperCase() + "AssignHandler";
            handler = (IOtherAssignHandler)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new BOSException(otherType + " \u5bf9\u5e94\u7684AssignHandler\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
        return handler;
    }
}

