/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.IWFSsclog;
import com.kingdee.eas.base.message.SCOperationEnum;
import com.kingdee.eas.base.message.WFSsclogFactory;
import com.kingdee.eas.base.message.WFSsclogInfo;
import com.kingdee.eas.base.message.webservice.WriteServiceLogReq;
import org.apache.log4j.Logger;

public class WebServiceSscLogUtil {
    private static Logger logger = Logger.getLogger(WebServiceSscLogUtil.class);

    public static void writeServiceLog(WriteServiceLogReq writeServiceLogReq) throws BOSException {
        WebServiceSscLogUtil.writeServiceLog(writeServiceLogReq.getCtx(), writeServiceLogReq.getAssignId(), writeServiceLogReq.getBillId(), writeServiceLogReq.getApi(), writeServiceLogReq.getParam(), writeServiceLogReq.getResponse(), writeServiceLogReq.getSubject(), writeServiceLogReq.isIssuccess(), writeServiceLogReq.getErrorStack(), writeServiceLogReq.getExecuteTime(), writeServiceLogReq.getOperation(), writeServiceLogReq.getShareCenterId());
    }

    public static void writeServiceLog(Context ctx, String assignId, String billId, String api, String param, String response, String subject, boolean issuccess, String errorStack, long executeTime, String operation, String shareCenterId) throws BOSException {
        try {
            WFSsclogInfo tWFSsclogInfo = new WFSsclogInfo();
            tWFSsclogInfo.setAssignId(assignId);
            tWFSsclogInfo.setBillId(billId);
            tWFSsclogInfo.setApi(api);
            if (param.length() > 500) {
                param = param.substring(0, 500);
            }
            tWFSsclogInfo.setParam(param);
            tWFSsclogInfo.setResponse(response);
            if (subject.length() > 500) {
                subject = subject.substring(0, 500);
            }
            tWFSsclogInfo.setSubject(subject);
            tWFSsclogInfo.setIsSuccess(issuccess);
            tWFSsclogInfo.setErrorStack(errorStack);
            tWFSsclogInfo.setExecuteTime(new Long(executeTime / 1000L).intValue());
            tWFSsclogInfo.setOperation(SCOperationEnum.getEnum(operation));
            tWFSsclogInfo.setShareCenterId(shareCenterId);
            IWFSsclog iwfssclog = null;
            iwfssclog = ctx == null ? WFSsclogFactory.getRemoteInstance() : WFSsclogFactory.getLocalInstance(ctx);
            iwfssclog.addnew(tWFSsclogInfo);
        }
        catch (Exception e) {
            logger.error((Object)("-------WebServiceSscLogUtil----add WFSsclogInfo error " + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
    }

    public static String exceptionToString(Exception e) {
        StringBuffer sb = new StringBuffer("");
        try {
            if (e == null) {
                return "";
            }
            sb.append(e.toString()).append("\n");
            StackTraceElement[] stack = e.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                sb.append(stack[i].toString()).append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }
}

