/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.person.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.exception.WfParticipantException;
import com.kingdee.bos.workflow.participant.Group;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.OrgUnitInfo;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.participant.PositionInfo;
import com.kingdee.eas.base.message.MAGroupCollection;
import com.kingdee.eas.base.message.MAGroupFactory;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyCollection;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.IJob;
import com.kingdee.eas.basedata.org.INewOrgUnitFacade;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyFactory;
import com.kingdee.eas.basedata.org.PositionHierarchyInfo;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.app.OrgAppUtils;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PersonToWFAdapter
implements IParticipantProvider {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.person.app.PersonToWFAdapter");

    public BOSObjectType getType() {
        return new BOSObjectType("HRWFPPVE");
    }

    private Person[] getSuperAndSubPersons(Context context, String id, int type, String hierarchyId) throws WfParticipantException {
        return this.getSuperAndSubPersons(context, id, type, hierarchyId, null);
    }

    private Person[] getSuperAndSubPersons(Context context, String id, int type, String hierarchyId, String positionId) throws WfParticipantException {
        FilterInfo filter = new FilterInfo();
        String filterStr = null;
        String idStr = null;
        String nameStr = null;
        String userIdStr = null;
        String userNameStr = null;
        String postIdStr = null;
        String currentPersonId = id;
        String empTypeStr = null;
        String userStr = null;
        switch (type) {
            case 0: {
                filterStr = "childUser.id";
                idStr = "parentPerson.id";
                nameStr = "parentPerson.name";
                empTypeStr = "ppEmpType";
                userIdStr = "parentUser.id";
                userNameStr = "parentUser.name";
                userStr = "parentUser";
                postIdStr = "childPosition.id";
                break;
            }
            case 1: {
                filterStr = "parentUser.id";
                idStr = "childPerson.id";
                nameStr = "childPerson.name";
                empTypeStr = "cpEmpType";
                userIdStr = "childUser.id";
                userNameStr = "childUser.name";
                userStr = "childUser";
                postIdStr = "parentPosition.id";
                break;
            }
            case 2: {
                filterStr = "childPerson.id";
                idStr = "parentPerson.id";
                nameStr = "parentPerson.name";
                empTypeStr = "ppEmpType";
                userIdStr = "parentUser.id";
                userNameStr = "parentUser.name";
                userStr = "parentUser";
                postIdStr = "childPosition.id";
                currentPersonId = id;
                break;
            }
            case 3: {
                filterStr = "parentPerson.id";
                idStr = "childPerson.id";
                nameStr = "childPerson.name";
                empTypeStr = "cpEmpType";
                userIdStr = "childUser.id";
                userNameStr = "childUser.name";
                userStr = "childUser";
                postIdStr = "parentPosition.id";
                currentPersonId = id;
            }
        }
        if (type == 0 || type == 1) {
            currentPersonId = this.getPersonByUserId(context, id).getEmployeeId();
            filter.getFilterItems().add(new FilterItemInfo(filterStr, (Object)id));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(filterStr, (Object)id));
        }
        if (hierarchyId == null || hierarchyId.trim().length() == 0) {
            if (positionId == null || positionId.trim().length() == 0) {
                filter.setMaskString("#0");
            } else {
                filter.getFilterItems().add(new FilterItemInfo(postIdStr, (Object)positionId, CompareType.EQUALS));
                filter.setMaskString("#0 and #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)hierarchyId, CompareType.EQUALS));
            if (positionId == null || positionId.trim().length() == 0) {
                filter.setMaskString("#0 and #1");
            } else {
                filter.getFilterItems().add(new FilterItemInfo(postIdStr, (Object)positionId, CompareType.EQUALS));
                filter.setMaskString("#0 and #1 and #2");
            }
        }
        this.mergeEmpTypeFilter(empTypeStr, filter);
        this.mergeUserFilter(userStr, filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.SuperAndSubPersons");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            return this.getPersonArrayByIRowSet(context, queryExec.executeQuery(), idStr, nameStr, userIdStr, userNameStr);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    private void mergeEmpTypeFilter(String empTypeStr, FilterInfo filter) throws WfParticipantException {
        if (filter == null || empTypeStr == null) {
            return;
        }
    }

    private void mergeUserFilter(String userStr, FilterInfo filter) throws WfParticipantException {
        if (filter == null) {
            return;
        }
        String isDelete = "isDelete";
        String isForbidden = "isForbidden";
        String effectiveDate = "effectiveDate";
        String invalidationDate = "invalidationDate";
        if (userStr != null) {
            isDelete = userStr + "." + isDelete;
            isForbidden = userStr + "." + isForbidden;
            effectiveDate = userStr + "." + effectiveDate;
            invalidationDate = userStr + "." + invalidationDate;
        }
        FilterInfo userFilter = new FilterInfo();
        userFilter.getFilterItems().add(new FilterItemInfo(isDelete, (Object)Boolean.FALSE));
        userFilter.getFilterItems().add(new FilterItemInfo(isForbidden, (Object)Boolean.FALSE));
        Date date = new Date();
        Date InvalidDate = this.getInvalidDate();
        userFilter.getFilterItems().add(new FilterItemInfo(effectiveDate, (Object)date, CompareType.LESS));
        userFilter.getFilterItems().add(new FilterItemInfo(invalidationDate, (Object)InvalidDate, CompareType.GREATER));
        try {
            filter.mergeFilter(userFilter, "and");
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    private Date getInvalidDate() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(6, -1);
        calendar.add(13, 1);
        return calendar.getTime();
    }

    private PositionInfo[] getPositionArrayByPersons(Context context, String[] personIds) throws WfParticipantException {
        double d = new Integer(personIds.length).doubleValue();
        HashSet[] sets = new HashSet[new Double(Math.ceil(d / (double)OrgAppUtils.IN_CLAUSE_COUNT)).intValue()];
        ArrayList[] tmp = new ArrayList[sets.length];
        EntityViewInfo evi = null;
        FilterInfo filter = null;
        evi = new EntityViewInfo();
        int count = 0;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PersonToPositions");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        for (int i = 0; i < sets.length; ++i) {
            filter = new FilterInfo();
            sets[i] = new HashSet();
            count = i * OrgAppUtils.IN_CLAUSE_COUNT + OrgAppUtils.IN_CLAUSE_COUNT >= personIds.length ? personIds.length : i * OrgAppUtils.IN_CLAUSE_COUNT + OrgAppUtils.IN_CLAUSE_COUNT;
            for (int j = i * OrgAppUtils.IN_CLAUSE_COUNT; j < count; ++j) {
                sets[i].add(personIds[j]);
            }
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)sets[i], CompareType.INCLUDE));
            if (evi.getFilter() != null) {
                evi.getFilter().clear();
            }
            evi.setFilter(filter);
            if (queryExcu.getObjectView() != null) {
                queryExcu.getObjectView().clear();
            }
            queryExcu.setObjectView(evi);
            try {
                tmp[i] = this.getPositionListByIRowSet(context, queryExcu.executeQuery());
                continue;
            }
            catch (BOSException e) {
                throw new WfParticipantException((Throwable)e);
            }
            catch (SQLException e) {
                throw new WfParticipantException((Throwable)e);
            }
        }
        int positionCount = 0;
        for (int i = 0; i < tmp.length; ++i) {
            positionCount += tmp[i].size();
        }
        PositionInfo[] wfPostions = new PositionInfo[positionCount];
        int tmpCount = 0;
        for (int i = 0; i < tmp.length; ++i) {
            for (int j = 0; j < tmp[i].size(); ++j) {
                wfPostions[tmpCount] = (PositionInfo)tmp[i].get(j);
                ++tmpCount;
            }
        }
        return wfPostions;
    }

    private Person[] getPersonArrayByIRowSet(Context context, IRowSet rows, String idStr, String nameStr, String userIdStr, String userNameStr) throws SQLException {
        return this.getPersonArrayByIRowSet(context, rows, idStr, nameStr, userIdStr, userNameStr, false);
    }

    private Person[] getPersonArrayByIRowSet(Context context, IRowSet rows) throws SQLException {
        return this.getPersonArrayByIRowSet(context, rows, null, null, null, null, false);
    }

    private Person[] getPersonArrayByIRowSet(Context context, IRowSet rows, String idStr, String nameStr, String userIdStr, String userNameStr, boolean removeDuplicate) throws SQLException {
        if (idStr == null) {
            idStr = "person.id";
        }
        if (nameStr == null) {
            nameStr = "person.name";
        }
        if (userIdStr == null) {
            userIdStr = "user.id";
        }
        if (userNameStr == null) {
            userNameStr = "user.name";
        }
        Locale l1 = new Locale("l1");
        Locale l2 = new Locale("l2");
        Locale l3 = new Locale("l3");
        StringBuffer userSB = new StringBuffer();
        String userFilter = "";
        int count = rows.size();
        while (rows.next()) {
            String userId = rows.getString(userIdStr);
            userSB.append("'").append(userId).append("',");
        }
        int len = userSB.length();
        Person[] persons = new Person[]{};
        if (len > 0) {
            userFilter = userSB.substring(0, len - 1);
            String sql = "SELECT a.fid as employeeId,a.FNAME_L1 as employee_l1,a.FNAME_L2 as employee_l2,a.FNAME_L3 as employee_l3,b.FID as userId,b.FNAME_L1 as username_l1,b.FNAME_L2 as username_l2,b.FNAME_L3 as username_l3 FROM T_pm_user b left outer join T_bd_person a on b.fpersonid =a.FID where b.fid in (" + userFilter + ")";
            try {
                rows = DbUtil.executeQuery((Context)context, (String)sql);
                if (removeDuplicate) {
                    int i;
                    Person person = null;
                    boolean hasSamePerson = false;
                    ArrayList<Person> list = new ArrayList<Person>();
                    while (rows.next()) {
                        person = new Person();
                        person.setEmployeeId(rows.getString("employeeId"));
                        person.setEmployeeName(l1, rows.getString("employee_l1"));
                        person.setEmployeeName(l2, rows.getString("employee_l2"));
                        person.setEmployeeName(l3, rows.getString("employee_l3"));
                        person.setUserId(rows.getString("userId"));
                        person.setUserName(l1, rows.getString("username_l1"));
                        person.setUserName(l2, rows.getString("username_l2"));
                        person.setUserName(l3, rows.getString("username_l3"));
                        hasSamePerson = false;
                        for (i = 0; i < list.size(); ++i) {
                            if (!((Person)list.get(i)).getEmployeeId().equals(person.getEmployeeId())) continue;
                            hasSamePerson = true;
                            break;
                        }
                        if (hasSamePerson) continue;
                        list.add(person);
                    }
                    rows.close();
                    persons = new Person[list.size()];
                    for (i = 0; i < list.size(); ++i) {
                        persons[i] = (Person)list.get(i);
                    }
                } else {
                    int i = 0;
                    int curCount = rows.size();
                    persons = new Person[count];
                    while (rows.next()) {
                        persons[i] = new Person();
                        persons[i].setEmployeeId(rows.getString("employeeId"));
                        persons[i].setEmployeeName(l1, rows.getString("employee_l1"));
                        persons[i].setEmployeeName(l2, rows.getString("employee_l2"));
                        persons[i].setEmployeeName(l3, rows.getString("employee_l3"));
                        persons[i].setUserId(rows.getString("userId"));
                        persons[i].setUserName(l1, rows.getString("username_l1"));
                        persons[i].setUserName(l2, rows.getString("username_l2"));
                        persons[i].setUserName(l3, rows.getString("username_l3"));
                        ++i;
                    }
                    int diff = count - curCount;
                    for (int j = 0; j < diff; ++j) {
                        persons[i + j] = persons[i - 1];
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return persons;
    }

    private String getPersonIdByUserId(Context context, String userId) throws BOSException {
        IUser iUser = UserFactory.getLocalInstance((Context)context);
        try {
            return iUser.getUserInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId))).getId().toString();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        catch (UuidException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private ArrayList getPositionListByIRowSet(Context context, IRowSet rows) throws SQLException {
        ArrayList<PositionInfo> list = new ArrayList<PositionInfo>();
        PositionInfo position = null;
        while (rows.next()) {
            position = new PositionInfo();
            position.setId(rows.getString("id"));
            position.setName(context.getLocale(), rows.getString("name"));
            position.setOrgId(rows.getString("AdminOrg.id"));
            position.setOrgName(context.getLocale(), rows.getString("AdminOrg.name"));
            list.add(position);
        }
        return list;
    }

    public Person[] getPersonByUserIds(Context context, String[] userIds) throws WfParticipantException {
        IRowSet rows;
        LowTimer t = new LowTimer();
        t.reset();
        FilterInfo filter = new FilterInfo();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < userIds.length; ++i) {
            set.add(userIds[i]);
        }
        filter.getFilterItems().add(new FilterItemInfo("User.id", set, CompareType.INCLUDE));
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("User", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PersonFromUser");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        Person[] wfPersonInfos = new Person[]{};
        try {
            rows = queryExec.executeQuery();
        }
        catch (BOSException e1) {
            throw new WfParticipantException((Throwable)e1);
        }
        try {
            wfPersonInfos = new Person[rows.size()];
            int i = 0;
            while (rows.next()) {
                wfPersonInfos[i] = new Person();
                if (StringUtils.isEmpty((String)rows.getString("person.id"))) {
                    wfPersonInfos[i].setEmployeeName(context.getLocale(), rows.getString("User.name"));
                }
                wfPersonInfos[i].setEmployeeName(context.getLocale(), rows.getString("person.name"));
                wfPersonInfos[i].setUserId(rows.getString("User.id"));
                wfPersonInfos[i].setUserName(context.getLocale(), rows.getString("User.name"));
                wfPersonInfos[i].setEmployeeId(rows.getString("person.id"));
                ++i;
            }
            rows.close();
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"3_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersonInfos;
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    public Person[] getPersonsByUserId(Context context, String userId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        String sql = "SELECT FID from T_PM_User WHERE FPersonID IN (SELECT FPersonID FROM T_PM_USER WHERE FID = ?)";
        HashSet<String> set = new HashSet<String>();
        try {
            IRowSet rows = DbUtil.executeQuery((Context)context, (String)sql, (Object[])new Object[]{userId});
            while (rows.next()) {
                set.add(rows.getString("FID"));
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        if (set.size() == 0) {
            return new Person[0];
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        this.mergeEmpTypeFilter("person.employeeType", filter);
        this.mergeUserFilter(null, filter);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        evi.getSelector().add(new SelectorItemInfo("person.name"));
        UserCollection uc = new UserCollection();
        try {
            IUser iu = UserFactory.getLocalInstance((Context)context);
            uc = iu.getUserCollection(evi);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        Person wfPersonInfo = null;
        Person[] persons = new Person[uc.size()];
        if (uc.size() > 0) {
            Locale[] locales = PersonToWFAdapter.getContextLocales(context);
            UserInfo user = null;
            for (int j = 0; j < persons.length; ++j) {
                int i;
                user = uc.get(j);
                wfPersonInfo = new Person();
                wfPersonInfo.setUserId(user.getId().toString());
                for (i = 0; i < locales.length; ++i) {
                    wfPersonInfo.setUserName(locales[i], user.getName(locales[i]));
                }
                if (user.getPerson() != null) {
                    wfPersonInfo.setEmployeeId(user.getPerson().getId().toString());
                    for (i = 0; i < locales.length; ++i) {
                        wfPersonInfo.setEmployeeName(locales[i], user.getPerson().getName(locales[i]));
                    }
                }
                persons[j] = wfPersonInfo;
            }
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"4_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return persons;
    }

    public Person getPersonByUserId(Context context, String userId) throws WfParticipantException {
        if (userId == null || userId.length() == 0) {
            return null;
        }
        LowTimer t = new LowTimer();
        t.reset();
        UserCollection uc = new UserCollection();
        try {
            IUser iu = UserFactory.getLocalInstance((Context)context);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)userId));
            this.mergeEmpTypeFilter("person.employeeType", filter);
            this.mergeUserFilter(null, filter);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("name"));
            evi.getSelector().add(new SelectorItemInfo("person.id"));
            evi.getSelector().add(new SelectorItemInfo("person.name"));
            uc = iu.getUserCollection(evi);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        Person wfPersonInfo = new Person();
        if (uc.size() > 0) {
            int i;
            Locale[] locales = PersonToWFAdapter.getContextLocales(context);
            UserInfo user = uc.get(0);
            wfPersonInfo = new Person();
            wfPersonInfo.setUserId(user.getId().toString());
            for (i = 0; i < locales.length; ++i) {
                wfPersonInfo.setUserName(locales[i], TypeConversionUtils.objToString((Object)user.get(PersonToWFAdapter.localedKeyName("name", locales[i]))));
            }
            if (user.getPerson() != null) {
                wfPersonInfo.setEmployeeId(user.getPerson().getId().toString());
                for (i = 0; i < locales.length; ++i) {
                    wfPersonInfo.setEmployeeName(locales[i], TypeConversionUtils.objToString((Object)user.getPerson().get(PersonToWFAdapter.localedKeyName("name", locales[i]))));
                }
            } else {
                for (i = 0; i < locales.length; ++i) {
                    wfPersonInfo.setEmployeeName(locales[i], TypeConversionUtils.objToString((Object)user.get(PersonToWFAdapter.localedKeyName("name", locales[i]))));
                }
            }
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"3_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersonInfo;
    }

    private static final String localedKeyName(String key, Locale locale) {
        return key.trim() + "_" + BOSLocaleUtil.getShortCode((Locale)locale);
    }

    public Person[] getPersonByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        if (employeeId == null || employeeId.length() == 0) {
            return new Person[0];
        }
        LowTimer t = new LowTimer();
        t.reset();
        UserCollection uc = new UserCollection();
        try {
            IUser iu = UserFactory.getLocalInstance((Context)context);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)employeeId));
            this.mergeEmpTypeFilter("person.employeeType", filter);
            this.mergeUserFilter(null, filter);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("name"));
            evi.getSelector().add(new SelectorItemInfo("person.id"));
            evi.getSelector().add(new SelectorItemInfo("person.name"));
            uc = iu.getUserCollection(evi);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        Person wfPersonInfo = null;
        int size = uc.size();
        Person[] wfPersons = new Person[size];
        Locale[] locales = PersonToWFAdapter.getContextLocales(context);
        UserInfo user = null;
        for (int j = 0; j < size; ++j) {
            int i;
            user = uc.get(j);
            wfPersonInfo = new Person();
            wfPersonInfo.setUserId(user.getId().toString());
            for (i = 0; i < locales.length; ++i) {
                wfPersonInfo.setUserName(locales[i], user.getName(locales[i]));
            }
            if (user.getPerson() != null) {
                wfPersonInfo.setEmployeeId(user.getPerson().getId().toString());
                for (i = 0; i < locales.length; ++i) {
                    wfPersonInfo.setEmployeeName(locales[i], user.getPerson().getName(locales[i]));
                }
            }
            wfPersons[j] = wfPersonInfo;
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"5_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getPositionHolders(Context context, String positionId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PositionHolders");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        Person[] wfPersons = new Person[]{};
        try {
            wfPersons = this.getPersonArrayByIRowSet(context, queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"6_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getOrgMember(Context context, String orgId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = this.getOrgMembersByOrgId(context, orgId, false);
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"7_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getOrgAllMember(Context context, String orgId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = this.getOrgMembersByOrgId(context, orgId, true);
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"8_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getFellowOrgPersons(Context context, String orgId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        String oql = "select parent.id where id = '" + orgId + "'";
        AdminOrgUnitCollection c = null;
        try {
            c = AdminOrgUnitFactory.getLocalInstance((Context)context).getAdminOrgUnitCollection(oql);
        }
        catch (BOSException e1) {
            throw new WfParticipantException((Throwable)e1);
        }
        Person[] wfPersons = new Person[]{};
        String parentId = null;
        if (c.size() <= 0 || c.get(0).getParent() == null) {
            return wfPersons;
        }
        parentId = c.get(0).getParent().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)parentId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("child.id", (Object)orgId, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1");
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.PersonOrgQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            wfPersons = this.getPersonArrayByIRowSet(context, queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"9_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getSubOrgPersons(Context context, String orgId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgId));
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.PersonOrgQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        Person[] wfPersons = new Person[]{};
        try {
            wfPersons = this.getPersonArrayByIRowSet(context, queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"10_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getSuperOrgPersons(Context context, String orgId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("child.id", (Object)orgId));
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.PersonOrgQuery2");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        Person[] wfPersons = new Person[]{};
        try {
            wfPersons = this.getPersonArrayByIRowSet(context, queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"11_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getOrgPrincipal(Context context, String orgId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)orgId));
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.OrgPrincipal");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        Person[] wfPersons = new Person[]{};
        try {
            wfPersons = this.getPersonArrayByIRowSet(context, queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"12_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getSupervisor(Context context, String userId, String hierarchyId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = this.getSuperAndSubPersons(context, userId, 0, hierarchyId);
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"13_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getSupervisor(Context context, String userId) throws WfParticipantException {
        return this.getSupervisor(context, userId, null);
    }

    public Person[] getSubordinate(Context context, String userId, String hierarchyId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = this.getSuperAndSubPersons(context, userId, 1, hierarchyId);
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"14_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getSubordinate(Context context, String userId) throws WfParticipantException {
        return this.getSubordinate(context, userId, null);
    }

    public Person[] getFellow(Context context, String personId, String hierarchyId) throws WfParticipantException {
        return this._getFellow(context, personId, hierarchyId, null);
    }

    private Person[] _getFellow(Context context, String personId, String hierarchyId, String positionId) throws WfParticipantException {
        return this._getFellow(context, personId, hierarchyId, null, false);
    }

    private Person[] _getFellow(Context context, String id, String hierarchyId, String positionId, boolean isUser) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        String personId = null;
        personId = isUser ? this.getPersonByUserId(context, id).getEmployeeId() : id;
        String sql = null;
        HashSet<String> postSet = null;
        IRowSet postRows = null;
        if (hierarchyId != null && hierarchyId.trim().length() > 0) {
            sql = "SELECT FID FROM T_ORG_Position WHERE (FID IN (SELECT fchildid FROM t_org_positionHierarchy WHERE fhierarchyId = '" + hierarchyId + "'))";
            if (positionId != null) {
                sql = sql + "AND (FID = '" + positionId + "')";
            }
            ISQLExecutor isql = SQLExecutorFactory.getLocalInstance((Context)context, (String)sql);
            try {
                postRows = isql.executeSQL();
                if (postRows.size() != 0) {
                    postSet = new HashSet<String>();
                    while (postRows.next()) {
                        postSet.add(postRows.getString("FID"));
                    }
                }
            }
            catch (BOSException e1) {
                throw new WfParticipantException((Throwable)e1);
            }
            catch (SQLException e) {
                throw new WfParticipantException((Throwable)e);
            }
        }
        FilterInfo filter = new FilterInfo();
        if (isUser) {
            filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)id));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        }
        filter.getFilterItems().add(new FilterItemInfo("fellow.id", (Object)personId, CompareType.NOTEQUALS));
        if (postSet == null) {
            filter.setMaskString("#0 and #1");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("position.id", postSet, CompareType.INCLUDE));
            filter.setMaskString("#0 and #1 and #2");
        }
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.Fellows");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        Person[] wfPersons = new Person[]{};
        try {
            wfPersons = this.getPersonArrayByIRowSet(context, queryExec.executeQuery(), "fellow.id", "fellow.name", "fellowUser.id", "fellowUser.name");
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"15_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getFellow(Context context, String personId) throws WfParticipantException {
        return this.getFellow(context, personId, null);
    }

    public Person[] getRoleMember(Context context, String personUserId, String roleId) throws WfParticipantException {
        return null;
    }

    public PositionInfo[] getPositionArrayByUserId(Context context, String userId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        PositionInfo[] wfPositions = null;
        try {
            wfPositions = this.getPositionArrayByPersons(context, new String[]{this.getPersonIdByUserId(context, userId)});
        }
        catch (WfParticipantException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"16_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPositions;
    }

    public PositionInfo[] getPositionArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        PositionInfo[] wfPositions = this.getPositionArrayByPersons(context, new String[]{employeeId});
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"17_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPositions;
    }

    public OrgUnitInfo[] getOrgUnitArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        OrgUnitInfo[] wfOrgs = this.getOrgUnitArrayById(context, employeeId, 0);
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"18_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfOrgs;
    }

    public OrgUnitInfo[] getOrgUnitArrayById(Context context, String id, int type) throws WfParticipantException {
        OrgUnitInfo[] orgs = new OrgUnitInfo[]{};
        FilterInfo filter = new FilterInfo();
        String idStr = null;
        idStr = type == 0 ? "person.id" : "user.id";
        filter.getFilterItems().add(new FilterItemInfo(idStr, (Object)id));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.WFOrgByPerson");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        HashSet<String> set = new HashSet<String>();
        try {
            IRowSet rows = queryExec.executeQuery();
            while (rows.next()) {
                set.add(rows.getString("AdminOrgUnit.id"));
            }
            rows.close();
            if (set.size() > 0) {
                ArrayList<OrgUnitInfo> list = new ArrayList<OrgUnitInfo>();
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                evi.setFilter(filter);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("id"));
                selectors.add(new SelectorItemInfo("isCU"));
                selectors.add(new SelectorItemInfo("name"));
                selectors.add(new SelectorItemInfo("parent.id"));
                selectors.add(new SelectorItemInfo("parent.name"));
                evi.setSelector(selectors);
                AdminOrgUnitCollection adminOrgs = AdminOrgUnitFactory.getLocalInstance((Context)context).getAdminOrgUnitCollection(evi);
                if (adminOrgs.size() > 0) {
                    for (int index = 0; index < adminOrgs.size(); ++index) {
                        AdminOrgUnitInfo adminOrgInfo = adminOrgs.get(index);
                        OrgUnitInfo wfOrg = new OrgUnitInfo();
                        wfOrg.setId(adminOrgInfo.getId().toString());
                        wfOrg.setName(context.getLocale(), adminOrgInfo.getName());
                        if (adminOrgInfo.getParent() != null) {
                            if (adminOrgInfo.getParent().getId() != null) {
                                wfOrg.setParentId(adminOrgInfo.getParent().getId().toString());
                            }
                            wfOrg.setParentName(context.getLocale(), adminOrgInfo.getParent().getName());
                        }
                        wfOrg.setCU(adminOrgInfo.isIsCU());
                        wfOrg.setOrgType(0);
                        list.add(wfOrg);
                    }
                }
                orgs = new OrgUnitInfo[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    orgs[i] = (OrgUnitInfo)list.get(i);
                }
            }
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        return orgs;
    }

    public OrgUnitInfo[] getOrgUnitArrayByUserId(Context context, String userId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        OrgUnitInfo[] wfOrgs = this.getOrgUnitArrayById(context, userId, 1);
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"19_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfOrgs;
    }

    public OrgUnitInfo getParentOrgUnit(Context context, String orgUnitId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        OrgUnitInfo wfOrg = null;
        String sql = "select fparentid from T_ORG_Admin where fid = ?";
        IRowSet rows = null;
        try {
            rows = DbUtil.executeQuery((Context)context, (String)sql, (Object[])new Object[]{orgUnitId});
            if (!rows.next()) {
                rows.close();
                return wfOrg;
            }
            orgUnitId = rows.getString("fparentid");
            rows.close();
            if (StringUtils.isEmpty((String)orgUnitId)) {
                return wfOrg;
            }
            String oql = "select id,iscu,name,parent.id,parent.name where id = '" + orgUnitId + "'";
            AdminOrgUnitCollection adminOrgs = null;
            adminOrgs = AdminOrgUnitFactory.getLocalInstance((Context)context).getAdminOrgUnitCollection(oql);
            if (adminOrgs.size() > 0) {
                AdminOrgUnitInfo adminOrgInfo = adminOrgs.get(0);
                wfOrg = new OrgUnitInfo();
                wfOrg.setId(adminOrgInfo.getId().toString());
                wfOrg.setName(context.getLocale(), adminOrgInfo.getName());
                if (adminOrgInfo.getParent() != null) {
                    if (adminOrgInfo.getParent().getId() != null) {
                        wfOrg.setParentId(adminOrgInfo.getParent().getId().toString());
                    }
                    wfOrg.setParentName(context.getLocale(), adminOrgInfo.getParent().getName());
                }
                wfOrg.setCU(adminOrgInfo.isIsCU());
                wfOrg.setOrgType(0);
            }
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"20_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfOrg;
    }

    public PositionInfo[] getPositionArrayByOrgUnitId(Context context, String orgUnitId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        PositionInfo[] wfPositions = null;
        try {
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filtem = new FilterItemInfo("adminOrgUnit.id", (Object)orgUnitId);
            FilterItemInfo filtemDelete = new FilterItemInfo("deletedStatus", (Object)new Integer(1));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
            viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
            filter.getFilterItems().add(filtem);
            filter.getFilterItems().add(filtemDelete);
            viewInfo.setFilter(filter);
            IPosition iPosition = PositionFactory.getLocalInstance((Context)context);
            PositionCollection positionColl = iPosition.getPositionCollection(viewInfo);
            com.kingdee.eas.basedata.org.PositionInfo info = null;
            if (positionColl != null) {
                int size = positionColl.size();
                wfPositions = new PositionInfo[size];
                for (int i = 0; i < size; ++i) {
                    info = positionColl.get(i);
                    wfPositions[i] = new PositionInfo();
                    wfPositions[i].setId(info.getId().toString());
                    wfPositions[i].setName(context.getLocale(), info.getName());
                    wfPositions[i].setOrgId(info.getAdminOrgUnit().getId().toString());
                    wfPositions[i].setOrgName(context.getLocale(), info.getAdminOrgUnit().getName());
                }
            }
        }
        catch (BOSException ex) {
            throw new WfParticipantException((Throwable)ex);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"21_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPositions;
    }

    private FilterItemInfo getOrgTypeFilter(int orgType) {
        FilterItemInfo filterItem = null;
        switch (orgType) {
            case 0: {
                filterItem = new FilterItemInfo("isAdminOrgUnit", (Object)new Integer(1));
                break;
            }
            case 1: {
                filterItem = new FilterItemInfo("isCompanyOrgUnit", (Object)new Integer(1));
                break;
            }
            case 10: {
                filterItem = new FilterItemInfo("isCU", (Object)new Integer(1));
                break;
            }
            case 2: {
                filterItem = new FilterItemInfo("isSaleOrgUnit", (Object)new Integer(1));
                break;
            }
            case 3: {
                filterItem = new FilterItemInfo("isPurchaseOrgUnit", (Object)new Integer(1));
                break;
            }
            case 4: {
                filterItem = new FilterItemInfo("isStorageOrgUnit", (Object)new Integer(1));
                break;
            }
            case 6: {
                filterItem = new FilterItemInfo("isProfitOrgUnit", (Object)new Integer(1));
                break;
            }
            case 5: {
                filterItem = new FilterItemInfo("isCostOrgUnit", (Object)new Integer(1));
            }
        }
        return filterItem;
    }

    public OrgUnitInfo[] getAllOrgUnitByType(Context context, int orgType) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        if (orgType == 8) {
            throw new WfParticipantException("union type is unvaliable!");
        }
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.person.app.WFOrgBizViewQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)pk);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)NewOrgViewHelper.convert2TreeId((OrgType)OrgType.getEnum((int)orgType))));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExcu.setObjectView(evi);
        OrgUnitInfo[] wfOrgUnits = new OrgUnitInfo[]{};
        try {
            IRowSet rows = DbUtil.executeQuery((Context)context, (String)queryExcu.getSQL());
            wfOrgUnits = new OrgUnitInfo[rows.size()];
            int i = 0;
            while (rows.next()) {
                wfOrgUnits[i] = new OrgUnitInfo();
                wfOrgUnits[i].setId(rows.getString("unit.id"));
                wfOrgUnits[i].setName(context.getLocale(), rows.getString("unit.name"));
                wfOrgUnits[i].setParentId(rows.getString("parent1.id"));
                wfOrgUnits[i].setParentName(context.getLocale(), rows.getString("parent1.name"));
                wfOrgUnits[i].setCU(rows.getBoolean("unit.isCU"));
                if (rows.getBoolean("unit.isCU")) {
                    wfOrgUnits[i].setOrgType(10);
                } else if (rows.getBoolean("unit.isCompanyOrgUnit")) {
                    wfOrgUnits[i].setOrgType(1);
                } else if (rows.getBoolean("unit.isAdminOrgUnit")) {
                    wfOrgUnits[i].setOrgType(0);
                } else if (rows.getBoolean("unit.isSaleOrgUnit")) {
                    wfOrgUnits[i].setOrgType(2);
                } else if (rows.getBoolean("unit.isPurchaseOrgUnit")) {
                    wfOrgUnits[i].setOrgType(3);
                } else if (rows.getBoolean("unit.isStorageOrgUnit")) {
                    wfOrgUnits[i].setOrgType(4);
                } else if (rows.getBoolean("unit.isProfitOrgUnit")) {
                    wfOrgUnits[i].setOrgType(6);
                } else if (rows.getBoolean("unit.isCostOrgUnit")) {
                    wfOrgUnits[i].setOrgType(5);
                } else if (rows.getBoolean("unit.isUnion")) {
                    wfOrgUnits[i].setOrgType(8);
                }
                ++i;
            }
            rows.close();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"22_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfOrgUnits;
    }

    public OrgUnitInfo getRootUnit(Context context, int orgType) throws WfParticipantException {
        IRowSet rows;
        LowTimer t = new LowTimer();
        t.reset();
        if (orgType == 8) {
            throw new WfParticipantException("union type is unvaliable!");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(this.getOrgTypeFilter(orgType));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", null, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.WFOrgQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        String unitId = null;
        try {
            rows = queryExec.executeQuery();
            if (rows.next()) {
                unitId = rows.getString("id");
            }
            rows.close();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        OrgUnitInfo wfOrg = null;
        if (unitId != null) {
            filter.getFilterItems().clear();
            filter.getFilterItems().add(this.getOrgTypeFilter(orgType));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)unitId));
            filter.setMaskString("#0 and #1");
            evi.setFilter(filter);
            queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
            queryExec.setObjectView(evi);
            try {
                rows = queryExec.executeQuery();
                if (rows.next()) {
                    wfOrg = new OrgUnitInfo();
                    wfOrg.setId(rows.getString("id"));
                    wfOrg.setName(context.getLocale(), rows.getString("name"));
                    wfOrg.setCU(rows.getBoolean("isCU"));
                    if (rows.getBoolean("isCU")) {
                        wfOrg.setOrgType(10);
                    } else if (rows.getBoolean("isCompanyOrgUnit")) {
                        wfOrg.setOrgType(1);
                    } else if (rows.getBoolean("isAdminOrgUnit")) {
                        wfOrg.setOrgType(0);
                    } else if (rows.getBoolean("isSaleOrgUnit")) {
                        wfOrg.setOrgType(2);
                    } else if (rows.getBoolean("isPurchaseOrgUnit")) {
                        wfOrg.setOrgType(3);
                    } else if (rows.getBoolean("isStorageOrgUnit")) {
                        wfOrg.setOrgType(4);
                    } else if (rows.getBoolean("isProfitOrgUnit")) {
                        wfOrg.setOrgType(6);
                    } else if (rows.getBoolean("isCostOrgUnit")) {
                        wfOrg.setOrgType(5);
                    } else if (rows.getBoolean("isUnion")) {
                        wfOrg.setOrgType(8);
                    }
                    wfOrg.setParentId(rows.getString("parent.id"));
                    wfOrg.setParentName(context.getLocale(), rows.getString("parent.name"));
                }
                rows.close();
            }
            catch (BOSException e) {
                throw new WfParticipantException((Throwable)e);
            }
            catch (SQLException e) {
                throw new WfParticipantException((Throwable)e);
            }
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"23_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfOrg;
    }

    public Object[] getPositionAndOrgByUserId(Context context, String userId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        String sql = "select distinct fpositionid from t_org_positionMember a inner join t_bd_person b on a. fpersonid = b.fid  inner join t_pm_user c on b.fid = c.fpersonid where c.fid = '" + userId + "'";
        Object[] rtn = new Object[2];
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)context, (String)sql);
        try {
            IRowSet rows = exec.executeSQL();
            if (rows.size() == 0) {
                rtn[0] = new String[0];
                rtn[1] = new String[0][0];
                return rtn;
            }
            String[] positions = new String[rows.size()];
            int i = 0;
            while (rows.next()) {
                positions[i] = rows.getString(1);
                ++i;
            }
            rows.close();
            sql = "select distinct FAdminOrgUnitId from t_org_position where FID in ('" + positions[0] + "'";
            for (int j = 1; j < positions.length; ++j) {
                sql = sql + ", '" + positions[j] + "'";
            }
            sql = sql + ")";
            exec = SQLExecutorFactory.getLocalInstance((Context)context, (String)sql);
            rows = exec.executeSQL();
            String[] orgs = new String[rows.size()];
            i = 0;
            while (rows.next()) {
                orgs[i] = rows.getString(1);
                ++i;
            }
            rows.close();
            String[][] rtnOrgs = new String[orgs.length][0];
            String longNumber = null;
            for (int k = 0; k < orgs.length; ++k) {
                sql = "select FLongNumber from t_org_admin where fid = '" + orgs[k] + "'";
                exec = SQLExecutorFactory.getLocalInstance((Context)context, (String)sql);
                rows = exec.executeSQL();
                if (rows.next()) {
                    longNumber = rows.getString(1);
                    rows.close();
                    sql = "select FID from t_org_admin where charindex(flongnumber, '" + longNumber + "') = 1 order by flongnumber desc";
                    exec = SQLExecutorFactory.getLocalInstance((Context)context, (String)sql);
                    rows = exec.executeSQL();
                    rtnOrgs[k] = new String[rows.size()];
                    int j = 0;
                    while (rows.next()) {
                        rtnOrgs[k][j] = rows.getString(1);
                        ++j;
                    }
                }
                rows.close();
            }
            rtn[0] = positions;
            rtn[1] = rtnOrgs;
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"24_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return rtn;
    }

    public boolean isPersonInOrg(Context context, String personId, String OrgId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        boolean isIn = false;
        String sql = "";
        sql = sql + "select FLongNumber, FLevel from T_Org_Admin where FID = '" + OrgId + "'";
        ISQLExecutor isql = SQLExecutorFactory.getLocalInstance((Context)context, (String)sql);
        IRowSet rows = null;
        String longNumber = "";
        int level = 0;
        try {
            rows = isql.executeSQL();
            if (rows.next()) {
                longNumber = rows.getString("FLongNumber");
                level = rows.getInt("FLevel");
            }
            rows.close();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        sql = "select FID from t_org_admin where FLevel >= ";
        sql = sql + String.valueOf(level) + " and FLongNumber like '" + longNumber + "%' order by FLongNumber";
        isql = SQLExecutorFactory.getLocalInstance((Context)context, (String)sql);
        String[] orgIds = null;
        try {
            rows = isql.executeSQL();
            orgIds = new String[rows.size()];
            int i = 0;
            while (rows.next()) {
                orgIds[i] = rows.getString("FID");
                ++i;
            }
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        double d = new Integer(orgIds.length).doubleValue();
        int sqlCount = new Double(Math.ceil(d / (double)OrgAppUtils.IN_CLAUSE_COUNT)).intValue();
        String ids = "";
        for (int i = 0; i < sqlCount; ++i) {
            ids = "";
            for (int j = 0; j < OrgAppUtils.IN_CLAUSE_COUNT && i * OrgAppUtils.IN_CLAUSE_COUNT + j < orgIds.length; ++j) {
                ids = ids.length() == 0 ? ids + "'" + orgIds[i * OrgAppUtils.IN_CLAUSE_COUNT + j] + "'" : ids + ",'" + orgIds[i * OrgAppUtils.IN_CLAUSE_COUNT + j] + "'";
            }
            sql = "select a.fid from t_org_positionmember a inner join t_org_position b on a.fpositionid = b.fid ";
            sql = sql + "where a.fpersonid = '" + personId + "' and b.fAdminOrgUnitId in (" + ids + ")";
            isql = SQLExecutorFactory.getLocalInstance((Context)context, (String)sql);
            try {
                rows = isql.executeSQL();
                if (rows.size() <= 0) continue;
                rows.close();
                isIn = true;
                break;
            }
            catch (BOSException e) {
                throw new WfParticipantException((Throwable)e);
            }
            catch (SQLException e) {
                throw new WfParticipantException((Throwable)e);
            }
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"25_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return isIn;
    }

    private Person[] getOrgMembersByOrgId(Context context, String adminOrgId, boolean isAll) throws WfParticipantException {
        AdminOrgUnitCollection c = null;
        try {
            c = AdminOrgUnitFactory.getLocalInstance((Context)context).getAdminOrgUnitCollection("select longNumber where id = '" + adminOrgId + "'");
        }
        catch (BOSException e1) {
            throw new WfParticipantException((Throwable)e1);
        }
        if (c.size() == 0) {
            throw new WfParticipantException("have no such adminOrg!");
        }
        String longNumber = c.get(0).getLongNumber();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.Persons2ByAdminOrg");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        if (isAll) {
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)longNumber, CompareType.EQUALS));
        }
        this.mergeEmpTypeFilter("empType", filterInfo);
        this.mergeUserFilter("user", filterInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        queryExcu.setObjectView(viewInfo);
        try {
            int dataCount = queryExcu.getRowCount();
            int pageCount = 6666;
            int pages = dataCount / pageCount + 1;
            Person[] persons = new Person[dataCount];
            Person[] tempPers = null;
            int rowNum = 0;
            for (int i = 0; i < pages; ++i) {
                IRowSet rowSet = queryExcu.executeQuery(i * pageCount, pageCount);
                tempPers = this.getPersonArrayByIRowSet(context, rowSet);
                if (tempPers.length <= 0) continue;
                for (int j = 0; j < tempPers.length && rowNum < dataCount; ++rowNum, ++j) {
                    persons[rowNum] = tempPers[j];
                }
            }
            return persons;
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    public String getHierarchyNameByID(Context context, String id) throws WfParticipantException {
        IHierarchy ih = null;
        CoreBaseCollection c = null;
        try {
            ih = HierarchyFactory.getLocalInstance((Context)context);
            c = ih.getCollection("select name where id = '" + id + "'");
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        if (c.size() > 0) {
            return (String)c.get(0).get("name");
        }
        return null;
    }

    public PositionInfo[] getPositionByPersonAndHierarchy(Context context, String personID, String hierarchyID) throws WfParticipantException {
        IRowSet rows;
        LowTimer t = new LowTimer();
        t.reset();
        StringBuffer sqlb = new StringBuffer();
        sqlb.append("SELECT DISTINCT FPositionID ");
        sqlb.append("FROM T_ORG_PositionMember ");
        sqlb.append("WHERE (FPersonID = '");
        sqlb.append(personID);
        sqlb.append("') AND (FPositionID IN ");
        sqlb.append("\t\t          (SELECT FParentID ");
        sqlb.append("\t\t         FROM T_ORG_PositionHierarchy ");
        sqlb.append("\t\t         WHERE FHierarchyID = '");
        sqlb.append(hierarchyID);
        sqlb.append("') OR  FPositionID IN ");
        sqlb.append("\t\t          (SELECT FChildID ");
        sqlb.append("\t\t         FROM T_ORG_PositionHierarchy ");
        sqlb.append("\t\t         WHERE FHierarchyID = '");
        sqlb.append(hierarchyID);
        sqlb.append("'))");
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)context, (String)sqlb.toString());
        HashSet<String> set = new HashSet<String>();
        try {
            rows = exec.executeSQL();
            while (rows.next()) {
                set.add(rows.getString("FPositionID"));
            }
            rows = null;
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        if (set.size() == 0) {
            return new PositionInfo[0];
        }
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.org.app.PositionQuery"));
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        queryExcu.setObjectView(evi);
        PositionInfo[] wfPositions = null;
        try {
            rows = queryExcu.executeQuery();
            wfPositions = new PositionInfo[rows.size()];
            int i = 0;
            while (rows.next()) {
                wfPositions[i] = new PositionInfo();
                wfPositions[i].setId(rows.getString("id"));
                wfPositions[i].setName(context.getLocale(), rows.getString("name"));
                wfPositions[i].setOrgId(rows.getString("AdminOrgUnit.id"));
                wfPositions[i].setOrgName(context.getLocale(), rows.getString("AdminOrgUnit.name"));
                ++i;
            }
        }
        catch (BOSException e1) {
            throw new WfParticipantException((Throwable)e1);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"26_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPositions;
    }

    public String[] getHierarchyByOrgType(Context context, int orgType) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        HierarchyCollection c = null;
        try {
            c = HierarchyFactory.getLocalInstance((Context)context).getHierarchyCollection();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        String[] value = new String[c.size()];
        int size = value.length;
        for (int i = 0; i < size; ++i) {
            value[i] = c.get(i).getId().toString();
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"27_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return value;
    }

    public String getAdminOrgUnitNamebyPositionID(Context context, String posittonID) throws WfParticipantException {
        SelectorItemCollection s = new SelectorItemCollection();
        s.add(new SelectorItemInfo("adminOrgUnit.id"));
        s.add(new SelectorItemInfo("adminOrgUnit.name"));
        try {
            ObjectUuidPK pk = new ObjectUuidPK(posittonID);
            IPosition ip = PositionFactory.getRemoteInstance();
            com.kingdee.eas.basedata.org.PositionInfo pInfo = ip.getPositionInfo((IObjectPK)pk, s);
            AdminOrgUnitInfo info = pInfo.getAdminOrgUnit();
            String orgName = info.getName(context.getLocale());
            if (StringUtils.isEmpty((String)orgName)) {
                return "UnKownOrg";
            }
            return orgName;
        }
        catch (Exception ex) {
            logger.debug((Object)ex.toString(), (Throwable)ex);
            return "UnKownOrg";
        }
    }

    public OrgUnitInfo[] getAllOrgUnitArray(Context context) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.basedata.org.app.WFOrgQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)pk);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExcu.setObjectView(evi);
        OrgUnitInfo[] wfOrgUnits = new OrgUnitInfo[]{};
        try {
            IRowSet rows = queryExcu.executeQuery();
            wfOrgUnits = new OrgUnitInfo[rows.size()];
            int orgType = 0;
            int i = 0;
            while (rows.next()) {
                wfOrgUnits[i] = new OrgUnitInfo();
                wfOrgUnits[i].setId(rows.getString("id"));
                wfOrgUnits[i].setName(context.getLocale(), rows.getString("name"));
                wfOrgUnits[i].setParentId(rows.getString("parent.id"));
                wfOrgUnits[i].setParentName(context.getLocale(), rows.getString("parent.name"));
                wfOrgUnits[i].setCU(rows.getBoolean("isCU"));
                orgType = 0;
                if (rows.getBoolean("isAdminOrgUnit")) {
                    ++orgType;
                }
                if (rows.getBoolean("isCompanyOrgUnit")) {
                    orgType += 2;
                }
                if (rows.getBoolean("isSaleOrgUnit")) {
                    orgType += 4;
                }
                if (rows.getBoolean("isPurchaseOrgUnit")) {
                    orgType += 8;
                }
                if (rows.getBoolean("isStorageOrgUnit")) {
                    orgType += 16;
                }
                if (rows.getBoolean("isCostOrgUnit")) {
                    orgType += 32;
                }
                if (rows.getBoolean("isProfitOrgUnit")) {
                    orgType += 64;
                }
                if (rows.getBoolean("isUnion")) {
                    orgType += 128;
                }
                if (rows.getBoolean("isCU")) {
                    orgType += 256;
                }
                wfOrgUnits[i].setOrgType(orgType);
                ++i;
            }
            rows.close();
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"28_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfOrgUnits;
    }

    public OrgUnitInfo[] getSubOrgUnit(Context arg0, String arg1) throws WfParticipantException {
        return null;
    }

    public void initProvider(WfEngine arg0) throws WfParticipantException {
    }

    private Person[] getSupervisorByPositionID(Context context, int type, String positionId, String hierarchyId) throws WfParticipantException {
        String posStr = "";
        if (type == 0) {
            posStr = "child";
        }
        if (type == 1) {
            posStr = "parent";
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(posStr, (Object)positionId));
        if (hierarchyId != null && hierarchyId.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("hierarchy", (Object)hierarchyId));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        try {
            CoreBaseCollection collection = PositionHierarchyFactory.getLocalInstance((Context)context).getCollection(evi);
            if (collection != null && collection.size() > 0) {
                ArrayList<Person> pl = new ArrayList<Person>();
                for (int i = 0; i < collection.size(); ++i) {
                    Person[] p;
                    PositionHierarchyInfo positionHierarchyInfo = (PositionHierarchyInfo)collection.get(i);
                    String positionid = "";
                    if (type == 0) {
                        positionid = positionHierarchyInfo.getParent().getId().toString();
                    }
                    if (type == 1) {
                        positionid = positionHierarchyInfo.getChild().getId().toString();
                    }
                    if ((p = this.getPositionHolders(context, positionid)) == null || p.length <= 0) continue;
                    for (int j = 0; j < p.length; ++j) {
                        pl.add(p[j]);
                    }
                }
                if (pl.size() > 0) {
                    Person[] preturn = new Person[pl.size()];
                    for (int j = 0; j < pl.size(); ++j) {
                        preturn[j] = (Person)pl.get(j);
                    }
                    return preturn;
                }
                return new Person[0];
            }
            return new Person[0];
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    public Person[] getSupervisor(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = null;
        if (personId != null) {
            wfPersons = this.getSuperAndSubPersons(context, personId, 2, hierarchyId, positionId);
        } else if (positionId != null) {
            wfPersons = this.getSupervisorByPositionID(context, 0, positionId, hierarchyId);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"13_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getIndirectSupervisor(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = new Person[]{};
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person2.id", (Object)personId));
        if (hierarchyId != null && hierarchyId.trim().length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchyId));
            filter.getFilterItems().add(new FilterItemInfo("hierarchy2.id", (Object)hierarchyId));
            filter.setMaskString("#0 and #1 and #2");
        }
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.ESPersonIndirectQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            wfPersons = this.getPersonArrayByIRowSet(context, queryExec.executeQuery(), "id", "name", "User.id", "User.name");
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"29_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getSubordinate(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = null;
        if (personId != null) {
            wfPersons = this.getSuperAndSubPersons(context, personId, 3, hierarchyId, positionId);
        } else if (positionId != null) {
            wfPersons = this.getSupervisorByPositionID(context, 1, positionId, hierarchyId);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"14_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getFellow(Context context, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = this._getFellow(context, personId, hierarchyId, positionId, false);
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"15_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    private HashSet getSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        int size = array.length;
        for (int i = 0; i < size; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public Person[] getAllPosFellow(Context ctx, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = new Person[]{};
        if (hierarchyId == null || hierarchyId.trim().length() == 0) {
            hierarchyId = "00000000-0000-0000-0000-000000000001396FCAD0";
        }
        HashSet supPosSet = this.getSetByArray(this.getSuperPostions(ctx, personId, hierarchyId));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)supPosSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchyId));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.SubPersonQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            wfPersons = this.getPersonArrayByIRowSet(ctx, queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"30_PersonToWFAdapter", (Locale)ctx.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public Person[] getSameJobGradePersonFellow(Context ctx, String personId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        String jobGradeId = null;
        Person[] persons = new Person[]{};
        try {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("jobGrade.id");
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
            view.setFilter(filter);
            IObjectValue personPosition = (IObjectValue)BusinessProcessUtil.getValueByBosType((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"326C5FD0"), (EntityViewInfo)view);
            if (personPosition != null) {
                jobGradeId = ((IObjectValue)personPosition.get("jobGrade")).get("id").toString();
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        if (jobGradeId != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("JobGrade.id", (Object)jobGradeId));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)personId, CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
            this.mergeEmpTypeFilter("empType", filter);
            this.mergeUserFilter("User", filter);
            MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.person.app.SameJobGradePersonQuery");
            IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            queryExec.setObjectView(evi);
            try {
                persons = this.getPersonArrayByIRowSet(ctx, queryExec.executeQuery(), "id", "name", "User.id", "User.name");
            }
            catch (BOSException e) {
                throw new WfParticipantException((Throwable)e);
            }
            catch (SQLException e) {
                throw new WfParticipantException((Throwable)e);
            }
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"31_PersonToWFAdapter", (Locale)ctx.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return persons;
    }

    public Person[] getOtherPosFellow(Context ctx, String personId, String positionId, String hierarchyId) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        Person[] wfPersons = new Person[]{};
        if (hierarchyId == null || hierarchyId.trim().length() == 0) {
            hierarchyId = "00000000-0000-0000-0000-000000000001396FCAD0";
        }
        HashSet supPosSet = this.getSetByArray(this.getSuperPostions(ctx, personId, hierarchyId));
        HashSet noIncludePosSet = this.getSetByArray(this.getPositionByPersonId(ctx, personId, hierarchyId, false));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)supPosSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("subPosition.id", (Object)noIncludePosSet, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchyId));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3");
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.SubPersonQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        try {
            wfPersons = this.getPersonArrayByIRowSet(ctx, queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"31_PersonToWFAdapter", (Locale)ctx.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public String[] getSuperPostions(Context ctx, String personId, String hierarchyId) throws WfParticipantException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("hierarchy.id", (Object)hierarchyId));
        filter.setMaskString("#0 and #1");
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.SuperPositionQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        String[] positions = new String[]{};
        IRowSet rows = null;
        int i = 0;
        try {
            rows = queryExec.executeQuery();
            positions = new String[rows.size()];
            while (rows.next()) {
                positions[i] = rows.getString("position.id");
                ++i;
            }
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        return positions;
    }

    private String[] getPositionByPersonId(Context ctx, String personId, String hierarchyId, boolean isPrimary) throws WfParticipantException {
        if (hierarchyId == null || hierarchyId.trim().length() == 0) {
            hierarchyId = "00000000-0000-0000-0000-000000000001396FCAD0";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT PM.FPositionID \n");
        sb.append("FROM T_ORG_PositionHierarchy PH \n");
        sb.append("INNER JOIN T_ORG_PositionMember PM \n");
        sb.append("ON PH.FCHILDID = PM.FPositionID \n");
        sb.append("WHERE FPersonID = ? AND PH.FHierarchyID = ? \n");
        if (isPrimary) {
            sb.append("AND PM.FIsPrimary = 1 \n");
        }
        logger.debug((Object)sb.toString());
        Object[] param = new String[]{personId, hierarchyId};
        String[] positions = new String[]{};
        IRowSet rows = null;
        try {
            rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            positions = new String[rows.size()];
            int i = 0;
            while (rows.next()) {
                positions[i] = rows.getString("FPositionID");
                ++i;
            }
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        return positions;
    }

    private String getOUIdByUserId(Context ctx, String userId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FControlUnitId, FDefOrgUnitID \n");
        sql.append("from t_pm_user \n");
        sql.append("where fid = ? \n");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId});
        String defOrgId = null;
        String ouId = null;
        if (rows.next()) {
            defOrgId = rows.getString("FDefOrgUnitID");
            if (defOrgId != null && !defOrgId.equalsIgnoreCase("null")) {
                ouId = defOrgId;
            }
            return ouId;
        }
        return null;
    }

    public String getCurrentOrgIdByUser(Context context, String userId, int orgType) throws WfParticipantException {
        CtrlUnitInfo unit;
        String ouId;
        LowTimer t = new LowTimer();
        t.reset();
        try {
            ouId = this.getOUIdByUserId(context, userId);
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        if (ouId == null) {
            throw new WfParticipantException("can not find defaultOrg by userId, please check data!");
        }
        try {
            FullOrgUnitCollection c = FullOrgUnitFactory.getLocalInstance((Context)context).getFullOrgUnitCollection("select *,CU.* where id = '" + ouId + "'");
            FullOrgUnitInfo ouInfo = c.get(0);
            CtrlUnitInfo cuInfo = ouInfo.getCU();
            if (orgType == 10) {
                unit = cuInfo;
            } else {
                INewOrgUnitFacade iOrg = NewOrgUnitFacadeFactory.getLocalInstance((Context)context);
                unit = iOrg.getDelegateUnit(ouId, OrgType.getEnum((int)orgType));
            }
            if (unit == null) {
                throw new WfParticipantException("can not find delegateUnit by ou !!!!");
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"32_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return unit.getId().toString();
    }

    public static CompanyOrgUnitInfo getCompanyInfoByAdminId(Context ctx, String orgId) throws WfParticipantException {
        INewOrgUnitFacade iOrg;
        try {
            iOrg = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        CompanyOrgUnitInfo fiInfo = null;
        try {
            fiInfo = (CompanyOrgUnitInfo)iOrg.getDelegateUnit(orgId, OrgType.Company);
        }
        catch (EASBizException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        return fiInfo;
    }

    public static String getCompanyIdByAdminId(Context ctx, String orgId) throws WfParticipantException {
        INewOrgUnitFacade iOrg;
        try {
            iOrg = NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        CompanyOrgUnitInfo fiInfo = null;
        try {
            fiInfo = (CompanyOrgUnitInfo)iOrg.getDelegateUnit(orgId, OrgType.Company);
        }
        catch (EASBizException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        if (fiInfo != null) {
            return fiInfo.getId().toString();
        }
        return "";
    }

    public com.kingdee.bos.workflow.participant.JobInfo[] getJobArrayByEmployeeId(Context context, String employeeId) throws WfParticipantException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)employeeId));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.JobsOfPersonQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        queryExec.setObjectView(evi);
        com.kingdee.bos.workflow.participant.JobInfo[] jobs = null;
        try {
            IRowSet rows = queryExec.executeQuery();
            if (rows != null && rows.size() > 0) {
                int size = rows.size();
                jobs = new com.kingdee.bos.workflow.participant.JobInfo[size];
                com.kingdee.bos.workflow.participant.JobInfo jobInfo = null;
                int i = 0;
                while (rows.next()) {
                    jobInfo = new com.kingdee.bos.workflow.participant.JobInfo();
                    jobInfo.setId(rows.getString("id"));
                    jobInfo.setName(context.getLocale(), rows.getString("name"));
                    jobs[i] = jobInfo;
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        return jobs;
    }

    public com.kingdee.bos.workflow.participant.JobInfo[] getJobArrayByOrgUnitId(Context context, String orgUnitId) throws WfParticipantException {
        JobCollection jc;
        LowTimer t = new LowTimer();
        String sql = "SELECT DISTINCT FJOBID FROM T_ORG_POSITION WHERE FADMINORGUNITID = ? AND FJOBID IS NOT NULL ";
        HashSet<String> set = new HashSet<String>();
        int size = 0;
        try {
            IRowSet rows = DbUtil.executeQuery((Context)context, (String)sql, (Object[])new Object[]{orgUnitId});
            size = rows.size();
            while (rows.next()) {
                set.add(rows.getString("FJOBID"));
            }
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        if (size == 0) {
            set.add("");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        try {
            jc = JobFactory.getLocalInstance((Context)context).getJobCollection(evi);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        Locale[] locales = PersonToWFAdapter.getContextLocales(context);
        com.kingdee.bos.workflow.participant.JobInfo[] jobs = new com.kingdee.bos.workflow.participant.JobInfo[jc.size()];
        JobInfo jInfo = null;
        for (int i = 0; i < jobs.length; ++i) {
            jInfo = jc.get(i);
            jobs[i] = new com.kingdee.bos.workflow.participant.JobInfo();
            jobs[i].setId(jInfo.getId().toString());
            for (int j = 0; j < locales.length; ++j) {
                jobs[i].setName(locales[j], jInfo.getName(locales[j]));
            }
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"33_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return jobs;
    }

    public Person[] getAdminOrgUnitJobHolders(Context context, String adminOrgUnitID, String jobID) throws WfParticipantException {
        LowTimer t = new LowTimer();
        t.reset();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("job.id", (Object)jobID));
        filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)adminOrgUnitID));
        MetaDataPK metadataPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.PositionHolders");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)metadataPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.mergeEmpTypeFilter("empType", filter);
        this.mergeUserFilter("user", filter);
        queryExec.setObjectView(evi);
        Person[] wfPersons = new Person[]{};
        try {
            wfPersons = this.getPersonArrayByIRowSet(context, queryExec.executeQuery());
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
        logger.debug((Object)(ResourceBase.getString((String)"com.kingdee.eas.basedata.person.PERSONAutoGenerateResource", (String)"34_PersonToWFAdapter", (Locale)context.getLocale()) + t.msValue() + "ms"));
        t.reset();
        return wfPersons;
    }

    public com.kingdee.bos.workflow.participant.JobInfo[] getJobsArray(Context context) throws WfParticipantException {
        JobCollection c = new JobCollection();
        try {
            IJob ij = JobFactory.getLocalInstance((Context)context);
            c = ij.getJobCollection("select id, name");
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        com.kingdee.bos.workflow.participant.JobInfo[] jobs = new com.kingdee.bos.workflow.participant.JobInfo[c.size()];
        JobInfo jInfo = null;
        Locale[] locales = PersonToWFAdapter.getContextLocales(context);
        for (int i = 0; i < jobs.length; ++i) {
            jInfo = c.get(i);
            jobs[i] = new com.kingdee.bos.workflow.participant.JobInfo();
            jobs[i].setId(jInfo.getId().toString());
            for (int j = 0; j < locales.length; ++j) {
                jobs[i].setName(locales[j], jInfo.getName(locales[j]));
            }
        }
        return jobs;
    }

    public Person[] getMLBranchPrincipal(Context ctx, String personId) throws WfParticipantException {
        String adminOrgId = "";
        try {
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            adminOrgId = ipm.getPositionMemberCollection("select position.adminOrgUnit.id where person.id = '" + personId + "' and isPrimary = 1").get(0).getPosition().getAdminOrgUnit().getId().toString();
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        String typeId = "00000000-0000-0000-0000-0000000000100FE9F8B5";
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FResponPositionId  \n");
        sb.append("FROM T_ORG_Admin  \n");
        sb.append("WHERE FID IN(  \n");
        sb.append("SELECT FToUnitId    \n");
        sb.append("\tFROM T_ORG_UNITRELATION  \n");
        sb.append("\tWHERE FTypeRelationId = ?  \n");
        sb.append("\tAND FFromUnitId = ?)  \n");
        String positionId = "";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{typeId, adminOrgId});
            if (rows.next()) {
                positionId = rows.getString("FResponPositionId");
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        return new PersonToWFAdapter().getPositionHolders(ctx, positionId);
    }

    public Person[] getMLHRPrincipal(Context ctx, String personId) throws WfParticipantException {
        String adminOrgId = "";
        try {
            IPositionMember ipm = PositionMemberFactory.getLocalInstance((Context)ctx);
            adminOrgId = ipm.getPositionMemberCollection("select position.adminOrgUnit.id where person.id = '" + personId + "' and isPrimary = 1").get(0).getPosition().getAdminOrgUnit().getId().toString();
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        String typeId = "00000000-0000-0000-0000-0000000000100FE9F8B5";
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FResponPositionId  \n");
        sb.append("FROM T_ORG_Admin  \n");
        sb.append("WHERE FID IN  \n");
        sb.append("(SELECT FFromUnitId  \n");
        sb.append("FROM T_ORG_UNITRELATION U  \n");
        sb.append("INNER JOIN T_Org_Admin A ON U.FFromUnitId = A.FID  \n");
        sb.append("WHERE U.FToUnitId in  \n");
        sb.append("(\tSELECT FToUnitId    \n");
        sb.append("\tFROM T_ORG_UNITRELATION  \n");
        sb.append("\tWHERE FTypeRelationId = ?  \n");
        sb.append("\tAND FFromUnitId = ?)  \n");
        sb.append("and U.FTypeRelationId = ?  \n");
        sb.append("and A.FNumber like '%XZ')  \n");
        String positionId = "";
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{typeId, adminOrgId, typeId});
            if (rows.next()) {
                positionId = rows.getString("FResponPositionId");
            }
        }
        catch (Exception e) {
            throw new WfParticipantException((Throwable)e);
        }
        return new PersonToWFAdapter().getPositionHolders(ctx, positionId);
    }

    public Person[] getPersonsFromGroup(Context context, String groupId) throws WfParticipantException {
        try {
            Locale[] locales = PersonToWFAdapter.getContextLocales(context);
            ArrayList<Person> personList = new ArrayList<Person>();
            String currDate = this.getCurrentDate();
            IRowSet rows = DbUtil.executeQuery((Context)context, (String)("select c.fid personid,c.fname_l1 personname_l1,c.fname_l2 personname_l2,c.fname_l3 personname_l3,a.fid userid,a.fname_l1 username_l1,a.fname_l2 username_l2,a.fname_l3 username_l3   from t_bas_magroupentry b  inner JOIN t_bd_person c     on b.FPERSONNEL = c.fid   LEFT OUTER JOIN (select *                      from t_pm_user                     where FIsDelete = 0                       and FIsLocked = 0                       and FForbidden = 0                       and FEffectiveDate < " + currDate + "                      and FInvalidationDate > " + currDate + "\t\t\t\t    ) a     on b.fpersonnel = a.fpersonid  where b.FPARENT = '" + groupId + "'"));
            while (rows.next()) {
                Person per = new Person();
                if (rows.getString("personid") != null) {
                    per.setEmployeeId(rows.getString("personid"));
                }
                if (rows.getString("userid") != null) {
                    per.setUserId(rows.getString("userid"));
                }
                for (int k = 0; k < locales.length; ++k) {
                    String field_userName = "username_" + locales[k].toString();
                    String field_personName = "personname_" + locales[k].toString();
                    if (rows.getString(field_personName) != null) {
                        per.setEmployeeName(locales[k], rows.getString(field_personName));
                    }
                    if (rows.getString(field_userName) == null) continue;
                    per.setUserName(locales[k], rows.getString(field_userName));
                }
                personList.add(per);
            }
            Person[] persons = new Person[personList.size()];
            personList.toArray(persons);
            return persons;
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (UuidException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    private String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    private boolean isPersonValid(PersonInfo perInto) {
        if (perInto == null || perInto.getEmployeeType() != null) {
            // empty if block
        }
        return true;
    }

    public Group[] getAllGroups(Context context) throws WfParticipantException {
        try {
            Locale[] locales = PersonToWFAdapter.getContextLocales(context);
            ArrayList<Person> ay = null;
            Group tempGroup = null;
            EntityViewInfo view = new EntityViewInfo();
            SorterItemCollection sorterColl = new SorterItemCollection();
            sorterColl.add(new SorterItemInfo("name"));
            view.setSorter(sorterColl);
            MAGroupCollection magCol = MAGroupFactory.getLocalInstance(context).getMAGroupCollection(view);
            Group[] group = new Group[magCol.size()];
            Iterator it = magCol.iterator();
            int num = 0;
            while (it.hasNext()) {
                MAGroupInfo magInfo = (MAGroupInfo)it.next();
                tempGroup = new Group();
                ay = new ArrayList<Person>();
                tempGroup.setGroupId(magInfo.getId().toString());
                tempGroup.setGroupName(context.getLocale(), magInfo.getName());
                for (int i = 0; i < magInfo.getEntries().size(); ++i) {
                    if (magInfo.getEntries().get(i).getPersonnel() == null || magInfo.getEntries().get(i).getPersonnel().getId() == null) continue;
                    BOSUuid id = magInfo.getEntries().get(i).getPersonnel().getId();
                    Person per = new Person();
                    if (!PersonFactory.getLocalInstance((Context)context).exists((IObjectPK)new ObjectUuidPK(id))) continue;
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("name"));
                    selector.add(new SelectorItemInfo("employeeType.id"));
                    selector.add(new SelectorItemInfo("employeeType.inService"));
                    PersonInfo perInto = PersonFactory.getLocalInstance((Context)context).getPersonInfo((IObjectPK)new ObjectUuidPK(id), selector);
                    if (!this.isPersonValid(perInto)) continue;
                    per.setEmployeeId(perInto.getId().toString());
                    for (int k = 0; k < locales.length; ++k) {
                        per.setEmployeeName(locales[k], perInto.getName(locales[k]));
                    }
                    IRowSet rows = DbUtil.executeQuery((Context)context, (String)("select * from t_pm_user where fpersonid = '" + id.toString() + "'"));
                    if (rows.next()) {
                        per.setUserId(rows.getString("fid"));
                        for (int k = 0; k < locales.length; ++k) {
                            String str = "fname_" + locales[k].toString();
                            per.setUserName(locales[k], rows.getString(str));
                        }
                    }
                    ay.add(per);
                }
                tempGroup.setPersons(ay);
                group[num] = tempGroup;
                ++num;
            }
            return group;
        }
        catch (EASBizException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (BOSException e) {
            throw new WfParticipantException((Throwable)e);
        }
        catch (SQLException e) {
            throw new WfParticipantException((Throwable)e);
        }
    }

    public Group[] getGroupArrayByEmployeeId(Context ctx, String employeeId) throws WfParticipantException {
        if (employeeId == null || employeeId.trim().length() <= 0) {
            return null;
        }
        Locale l1 = new Locale("l1");
        Locale l2 = new Locale("l2");
        Locale l3 = new Locale("l3");
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" select entry.fparent groupId,parent.FName_l1 groupName1 ");
            sb.append(" ,parent.FName_l2 groupName2,parent.FName_l3 groupName3 ");
            sb.append(" from T_BAS_MAGroupEntry entry ");
            sb.append("inner join T_BAS_MAGroup parent on entry.FParent = parent.fid");
            sb.append(" where entry.FPersonnel = '").append(employeeId).append("'");
            IRowSet groupRow = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            HashMap<String, Group> groupMap = new HashMap<String, Group>();
            while (groupRow.next()) {
                String groupId = groupRow.getString("groupId");
                if (groupId == null || groupMap.containsKey(groupId)) continue;
                Group g = new Group();
                g.setGroupId(groupId);
                if (groupRow.getString("groupName1") != null) {
                    g.setGroupName(l1, groupRow.getString("groupName1"));
                }
                if (groupRow.getString("groupName2") != null) {
                    g.setGroupName(l2, groupRow.getString("groupName2"));
                }
                if (groupRow.getString("groupName3") != null) {
                    g.setGroupName(l3, groupRow.getString("groupName3"));
                }
                groupMap.put(groupId, g);
            }
            if (groupMap.size() == 0) {
                return null;
            }
            sb.delete(0, sb.length());
            sb.append(" select entry.fparent groupId, ");
            sb.append(" p.Fid pId,p.FName_l1 pNm1,p.FName_l2 pNm2,p.FName_l3 pNm3,");
            sb.append(" u.FId usId,u.FName_l1 uNm1,u.FName_l2 uNm2,u.FName_l3 uNm3");
            sb.append(" from T_BAS_MAGroupEntry entry ");
            sb.append(" inner join t_bd_person p on entry.FPersonnel = p.FId ");
            sb.append(" inner join t_pm_user u on u.FPersonId = p.fid ");
            sb.append(" where entry.fparent in ");
            sb.append("(");
            sb.append(" select entry.fparent ");
            sb.append(" from T_BAS_MAGroupEntry entry ");
            sb.append(" where entry.FPersonnel = '").append(employeeId).append("'");
            sb.append(")");
            IRowSet personRow = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            HashMap personMap = new HashMap();
            while (personRow.next()) {
                List<Person> pList;
                String groupId = personRow.getString("groupId");
                if (personMap.containsKey(groupId)) {
                    pList = (List)personMap.get(groupId);
                } else {
                    pList = new ArrayList();
                    personMap.put(groupId, pList);
                }
                Person p = new Person();
                p.setEmployeeId(personRow.getString("pId"));
                p.setEmployeeName(l1, personRow.getString("pNm1"));
                p.setEmployeeName(l2, personRow.getString("pNm2"));
                p.setEmployeeName(l3, personRow.getString("pNm3"));
                p.setUserId(personRow.getString("usId"));
                p.setUserName(l1, personRow.getString("uNm1"));
                p.setUserName(l2, personRow.getString("uNm2"));
                p.setUserName(l3, personRow.getString("uNm3"));
                pList.add(p);
            }
            for (Map.Entry entry : groupMap.entrySet()) {
                String groupId = entry.getKey().toString();
                Group group = (Group)entry.getValue();
                if (!personMap.containsKey(groupId)) continue;
                group.setPersons((ArrayList)personMap.get(groupId));
            }
            Group[] groups = new Group[groupMap.size()];
            int i = 0;
            Iterator it = groupMap.values().iterator();
            while (it.hasNext()) {
                groups[i] = (Group)it.next();
                ++i;
            }
            return groups;
        }
        catch (Exception e) {
            throw new WfParticipantException(e.getCause());
        }
    }

    public void claenCache() throws WfException {
    }

    public void cleanCache() throws WfException {
    }

    public Set<String> getVoidedEmployees(Context ctx) {
        HashSet<String> voidedEmps = new HashSet<String>();
        try {
            String sql = "SELECT FID FROM T_BD_PERSON WHERE FDELETEDSTATUS = 2 ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs != null && rs.next()) {
                voidedEmps.add(rs.getString(1));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return voidedEmps;
    }
}

