/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.sns.task.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.dingtalk.DingtalkAPIInvokeUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DingtalkMessageDeal {
    private static Logger logger = Logger.getLogger(DingtalkMessageDeal.class);

    public static String Deal(Context ctx, String assignId) {
        String msgId = "";
        String dbCode = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String appKey = XTServiceConfig.getInstance().getDingtalkAppKey(eid);
        try {
            String sql = "select A.msgid,b.fxtid,b.FUnionid,a.fuserid  from t_assign_dtmsg A,t_pm_easdtusermap B  where A.fuserid=b.fuserid and  A.fassignid= ? and a.fstate  is null ";
            IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{assignId});
            if (countRowSet.size() > 0) {
                while (countRowSet.next()) {
                    Object columnObj = countRowSet.getObject("msgid");
                    Object columnObj1 = countRowSet.getObject("fxtid");
                    if (columnObj == null || columnObj1 == null) continue;
                    msgId = columnObj.toString();
                    String userid = columnObj1.toString();
                    String apiType = XTServiceConfig.getInstance().getDingtalkApiType();
                    if ("3".equals(apiType)) {
                        String unionid = countRowSet.getObject("FUnionid").toString();
                        DingtalkMessageDeal.dealTask(ctx, assignId, msgId, appKey, unionid);
                        continue;
                    }
                    DingtalkMessageDeal.dealNormalTodo(ctx, assignId, msgId, appKey, userid);
                }
            }
        }
        catch (Exception e) {
            DingtalkMessageDeal.insertError(msgId, assignId, e.getMessage(), "0", ctx);
            logger.error((Object)("xtmsg MsgId error:" + e.getMessage()));
        }
        return assignId;
    }

    private static void dealTask(Context ctx, String assignId, String msgId, String appKey, String unionid) throws Exception, BOSException {
        HashMap<String, Boolean> dealMap = new HashMap<String, Boolean>();
        dealMap.put("done", true);
        String resultStr = DingtalkAPIInvokeUtil.updateTaskMessage((String)JSON.toJSONString(dealMap), (String)unionid, (String)msgId, (String)appKey);
        logger.error((Object)("dtmsg changgetask re:" + resultStr));
        JSONObject result = JSON.parseObject((String)resultStr);
        if (result.getBooleanValue("result")) {
            DingtalkMessageDeal.updateTodo(ctx, msgId);
        } else {
            DingtalkMessageDeal.insertError(msgId, assignId, result.getString("message"), result.getString("code"), ctx);
        }
    }

    private static void dealNormalTodo(Context ctx, String assignId, String msgId, String appKey, String userid) throws Exception, BOSException {
        HashMap<String, String> dealMap = new HashMap<String, String>();
        dealMap.put("record_id", msgId);
        dealMap.put("userid", userid);
        String resultStr = DingtalkAPIInvokeUtil.updateTodoMessage((String)JSON.toJSONString(dealMap), (String)appKey);
        logger.error((Object)("dtmsg changge re:" + resultStr));
        JSONObject result = JSON.parseObject((String)resultStr);
        if (0 == result.getInteger("errcode")) {
            DingtalkMessageDeal.updateTodo(ctx, msgId);
        } else {
            DingtalkMessageDeal.insertError(msgId, assignId, result.getString("errmsg"), result.getInteger("errcode") + "", ctx);
        }
    }

    private static void updateTodo(Context ctx, String msgId) throws BOSException {
        String updatesql = "update t_assign_dtmsg  set fstate= '1' where  msgid=  ? ";
        DbUtil.execute((Context)ctx, (String)updatesql, (Object[])new Object[]{msgId});
    }

    public static void insertError(String msgid, String assignId, String errormsg, String errorcode, Context ctx) {
        try {
            String insertsql = " insert into t_assign_dtmsgdealerror(msgid,fassignid,errormsg,errorcode,sendtime) values('" + msgid + "','" + assignId + "','" + errormsg + "','" + errorcode + "',getdate())";
            DbUtil.execute((Context)ctx, (String)insertsql);
        }
        catch (Exception e) {
            logger.error((Object)("-----------deal dtmsg assignId \u5b58\u50a8\u9519\u8bef\u4fe1\u606f\u5931\u8d25: " + assignId));
        }
    }
}

