/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.sns.task.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.jms.TextMessage;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.lightapp.message.WFMessageAdapter;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.pa.api.YZJInvokeUtil;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.XTServiceFacade;
import com.kingdee.sns.task.util.YZJFlowCenterDeal;
import com.kingdee.sns.task.util.YZJMessageDeal;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MessageStatusHelper {
    private static Logger logger = Logger.getLogger(MessageStatusHelper.class);

    public static HashMap<String, Object> getStatusByAssignids(Context ctx, Set<String> assignids) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (assignids == null || assignids.size() == 0) {
            return null;
        }
        boolean isSurpportMobile = MessageStatusHelper.getIsSurpportMobile(ctx, assignids);
        if (isSurpportMobile) {
            HashSet<String> allAssignids = new HashSet<String>(assignids);
            HashSet<String> useYZJAssignids = MessageStatusHelper.getUseYZJAssignids(ctx, assignids);
            assignids.removeAll(useYZJAssignids);
            Set<String> haveDoneAssignids = MessageStatusHelper.getHaveDoneAssignid(ctx, useYZJAssignids);
            HashSet<String> haveDoneAssignidsCopy = new HashSet<String>(haveDoneAssignids);
            MessageStatusHelper.getSendSuccessAssign(ctx, useYZJAssignids, resultMap);
            useYZJAssignids.removeAll(resultMap.keySet());
            MessageStatusHelper.getSendFailedAssignMsg(ctx, useYZJAssignids, resultMap);
            haveDoneAssignids.removeAll(useYZJAssignids);
            Set<String> handledOkAssignids = MessageStatusHelper.getHandledOkAssignids(ctx, haveDoneAssignids);
            haveDoneAssignids.removeAll(handledOkAssignids);
            HashMap<String, Object> handledErrorInfo = MessageStatusHelper.getHandledErrorInfo(ctx, haveDoneAssignids);
            MessageStatusHelper.combineAllInfo(resultMap, handledErrorInfo, assignids, haveDoneAssignidsCopy, handledOkAssignids);
            MessageStatusHelper.dealNoMsg(allAssignids, haveDoneAssignidsCopy, resultMap);
        }
        resultMap.put("surpportMobile", isSurpportMobile);
        return resultMap;
    }

    public static HashMap<String, Object> reHandleProblemAssign(Context ctx, String assignid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            resultMap.put("success", false);
            if (MessageStatusHelper.checkAssignSentFlowCenter(ctx, assignid)) {
                String change2Done = YZJFlowCenterDeal.change2Done(ctx, assignid);
                if (!StringUtils.isEmpty((String)change2Done)) {
                    JSONObject result = JSON.parseObject((String)change2Done);
                    resultMap.put("success", (boolean)result.getBoolean("success"));
                    resultMap.put("errmsg", result.getString("error"));
                } else {
                    resultMap.put("errmsg", "\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5EAS\u80fd\u5426\u8bbf\u95ee\u4e91\u4e4b\u5bb6\u3002");
                }
            } else {
                String deal = YZJMessageDeal.Deal(assignid, ctx);
                if (!StringUtils.isEmpty((String)deal)) {
                    JSONObject parse = JSON.parseObject((String)deal);
                    String success = (String)parse.get((Object)"success");
                    String error = (String)parse.get((Object)"error");
                    resultMap.put("success", "true".equals(success));
                    resultMap.put("errmsg", error);
                    MessageStatusHelper.transferData(ctx, assignid);
                } else {
                    resultMap.put("errmsg", "\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5EAS\u80fd\u5426\u8bbf\u95ee\u4e91\u4e4b\u5bb6\u3002");
                }
            }
        }
        catch (Exception e) {
            resultMap.put("errmsg", e.getMessage());
        }
        return resultMap;
    }

    public static boolean checkAssignSentFlowCenter(Context ctx, String assignid) {
        boolean flag = false;
        try {
            String av = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
            if ("flowcenter".equals(av) && !StringUtils.isEmpty((String)assignid)) {
                String sql = "SELECT MSGID,PUSHTYPE FROM t_assign_xtmsg where fassignid = ? ";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{assignid});
                while (rowSet.next()) {
                    String msgid = rowSet.getString("MSGID");
                    String pushtype = rowSet.getString("PUSHTYPE");
                    if (!"1".equals(pushtype) && !msgid.startsWith("FC-")) continue;
                    flag = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"check assign sent flowcenter error", (Throwable)e);
        }
        return flag;
    }

    public static boolean checkAssignShouldSendFlowCenter(Context ctx, String assignid) {
        boolean flag = false;
        try {
            IEnactmentService svc;
            ProcessInstInfo pi;
            String initiatorId;
            String quarySql;
            IRowSet rowSet;
            String av = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
            if ("flowcenter".equals(av) && !StringUtils.isEmpty((String)assignid) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? "), (Object[])new Object[]{initiatorId = (pi = (svc = EnactmentServiceFactory.createEnactService((Context)ctx)).getProcessInstInfoByAssign(assignid)).getInitiatorId(), initiatorId})).next()) {
                flag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public static HashMap<String, Object> reSendProblemAssign(Context ctx, String assignid) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", false);
        try {
            String sql;
            IRowSet qryResult;
            if (MessageStatusHelper.checkAssignShouldSendFlowCenter(ctx, assignid)) {
                resultMap.put("errmsg", "\u6682\u672a\u652f\u6301\u4e91\u4e4b\u5bb6\u6d41\u7a0b\u4e2d\u5fc3\u7684\u5f85\u529e\u63a8\u9001");
            }
            if ((qryResult = DbUtil.executeQuery((Context)ctx, (String)(sql = "SELECT A.FPERSONUSERID, A.FASSIGNID, A.FPERSONUSERID, A.FASSIGNID,A.FBIZOBJID,A.FPRIORPERFORMERNAME_L2,A.FSUBJECT_L2,A.FBODY_L2,A.FPROCINSTID,A.FBIZFUNCTION,C.FINITIATORNAME_L2 FROM T_WFR_ASSIGN A, T_ASSIGN_XTMSGERROR B ,T_WFR_PROCINST C WHERE B.FASSIGNID = A.FASSIGNID AND C.FPROCINSTID = A.FPROCINSTID AND NOT EXISTS (SELECT 1 FROM T_ASSIGN_XTMSG C WHERE A.FASSIGNID = C.FASSIGNID) AND A.FASSIGNID = ?"), (Object[])new Object[]{assignid})).next()) {
                String receiver = qryResult.getString("fpersonuserid");
                String xtId = MessageStatusHelper.transferPersonIdToXtId(ctx, receiver);
                if (StringUtils.isEmpty((String)xtId)) {
                    resultMap.put("errmsg", "\u672a\u7ed1\u5b9aEAS\u7528\u6237\u3002");
                    return resultMap;
                }
                String YZJResult = MessageStatusHelper.checkSendFromYZJ(ctx, xtId, assignid);
                if (StringUtils.isEmpty((String)YZJResult)) {
                    resultMap.put("errmsg", "EAS\u8bf7\u6c42\u4e91\u4e4b\u5bb6\u51fa\u73b0\u4e86\u95ee\u9898\u3002");
                    return resultMap;
                }
                JSONObject result = JSON.parseObject((String)YZJResult);
                JSONObject dataObject = result.getJSONObject("data");
                int dealCount = dataObject.getIntValue("dealCount");
                int undelCount = dataObject.getIntValue("undelCount");
                boolean hasSent = MessageStatusHelper.recheckTodoAssignHasSent(ctx, assignid);
                if (dealCount == 0 && undelCount == 0 && !hasSent) {
                    Message makeMessage = MessageStatusHelper.makeMessage(ctx, qryResult);
                    Map<String, Object> reMap = MessageStatusHelper.sendYZJmsgAssign(ctx, makeMessage);
                    resultMap.put("success", "true".equals(reMap.get("success")));
                    resultMap.put("errmsg", reMap.get("errormsg"));
                    if ("true".equals(reMap.get("success"))) {
                        String msgId = (String)reMap.get("MsgId");
                        String userid = makeMessage.getStringHeader("receiver");
                        String insertXtmsgbackstage = " INSERT INTO T_ASSIGN_XTMSGBACKSTAGE(MSGID,FASSIGNID,FUSERID,FTYPE,FYZJRESULT,FSENDTIME) VALUES(?,?,?,?,?,GETDATE())";
                        DbUtil.execute((Context)ctx, (String)insertXtmsgbackstage, (Object[])new Object[]{msgId, assignid, userid, "artificial resend", YZJResult});
                        String delErrorSql = "DELETE FROM T_ASSIGN_XTMSGERROR WHERE FASSIGNID = ?";
                        DbUtil.execute((Context)ctx, (String)delErrorSql, (Object[])new Object[]{assignid});
                    }
                } else {
                    String eid = XTServiceConfig.getInstance().getEidByDbCode(ctx.getAIS());
                    String msgId = eid + "-" + assignid;
                    String insertXtmsg = " INSERT INTO T_ASSIGN_XTMSG(MSGID,FASSIGNID,FUSERID) VALUES(?,?,?)";
                    DbUtil.execute((Context)ctx, (String)insertXtmsg, (Object[])new Object[]{msgId, assignid, receiver});
                    resultMap.put("errmsg", "\u8be5\u5ba1\u6279\u4efb\u52a1\u5df2\u7ecf\u63a8\u9001\u8fc7\uff0c\u65e0\u9700\u518d\u6b21\u63a8\u9001\u3002");
                }
            } else {
                resultMap.put("errmsg", "\u6ca1\u6709\u63a8\u9001\u9519\u8bef\u8bb0\u5f55\uff0c\u4e0d\u80fd\u518d\u6b21\u63a8\u9001\u3002");
            }
        }
        catch (Exception e) {
            String msg = e instanceof ConnectException ? "EAS\u8bf7\u6c42\u4e91\u4e4b\u5bb6\u5931\u8d25\uff1a" + e.getMessage() : e.getMessage();
            resultMap.put("errmsg", msg);
            logger.error((Object)"reSendProblemAssign error ", (Throwable)e);
        }
        return resultMap;
    }

    private static void dealNoMsg(HashSet<String> allAssignids, HashSet<String> haveDoneAssignids, HashMap<String, Object> resultMap) {
        for (String assignid : allAssignids) {
            if (resultMap.containsKey(assignid)) continue;
            HashMap<String, Object> noYZJdMap = new HashMap<String, Object>();
            noYZJdMap.put("sent", false);
            noYZJdMap.put("assignState", "DONE");
            noYZJdMap.put("sentErrmsg", "\u672a\u67e5\u8be2\u5230\u6d88\u606f\u72b6\u6001\u3002");
            resultMap.put(assignid, noYZJdMap);
        }
    }

    private static boolean recheckTodoAssignHasSent(Context ctx, String assignid) {
        String sql = "SELECT 1 FROM T_ASSIGN_XTMSG C WHERE C.FASSIGNID = ? ";
        boolean result = false;
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{assignid});
            if (dataSet.next()) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("messageReSend ::recheckFromDB exception occur" + e.getMessage()));
        }
        return result;
    }

    private static HashSet<String> getUseYZJAssignids(Context ctx, Set<String> assignids) {
        HashSet<String> useYZJAssignids = new HashSet<String>();
        try {
            if (assignids != null && assignids.size() > 0) {
                String holder = MessageStatusHelper.getPlaceHolder(assignids);
                Object[] qryParam = MessageStatusHelper.getDoubleQuaryParam(assignids);
                String sql = "SELECT A.FASSIGNID FROM T_WFR_ASSIGN A, T_PM_EASXTUSERMAP B WHERE( A.FPERSONUSERID = B.FUSERID OR A.FPERSONEMPID =B.FPERSONID ) AND A.FASSIGNID IN (" + holder + ") UNION SELECT C.FASSIGNID FROM T_WFR_ASSIGNDETAIL C, T_PM_EASXTUSERMAP D WHERE( C.FPERSONUSERID = D.FUSERID OR C.FPERSONEMPID =D.FPERSONID ) AND C.FASSIGNID IN (" + holder + ")";
                IRowSet qryResult = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])qryParam);
                while (qryResult.next()) {
                    String assignid = qryResult.getString(1);
                    useYZJAssignids.add(assignid);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getUseYZJAssignids error ", (Throwable)e);
        }
        return useYZJAssignids;
    }

    private static void transferData(Context ctx, String assignid) {
        if (StringUtils.isEmpty((String)assignid)) {
            return;
        }
        try {
            String backupSql = "INSERT INTO t_assign_xtmsghst(MSGID,FASSIGNID,FUSERID,PROCINSTID,FSTATE,INFO,FBACKUPTIME)SELECT MSGID,FASSIGNID,FUSERID,PROCINSTID,FSTATE,INFO,GETDATE() FROM T_ASSIGN_XTMSG  WHERE FASSIGNID = ? ";
            DbUtil.execute((Context)ctx, (String)backupSql, (Object[])new Object[]{assignid});
            String clearSql = "DELETE FROM T_ASSIGN_XTMSG WHERE WHERE FASSIGNID = ?";
            DbUtil.execute((Context)ctx, (String)clearSql, (Object[])new Object[]{assignid});
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static void combineAllInfo(HashMap<String, Object> resultMap, HashMap<String, Object> handledErrorInfo, Set<String> noYZJAssignids, Set<String> haveDoneAssignids, Set<String> handledOkAssignids) {
        Set<String> resultKeySet = resultMap.keySet();
        for (String assignid : resultKeySet) {
            Map infoMap = (Map)resultMap.get(assignid);
            String assignState = haveDoneAssignids.contains(assignid) ? "DONE" : "TODO";
            infoMap.put("assignState", assignState);
            Map<String, Boolean> handledMap = null;
            if (handledOkAssignids.contains(assignid)) {
                handledMap = new HashMap<String, Boolean>();
                handledMap.put("handled", true);
            } else {
                if (handledErrorInfo.get(assignid) == null) continue;
                handledMap = (Map)handledErrorInfo.get(assignid);
            }
            infoMap.putAll(handledMap);
        }
        for (String assignid : noYZJAssignids) {
            HashMap<String, Object> noYZJdMap = new HashMap<String, Object>();
            noYZJdMap.put("sent", false);
            noYZJdMap.put("assignState", "NOYZJUSER");
            noYZJdMap.put("sentErrmsg", "\u7528\u6237\u672a\u4f7f\u7528\u6d41\u7a0b\u52a9\u624b\u3002");
            resultMap.put(assignid, noYZJdMap);
        }
    }

    private static Set<String> getHaveDoneAssignid(Context ctx, Set<String> assignids) {
        HashSet<String> haveDoneSet = new HashSet<String>();
        try {
            String placeHolder = MessageStatusHelper.getPlaceHolder(assignids);
            String sql = "SELECT FASSIGNID FROM T_WFR_ASSIGNDETAIL WHERE FASSIGNID IN(" + placeHolder + ")";
            IRowSet qryResult = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])assignids.toArray());
            while (qryResult.next()) {
                String assignid = qryResult.getString(1);
                haveDoneSet.add(assignid);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getHaveDoneAssignid error ", (Throwable)e);
        }
        return haveDoneSet;
    }

    private static HashMap<String, Object> getHandledErrorInfo(Context ctx, Set<String> assignids) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (assignids.size() > 0) {
            try {
                String holder = MessageStatusHelper.getPlaceHolder(assignids);
                String sql = "SELECT FASSIGNID,ERRORMSG FROM T_ASSIGN_CHANGGEERROR WHERE   FASSIGNID IN (" + holder + ")";
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])assignids.toArray());
                while (result.next()) {
                    HashMap<String, Object> statusMap = new HashMap<String, Object>();
                    String fassignid = result.getString(1);
                    String errormsg = result.getString(2);
                    statusMap.put("handled", false);
                    statusMap.put("handledErrmsg", MessageStatusHelper.handleNormalError(errormsg));
                    resultMap.put(fassignid, statusMap);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return resultMap;
    }

    private static Message makeMessage(Context ctx, IRowSet qryResult) throws SQLException {
        TextMessage message = new TextMessage();
        message.setStringHeader("receiver", qryResult.getString("FPERSONUSERID"));
        String assignid = qryResult.getString("fassignid");
        message.setStringHeader("assignid", assignid);
        message.setStringHeader("solution", "eas");
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("bizfunction", qryResult.getString("FBIZFUNCTION"));
        String initiatorName = qryResult.getString("FINITIATORNAME_L2");
        String billID = qryResult.getString("FBIZOBJID");
        message.setStringHeader("billID", billID);
        message.setStringHeader("sendId", initiatorName);
        String billAlias = "";
        BOSObjectType bostype = null;
        if (billID != null) {
            bostype = BOSUuid.getBOSObjectType((String)billID, (boolean)true);
            EntityObjectInfo entityinfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bostype);
            billAlias = entityinfo.getAlias();
        }
        logger.info((Object)("XT message send bostype :" + bostype));
        Locale locale = new Locale("L2");
        String pre = (initiatorName == null ? "" : String.valueOf(initiatorName) + "\u7684") + billAlias;
        message.setLocaleStringHeader("predetails", pre, locale);
        message.setLocaleStringHeader("title", qryResult.getString("FSUBJECT_L2"), locale);
        message.setLocaleStringHeader("body", qryResult.getString("FBODY_L2"), locale);
        return message;
    }

    private static Map<String, Object> sendYZJmsgAssign(Context ctx, Message message) throws EASBizException, BOSException {
        WFMessageAdapter adapter = new WFMessageAdapter(message);
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        String receiver = message.getStringHeader("receiver");
        String assignid = message.getStringHeader("assignid");
        UserInfo userInfo = (UserInfo)user.getValue((IObjectPK)new ObjectStringPK(receiver));
        String userid = userInfo.getId().toString();
        ArrayList<WFMessageAdapter> adlist = new ArrayList<WFMessageAdapter>();
        adlist.add(adapter);
        Map map = XTServiceFacade.pushWithToken((Context)ctx, adlist, (String)"WFMessage");
        boolean bResult = (Boolean)map.get("bResult");
        logger.info((Object)("XT Messages send result :: " + bResult));
        String msgId = (String)map.get("MsgId");
        if (bResult && !StringUtils.isEmpty((String)msgId) && !"".equals(assignid)) {
            try {
                map.put("sucess", true);
                String insertXtmsg = " insert into t_assign_xtmsg(msgid,fassignid,fuserid) values(?,?,?)";
                DbUtil.execute((Context)ctx, (String)insertXtmsg, (Object[])new Object[]{msgId, assignid, userid});
                logger.info((Object)("message resend " + msgId));
            }
            catch (Exception localException1) {
                logger.error((Object)(assignid + "##MsgId:" + msgId + " resend result:" + bResult + ",insert fail " + localException1.getMessage()));
            }
        }
        return map;
    }

    public static String checkSendFromYZJ(Context ctx, String openid, String assignid) throws Exception {
        String ais = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(ais);
        String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
        String token = YZJInvokeUtil.getInstance().getAccessToken(appId, null);
        String url = XTServiceConfig.getInstance().getXTMcloudUrl() + "/gateway/newtodo/open/checkcreatetodo.json?accessToken=" + token;
        String itemid = eid + "-" + assignid;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("accessToken", token);
        param.put("sourceitemid", itemid);
        param.put("sourcetype", appId);
        param.put("openId", openid);
        return HttpClientUtil.doPost((String)url, (String)JSON.toJSONString(param), (String)"UTF-8");
    }

    public static String transferPersonIdToXtId(Context ctx, String personId) {
        IRowSet rs;
        String xtId = "";
        String sql = "select FXtId from T_PM_easxtusermap where FuserId = ?";
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{personId});
            if (rs.next() && !StringUtil.isEmpty((String)rs.getString("FXtId"))) {
                xtId = rs.getString("FXtId");
            }
        }
        catch (Exception e) {
            logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
        }
        if (StringUtil.isEmpty((String)xtId)) {
            sql = "select FXtId from T_PM_easxtusermap where FPersonId = ?";
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{personId});
                if (rs.next() && !StringUtil.isEmpty((String)rs.getString("FXtId"))) {
                    xtId = rs.getString("FXtId");
                }
            }
            catch (Exception e) {
                logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()), (Throwable)e);
            }
        }
        return xtId;
    }

    private static Set<String> getHandledOkAssignids(Context ctx, Set<String> assignids) {
        HashSet<String> resultSet = new HashSet<String>();
        if (assignids.size() > 0) {
            String holder = MessageStatusHelper.getPlaceHolder(assignids);
            Object[] param = MessageStatusHelper.getDoubleQuaryParam(assignids);
            String sql = "SELECT FASSIGNID FROM T_ASSIGN_XTMSG WHERE FSTATE = 1 AND FASSIGNID IN (" + holder + ") UNION SELECT FASSIGNID FROM T_ASSIGN_XTMSGHST WHERE FSTATE = 1 AND FASSIGNID IN (" + holder + ")";
            try {
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
                while (result.next()) {
                    String fassignid = result.getString(1);
                    resultSet.add(fassignid);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return resultSet;
    }

    private static Object[] getDoubleQuaryParam(Set<String> assignids) {
        Object[] param = null;
        if (assignids != null) {
            int size = assignids.size();
            param = new Object[size * 2];
            int i = 0;
            for (String assignid : assignids) {
                param[i] = assignid;
                param[i + size] = assignid;
                ++i;
            }
        }
        return param;
    }

    private static String getPlaceHolder(Set<String> assignids) {
        String holder = "";
        StringBuilder placeholder = new StringBuilder();
        for (int i = 0; i < assignids.size(); ++i) {
            placeholder.append("?,");
        }
        if (placeholder.length() > 1) {
            holder = placeholder.substring(0, placeholder.length() - 1);
        }
        return holder;
    }

    private static void getSendFailedAssignMsg(Context ctx, Set<String> assignids, HashMap<String, Object> resultMap) {
        try {
            if (assignids.size() == 0) {
                return;
            }
            String placeholder = MessageStatusHelper.getPlaceHolder(assignids);
            String sql = "SELECT FASSIGNID,ERRORMSG FROM T_ASSIGN_XTMSGERROR WHERE FASSIGNID IN (" + placeholder + ")";
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])assignids.toArray());
            while (result.next()) {
                String fassignid = result.getString("FASSIGNID");
                String errormsg = result.getString("ERRORMSG");
                HashMap<String, Object> statusMap = new HashMap<String, Object>();
                statusMap.put("sent", false);
                statusMap.put("sentErrmsg", MessageStatusHelper.dealNormalError(errormsg));
                resultMap.put(fassignid, statusMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private static String dealNormalError(String errormsg) {
        if (StringUtils.isEmpty((String)errormsg) || "null".equals(errormsg)) {
            return "\u5c1d\u8bd5\u63a8\u9001\u5931\u8d25\u3002";
        }
        if ("nouser".equals(errormsg)) {
            return "\u4efb\u52a1\u751f\u6210\u65f6\uff0c\u7528\u6237\u8fd8\u672a\u4f7f\u7528\u6d41\u7a0b\u52a9\u624b\u3002";
        }
        if ("Read timed out".equals(errormsg)) {
            return "\u63a8\u9001\u6d88\u606f\u65f6\u8fde\u63a5\u4e91\u4e4b\u5bb6\u6210\u529f\uff0c\u4f46\u662f\u4e91\u4e4b\u5bb6\u6ca1\u6709\u53ca\u65f6\u8fd4\u56de\u6570\u636e\u3002";
        }
        if ("Connection refused".equals(errormsg) || "kingdee.yunzhijia.com".equals(errormsg) || "www.yunzhijia.com".equals(errormsg) || "mcloud.kingdee.com".equals(errormsg)) {
            return "EAS\u670d\u52a1\u5668\u4e0d\u80fd\u8bbf\u95ee\u4e91\u4e4b\u5bb6\uff0c\u8bf7\u68c0\u67e5EAS\u80fd\u5426\u8bbf\u95ee\u4e91\u4e4b\u5bb6\u3002";
        }
        if ("org/apache/http/client/HttpClient".equals(errormsg)) {
            return "EAS\u73af\u5883\u7f3a\u5c11\u5fc5\u8981\u7b2c\u4e09\u65b9jar\u5305\uff1ahttpclient\u3002";
        }
        errormsg = errormsg.replaceAll("\"", "\\\"").replaceAll("{", "\\{").replaceAll("{", "\\}");
        return errormsg;
    }

    private static String handleNormalError(String errormsg) {
        if (StringUtils.isEmpty((String)errormsg) || "null".equals(errormsg)) {
            return "\u5904\u7406\u4e91\u4e4b\u5bb6\u5f85\u529e\u4efb\u52a1\u5931\u8d25\uff0c\u539f\u56e0\u672a\u77e5\u3002";
        }
        if ("Read timed out".equals(errormsg)) {
            return "\u5904\u7406\u5f85\u529e\u65f6\u8fde\u63a5\u4e91\u4e4b\u5bb6\u6210\u529f\uff0c\u4f46\u662f\u4e91\u4e4b\u5bb6\u6ca1\u6709\u53ca\u65f6\u8fd4\u56de\u6570\u636e\u3002";
        }
        if ("\u67e5\u8be2msg\u5931\u8d25".equals(errormsg)) {
            return "\u672a\u67e5\u8be2\u5f85\u529e\u4efb\u52a1\u7684\u6d88\u606f\u8bb0\u5f55\u3002";
        }
        if ("Connection refused".equals(errormsg) || "kingdee.yunzhijia.com".equals(errormsg) || "www.yunzhijia.com".equals(errormsg) || "mcloud.kingdee.com".equals(errormsg)) {
            return "EAS\u670d\u52a1\u5668\u4e0d\u80fd\u8bbf\u95ee\u4e91\u4e4b\u5bb6\uff0c\u8bf7\u68c0\u67e5EAS\u80fd\u5426\u8bbf\u95ee\u4e91\u4e4b\u5bb6\u3002";
        }
        if (errormsg.contains("\u8bf7\u6c42\u7684URI\u5730\u5740\u4e0d\u5b58\u5728")) {
            return "\u6d41\u7a0b\u52a9\u624b\u914d\u7f6e\u6709\u8bef\uff0c\u4e91\u4e4b\u5bb6\u5730\u5740\u672a\u914d\u7f6e\u6b63\u786e\u3002";
        }
        errormsg = errormsg.replaceAll("\"", "\\\"").replaceAll("{", "\\{").replaceAll("{", "\\}");
        return errormsg;
    }

    private static void getSendSuccessAssign(Context ctx, Set<String> assignids, HashMap<String, Object> resultMap) {
        if (assignids != null && assignids.size() > 0) {
            Object[] param = MessageStatusHelper.getDoubleQuaryParam(assignids);
            String holder = MessageStatusHelper.getPlaceHolder(assignids);
            String sql = "SELECT FASSIGNID FROM T_ASSIGN_XTMSG WHERE FASSIGNID IN (" + holder + ") UNION SELECT FASSIGNID FROM T_ASSIGN_XTMSGHST WHERE FASSIGNID IN (" + holder + ")";
            try {
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
                while (result.next()) {
                    String fassignid = result.getString(1);
                    HashMap<String, Boolean> statusMap = new HashMap<String, Boolean>();
                    statusMap.put("sent", true);
                    resultMap.put(fassignid, statusMap);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private static boolean getIsSurpportMobile(Context ctx, Set<String> assignids) {
        Iterator<String> iterator;
        boolean issupportmobile = true;
        if (assignids != null && assignids.size() > 0 && (iterator = assignids.iterator()).hasNext()) {
            String assignid = iterator.next();
            try {
                String sql = "SELECT  fassignid FROM t_wfr_assign where fissupportmobile = 1 and fassignid = ? union SELECT  fassignid FROM t_wfr_assigndetail where fissupportmobile = 1 and fassignid = ? ";
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{assignid, assignid});
                if (result.size() < 1) {
                    issupportmobile = false;
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return issupportmobile;
    }

    public static boolean checkDeployed(Context ctx) {
        XTServiceConfig configInstance = XTServiceConfig.getInstance();
        String eid = null;
        String host = null;
        String enabled = null;
        try {
            eid = configInstance.getEidByDbCode(ctx.getAIS());
            host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
            enabled = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "enabled", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfigurationItem wXitem = XTServiceConfig.getInstance().getConfigurationItem("WX");
        ConfigurationItem dingtalkitem = XTServiceConfig.getInstance().getConfigurationItem("Dingtalk");
        ConfigurationItem otherAppitem = XTServiceConfig.getInstance().getConfigurationItem("OtherApp");
        return !StringUtils.isEmpty((String)eid) && !StringUtils.isEmpty((String)host) && "true".equals(enabled) && wXitem == null && dingtalkitem == null && otherAppitem == null;
    }
}

