/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bs.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.BizFieldEnum;
import com.kingdee.eas.bs.ml.EASMultiLanResInfo;
import com.kingdee.eas.bs.ml.EASResourceException;
import com.kingdee.eas.bs.ml.MetaDataTypeEnum;
import com.kingdee.eas.bs.ml.PresetDataResInfo;
import com.kingdee.eas.bs.ml.ResourceFacadeFactory;
import com.kingdee.eas.bs.ml.app.AbstractMLFacadeControllerBean;
import com.kingdee.eas.bs.ml.app.MLFacadeHelper;
import com.kingdee.eas.bs.ml.app.RemoveDuplicatedWordsInTransDB;
import com.kingdee.eas.bs.ml.app.ResourceServerCache;
import com.kingdee.eas.bs.ml.app.UpdateMLFieldResourceHelper;
import com.kingdee.eas.bs.ml.app.UpdateMetasResourceHelper;
import com.kingdee.eas.bs.ml.app.UpdateTemplateMLResourceHelper;
import com.kingdee.eas.bs.ml.util.MLConstonts;
import com.kingdee.eas.bs.ml.util.MLToolsConstonts;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.bs.ml.util.MetaDataResourceInfo;
import com.kingdee.eas.bs.ml.util.PrintWriteResource;
import com.kingdee.eas.bs.ml.util.ResourceInfo;
import com.kingdee.eas.bs.ml.util.WorkFlowWriteResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tools.datatask.ImportModeEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MLFacadeControllerBean
extends AbstractMLFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.bs.ml.app.MLFacadeControllerBean");

    @Override
    protected Map _importContent(Context ctx, List list, boolean isUpdateAllWords, int errorHandleMode, String lan) throws BOSException, EASBizException {
        if (list == null || list.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            this.updateImport(ctx, list, isUpdateAllWords, errorHandleMode, lan);
        }
        catch (Exception e) {
            map.put("hasError", Boolean.TRUE);
            map.put("errorStr", e.getMessage());
        }
        return map;
    }

    private Map updateImport(Context ctx, List list, boolean isUpdateAllWords, int errorHandleMode, String lan) throws Exception {
        String upd_sql = isUpdateAllWords ? "update t_res_EASMultiLanRes set FContent = ?,FTransLatorID = ?, FTransTime = ?,FIsTranslated = ? ,FRemarks=? where FCNMD5Code = ? and FLanguageID = '" + lan + "'" : "update t_res_EASMultiLanRes set FContent = ?,FTransLatorID = ?, FTransTime = ?,FIsTranslated = ? ,FRemarks=? where FCNMD5Code = ? and FLanguageID = '" + lan + "' and FIsTranslated = 0";
        Connection conn = super.getConnection(ctx);
        try {
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Timestamp transTime = new Timestamp(System.currentTimeMillis());
            PreparedStatement ps = conn.prepareStatement(upd_sql);
            int j = list.size();
            for (int i = 0; i < j; ++i) {
                ResourceInfo info = (ResourceInfo)list.get(i);
                String cn = MLUtils.myTrim(info.getCn());
                String content = MLUtils.myTrim(info.getContent());
                String description = MLUtils.myTrim(info.getDescription());
                if (MLUtils.isEmpty(cn) || MLUtils.isEmpty(content)) continue;
                if (content.length() > 2000) {
                    throw new EASResourceException(EASResourceException.TRANSLATE_TOO_LONG, new Object[]{new Integer(i + 3)});
                }
                String md5 = MLUtils.md5HashCode(cn);
                ps.setString(1, content);
                ps.setString(2, userId);
                ps.setTimestamp(3, transTime);
                ps.setInt(4, 1);
                ps.setString(5, description);
                ps.setString(6, md5);
                ps.addBatch();
                if (i == 0 || i % 4000 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            ps.executeBatch();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return Collections.EMPTY_MAP;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map addNewImport(Context ctx, List list, int errorHandleMode, String lan) throws Exception {
        PreparedStatement ps;
        Connection conn;
        block6: {
            this.updateImport(ctx, list, false, errorHandleMode, lan);
            conn = null;
            ps = null;
            String tempName = null;
            TempTablePool pool = null;
            try {
                conn = super.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                StringBuffer sb = new StringBuffer("create table tempTAB ");
                sb.append("(");
                sb.append(" FMD5 varchar(32), ");
                sb.append(" FLanguage varchar(32), ");
                sb.append(" FCN nvarchar(1000),");
                sb.append(" FContent nvarchar(2000)");
                sb.append(")");
                tempName = pool.createTempTable(sb.toString());
                String ins_sql = "insert into " + tempName + "(FMD5,FLanguage,FContent,FCN) values(?,?,?,?)";
                ps = conn.prepareStatement(ins_sql);
                int j = list.size();
                for (int i = 0; i < j; ++i) {
                    ResourceInfo info = (ResourceInfo)list.get(i);
                    String cn = MLUtils.myTrim(info.getCn());
                    String content = MLUtils.myTrim(info.getContent());
                    if (MLUtils.isEmpty(cn) || MLUtils.isEmpty(content)) continue;
                    String md5 = MLUtils.md5HashCode(cn);
                    ps.setString(1, md5);
                    ps.setString(2, lan);
                    ps.setString(3, content);
                    ps.setString(4, cn);
                    ps.addBatch();
                }
                ps.executeBatch();
                MLFacadeHelper.addNewWordsAndTrans(ctx, conn, tempName, lan);
                if (pool == null) break block6;
            }
            catch (Exception ex) {
                try {
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        pool.releaseTable(tempName);
                    }
                    SQLUtils.cleanup(ps);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tempName);
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
        return Collections.EMPTY_MAP;
    }

    @Override
    protected void _submitMLRes(Context ctx, List ids) throws BOSException {
        if (ids == null || ids.size() <= 0) {
            return;
        }
        Connection conn = super.getConnection(ctx);
        String upd_sql = "update t_res_EASMultiLanRes set FISTranslated = 1 where fid = ? ";
        try {
            PreparedStatement ps = conn.prepareStatement(upd_sql);
            for (int i = 0; i < ids.size(); ++i) {
                ps.setString(1, ids.get(i).toString());
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateSysResource(Context ctx, boolean isSelectedUpdate, List selectes, String language, BizFieldEnum bizField) throws BOSException, EASBizException {
        if (isSelectedUpdate && (selectes == null || selectes.size() <= 0)) {
            return;
        }
        if (language == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select FCNMD5Code md5, FContent en, FMenuContent men, FIsMenuType mety from t_res_EASMultiLanRes where ");
        if (isSelectedUpdate) {
            StringBuffer sbIn = new StringBuffer();
            for (int i = 0; i < selectes.size(); ++i) {
                if (i % 1000 == 0 && i > 0) {
                    sbIn.deleteCharAt(sbIn.length() - 1);
                    sbIn.append(") OR fid in ( '" + selectes.get(i).toString() + "',");
                    continue;
                }
                sbIn.append("'" + selectes.get(i).toString() + "',");
            }
            sbIn.deleteCharAt(sbIn.length() - 1);
            sb.append(" fid in (" + sbIn.toString() + ")");
            sb.append(" and FLanguageId = '").append(language).append("'");
            sb.append(" and FISTransLated = ").append(1);
        } else {
            sb.append(" FLanguageId = '").append(language).append("'");
            sb.append(" and FISTransLated = ").append(1);
        }
        String tempTable = null;
        Connection conn = null;
        try {
            tempTable = TableManager.getTableManager((Context)ctx).getTableName("ML_TABLE");
            String sqlTemp = " SELECT * INTO " + tempTable + " FROM (" + sb.toString() + " ) TT";
            DbUtil.execute((Context)ctx, (String)sqlTemp);
            String columns = "md5";
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).createDBSystemTempTableIndex(tempTable, columns, true, false, conn);
            UpdateMetasResourceHelper.updateSystemRes(ctx, tempTable, language);
            UpdateTemplateMLResourceHelper.updateTemplateMLRes(ctx, tempTable, language);
        }
        catch (Exception e1) {
            try {
                throw new BOSException((Throwable)e1);
            }
            catch (Throwable throwable) {
                try {
                    TableManager.getTableManager((Context)ctx).releaseTable(tempTable);
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                if (conn != null) {
                    SQLUtils.cleanup(conn);
                }
                throw throwable;
            }
        }
        try {
            TableManager.getTableManager((Context)ctx).releaseTable(tempTable);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        if (conn != null) {
            SQLUtils.cleanup((Connection)conn);
        }
        this.updateServerTimestamp(ctx);
    }

    private void updateServerCache(Context ctx) throws BOSException {
        ResourceFacadeFactory.getLocalInstance(ctx).clearResourceCache();
    }

    private void updateServerTimestamp(Context ctx) {
        String now = String.valueOf(System.currentTimeMillis());
        String updateSql = "update T_Res_CacheTime set FCacheTime='" + now + "'";
        try {
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void _fetchNewWords(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = super.getConnection(ctx);
            MLFacadeHelper.fetchNewWordsFromMetaRes(ctx, conn);
            MLFacadeHelper.fetchNewWordsFromPresetDataRes(ctx, conn);
            MLFacadeHelper.fetchNewWordsFromTemplate(ctx, conn);
            RemoveDuplicatedWordsInTransDB.getInstance().RemoveDuplicatedWordsInTransDB(ctx);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected Map _getSystemResource(Context ctx, String md5Code) throws BOSException, EASBizException {
        if (md5Code == null) {
            return Collections.EMPTY_MAP;
        }
        Connection conn = null;
        HashMap<String, List> map = new HashMap<String, List>(10, 0.75f);
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            List ltMetas = MLFacadeHelper.getSystemResourceFromMetas(ctx, conn, md5Code);
            List ltPresetData = MLFacadeHelper.getSystemResourceFromPresetData(ctx, conn, md5Code);
            List ltTemp = MLFacadeHelper.getSystemResourceFromTemplate(ctx, conn, md5Code);
            map.put(MLConstonts.Metas_Resource, ltMetas);
            map.put(MLConstonts.PresetData_Resource, ltPresetData);
            map.put(MLConstonts.Template_Resource, ltTemp);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return map;
    }

    @Override
    protected void _deleteResource(Context ctx, List mlIds) throws BOSException, EASBizException {
        if (mlIds == null || mlIds.size() <= 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mlIds.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append("'").append(mlIds.get(i)).append("'");
        }
        String resSql = "select FParentId from t_res_EASMultiLanRes where fid in (" + sb.toString() + ")";
        String resDelSql = "delete from t_res_EASResource where fid in (" + resSql + ")";
        String mlResDelSql = "delete from t_res_EASMultiLanRes where FParentId in (" + resSql + ")";
        DbUtil.execute((Context)ctx, (String)resDelSql);
        DbUtil.execute((Context)ctx, (String)mlResDelSql);
    }

    @Override
    protected Map _updateMLFieldResource(Context ctx, String language, boolean isUpdateAllMlField, List tables) throws BOSException {
        try {
            boolean isExistInitMLDB = ResourceFacadeFactory.getLocalInstance(ctx).checkExistInitMLDB();
            if (!isExistInitMLDB) {
                return Collections.EMPTY_MAP;
            }
            UpdateMLFieldResourceHelper.getInstance().startUpdate(ctx, language, isUpdateAllMlField, tables);
            return Collections.EMPTY_MAP;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
    }

    @Override
    protected void _recoverSysRes(Context ctx, List ids, String lang, boolean selectedRecover) throws BOSException, EASBizException {
        if (lang == null) {
            return;
        }
        if (selectedRecover && (ids == null || ids.size() <= 0)) {
            return;
        }
        Map map = this.getMetasResTab();
        StringBuffer condition = new StringBuffer();
        if (selectedRecover) {
            condition.append(" where FId in (");
            for (int i = 0; i < ids.size(); ++i) {
                if (i != 0) {
                    condition.append(",");
                }
                condition.append("'").append(ids.get(i)).append("'");
            }
            condition.append(")");
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sb = new StringBuffer();
            PreparedStatement ps = null;
            PreparedStatement mlPS = null;
            PreparedStatement mlPS2 = null;
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                sb.delete(0, sb.length());
                Map.Entry entry = it.next();
                String resTab = entry.getKey().toString();
                String mlTab = entry.getValue().toString();
                sb.append(" select FId id, FRes res from ").append(resTab);
                if (selectedRecover) {
                    sb.append(condition.toString());
                }
                if ("zh_CN".equals(lang)) {
                    ps = conn.prepareStatement("update " + resTab + " set FRes2 = FRes, FMD5 = ? where fid = ? ");
                    mlPS = conn.prepareStatement("update " + mlTab + " set FCNMD5 = ? where FResId = ? ");
                } else {
                    mlPS2 = conn.prepareStatement("update " + mlTab + " set FMLRes2 = FMLRes, FForbidSysUpd = 0 where FResId = ? and FLanguage = ?");
                }
                ResultSet rs = conn.createStatement().executeQuery(sb.toString());
                int c = 0;
                while (rs.next()) {
                    String id = rs.getString("id");
                    String res = rs.getString("res");
                    String md5 = MLUtils.md5HashCode(res);
                    if (md5 == null) continue;
                    if ("zh_CN".equals(lang)) {
                        ps.setString(1, md5);
                        ps.setString(2, id);
                        ps.addBatch();
                        mlPS.setString(1, md5);
                        mlPS.setString(2, id);
                        mlPS.addBatch();
                    } else {
                        mlPS2.setString(1, id);
                        mlPS2.setString(2, lang);
                        mlPS2.addBatch();
                    }
                    if (++c <= 5000) continue;
                    if ("zh_CN".equals(lang)) {
                        ps.executeBatch();
                        mlPS.executeBatch();
                        ps.clearBatch();
                        mlPS.clearBatch();
                    } else {
                        mlPS2.executeBatch();
                        mlPS2.clearBatch();
                    }
                    c = 0;
                }
                if ("zh_CN".equals(lang)) {
                    ps.executeBatch();
                    mlPS.executeBatch();
                } else {
                    mlPS2.executeBatch();
                }
                SQLUtils.cleanup((Statement)ps);
                SQLUtils.cleanup((Statement)mlPS);
                SQLUtils.cleanup((Statement)mlPS2);
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        catch (Exception ex) {
            throw new BOSException(ex.getMessage(), ex.getCause());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private Map getMetasResTab() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("t_res_uiresource", "t_res_uimultilan");
        map.put("t_res_resresource", "t_res_resmultilan");
        map.put("t_res_enumresource", "t_res_enummultilan");
        map.put("t_res_entityresource", "t_res_entitymultilan");
        map.put("t_res_queryresource", "t_res_querymultilan");
        map.put("t_res_permresource", "t_res_permmultilan");
        return map;
    }

    @Override
    protected void _analyseUIMenuType(Context ctx) throws BOSException {
        String sql = "UPDATE T_RES_UIRESOURCE SET FResUiType = ? WHERE FKEY like ? ";
        String clearSql = " UPDATE T_RES_UIRESOURCE SET FResUiType = ? ";
        DbUtil.execute((Context)ctx, (String)clearSql, (Object[])new Object[]{"10"});
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"1", "menuItem%"});
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"3", "this.title%"});
        sql = "UPDATE T_RES_EASMultiLanRes SET FIsMenuType = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{String.valueOf(0)});
        sql = "UPDATE T_RES_EASMultiLanRes SET FIsMenuType = ? WHERE FCNMD5Code IN(SELECT FMD5 FROM T_RES_UIRESOURCE WHERE FResUiType IN(?,?,?))";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{String.valueOf(1), "1", "2", "3"});
        StringBuffer sb2 = new StringBuffer();
        sb2.append(" UPDATE T_RES_EASMultiLanRes SET FIsMenuType = ? WHERE FCNMD5Code IN( ");
        sb2.append("   SELECT FMD5 FROM T_RES_PresetDataRes where FParentID IN ( ");
        sb2.append("     SELECT FID FROM T_RES_MultiFieldMeta where FTableName IN('t_bas_sysmenuitem','t_pm_mainmenuitem') ");
        sb2.append("   )  ");
        sb2.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sb2.toString(), (Object[])new Object[]{String.valueOf(1)});
        sql = "UPDATE T_RES_EASMultiLanRes SET fmenucontent = fcontent where FIsMenuType = ? and (fmenucontent is null or fmenucontent = '')";
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{String.valueOf(1)});
    }

    @Override
    protected String _getServerCacheTime(Context ctx) throws BOSException {
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)"select FCacheTime from T_Res_CacheTime");
        String cachetime = null;
        try {
            if (rowset.next()) {
                cachetime = rowset.getString("FCacheTime");
                if (StringUtils.isEmpty((String)cachetime)) {
                    cachetime = Long.toString(System.currentTimeMillis());
                    String updateMenuSql = "update T_Res_CacheTime set FCacheTime='" + cachetime + "'";
                    DbUtil.execute((Context)ctx, (String)updateMenuSql);
                }
                return cachetime;
            }
            cachetime = Long.toString(System.currentTimeMillis());
            EASMultiLanResInfo info = new EASMultiLanResInfo();
            String insertSql = "insert into T_Res_CacheTime(FID,FCacheTime) values(?,?) ";
            Object[] params = new Object[]{BOSUuid.create((BOSObjectType)info.getBOSType()).toString(), cachetime};
            DbUtil.execute((Context)ctx, (String)insertSql, (Object[])params);
            return cachetime;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            cachetime = null;
            return cachetime;
        }
    }

    @Override
    protected void _updateServerCacheByKeyList(Context ctx, List keyList) throws BOSException {
        if (keyList == null || keyList.size() == 0) {
            return;
        }
        String key = null;
        int j = keyList.size();
        for (int i = 0; i < j; ++i) {
            key = (String)keyList.get(i);
            ResourceServerCache.getInstance().remove(key);
        }
        this.updateServerTimestamp(ctx);
    }

    @Override
    protected void _updateMenuResource(Context ctx, String language) throws BOSException, EASBizException {
        Boolean isAllUpdate = Boolean.FALSE;
        ArrayList<String> tables = new ArrayList<String>();
        tables.add("t_bas_sysmenuitem");
        tables.add("t_pm_mainmenuitem");
        this.updateMLFieldResource(ctx, language, isAllUpdate, tables);
    }

    @Override
    protected void _updatePrintTemplateResource(Context ctx, String language) throws BOSException, EASBizException {
        PrintWriteResource printWriteResource = new PrintWriteResource();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            printWriteResource.writePrintResource(ctx, conn, language);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _updateWorkFlowResource(Context ctx, String language) throws BOSException, EASBizException {
        WorkFlowWriteResource workFlowWriteResource = new WorkFlowWriteResource();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            workFlowWriteResource.writeWorkFlowResource(ctx, conn);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected Map _importResource(Context ctx, List list, int errorHandleMode, String lang, MetaDataTypeEnum metadataType, ImportModeEnum importMode) throws BOSException, EASBizException {
        if (list == null || list.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            this.updateImportResource(ctx, list, errorHandleMode, lang, metadataType);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            map.put("hasError", Boolean.TRUE);
            map.put("errorStr", e.getMessage());
        }
        return map;
    }

    private void addNewImportResource(List list, int errorHandleMode, String lang, MetaDataTypeEnum metadataType) {
    }

    @Override
    protected Map _importBizTableData(Context ctx, List list, int errorHandleMode, ImportModeEnum importMode) throws BOSException {
        if (list == null || list.size() <= 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            this.updateImportPresetData(ctx, list, errorHandleMode, importMode);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            map.put("hasError", Boolean.TRUE);
            map.put("errorStr", e.getMessage());
        }
        return map;
    }

    private void updateImportPresetData(Context ctx, List list, int errorHandleMode, ImportModeEnum importMode) throws BOSException {
        Object resTable = null;
        String bizDataTable = "T_RES_PresetDataRes";
        Object resBosType = null;
        Object mlBosType = null;
        Connection conn = null;
        PreparedStatement ps = null;
        Object tempTableName = null;
        TempTablePool pool = null;
        try {
            conn = super.getConnection(ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            String sql = "update T_RES_PresetDataRes set FText_zh_CN=?,FText_zh_TW=?,FText_en_US=?,FMD5=? where fid=? ";
            ps = conn.prepareStatement(sql);
            int j = list.size();
            for (int i = 0; i < j; ++i) {
                PresetDataResInfo info = (PresetDataResInfo)list.get(i);
                String res = MLUtils.myTrim(info.getText_zh_CN());
                String cnmd5 = MLUtils.md5HashCode(res);
                String eng = MLUtils.myTrim(info.getText_en_US());
                String zh_tw = MLUtils.myTrim(info.getText_zh_TW());
                String id = MLUtils.myTrim(info.getString("id"));
                if (StringUtils.isEmpty((String)id) || MLUtils.isEmpty(res) || MLUtils.isEmpty(eng) && MLUtils.isEmpty(zh_tw)) continue;
                ps.setString(1, res);
                ps.setString(2, zh_tw);
                ps.setString(3, eng);
                ps.setString(4, cnmd5);
                ps.setString(5, id);
                ps.addBatch();
                if (i == 0 || i % 4000 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            ps.executeBatch();
            ps.clearBatch();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateImportResource(Context ctx, List list, int errorHandleMode, String lang, MetaDataTypeEnum metadataType) throws BOSException {
        PreparedStatement ps;
        Connection conn;
        block17: {
            String resTable = null;
            String mlResTable = null;
            String resBosType = null;
            String mlBosType = null;
            resBosType = MLToolsConstonts.getBOSType(metadataType.getValue(), false);
            mlBosType = MLToolsConstonts.getBOSType(metadataType.getValue(), true);
            if (MetaDataTypeEnum.entity.equals((Object)metadataType)) {
                resTable = "t_Res_EntityResource";
                mlResTable = "T_Res_EntityMultiLan";
            } else if (MetaDataTypeEnum.enumAndExc.equals((Object)metadataType)) {
                resTable = "t_Res_EnumResource";
                mlResTable = "T_Res_EnumMultiLan";
            } else if (MetaDataTypeEnum.query.equals((Object)metadataType)) {
                resTable = "t_Res_queryResource";
                mlResTable = "T_Res_QueryMultiLan";
            } else if (MetaDataTypeEnum.res.equals((Object)metadataType)) {
                resTable = "t_Res_ResResource";
                mlResTable = "T_Res_ResMultiLan";
            } else if (MetaDataTypeEnum.ui.equals((Object)metadataType)) {
                resTable = "t_Res_UIResource";
                mlResTable = "T_Res_UIMultiLan";
            } else {
                if (!MetaDataTypeEnum.mdbview.equals((Object)metadataType)) return;
                resTable = "T_RES_MdbviewResource";
                mlResTable = "T_RES_MdbviewMultiLan";
            }
            conn = null;
            ps = null;
            String tempTableName = null;
            TempTablePool pool = null;
            try {
                conn = super.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                StringBuffer createTableSql = new StringBuffer("create table tempTAB ");
                createTableSql.append("(");
                createTableSql.append(" FResID varchar(44) null, ");
                createTableSql.append(" FRes nvarchar(1000) null, ");
                createTableSql.append(" FCNMD5 varchar(32) null, ");
                createTableSql.append(" FMLID varchar(44) null, ");
                createTableSql.append(" FMLRes nvarchar(2000) null, ");
                createTableSql.append(" FPackage varchar(80) null, ");
                createTableSql.append(" FFileName varchar(120) null, ");
                createTableSql.append(" FKey nvarchar(300) not null, ");
                createTableSql.append(" FLanguage varchar(32) null ");
                createTableSql.append(")");
                tempTableName = pool.createDBSystemTempTable(createTableSql.toString(), conn);
                String ins_sql = "insert into " + tempTableName + "(FRes,FCNMD5,FMLRes,FPackage,FFileName,FKey,FLanguage) values(?,?,?,?,?,?,?)";
                logger.info((Object)("ins_sql: " + ins_sql));
                ps = conn.prepareStatement(ins_sql);
                int j = list.size();
                for (int i = 0; i < j; ++i) {
                    MetaDataResourceInfo info = (MetaDataResourceInfo)list.get(i);
                    String res = MLUtils.myTrim(info.getCn());
                    String cnmd5 = MLUtils.md5HashCode(res);
                    String mlres = MLUtils.myTrim(info.getContent());
                    String packageStr = MLUtils.myTrim(info.getPackageName());
                    String fileName = MLUtils.myTrim(info.getFileName());
                    String key = MLUtils.myTrim(info.getKey());
                    if (MLUtils.isEmpty(res) || MLUtils.isEmpty(mlres)) continue;
                    ps.setString(1, res);
                    ps.setString(2, cnmd5);
                    ps.setString(3, mlres);
                    ps.setString(4, packageStr);
                    ps.setString(5, fileName);
                    ps.setString(6, key);
                    ps.setString(7, lang);
                    ps.addBatch();
                    if (i == 0 || i % 4000 != 0) continue;
                    ps.executeBatch();
                    ps.clearBatch();
                }
                ps.executeBatch();
                ps.clearBatch();
                StringBuffer repairResIDsql = new StringBuffer();
                repairResIDsql.append(" update ").append(tempTableName).append(" set FResID = ( ");
                repairResIDsql.append("   select top 1 fid from ").append(resTable).append(" res ");
                repairResIDsql.append("      where ").append(tempTableName).append(".FRes = res.FRES2 ");
                if (!MetaDataTypeEnum.mdbview.equals((Object)metadataType)) {
                    repairResIDsql.append("        and ").append(tempTableName).append(".FPackage = res.FPACKAGE ");
                }
                repairResIDsql.append("        and ").append(tempTableName).append(".FFileName = res.FFILENAME ");
                repairResIDsql.append("        and ").append(tempTableName).append(".FKey = res.FKEY ");
                repairResIDsql.append("  )");
                logger.info((Object)("repairResIDsql: " + repairResIDsql));
                ps = conn.prepareStatement(repairResIDsql.toString());
                ps.execute();
                StringBuffer repairMLIDsql = new StringBuffer();
                repairMLIDsql.append(" update ").append(tempTableName).append(" set FMLID = ( ");
                repairMLIDsql.append("   select fid from ").append(mlResTable).append(" ml ");
                repairMLIDsql.append("     where ").append(tempTableName).append(".FResID = ml.FResID ");
                repairMLIDsql.append("       and ").append(tempTableName).append(".FCNMD5 = ml.FCNMD5 ");
                repairMLIDsql.append("       and ml.FLanguage = '").append(lang).append("' ");
                repairMLIDsql.append("  )");
                logger.info((Object)("repairMLIDsql: " + repairMLIDsql));
                ps = conn.prepareStatement(repairMLIDsql.toString());
                ps.execute();
                StringBuffer updateMLsql = new StringBuffer();
                updateMLsql.append(" update ").append(mlResTable).append(" set FMLRes2 = ( ");
                updateMLsql.append(" select top 1 FMLRes from ").append(tempTableName);
                updateMLsql.append("   where FMLID = ").append(mlResTable).append(".fid ");
                updateMLsql.append("  ) ");
                updateMLsql.append(" where exists( ");
                updateMLsql.append("   select FMLRes from ").append(tempTableName);
                updateMLsql.append("     where FMLID = ").append(mlResTable).append(".fid ");
                updateMLsql.append("  ) ");
                logger.info((Object)("updateMLsql: " + updateMLsql));
                ps = conn.prepareStatement(updateMLsql.toString());
                ps.execute();
                StringBuffer insertResSql = new StringBuffer();
                insertResSql.append(" insert into ").append(resTable).append("(FID,FPACKAGE,FFILENAME,FKEY,FRES,FRES2,FMD5) ");
                insertResSql.append(" select newbosid('").append(resBosType).append("') FID,FPackage FPACKAGE,FFileName FFILENAME,FKey FKEY,FRes FRES,FRes FRES2,FCNMD5 FMD5 ");
                insertResSql.append(" from ").append(tempTableName).append(" where FResID is null; ");
                logger.info((Object)("insertResSql: " + insertResSql));
                ps = conn.prepareStatement(insertResSql.toString());
                ps.execute();
                logger.info((Object)("repairResIDsql: " + repairResIDsql));
                ps = conn.prepareStatement(repairResIDsql.toString());
                ps.execute();
                StringBuffer insertMLSql = new StringBuffer();
                insertMLSql.append(" insert into ").append(mlResTable).append("(FID,FLANGUAGE,FRESID,FMLRES,FMLRES2,FCNMD5) ");
                insertMLSql.append(" select newbosid('").append(mlBosType).append("') FID,'").append(lang).append("' FLANGUAGE, FResID FRESID,FMLRes FMLRES,FMLRes FMLRES2,FCNMD5 FCNMD5 ");
                insertMLSql.append(" from ").append(tempTableName).append(" where FMLID is null ");
                logger.info((Object)("insertMLSql: " + insertMLSql));
                ps = conn.prepareStatement(insertMLSql.toString());
                ps.execute();
                if (pool == null) break block17;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (pool != null) {
                        pool.releaseTable(tempTableName);
                    }
                    SQLUtils.cleanup(ps);
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tempTableName);
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
    }
}

